#!/bin/sh

# takes one argument of a directory

set -x

if test x$1 = x; then
    echo "usage: $0 <game directory>"
    exit -1
fi

cd $1 || exit -1

fn1=`echo LOG*l/abmdp_track.log`
fn1=`echo LOG*l/abmdp_track.log.gz`
if test x$fn1 != x -o x$fn2 != x; then
    cd LOG*l

    gunzip -f abmdp_track.log.gz ../rule_actions.log.gz

    if test -e combine-matched.log.gz; then
        gunzip combine-matched.log.gz
    elif test ! -e combine-matched.log; then
	gunzip ?-matched.log.gz ??-matched.log.gz tree2state.log.gz abmdp_track.log.gz
	combine_matched_files.pl ?-matched.log ??-matched.log > combine-matched.log
    fi

    compare_coach_agent_acts.pl summary abmdp_track.log ../rule_actions.log combine-matched.log > compare_act_summary.log
    compare_coach_agent_acts.pl cycle abmdp_track.log ../rule_actions.log combine-matched.log > compare_act_cycle.log

    if test -e ../ball_possess.log.gz; then
	gunzip ../ball_possess.log.gz
    fi

    # now consider only the ball owner
    prune_matched.pl ../ball_possess.log left combine-matched.log > bp-matched.log
    compare_coach_agent_acts.pl summary abmdp_track.log ../rule_actions.log bp-matched.log > bp_compare_act_summary.log
    compare_coach_agent_acts.pl cycle abmdp_track.log ../rule_actions.log bp-matched.log > bp_compare_act_cycle.log

    gzip -f *.log
    cd ..
    gzip -f *.log
fi