#!/usr/local/bin/perl -w

# This script compares the coach and agent (advised) actions
# NOTE!!!! There is a weird hack in here. The coach can have advice for various
# non-play-on state which there is no advice about. To avoid considering these
# state as coach only states, we provide a boundary value for states that should be ignored
# Really, we should do what the compare_coach_agent_views script does and
# read tree2state to decide this

$min_state_value = 122;

$usage = "$0 cycle|summary <abmdp_track logfile> <rule_actions logfile> <combine-matched logfile>";

$modestr = shift @ARGV;
$abmdp_track_fn = shift @ARGV;
$rule_actions_fn = shift @ARGV;
$combine_matched_fn = shift @ARGV;

die $usage unless (defined($modestr) &&
		   defined($abmdp_track_fn) &&
		   defined($rule_actions_fn) &&
		   defined($combine_matched_fn));

#contants
$MODE_SUMMARY = 0;
$MODE_CYCLE = 1;

$modestr = lc $modestr;
if ($modestr eq "summary") {
  $mode = $MODE_SUMMARY;
} elsif ($modestr eq "cycle") {
  $mode = $MODE_CYCLE;
} else {
  die $usage;
}
# Read the rule_actions_file
# Fills in %rule_actions hash with refs to lists of actions
open (RAFH, "<$rule_actions_fn") || die "Could not open rule actions file '$rule_actions_fn': $!";
while (<RAFH>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    /^(\w+)\s*\:\s*(.*)$/ || die "Malformatted rule_actions line '$_'";
    $rulename = $1;
    $acts = $2;
    $rule_actions{$rulename} = [get_acts($acts)];
  }
close RAFH;

# Read the coach's abmdp_track
# Fill in @coach_acts with refs to list of actions
open (ATFH, "<$abmdp_track_fn") || die "Could not open abmdp_track '$abmdp_track_fn': $!";
while (<ATFH>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);
    /^(\d+)\s+(\d+)\s+(\d+)\s*(.*)$/ || die "Malformatted abmdp_track line '$_'";
    use vars qw($state $rew);
    ($time, $state, $rew, $acts) = ($1,$2,$3,$4);
    next if ($state < $min_state_value);
    $coach_acts[$time] = [get_acts($acts)];
  }

if ($mode == $MODE_CYCLE)
  {
    print <<EOH;
# This file was generated by compare_coach_agent_acts.pl in cycle mode
# This was run with a min_state_value of $min_state_value, are you sure this is correct?
# Format: <time> <# coach only acts> <# coach/player acts> <# player only acts>
EOH
  }

$total_cycles = 0;
$total_nonzero_cycles = 0;
$total_coach_only = 0;
$cycles_coach_only = 0;
$total_both = 0;
$cycles_both = 0;
$total_player = 0;
$cycles_player_only = 0;


open (MATCH, "<$combine_matched_fn") || die "Could not open combine matched file '$combine_matched_fn': $!";
while (<MATCH>)
  {
    chomp;
    s/\#.*//;
    next if (/^\s*$/);

    /^(\d+)\s*:\s*(.*)$/ || die "Malformed line in combine matched file: '$_'";
    $time = $1;
    @player_vals = split /\s+/, $2;
#     @orig_player_vals = @player_vals;
#     $idx = 0;
#     @orig_player_rules = grep {$idx++ % 2 == 0} @orig_player_vals;
#     $idx = 0;
#     @orig_player_masks = grep {$idx++ % 2 == 1} @orig_player_vals;
    #print "$time: " . (join " ", @player_vals) . "\n" if ($debug);

    @this_coach_acts = defined($coach_acts[$time]) ? @{$coach_acts[$time]} : ();

    %this_agent_acts = ();
    for (;;)
      {
	$rule = shift @player_vals;
	$numfield = shift @player_vals;
	last if (not defined($numfield));
	#numfield is a string represnting a number in binary

	map { $this_agent_acts{$_} = 1;} @{$rule_actions{$rule}};
      }

    # Now, let's do something with all this parsed data
    #separate actions into three classes: coach_only, both, player_only
    @coach_only = @both = @player_only = ();
    foreach $act (@this_coach_acts)
      {
	if (exists $this_agent_acts{$act})
	  {
	    push @both, $act;
	    delete $this_agent_acts{$act};
	  }
	else
	  {
	    push @coach_only, $act;
	  }
      }
    @player_only = keys %this_agent_acts;

    print ((join ' ', ($time, scalar(@coach_only), scalar(@both), scalar(@player_only))) . "\n") if ($mode == $MODE_CYCLE);

    $total_cycles++;
    $total_nonzero_cycles++ if (scalar(@coach_only) + scalar(@both) + scalar(@player_only) > 0);
    $total_coach_only += scalar(@coach_only);
    $cycles_coach_only++ if (@coach_only);
    $total_both += scalar(@both);
    $cycles_both++ if (@both);
    $total_player += scalar(@player_only);
    $cycles_player_only++ if (@player_only);
  }

if ($mode == $MODE_SUMMARY)
  {
    print <<EOH;
# This file was generated by compare_coach_agent_acts.pl in summary mode
# This was run with a min_state_value of $min_state_value, are you sure this is correct?
# Format: <description>: <value>
Total cycles             : $total_cycles
Total non-zero cycles    : $total_nonzero_cycles
Total coach only acts    : $total_coach_only
Total coach only cycles  : $cycles_coach_only
Total agree acts         : $total_both
Total agree cycles       : $cycles_both
Total player only acts   : $total_player
Total player only cycle  : $cycles_player_only
EOH
}

sub find_paren_balanced
  {
    my ($inputstr) = @_;
    my $idx = 0;
    my $open_cnt = 0;
    my $ch;
    for (;;) {
      if ($idx >= length($inputstr))
	{
	  return ('','') if ($idx == 0);
	  die "find_param_balanced: unbalanced at end" if ($open_cnt != 0);
	  die "find_param_balanced: weird input '$inputstr'" unless ($inputstr =~ /^\s*$/);
	  # it's just white space
	  return ('', '');
	}
      $ch = substr($inputstr, $idx, 1);
      $open_cnt++ if ($ch eq '(');
      $open_cnt-- if ($ch eq ')');
      $idx++;
      last if ($open_cnt == 0);
      die "too many )" if ($open_cnt < 0);
    }
    return (substr($inputstr, 0, $idx), substr($inputstr, $idx));
  }

sub trim_white_space
  {
    my ($str) = @_;
    $str =~ s/^\s+//;
    $str =~ s/\s+$//;
    return $str;
  }

sub get_acts
  {
    my ($rem) = @_;
    my @acts = ();
    my $act;
    for (;;)
      {
	$rem = trim_white_space($rem);
	($act, $rem) = find_paren_balanced($rem);
	last if ($act eq '');
	push @acts, $act;
	#print "rule '$rulename' has action '$act'\n";
      }
    return @acts;
  }
