#!/usr/local/bin/perl5 -w

# This script combines data files from the PlayerOccupancy tracking mode of the coach


$usage = "Usage: $0 <number of states> <list of logfiles>";

$numstates = shift @ARGV;
(defined $numstates && ($numstates > 0)) || die $usage;

print "# This file was generated by combine_posumm.pl. The files it is combining are:\n";
print "# ";
print (join "\n# ", @ARGV);
print "\n";

@counts = ((0) x $numstates);

while (<>) {
  chomp;
  s/\#.*//;
  next if (/^\s*$/);
  ($state, $cnt) = split /\s*:\s*/;
  #print "$state: $cnt\n";
  $counts[$state] += $cnt;
  (0 <= $state && $state < $numstates) || die "State out of range: $state (numstates=$numstates)";
}

for ($state = 0; $state < @counts; $state++) {
  $cnt = $counts[$state];
  print "$state: $cnt\n";
}
