#!/usr/local/bin/perl5 -w

# This script combines the matched rule logfiles generated by my hacked version
# of the UTA players

use File::Basename;

$usage = "$0 [list of matched logfiles; must have a <num> prefix]";

die $usage if (@ARGV == 0);

@pruned_prefixes = qw(SetHome SP_ FORM_ DEF ForBackUp MidBackUp DefCloseIn MarkPlayer PullOffsides GetBehindBall MarkPlayer ClearBall);

$date = `date`;
chomp $date;
print <<EOH;
# This file was created by $0 on $date
# Format: <time>: [<rulename> <whoid>]*
# <whoid> is a number where bit i (counting from the low order)
# represents whether player i sayed the rule matched
# NOTE: Some rules have been removed
EOH

# The main data structure is going to be an array of references to hashes
# The array index is time 1
# The hash key is the rule name. The hash value is the a bit field where each
# player number is the bit left shifted over the number of spots
# NOTE: we don't handle the paused time stuff at all
@timerules = ();

foreach $fn (@ARGV)
  {
    $basename = basename($fn);
    if (not $basename =~ /^(\d+)/)
      {
	warn "File '$fn' not in num prefix format, skipping";
	next;
      }
    $num = $1;
    open (FH, "<$fn") || die "Could not open file '$fn': $!";
    while (<FH>)
      {
	chomp;
	if (not /^ \( (\d+),(\d+) \) \s*: \s*([^\s]*)\s* $/x)
	  {
	    warn "Did not understand line '$_' in file '$fn', skipping";
	    next;
	  }

	$time1 = $1;
	$time2 = $2;
	$rule = $3;

	next if (grep {$rule =~ /^$_/} @pruned_prefixes);

	while ($#timerules < $time1)
	  {
	    push (@timerules, { });
	  }

	$timerules[$time1]->{$rule} |= (1 << $num);

	#print "$time1 $time2 $num $rule\n";
      }
  }

# Now print out all this stuff
$idx = 0;
foreach $hashref (@timerules)
  {
    print "$idx: ";
    foreach $rule (keys %$hashref)
      {
	printf ("%s %b ", $rule, ($hashref->{$rule}));
      }
    print "\n";
    $idx++;
  }
