#!/usr/local/bin/perl -w

# This scripts collects stats and generates an html file for them

$usage = "$0 <list of stats files>";

die $usage if (@ARGV == 0);

$cmdline = $0 . ' ' . (join ' ', @ARGV);
$pwd = `pwd`;
chomp $pwd;
$date = `date`;
chomp $date;

# %fileinfo: hash from filename to a has ref 
# that hash maps values names into a list ref of values
# %namehash: only the keys are meaningful: all names used
foreach $fn (@ARGV)
  {
    open (FH, "<$fn") || die "Could not open file '$fn': $!";
    $fileinfo{$fn} = { };
    while (<FH>) {
      chomp;
      s/\#.*//;
      next if /^\s*$/;
      if (not /^\s*(.*?)\s*\:\s*(.*)$/)
        {
          warn "Did not understand line '$_' of file '$fn'";
          next;
        }
      $name = $1;
      @vals = split /\s+/, $2;
      $fileinfo{$fn}->{$name} = [@vals];
      $namehash{$name} = 1;
    }
    close (FH);
  }

print <<EOS;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>Collected Stats</title>
</head>
<body>
<h1> Collected Stats </h1>
<hr>
<table border="1">
  <tbody>
EOS

print "<tr><td>File<td/>\n";
# Now the header row
foreach $name (sort (keys %namehash))
  {
    print "<td>$name</td>";
  }
print "</tr>\n";

# Now output this stuff
foreach $fn (sort (keys %fileinfo))
  {
    print "<tr><td>$fn<td/>\n";
    foreach $name (sort (keys %{$fileinfo{$fn}})) {
      print "<td> " . (join ("<br>", @{$fileinfo{$fn}->{$name}})) . "</td>\n";
    }
    print "</tr>\n";
  }

print <<EOS;
  </tbody>
</table>
<hr>
This file was generated by this command line:<br>
$cmdline<br>
in this directory:<br>
$pwd<br>
on $date
</body>
</html>
EOS
