#!/usr/local/bin/perl5 -w

# This script is to run the coach on a set of logfiles.
# You'll have to hack the script to make it do what you want, but it would be fairly easy
# All the standard configuration stuff is at the top
# The script will also put a copy of itself in the output dir so that you know how it was run
# The arguments should be the logfiles to run on


use File::Copy;
use File::Basename;
use Cwd qw(abs_path);

$usage = "$0 <extra_conf_file> <arg set> <outputdir> <list of logfiles>";

## Basic stuff I'll need
$coachdir = abs_path(dirname($0)."/../coach");

## Sanity checks
(@ARGV != 0) || die $usage;
$extra_conf_file = shift @ARGV;
$argset = shift @ARGV;
$outputdir = shift @ARGV;
(-e $outputdir) || die "Output dir '$outputdir' does not exist";
$outputdir = abs_path($outputdir);

@postprocess = ();
## Main parameters
# The standard argument of --file coach.conf, run_mode, logfile_fn do not need to be included
# The following replacements are made:
# %FN : the filename of the log we are analyzing
# %FB : just the 'basename' (no leading directory) of the log
# %OD : the output directory
# %ID : a unique ID for each logfile
# Note that we will run in the coach directory!
#$args = '--abstract_track_po_per_cycle_fn %OD/%FB_pocycle.log ';
#$args .= '--abstract_track_po_summ_fn %OD/%FB_posumm.log ';
#$args .= '--abstract_track_po_write_per_cycle off ';
if ($argset eq "absstate_both")
  {
    $args = '--file all_off.conf --use_mod_features --use_mod_abstract ';
    $args .= '--abstract_state_track on ';
    $args .= '--abstract_state_track_write_per_cycle on  ';
    $args .= '--abstract_state_track_per_cycle_fn %OD/%FB_%ID_absstate_cycle_%S.log ';
    $args .= '--abstract_state_track_write_summ on ';
    $args .= '--abstract_state_track_summ_fn %OD/%FB_%ID_absstate_summ_%S.log ';
    $args .= '--abstract_state_track_both_teams on ';
    $args .= '--action_log_level 0 ';
  }
elsif ($argset eq "absstate_left")
  {
    $args = '--file all_off.conf --use_mod_features --use_mod_abstract ';
    $args .= '--abstract_state_track on ';
    $args .= '--abstract_state_track_write_per_cycle on  ';
    $args .= '--abstract_state_track_per_cycle_fn %OD/%FB_%ID_absstate_cycle_%S.log ';
    $args .= '--abstract_state_track_write_summ on ';
    $args .= '--abstract_state_track_summ_fn %OD/%FB_%ID_absstate_summ_%S.log ';
    $args .= '--abstract_state_track_both_teams off ';
    $args .= '--logfile_side_to_analyze left ';
    $args .= '--action_log_level 0 ';
  }
elsif ($argset eq "abmdp_track")
  {
    $args = '--file all_off.conf ';
    $args .= '--use_mod_abstract --abstract_abmdp_track --use_mod_features ';
    $args .= '--abstract_abmdp_track --abstract_abmdp_track_fn %OD/%FB_%ID_abmdp_track.log ';
    $args .= '--logfile_team_to_analyze Coachable ';
    $args .= '--action_log_level 0 ';
  }
elsif ($argset eq "images")
  {
    $args = '--file all_off.conf ';
    $args .= '--use_mod_features ';
    $args .= '--use_mod_stat_image ';
    $args .= '--mod_stat_draw_world_state off ';
    $args .= '--mod_stat_draw_ball_path --mod_stat_ball_path_fstem %OD/%FB_%ID_ball_path ';
    $args .= '--action_log_level 0 ';
    push @postprocess, "montage -tile 2x3 -geometry 320x240 -label %f %OD/*ball_path*png %OD/all_ball_path_%02d.png";
  }
elsif ($argset eq "stats")
  {
    $args = '--file all_off.conf ';
    $args .= '--use_mod_features ';
    $args .= '--use_mod_stat_image ';
    $args .= '--mod_stat_draw_world_state off ';
    $args .= '--mod_stat_draw_ball_path off ';
    $args .= '--mod_stat_do_misc --mod_stat_misc_out_fn %OD/%FB_%ID_stats.log ';
    $args .= '--mod_stat_misc_ball_in_rec_x_fn %OD/%FB_%ID_recX.log ';
    $args .= '--action_log_level 0 ';
    push @postprocess, "cat %OD/*recX* | grep -v '^#' > %OD/all_recX.log";
  }
else
  {
    die "Did not understand argument set '$argset'";
  }

## absolutize the logfiles
@logfiles = map { abs_path(dirname($_)) . '/' . basename($_) } @ARGV;

## Write some config stuff to the output dir
copy ($0, $outputdir) || die "Could not copy script to outputdir '$outputdir': $!";
copy ("$coachdir/coach.conf", $outputdir) || die "Could not copy coach.conf to outputdir '$outputdir': $!";
open (LOGFILE_LIST_FH, ">$outputdir/LOGFILE_LIST") || die "Could not open logfile list: $!";
print LOGFILE_LIST_FH (join "\n", @logfiles);
print LOGFILE_LIST_FH "\n";
close (LOGFILE_LIST_FH);

open (COMMANDS_LIST_FH, ">$outputdir/COMMANDS") || die "Could not open commands list: $!";

$outputfn = "$outputdir/OUTPUT.LOG";

if (-e $outputfn)
  {
    unlink ($outputfn) || die "Could not remove old output file '$outputfn': $!";
  }

## Now on to the main loop
chdir ($coachdir) || die "Could not chage to coach dir '$coachdir': $!";
$logfile_idx = 0;
foreach $logfn (@logfiles)
  {
    $basefn = basename($logfn);
    $standard_args = "--file coach.conf ";
    $standard_args .= "--file $extra_conf_file " if ($extra_conf_file ne '');
    $standard_args .= "--logfile_dir $outputdir --action_log_fn ${basefn}_${logfile_idx}_actions.log ";
    $standard_args .= "--run_mode logfile --logfile_fn $logfn ";
    $this_args = $args;
    $this_args =~ s/\%FN/$logfn/g;
    $this_args =~ s/\%FB/$basefn/g;
    $this_args =~ s/\%OD/$outputdir/g;
    $this_args =~ s/\%ID/$logfile_idx/g;

    $full_cmd = "./coach $standard_args $this_args 2>&1 | tee -a $outputfn";
    print COMMANDS_LIST_FH "$full_cmd\n";
    system $full_cmd;

    $logfile_idx++;
  }

# Now some post processing
foreach $cmdline (@postprocess) {
  $cmdline =~ s/\%OD/$outputdir/g;
  print "Running postprocess command: $cmdline\n";
  system $cmdline;
}
