#!/usr/local/bin/perl5 -ws

# This script takes a server.comm.log from a game and verifies that all 22 players
# sent a command in the last 50 cycles of the game. If so, the script returns nothing.
# If players failed to send commands, their numbers are printed out

# the file can be specified on the command line or stdin
# files on the command line with a .gz extension will be unzipped first

# a '-print' causes the last time each agent communicated to be printed

use vars qw($print);
use File::Basename;

$mydir = dirname($0);
$tmpfile = "$mydir/../tmp/check.$$.log";

sub check_players {
  my ($count) = (0);
  for ($num=0; $num<22; $num++) {
    $team = ($num < 11) ? 'l' : 'r';
    $pnum = ($num % 11) + 1;
    $count++ if (not $msg_recv[$num]);
    if (defined($print)) {
      print "$fn: Player $team$pnum last comm: $time_recv[$num]\n";
    } else {
      next if ($msg_recv[$num]);
      print "$fn: Player $team$pnum may have died (last time: $time_recv[$num])!\n";
    }
  }
  return $count;
}

$critical_time = 5500;

foreach $fn (@ARGV) {

  if ($fn =~ /\.gz$/) {
    system "gunzip -c $fn > $tmpfile";
    $openarg = $tmpfile;
  } else {
    $openarg = $fn;
  }

  open (FH, "<$openarg") || die "Could not open input file '$fn' '$openarg': $!";

  $teamsfound = 0;
  %teamside = ();
  @msg_recv = ();
  @time_recv = ();

  while (<FH>) {
    if (not (/^(\d*)\s+Recv ([\w\-]+)_(\d+):/o)) {
      next;
    }

    ($time, $team, $num) = ($1, $2, $3);
    if (not exists $teamside{$team}) {
      $teamside{$team} = $teamsfound++;
    }
    $teamidx = $teamside{$team};

    $time_recv[11 * $teamidx + $num - 1] = $time;

    next if ($time < $critical_time);

    #print "Line: '$currentfn' '$ARGV' '$_'\n";

    $msg_recv[11 * $teamidx + $num - 1] = 1;
  }

  close FH;

  #print "Processing file '$fn'\n";
  $count = &check_players;
  print "$fn: everyone lived!\n" if ($count == 0);
}

unlink $tmpfile;
