#!/usr/local/bin/perl5 -ws

# This script takes an rcl file and output the number of cycles which each player
# did not send an action

# files on the command line with a .gz extension will be unzipped first

# A file called missed_cycles.log is written in the same dir with the logfile

use vars qw($print);
use File::Basename;

#$mydir = dirname($0);
$tmpfile = "/tmp/checkmissed.$$.log";

$ARGV[0] = '-' if (@ARGV == 0);

$num_players = 11;

foreach $fn (@ARGV) {

  if ($fn =~ /\.gz$/) {
    $openarg = "gunzip -c $fn|";
  } else {
    $openarg = "<$fn";
  }

  open (FH, "$openarg") || die "Could not open input file '$fn' '$openarg': $!";

  $team0_name = undef;
  $team1_name = undef;
  @team0_miss_count = (0) x $num_players;
  @team1_miss_count = (0) x $num_players;
  $last_time = -1;
  while (<FH>) {
    /^(\d+) \s* Recv\s([\w-]+)_(\d+):/x || next;
    ($this_time, $this_team, $this_num) = ($1, $2, $3);
    if ($this_time != $last_time) {
      if ($last_time > 0) {
	map { $team0_miss_count[$_] += $team0_marks[$_] } 0 .. ($num_players -1);
	map { $team1_miss_count[$_] += $team1_marks[$_] } 0 .. ($num_players -1);
      }
      @team0_marks = (1) x $num_players;
      @team1_marks = (1) x $num_players;
      $last_time = $this_time;
    }
    $team_idx = -1;
    $team0_name = $this_team if (!defined($team0_name));
    $team_idx = 0 if ($this_team eq $team0_name);
    $team1_name = $this_team if ($team_idx == -1 && !defined($team1_name));
    $team_idx = 1 if ($team_idx == -1 && $this_team eq $team1_name);
    die "Weird team '$this_team', teams I have = ('$team0_name', '$team1_name')" if ($team_idx == -1);

    (($team_idx == 0) ? $team0_marks[$this_num - 1] : $team1_marks[$this_num - 1]) = 0;
  }

  close FH;

  # Now print out the results
  $outfn = dirname($fn) . "/missed_cycles.log";
  open (OUTFH, ">$outfn") || die "Could not open out file '$outfn': $!";

  print_res(\*OUTFH, $team0_name, @team0_miss_count);
  print_res(\*OUTFH, $team1_name, @team1_miss_count);
  close(OUTFH);

}

unlink $tmpfile;

  sub print_res {
    my ($fh, $team_name, @counts) = @_;
    my ($cnt, $idx);
    $idx = 0;
    foreach $cnt (@counts) {
      print $fh ("${team_name}_" . (++$idx) . ": $cnt\n");
    }
  }

