#!/usr/local/bin/perl -w

# This scripts is intended to process an abmdp_track.log file to establish
# how long (in a given interval) it takes to get a reward
# for each fn, creates a fn.processed

$usage = "$0 <interval> <list of data files>";

$interval = shift @ARGV;
(defined $interval) || die $usage;

foreach $fn (@ARGV)
  {
    (-e $fn) || die "File '$fn' DNE";
    $outfn = "$fn.processed";
    open (INFH, "<$fn") || die "Could not open file '$fn': $!";
    open (OUTFH, ">$outfn") || die "Could not open output file '$outfn': $!";
    print OUTFH <<EOH;
# This file was generated by analyza_rew_intervals.pl
# Format: <time at start of interval> <time to get reward>
EOH
    $this_interval_start = 1;
    $this_interval_rew_time = 99999;
    while (<INFH>)
      {
	s/\#.*//;
	next if (/^\s*$/);
	($time, undef, $reward) = split;

	PROCESS : {
	  # check to see if we finished an interval
	  if ($time > $this_interval_start + $interval)
	    {
	      print OUTFH "$this_interval_start $this_interval_rew_time\n";
	      $this_interval_start += $interval;
	      $this_interval_rew_time = 99999;
	      redo PROCESS;
	    }
	  if ($reward > 0 && ($time-$this_interval_start) < $this_interval_rew_time)
	    {
	      $this_interval_rew_time = $time-$this_interval_start;
	    }
	}
      }

    close(INFH);
    close(OUTFH);
  }
