#!/usr/local/bin/perl5 -w

# This script will analyze the values from a abmdp track log file
# to determine some things about the rewards

use Statistics::Descriptive;

use vars qw($time $state $rew $usage);

$usage = "$0 [<logfn>]";

$stat = Statistics::Descriptive::Sparse->new();

print ("Files: " . (join ' ', @ARGV)."\n");

while (<>)
  {
    s/\#.*//;
    next if (/^\s*$/);
    ($time, $state, $rew) = split;
    $stat->add_data($rew);
    $latest_time = $time;
  }

$latest_time = 6000 if ($latest_time > 5800 && $latest_time <= 6000);

print ("Steps: " . ($stat->count()) . "\n");
print ("Mean Rew (step): " . ($stat->mean()) . "\n");
print ("Mean Rew (simtime, time est=${latest_time}): " . ($stat->mean() * $stat->count() / $latest_time) . "\n");
print ("Stdev: " . ($stat->standard_deviation()) . "\n");
