/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMERTHREAD_H
#define TIMERTHREAD_H

#include <qthread.h>
#include <qpixmap.h>
#include <qmap.h>

#include "kwirelessmonitor.h"
#include "interfacemonitor.h"

class TimerThread : public QThread
{
public:
    TimerThread(KWirelessMonitor *w);
    virtual void run();
    void setInterface(const QString& ifName);

private:
    KWirelessMonitor *mWidget;

    int mCurrentState;
    QPixmap ***mPixmapArray;
    InterfaceMonitor *mIFMonitor;
    QMap<int, int> mBitrateIndexMap;
    static const char *mSignalArray[];
    static const char *mBitrateArray[];
    static const int mNumSignal;
    static const int mNumBitrate;

    bool mWasOnACPower;
};

#endif /* TIMERTHREAD_H */
