/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIRELESSMONITOR_H
#define KWIRELESSMONITOR_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <ksystemtray.h>
#include <kprocess.h>

#include <qvbox.h>
#include <qaction.h>

#define HELPER_FIFO "/tmp/kwmhelper-fifo"

#define DATA_TRANSFER_THRESHOLD 2000
#define TRANSFER_TIMEOUT 3

#define BITRATE_GRAPH_PARTS 4

enum { DetectMode, ManualMode };
enum { PMManual = 0, PMAuto = 1 };
enum { PMOn = 0, PMOff = 1 };
enum { BRAuto = 0, BRManual = 1 };

struct wirelessStats {
    QString ESSID;
    int quality;
    int bitrate;
    int powermgmt;
};

extern QValueList<int> availableBitrateList;
extern QStringList availableBitrateStrList;
extern int numAvailableBitrates;

class TimerThread;
class ConfigDialog;

/** KWirelessMonitor is the base class of the project */
class KWirelessMonitor : public KSystemTray
{
    Q_OBJECT 
public:
    /** construtor */
    KWirelessMonitor(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~KWirelessMonitor();
    void setTimerThread(TimerThread *tthread);
    void updateStats(const QString& stats);
    
    void setPMModeHelper(int mode);
    bool isBatteryPMEnabled();
    bool isTransferPMEnabled();
    void disableMenuSettings();

protected slots:
    void slotDestroyed();
    void slotEnableSettings();
    void slotConfigure();
    void slotConfigApply();

protected:
    void toggleStatusBox();
    
    void mousePressEvent(QMouseEvent *e);
    void paintEvent(QPaintEvent *e);

private:
    QVBox *mStatusBox;
    TimerThread *mTimerThread;

    QAction *mActionConfigure;
    QAction *mActionEnableSettings;
    ConfigDialog *mConfigDialog;
    QString mStatusStr;
    QLabel *mStatusLabel;

    KProcess *mHelper;
    FILE *mHelperFifo;

    QString *mCurInterface;
    //int mCurPMMode;
    int mCurBRMode;
    int mCurBRManualIdx;
};

#endif /* KWIRELESSMONITOR_H */
