/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache\@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation, and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.ibm.com .  For more information
 * on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

/*
 * $Log: smvgen.cpp,v $
 * Revision 1.9  2004/04/15 19:05:47  alex
 * Support of firewalls
 *
 * Revision 1.8  2004/03/05 02:24:25  alex
 * Threadsafe
 *
 * Revision 1.7  2004/03/04 23:40:20  alex
 * *** empty log message ***
 *
 * Revision 1.5  2003/11/25 20:59:36  alex
 * Host objects: additional features
 *
 * Revision 1.4  2003/11/21 01:47:54  alex
 * Implementation of Host Object tags support
 *
 * Revision 1.3  2003/11/10 22:02:16  alex
 * Segmentation fault bug fixing
 *
 * Revision 1.2  2003/10/29 16:57:02  roman
 * Fixing problem of correct working with caml from ScenarioApp
 *
 * Revision 1.1.1.1  2003/10/28 22:15:44  rl
 * Initial import
 *
 * Revision 1.3  2003/04/03 12:52:01  RL
 * full xml_comp version
 *
 * Revision 1.2  2003/03/28 03:05:25  oleg
 * Full working version.  Next task: adding second pass to count
 * hosts, services, etc. before main processing.
 *
 * Revision 1.1  2001/05/11 19:17:14  oleg
 * Initial revision
 *
 */


#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/XMLUniDefs.hpp>
#include <xercesc/framework/XMLFormatter.hpp>
#include <xercesc/util/TranscodingException.hpp>


#include <xercesc/dom/deprecated/DOM_DOMException.hpp>

#include <xercesc/dom/deprecated/DOMParser.hpp>
#include <xercesc/dom/deprecated/DOM.hpp>
#include "ErrorReporter.hpp"
#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include <fstream>

#include <ext/hash_map>
#include <outpost.h>
#include "Network.hpp"
#include "StateInfo.hpp"
#include "cint.h"

#ifndef NO_ODBC
#include "odbc.hpp"
#endif

#ifndef NO_REACH
#include <caml/callback.h>
#endif

#define  MAXNAMELEN 100

// ---------------------------------------------------------------------------
//  Forward references
// ---------------------------------------------------------------------------
void     usage();
ostream& operator<<(ostream& target, const DOMString& toWrite);
ostream& operator<<(ostream& target, DOM_Node& toWrite);
XMLFormatter& operator<< (XMLFormatter& strm, const DOMString& s);


void InitializeCompiler();
void GenerateNetwork( AuxilaryParserData *auxilary, Network *network, DOM_Element *element );



// ---------------------------------------------------------------------------
//
//  Usage()
//
// ---------------------------------------------------------------------------
void usage() 
{
}

// ---------------------------------------------------------------------------
//
//  main
//
// ---------------------------------------------------------------------------

// The function should be called in main() before xml_parser() is called
bool init_xml_parser()
{
    // Initialize the XML4C2 system
  try
  {
    XMLPlatformUtils::Initialize();
  }
  catch(const XMLException& toCatch)
  {
    cerr << "Error during Xerces-c Initialization.\n"
       << "  Exception message:"
       << DOMString(toCatch.getMessage()) << endl;
    return false;
  }
  
  return true;
}

Network* xml_parser(string xmlname)
{
  AuxilaryParserData *auxilary = 0;
  Network *network = 0;

  char opt;
  string target("*unspecified*");
    
  network = new Network();
  auxilary = new AuxilaryParserData();
      
  auxilary->Initialize();

  // gXmlFile = xmlname.c_str();

  //
  //  Create our parser, then attach an error handler to the parser.
  //  The parser will call back to methods of the ErrorHandler if it
  //  discovers errors during the course of parsing the XML document.
  //
  DOMParser *parser = new DOMParser;
  ErrorHandler *errReporter = new DOMTreeErrorReporter();
  parser->setErrorHandler(errReporter);

#ifndef NO_REACH
  // CAML startup
  //RL Temporal solution!!!
  char **argv;
    
  argv = new char*[2];
  argv[0] = new char[100];
  strcpy(argv[0], "graph_view");
  argv[1] = 0;
   
  CamlStartup(argv);
#endif

#ifndef NO_ODBC
  // ODBC startup
  auxilary->Odbc.EstablishDBConnection();
#endif

//RL Registration of nessus scanner
  char      *home_path = getenv("HOME");
  char       pref_path[255];
  string     host_name;
  string     port;
  string     user_name;
  string     user_password;

  sprintf(pref_path, "%s/.sgraph/mdlgen/nessus/preferences", home_path);
    
  ifstream   in_stream( (const char*)pref_path );
    
  if ( in_stream.is_open() )
  {
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    host_name = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    port = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    user_name = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    user_password = string( pref_path );
    
    in_stream.close();
  }


  StringList  reg_info;
  reg_info.push_back(host_name);  
  reg_info.push_back(port);  
  reg_info.push_back(user_name);
  reg_info.push_back(user_password);
 
  NessusScanner *scanner = new NessusScanner();
  scanner->set_register_data(reg_info);
  
  auxilary->scan_mang.ScannerRegistration(scanner);

  
  /*
  // Test Outpost
  auxilary->Outpost.EstablishDBConnection();

  auxilary->Odbc.DBGetData("smilla.mitre.org", IP_BY_HOST, BUF_LEN_128, "1780");  
  exit(0);
  */
  //
  //  Parse the XML file, catching any XML exceptions that might propogate
  //  out of it.
  //
  bool errorsOccured = false;
  try
    {
      cout << xmlname;
      parser->parse(xmlname.c_str());
    }

  catch (const XMLException& e)
    {
      cerr << "An error occured during parsing\n   Message: "
	   << DOMString(e.getMessage()) << endl;
      errorsOccured = true;
    }

 
  catch (const DOM_DOMException& e)
    {
      cerr << "An error occured during parsing\n   Message: "
	   << DOMString(e.msg) << endl;
      errorsOccured = true;
    }

  catch (...)
    {
      cerr << "An error occured during parsing\n " << endl;
      errorsOccured = true;
    }


  // If the parse was successful, output the document data from the DOM tree
  if (!errorsOccured) {
    DOM_Node doc = parser->getDocument();
    DOM_Node child = doc.getFirstChild();
    while (child != 0) {
      DOMString nodeName = child.getNodeName();

      if (nodeName.equals(auxilary->enames[NETWORK])) {
        DOM_Element *element = (DOM_Element *) &child;
        GenerateNetwork( auxilary, network, element);
        break;
      }
      child = child.getNextSibling();
    }
  } 
  else {
    delete network;
    network = 0;
  }
  

  //
  //  Clean up the error handler. The parser does not adopt handlers
  //  since they could be many objects or one object installed for multiple
  //  handlers.
  //
  delete errReporter;

  //
  //  Delete the parser itself.  Must be done prior to calling Terminate, below.
  //
  delete parser;

  char inputFileName[MAXNAMELEN+1];
  inputFileName[MAXNAMELEN] = '\0';
  strncpy(inputFileName, xmlname.c_str(), MAXNAMELEN);
  char *FileName = strtok(inputFileName, ".");
  char outputFileName[MAXNAMELEN+5];


  // And call the termination method
  // XMLPlatformUtils::Terminate();
  // DomMemDebug().print();

  // Close data sources
  // auxilary->Outpost.TerminateDBConnection();

  //
  //  The DOM document and its contents are reference counted, and need
  //  no explicit deletion.
  //

  // Test OCAML interface
  // bool reach = network->Reachable("network.dat", 2, 0, 80);
  // printf("\nReachability test: %s\n\n", reach ? "true" : "false");

#ifndef NO_REACH
  // CAML finalizing
  //RL Temporal solution!!!
  delete argv[0];
  delete argv;
#endif

  delete auxilary;
  
  return network;
}

void GenerateNetwork( AuxilaryParserData *auxilary, Network *network, DOM_Element *element )
{
  assert(element != NULL);
  // Retrieve hosts, attacks, and services attributes

  bool DeclarativeFormat = false;
  int numhosts = 0, numattacks = 0, numservices = 0;
  
  network->auxilary = auxilary;
  
  DOM_Attr attribute = element->getAttributeNode(auxilary->enames[HOSTS]);
  if (!attribute.isNull())
    numhosts = atoi(attribute.getValue());

  attribute = element->getAttributeNode(auxilary->enames[ATTACKS]);
  if (!attribute.isNull())
    numattacks = atoi(attribute.getValue());

  attribute = element->getAttributeNode(auxilary->enames[SERVICES]);
  if (!attribute.isNull())
    numservices = atoi(attribute.getValue());
  
  if (numhosts > 0 && numattacks > 0 && numservices > 0) {
    network->SetNumHosts(numhosts);
    network->SetNumAttacks(numattacks);
    network->SetNumServices(numservices);
    DeclarativeFormat = true;
  }
  else {
    network->SetNumHosts(0);
    network->SetNumAttacks(0);
    network->SetNumServices(0);

    network->CountingPass(element);
    DeclarativeFormat = false;
  }
  
  cout << "Graph element found: "
       << network->GetNumHosts() << " nodes, "
       << network->GetNumAttacks() << " actions, "
       << network->GetNumServices() << " state variables"
       << endl;
  if (network->GetNumHosts() <= 0 || network->GetNumAttacks() <= 0
      || network->GetNumServices() <= 0) {
    cerr << "Error: incorrect network initialization" << endl;
    exit(1);
  }

  // Initialize the NetInfo object.
  auxilary->theNet.numHosts = network->GetNumHosts();
  auxilary->theNet.numAttacks = network->GetNumAttacks();
  auxilary->theNet.numServices = network->GetNumServices();
  auxilary->theNet.numVars = 0;
  auxilary->theNet.numIVars = 0;

  // Process network elements
  for (DOM_Node child = element->getFirstChild(); child != 0; child = child.getNextSibling()) {

    if (child.getNodeType() != DOM_Node::ELEMENT_NODE) continue;
    DOM_Element *el = (DOM_Element *) &child;
    
    DOMString nodeName = el->getNodeName();

    if (nodeName.equals(auxilary->enames[HOST]))
      network->GenerateHost(el);
    else if (nodeName.equals(auxilary->enames[HOSTS]) && DeclarativeFormat)
      network->GenerateHosts(el);
    else if (nodeName.equals(auxilary->enames[ATTACKS]) && DeclarativeFormat)
      network->GenerateAttacks(el);
    else if (nodeName.equals(auxilary->enames[ATTACK]))
      network->GenerateAttack(el);
    else if (nodeName.equals(auxilary->enames[ADVERSARY]))
      network->adversary.Generate(el);
    else if (nodeName.equals(auxilary->enames[IDS]))
      network->ids.Generate(el);
    else if (nodeName.equals(auxilary->enames[SERVICES]) && DeclarativeFormat)
      network->GenerateServices(el);
    else if (nodeName.equals(auxilary->enames[VULNERABILITIES]) && DeclarativeFormat)
      network->GenerateVulnerabilities(el);
    else if (nodeName.equals(auxilary->enames[LTL_FORMULA]))
      network->GenerateLTLFormula(el);
    else if (nodeName.equals(auxilary->enames[FIREWALL]))
      network->GenerateFirewall(el);
  }
 
  cout << endl << "Local effects:" << endl;
  for (vector <Effect *>::iterator eff = network->priveff.begin();
       eff != network->priveff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  for (vector <Effect *>::iterator eff = network->passargeff.begin();
       eff != network->passargeff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  
  cout << endl << "Global effects:" << endl;
  for (vector <Effect *>::iterator eff = network->svceff.begin();
       eff != network->svceff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  for (vector <Effect *>::iterator eff = network->vuleff.begin();
       eff != network->vuleff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  for (vector <Effect *>::iterator eff = network->conneff.begin();
       eff != network->conneff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  for (vector <Effect *>::iterator eff = network->trusteff.begin();
       eff != network->trusteff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  for (vector <Effect *>::iterator eff = network->objeff.begin();
       eff != network->objeff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  for (vector <Effect *>::iterator eff = network->firewalleff.begin();
       eff != network->firewalleff.end(); eff++) {
    cout << "  " << *eff << endl;
  }
  
  //network->auxilary = 0;
  network->curr_doc = 0;
  
  network->ComputeFConnectivity();
}

ostream& operator<< (ostream& target, const DOMString& s)
{
  char *p = s.transcode();
  target << p;
  delete [] p;
  return target;
}

ostream& operator<< (ostream& target, const Precondition *pre)
{
  pre->Print(target);
  return target;
}

ostream& operator<< (ostream& target, const Effect *eff)
{
  eff->Print(target);
  return target;
}

int atoi(DOMString dstr)
{
  char *str = dstr.transcode();
  int val = atoi(str);
  delete [] str;
  return val;
}


void InitializeCompiler()
{
}
