#ifndef _SCANNER_HPP_
#define _SCANNER_HPP_

struct VulnerabilityScanInfo
{
  string vuln_name;
  string vuln_description;
  set<string> CVEs;
  
  void set_CVEs_string( const string &cves )
  {
    string cve = "";
    unsigned int ind = 0, ind_start = 0;
    
    while ( ind < cves.length() )
    {
      for ( ;ind < cves.length() && (cves[ind] == ' ' || cves[ind] == '\t'); ind ++ );
      
      if ( ind < cves.length() )
      {
        ind_start = ind;
        ind = cves.find( ',', ind_start );
        cve = cves.substr( ind_start, ((ind == string::npos)? string::npos: ind - ind_start) );
        
        CVEs.insert( cve );
        
        if ( ind != string::npos )
          ind++;
      }
    }
  }
};

struct PortScanInfo
{
  unsigned int port_id;
  string   service_name;
  string   protocol_name;
  
  vector<VulnerabilityScanInfo*> detected_vulns;
  ~PortScanInfo()
  {
    for ( unsigned int i = 0; i < detected_vulns.size(); i++ )
      delete (VulnerabilityScanInfo*)detected_vulns[i];
  }
};

typedef set<PortScanInfo*> PortSet;

struct HostScanInfo
{
  string host_name;
  string host_ip;
  vector<PortScanInfo*> opened_ports;
  
  ~HostScanInfo()
  {
    for ( unsigned int i = 0; i < opened_ports.size(); i++ )
      delete (PortScanInfo*)opened_ports[i];
    opened_ports.clear();
  }
  
  StringSet* get_CVEs()
  {
    StringSet* cve_set = new StringSet();
    PortScanInfo  *port_info;
    VulnerabilityScanInfo*  vuln_info;
    
    for (unsigned int indx_port = 0; indx_port < opened_ports.size(); indx_port++)
    {
      port_info = opened_ports[indx_port];
      for (unsigned int indx_vuln = 0; indx_vuln < port_info->detected_vulns.size(); indx_vuln++)      
      {
        vuln_info = port_info->detected_vulns[indx_vuln];    
        cve_set->insert(vuln_info->CVEs.begin(), vuln_info->CVEs.end());
      }
    }
    
    return cve_set;
  }
  
  PortSet *get_services()
  {
    PortSet* svc_set = new PortSet();
    PortScanInfo  *port_info;
    
    for (unsigned int indx_port = 0; indx_port < opened_ports.size(); indx_port++)
    {
      port_info = opened_ports[indx_port];
      svc_set->insert(port_info);
    }
    
    return svc_set;
  }
  
  // for debuging
  void trace()
  {
    cout << host_name << " " << host_ip << endl;
    for (unsigned int i = 0; i < opened_ports.size(); i++)
    {
      cout << "\tPORT: " << opened_ports[i]->port_id << "; Service: " << opened_ports[i]->service_name << "; Protocol: " << opened_ports[i]->protocol_name << endl;
      for ( unsigned int j = 0; j < opened_ports[i]->detected_vulns.size(); j++ )
      {
        cout << "\t\tVuln. Name: " << opened_ports[i]->detected_vulns[j]->vuln_name << endl << "\t\tVuln. Descr: " << opened_ports[i]->detected_vulns[j]->vuln_description << endl;
        cout << "\t\tCVEs: ";
        if ( !opened_ports[i]->detected_vulns[j]->CVEs.empty() )
        {
          for ( set<string>::iterator p = opened_ports[i]->detected_vulns[j]->CVEs.begin(); p != opened_ports[i]->detected_vulns[j]->CVEs.end(); p++ )
              cout << *p << " ";
        }
        cout << endl;
        cout << endl;
        
      }
    }
  }
};


class UnknownHostError {
private:
  string errorString;

public:
  UnknownHostError(string error) : errorString(error) {}
  UnknownHostError() { UnknownHostError("Unknown host"); }
};

struct ScannedHost
{
  StringSet IP;
  PortSet services;
  StringSet CVEs;
};  

typedef map<string, ScannedHost*> ScannedHostMap;
typedef map<string, ScannedHost*>::iterator ScannedHostMapIter;

typedef list<string> StringList;
typedef list<string>::iterator StringListIter;

class Scanner
{
protected:
  ScannedHostMap  hosts;  
  string          scanner_name;  
  virtual bool  add_host_info(const string &host_name) = 0;

public:
  Scanner() {};
  virtual ~Scanner() {};

  virtual bool  set_register_data(const StringList &reg_strs) = 0;

  string        get_scanner_name() { return scanner_name; }
  StringSet*    getIP(const string &host_name) throw(UnknownHostError);
  PortSet*      getServices(const string &host_name) throw(UnknownHostError);
  StringSet*    getCVEs(const string &host_name) throw(UnknownHostError);
};

typedef map<string, Scanner*> ScannerMap;
typedef map<string, Scanner*>::iterator ScannerMapIter;

class ScannerManager
{
  ScannerMap  scanners;
public:
  ScannerManager() {};
  ~ScannerManager() 
  {
    for ( ScannerMapIter it = scanners.begin(); it != scanners.end(); it++ )
      if ( it->second != 0 )
        delete it->second;
    scanners.clear();
  };  
  
  void ScannerRegistration(Scanner *s)
  {
    scanners[s->get_scanner_name()] = s;
  }
  
  Scanner* get_scanner(const string &scanner_name)
  {
    ScannerMapIter  iter;
    
/*    cout << "Enter to the get_scanner with " << scanner_name << "\n";
    cout << "Scanners list:\n";
    for (iter = scanners.begin(); iter != scanners.end(); iter++)
      cout << "\tScanner name: " << (*iter).first << "\n";*/
    
    iter = scanners.find(scanner_name);
    
/*    bool yes = ((iter == scanners.end()) ? false : true);
    cout << "Is scanner found?  " << yes << "\n";*/
    
    if (iter != scanners.end())
      return (*iter).second;
    else
      return 0;
  }
};

#endif
