/*
 * $Id: control.h,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $
 *
 * *************** Property of the Mitre Corporation *****************
 * Redistribution of this code in source or binary form for any reason
 * is prohibited without express permission of the Mitre Corporation.
 *
 * Copyright (C) 2000 - The Mitre Corporation
 * *******************************************************************
 */


/*
 * Define external global variables, data types, and functions
 * accessible to probes
 */

#ifndef __WINPATCH_HEADER__
#define __WINPATCH_HEADER__

#include <stddef.h>

/*
 * Server operation result codes
 */
#define OP_OK 0                /* Successful operation */
#define OP_PARSE_COMPLETE 1    /* Done parsing probe results */
#define OP_END_SESSION 2       /* Terminate client session */
#define OP_CLIENT_NOT_FOUND 3  /* Client is not registered with Outpost */
#define OP_CLIENT_EXISTS 4     /* Client is registered with Outpost */
#define OP_UPGRADE 5           /* Command Client to download an upgrade */

/*
 * Operation failed
 */
#define ERR_FATAL -1         /* Tell client to quit */
#define ERR_REPEAT_PROBE -2  /* Tell client to run probe again */
#define ERR_NEXT_PROBE -3    /* Move on to next probe on list */
#define ERR_ACCESS_DENIED -4 /* Bad authentication string from client */

/*
 * Debug log message levels
 */
#define DEBUG_0 0
#define DEBUG_1 1
#define DEBUG_2 2

/*
 * Patch comparison flag
 */
#define MATCH_PARTIAL 0
#define MATCH_EXACT 1

/*
 * Error message types
 */
#define APP_ERROR 0
#define DB_ERROR 1


/*
 * Error message formats
 */
#define LOG_MSG 0
#define XML_MSG 1

/*
 * WinPatch Functions
 */
#define INSTALL_ANALYSIS 1
#define REMOVE_ANALYSIS 2
#define DO_PATCH 3
#define WINDOW_RESPONSE 4

/*
 * Operating System Types
 */
#define OS_UNKNOWN 0
#define OS_SUNOS 1
#define OS_WINDOWS 2

/*
 * Various length parameters
 */
#define BUF_LEN_16 16
#define BUF_LEN_32 32
#define BUF_LEN_64 64
#define BUF_LEN_128 128
#define BUF_LEN_256 256
#define BUF_LEN_512 512
#define BUF_LEN_1024 1024
#define BUF_LEN_2048 2048


#define ORA_NOT_FOUND 1403  /* SELECT returned nothing */

/*
 * Kinds of data being retrieved from the Outpost database
 */


typedef enum dkind {
  HOST_CVE_VULNERABILITIES,
  HOST_SERVICES,
  VULNERABILITY_HOSTS,
  PORTS_BY_HOST_PID,
  IP_BY_HOST
} DBDataType;

typedef struct serverConfigType {
  char dbUID[BUF_LEN_32];
  char dbPassword[BUF_LEN_32];
  char dbHost[BUF_LEN_256];
  int debugLevel;
  char debugLogFile[BUF_LEN_512];
  int debugOverwrite;
  char errorLevel[BUF_LEN_32];
} serverConfigType;

/* Linked list of Name:Value pairs */
typedef struct nvListType {
  char *name;
  char *value;
  struct nvListType *next;
} nvListType;


typedef struct patchInfoType {
  int patchid;
  char patchName[BUF_LEN_128];
  struct patchInfoType *next;
} patchInfoType;

typedef struct patchConfigType {
  char clientid[BUF_LEN_128];
  char sessionid[BUF_LEN_128];
  int osType;
  struct patchInfoType *patch;
  struct patchInfoType *install;
  struct patchInfoType *remove;
} patchConfigType;


typedef struct replyType {
  char *contentType;
  struct nvListType *nvPtr;
  struct replyType *next;
} replyType;



#endif

