
#ifndef _ODBC_HEADER_
#define _ODBC_HEADER_

#include <outpost.h>

#include <odbc++/drivermanager.h>
#include <odbc++/connection.h>
#include <odbc++/preparedstatement.h>
#include <odbc++/resultset.h>
#include <odbc++/resultsetmetadata.h>
#include <odbc++/databasemetadata.h>

#include <set>
#include <string>

using namespace std;

typedef set<string> StringSet;

class ODBC {

public:
  
  ODBC() throw(FatalError) {
    con = NULL;
  }
  ~ODBC() {}

  // Database interface
  void EstablishDBConnection() throw(FatalError);
  StringSet *DBGetData(const char *hostname, DBDataType dbtype, int MaxLength, const char *aux = "")
    throw(FatalError);
  int DBGetPidByHostAndService(const char *hostname, const char *svcname) throw(FatalError);
  void TerminateDBConnection();

private:
  odbc::Connection *con;
};

#endif // _ODBC_HEADER_
