#include <iostream>
#include <set>
#include <map>
#include <list>
#include <vector>
#include <stdlib.h>
#include <xercesc/dom/deprecated/DOM.hpp>
#include <cstring>
#include <string>
#include <stdio.h>
#include <outpost.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <fcntl.h> 
#include "scanners.hpp"
#include "nessus_scaninfo.hpp"
#include "nessus_scanner.hpp"
#include "hostnameip.h"

 
bool run_nessus( const string server_name, const string &port, const string &user_name, 
                   const string &pass, const string &host_name, char* res_file_name );
 
NessusScanner::NessusScanner()
{
  scanner_name = "|Nessus|";
}

bool NessusScanner::set_register_data(const StringList &reg_strs)
{
  StringList::const_iterator  iter = reg_strs.begin();
  
  if (reg_strs.size() != 4)
    return false;
  else
  {
    m_server_name = *(iter++);
    m_port = *(iter++);
    m_user_name = *(iter++);
    m_password = *iter;
    
  }
   
  return true;
};

bool NessusScanner::add_host_info(const string &host_name)
{
  bool    ret = true;
  char   res_file_name[100];
  ScannedHost*  host = new ScannedHost();
  
  ret = run_nessus( m_server_name, m_port, m_user_name, m_password, host_name, res_file_name);
  
  if (ret)
  {
//    cout << "Res file name: " << *res_file_name << "\n";
    HostScanInfo* scan_info = ParseNessusXML(string(res_file_name));
//    cout << "Res file name (after): " << *res_file_name << "\n";    
//    HostScanInfo* scan_info = ParseNessusXML("/tmp/resfileohPPmu");    
    if (scan_info != 0)
    {
      string s = HostNameToIP(host_name);
      if (s != "")
        host->IP.insert(s);
      else
        host->IP.insert(scan_info->host_ip);
      
      StringSet*  cve_set = scan_info->get_CVEs(); 
      host->CVEs.insert(cve_set->begin(), cve_set->end());
      delete cve_set;
      
      PortSet*  svc_set = scan_info->get_services(); 
      host->services.insert(svc_set->begin(), svc_set->end());
      delete svc_set;
    }  
    
    unlink(res_file_name);    
  }
  
  hosts[host_name] = host;  
    
  return ret;
};

bool run_nessus( const string server_name, const string &port, const string &user_name, const string &pass, const string &host_name, char* res_file_name )
{
  char**  argv = new char*[11];
  int     program_pid;
  char    dest_host_name[100];
  FILE*   dest_host_descr;
  int     status;
  bool    prog_ret = true;
    
  dest_host_name[0] = 0;
  strcat(dest_host_name, "/tmp/desthostXXXXXX");
  mktemp(dest_host_name);
  dest_host_descr = fopen(dest_host_name, "w");
  fprintf(dest_host_descr, "%s", host_name.c_str());
  fclose(dest_host_descr);
    
  res_file_name[0] = 0;
  strcat(res_file_name, "/tmp/resfileXXXXXX");
//  strcat(res_file_name, "/home/rl/tmp/rl-linux.xml");  
//  strcat(res_file_name, "/tmp/resfileohPPmu");  
  mktemp(res_file_name);
//  *res_file_name = new string(file_name);
    
  argv[0] = "nessus";
  argv[1] = "-T";
  argv[2] = "xml";   
  argv[3] = "-qx";
  argv[4] = (char*)server_name.c_str();  
  argv[5] = (char*)port.c_str();
  argv[6] = (char*)user_name.c_str(); 
  argv[7] = (char*)pass.c_str();   
  argv[8] = (char*)dest_host_name;
  argv[9] = (char*)res_file_name;  
  argv[10] = 0;
  
  program_pid = fork();
	 
  if (program_pid == 0)
	{
    execvp((char*)argv[0], (char**)argv);    
    
    perror((char*)argv[0]);
    exit(errno);
	} else
  {
    if (waitpid(program_pid, &status, 0) == program_pid)
    {   
      int  fd = open(res_file_name, O_RDONLY, 0);

      if (fd > 0)
      {        
        prog_ret = true;
        close(fd);
      }
      else
        prog_ret = false;      
    }
    
    delete argv;
    unlink(dest_host_name);
    
    return prog_ret;
  }
  
  return prog_ret;
}
