
#include <iostream>

#include <xercesc/dom/deprecated/DOM_DOMException.hpp>

#include <xercesc/dom/deprecated/DOMParser.hpp>
#include <xercesc/dom/deprecated/DOM.hpp>
#include "ErrorReporter.hpp"

#include <map> 
#include <stdio.h>

#include <set>
#include <list>
#include <vector>
#include <stdlib.h>
#include <cstring>
#include <string>
#include <outpost.h>
#include "scanners.hpp" 
#include "nessus_scaninfo.hpp"

   
typedef map<long, VulnerabilityScanInfo*> NessusPluginMap;

HostScanInfo* ParseNessusXML( const string &file_name )
{
  //Nessus XML tags
  static DOMString REPORT_NODE_NAME = DOMString::transcode("report");
  static DOMString PLUGINS_NODE_NAME = DOMString::transcode("plugins");
  static DOMString PLUGIN_NODE_NAME = DOMString::transcode("plugin");
  static DOMString CVE_ID_NODE_NAME = DOMString::transcode("cve_id");
  static DOMString RESULTS_NODE_NAME = DOMString::transcode("results");
  static DOMString RESULT_NODE_NAME = DOMString::transcode("result");
  static DOMString HOST_NODE_NAME = DOMString::transcode("host");
  static DOMString NAME_ATTR = DOMString::transcode("name");
  static DOMString ID_ATTR = DOMString::transcode("id");
  static DOMString HOST_IP_ATTR = DOMString::transcode("ip");
  static DOMString PORTS_NODE_NAME = DOMString::transcode("ports");
  static DOMString PORT_NODE_NAME = DOMString::transcode("port");
  static DOMString PORT_PROTOCOL_ATTR = DOMString::transcode("protocol");
  static DOMString PORT_ID_ATTR = DOMString::transcode("portid");
  static DOMString SERVICE_NODE_NAME = DOMString::transcode("service");
  static DOMString INFORMATION_NODE_NAME = DOMString::transcode("information");
  static DOMString SEVERITY_NODE_NAME = DOMString::transcode("severity");
  static DOMString SEVERITY_HOLE_VALUE = DOMString::transcode("Security Hole");
  static DOMString SEVERITY_WARNING_VALUE = DOMString::transcode("Security Warning");
  static DOMString SEVERITY_NOTE_VALUE = DOMString::transcode("Security Note");
  static DOMString DATA_NODE_NAME = DOMString::transcode("data");

  bool             errorsOccured = false;
  HostScanInfo    *host = 0;
  NessusPluginMap  nessus_plugins;
  
  DOMParser    *parser = new DOMParser;
  ErrorHandler *errReporter = new DOMTreeErrorReporter();
  parser->setErrorHandler(errReporter);
  
  // Parse XML file
  try
  {
    parser->parse( file_name.c_str() );
  }
  catch (const XMLException& e)
  {
    cerr << "An error occured during parsing\n   Message: "
	       << DOMString( e.getMessage() ).transcode() << endl;
    errorsOccured = true;
  }
  catch (const DOM_DOMException& e)
  {
    cerr << "An error occured during parsing\n   Message: "
         << DOMString( e.msg ).transcode() << endl;
    errorsOccured = true;
  }
  catch (...)
  {
    cerr << "An error occured during parsing\n " << endl;
    errorsOccured = true;
  }
  
  if (!errorsOccured) 
  {
    DOM_Node doc = parser->getDocument();
    DOM_Node child = doc.getFirstChild();
    DOMString nodeName = child.getNodeName();
    
    //find report tag
    while ( !nodeName.equals( REPORT_NODE_NAME ) ) 
    {
      child = child.getNextSibling();
      if ( child == 0 )
        break;
      
      nodeName = child.getNodeName();
    }
    
    // read report
    if ( nodeName.equals(REPORT_NODE_NAME) ) 
    {
      DOM_Node root_child = child.getFirstChild();
      DOM_Node sub_child;
      DOM_Node text_node;
      nodeName = root_child.getNodeName();
      
      //find plugins tag 
      while ( !nodeName.equals( PLUGINS_NODE_NAME ) ) 
      {
         root_child = root_child.getNextSibling();
         nodeName = root_child.getNodeName();
      }
      
      // read plugins
      if ( nodeName.equals( PLUGINS_NODE_NAME ) ) 
      {
        child = root_child.getFirstChild();
        root_child = root_child.getNextSibling();
               
        while ( child != 0 ) 
        {
          nodeName = child.getNodeName();
          
          // read plugin
          if ( nodeName.equals(PLUGIN_NODE_NAME) )
          {
            DOM_Element *element = (DOM_Element *) &child;
            DOM_Attr attribute = element->getAttributeNode( ID_ATTR );
            long     plugin_id = 0;
            
            if ( !attribute.isNull() )
              plugin_id = atol( attribute.getValue().transcode() ); // get plugin id
            
            if ( plugin_id > 0 )
            {
              VulnerabilityScanInfo *vuln_info = new VulnerabilityScanInfo();
              
              sub_child = child.getFirstChild();
              
              while ( sub_child != 0 )     
              {
                nodeName = sub_child.getNodeName();
                
                if ( nodeName.equals(CVE_ID_NODE_NAME) ) // get CVEs
                {
                  text_node = sub_child.getFirstChild();
                  if ( text_node != 0 )
                    vuln_info->set_CVEs_string( text_node.getNodeValue().transcode() );
                }
                else if ( nodeName.equals(NAME_ATTR) ) // get name
                {
                  text_node = sub_child.getFirstChild();
                  
                  if ( text_node != 0 )
                    vuln_info->vuln_name = text_node.getNodeValue().transcode();
                }
                
                sub_child = sub_child.getNextSibling();
              }                
              
              // store plugin info
              nessus_plugins[plugin_id] = vuln_info;
            }
          }
          child = child.getNextSibling();
        }
      }
      
      nodeName = root_child.getNodeName();
      
      // find report results tag
      while ( !nodeName.equals( RESULTS_NODE_NAME ) ) 
      {
        root_child = root_child.getNextSibling();
        
        if ( root_child == 0 )
            break;
        
        nodeName = root_child.getNodeName();
      }
      
      // read report results
      if ( nodeName.equals( RESULTS_NODE_NAME ) )
      {
        root_child = root_child.getFirstChild();
        nodeName = root_child.getNodeName();
       
        // find result (host and ports info)
        while ( !nodeName.equals( RESULT_NODE_NAME ) ) 
        {
          root_child = root_child.getNextSibling();
        
          if ( root_child == 0 )
            break;
          
          nodeName = root_child.getNodeName();
        }
        
        if ( nodeName.equals( RESULT_NODE_NAME ) )
        {
          child = root_child.getFirstChild();
          nodeName = child.getNodeName();
          
          // find host tag
          while ( !nodeName.equals( HOST_NODE_NAME ) ) 
          {
            child = child.getNextSibling();
        
            if ( child == 0 )
              break;
          
            nodeName = child.getNodeName();
          }
        }
        
        // read host info
        if ( nodeName.equals( HOST_NODE_NAME ) )
        {
          DOM_Element *element = (DOM_Element *) &child;
          DOM_Attr attribute = element->getAttributeNode( NAME_ATTR );
          
          host = new HostScanInfo();
          
          if ( !attribute.isNull() )
            host->host_name = string( attribute.getValue().transcode() ); // get host name
          
          attribute = element->getAttributeNode( HOST_IP_ATTR );
          
          if ( !attribute.isNull() )
            host->host_ip = string( attribute.getValue().transcode() ); // get host ip
          
          //read ports info
          child = child.getNextSibling();
          nodeName = child.getNodeName();
          
          // find ports tag
          while ( !nodeName.equals( PORTS_NODE_NAME ) ) 
          {
            child = child.getNextSibling();
            if (child == 0)
              break;
            nodeName = child.getNodeName();
          }
          
          // read ports info
          if ( nodeName.equals( PORTS_NODE_NAME ) )
          {
            child = child.getFirstChild();
            
            while ( child != 0 )
            {
              nodeName = child.getNodeName();
            
              // read port info
              if ( nodeName.equals( PORT_NODE_NAME ) )
              {
                PortScanInfo *port = new PortScanInfo();
                
                element = (DOM_Element *) &child;
                attribute = element->getAttributeNode( PORT_PROTOCOL_ATTR );
                
                if ( !attribute.isNull() )
                  port->protocol_name = string( attribute.getValue().transcode() ); // get protocol name
                
                attribute = element->getAttributeNode( PORT_ID_ATTR );
                
                if ( !attribute.isNull() )
                  port->port_id = atoi( attribute.getValue().transcode() ); // get port id
                
                sub_child = child.getFirstChild();
                
                nodeName = sub_child.getNodeName();
                
                // find service tag
                while ( !nodeName.equals( SERVICE_NODE_NAME ) ) 
                {
                  sub_child = sub_child.getNextSibling();
                  
                  if (sub_child == 0)
                    break;
                  
                  nodeName = sub_child.getNodeName();
                }
                
                // read service name
                if ( nodeName.equals( SERVICE_NODE_NAME ) )
                {
                  element = (DOM_Element *) &sub_child;
                  attribute = element->getAttributeNode( NAME_ATTR );
                  port->service_name = string( attribute.getValue().transcode() );
                  
//                  cout << "service = " << port->service_name << "\n";
                  
                  sub_child = sub_child.getNextSibling();
                }
                
                bool is_vuln;
                while ( sub_child != 0 )
                {
                  nodeName = sub_child.getNodeName();
                  
                  // find and read the port vulnerabilities info
                  if ( nodeName.equals( INFORMATION_NODE_NAME ) )
                  {
                    DOM_Node data_node = sub_child.getFirstChild();
                    nodeName = data_node.getNodeName();
                    
                    is_vuln = false;
                    
                    // find severity tag
                    while ( !nodeName.equals( SEVERITY_NODE_NAME ) ) 
                    {
                      data_node = data_node.getNextSibling();
                      
                      if (data_node == 0)
                        break;
                      
                      nodeName = data_node.getNodeName();
                    }
                    
                    // verify if this is vulnerability
                    if ( nodeName.equals( SEVERITY_NODE_NAME ) )
                    {
                      text_node = data_node.getFirstChild();
                      
                      if ( text_node != 0 )
                        is_vuln = !( SEVERITY_NOTE_VALUE.equals( text_node.getNodeValue() ) );
                    }
                    
                    // read vulnerability info
                    if ( is_vuln )
                    {
                      VulnerabilityScanInfo *vuln = 0;
                      data_node = data_node.getNextSibling();
                      nodeName = data_node.getNodeName();
                      
                      // find plugin id tag
                      while ( !nodeName.equals( ID_ATTR ) ) 
                      {
                        data_node = data_node.getNextSibling();
                        
                        if (data_node == 0)
                          break;
                        
                        nodeName = data_node.getNodeName();
                      }
                      
                      if ( nodeName.equals( ID_ATTR ) )
                      {
                        long plugin_id = 0;
                        text_node = data_node.getFirstChild();
                        
                        if ( text_node != 0 )
                        {
                          plugin_id = atol( text_node.getNodeValue().transcode() ); // get plugin id
                          VulnerabilityScanInfo *plugin_info = nessus_plugins[plugin_id]; // get plugin info
                          
                          // copy plugin vulnerability info
                          if ( plugin_info != 0 )
                          {
                            vuln = new VulnerabilityScanInfo();
                            vuln->vuln_name = plugin_info->vuln_name;// vuln. name
                            vuln->CVEs = plugin_info->CVEs; // CVEs
                          }
                          
                          data_node = data_node.getNextSibling();
                          nodeName = data_node.getNodeName();
                          
                          // find vuln. data tag
                          while ( !nodeName.equals( DATA_NODE_NAME ) ) 
                          {
                            data_node = data_node.getNextSibling();
                            
                            if (data_node == 0)
                              break;
                            
                            nodeName = data_node.getNodeName();
                          }
                          
                          // read vuln.description
                          if ( nodeName.equals( DATA_NODE_NAME ) )
                          {
                            text_node = data_node.getFirstChild();
                            
                            if ( text_node != 0 )
                            {
                              unsigned int i;
                              string descr = "";
                              string data = string( text_node.getNodeValue().transcode() );
                                                            
                              for ( i = 0; i < data.length(); i++ )
                              {
                                if (data[i] != '\t' )
                                  descr += data[i];
                              }
                              unsigned int pos_start = 2;
                              unsigned int pos = descr.find( "\n\n", pos_start );
                              descr = descr.substr( pos_start, pos - pos_start );
                              
                              for ( i = 0; i < descr.length(); i++ )
                              {
                                if (descr[i] == '\n' )
                                  descr[i] = ' ';
                              }
                              
                              vuln->vuln_description = descr;
                            }
                          }
                        }
                      }
                      
                      // store port vuln. info
                      
                      if ( vuln != 0 )
                        port->detected_vulns.push_back( vuln );
                    }
                  }
                  
                  sub_child = sub_child.getNextSibling();
                }
                
                // store port info if a vuln. was detected
//                if ( port->detected_vulns.size() > 0 )
                  host->opened_ports.push_back( port );                
              }
              
              child = child.getNextSibling();
            }
          }
        }
      }
    }
  }
  
  // remove plugins info
  for ( NessusPluginMap::iterator p = nessus_plugins.begin(); p != nessus_plugins.end(); p++ )
  {
    delete (VulnerabilityScanInfo*)(*p).second;
  }
  
  delete errReporter;
  delete parser;
  
  return host;
}
