(* $Id: term.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

type term =
    Name of string
  | Variable of string
  | Complex of string * term list

exception Bad_list

let rec term2list f = function
    Name "$nil" -> []
  | Complex("$cons", [first; rest]) -> f(first) :: term2list f rest
	| Complex("$list", lst) -> List.map f lst
	| Complex("$pair", [first; second]) -> [f first; f second]
  | _ -> raise Bad_list 

let list2term f lst =
  Complex("$list", List.map f lst)

(* printers for terms *)

let display_simple cout s =
  output_string cout s

let rec display_term cout = function
    Name s -> display_simple cout s
  | Variable s -> display_simple cout s
  | Complex(s, []) -> failwith ("display term: invalid term: " ^ s)
  | Complex("$list", t :: ts) -> 
      output_string cout "[";
      display_term cout t;
      display_rest cout ts;
      output_string cout "]"
  | Complex("$pair", [first; second]) -> 
      output_string cout "[";
      display_term cout first;
      output_string cout "|";
      display_term cout second;
      output_string cout "]"
  | Complex(s, t :: ts) -> 
      display_simple cout s;
      output_string cout "(";
      display_term cout t;
      display_rest cout ts;
      output_string cout ")"
and display_rest cout = function
    [] -> ()
  | t :: ts ->
      output_string cout ",";
      display_term cout t;
      display_rest cout ts

let display_term_nl cout t =
  display_term cout t;
  output_char cout '.';
  output_char cout '\n'

let rec print_term t =
  let rec print_rest ts =
    match ts with
      [] -> ()
    | t :: ts ->
	Format.print_string ",";
	(* Format.print_cut(); *)
	Format.print_space();
	print_term t;
	print_rest ts in	
  match t with
    Name s -> Format.print_string s
  | Variable s -> Format.print_string s
  | Complex("$list", []) -> Format.print_string "[]"
  | Complex(s, []) -> failwith ("print term: invalid term: " ^ s)
  | Complex("$list", t :: ts) -> 
      Format.print_string "[";
      Format.open_box 0;
      print_term t;
      print_rest ts;
      Format.close_box();
      Format.print_string "]"
  | Complex("$pair", [first; second]) -> 
      Format.print_string "[";
      Format.open_box 0;
      print_term first;
      Format.print_string "|";
      print_term second;
      Format.close_box();
      Format.print_string "]"
  | Complex(s, t :: ts) -> 
      Format.print_string s;
      Format.print_string "(";
      Format.open_box 0;
      print_term t;
      print_rest ts;
      Format.close_box();
      Format.print_string ")"

let print_term_nl t =
  print_term t;
  Format.print_string ".";
  Format.print_newline()
