(* $Id: savant.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

open Bdd
open Bdd_utils
open Spine
open Term
open Ippkts
open Spec
open Actions
open Action_term

let debug = false

let ippkts2actions t =
  try 
    let specs = term2ippkts t in
    let actions = specs2actions specs in
    if debug then (
      print_actions actions;
      Format.print_newline());
    list2term action2term actions
  with
    e -> Complex("nar_error",
		 [Name("'ippkts: " ^ Printexc.to_string(e) ^ "'")])

let subset t1 t2 =
  try
    let a1 = term2list term2action t1 in
    let a2 = term2list term2action t2 in
    let s1 = actions2spines a1 in
    let s2 = actions2spines a2 in
    let b1 = spines2bdd s1 in
    let b2 = spines2bdd s2 in
    if is_falsehood(difference b1 b2) then
      Name "$T"
    else
      Name "$F"
  with
    e -> Complex("nar_error",
		 [Name("'subset: " ^ Printexc.to_string(e) ^ "'")])

let not_empty_intersection t1 t2 =
  try
    let a1 = term2list term2action t1 in
    let a2 = term2list term2action t2 in
    let s1 = actions2spines a1 in
    let s2 = actions2spines a2 in
    let b1 = spines2bdd s1 in
    let b2 = spines2bdd s2 in
    if is_falsehood(conjoin b1 b2) then
      Name "$F"
    else
      Name "$T"
  with
    e -> Complex("nar_error",
		 [Name("'empty intersection: " ^ Printexc.to_string(e) ^ "'")])

let savant t = 
  if debug then (
    print_term t;
    Format.print_string ".";
    Format.print_newline());
  match t with
    Complex("ippkts", _) ->
      ippkts2actions t
  | Complex("subset", [s1; s2]) ->
      subset s1 s2
  | Complex("not_empty_intersection", [s1; s2]) ->
      not_empty_intersection s1 s2
  | _ -> t
