(* $Id: prop_file.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* The main structure for the frame propagation program *)

let propagate_file input_file output_file =
  let input =
    if input_file = "-" then
      stdin
    else
      open_in input_file in

  (* read input *)

  let geom = List.map Graph_term.term2geom (Read_term.read_all_terms input) in

  (* do the main calculation *)

  let prop_geom = Prop.propagate_geometry geom in

  (* print the results *)

  let output =
    if output_file <> "-" && output_file <> input_file then
      open_out output_file
    else
      stdout in

  Graph_term.print_geometries output prop_geom

