(* $Id: nar.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* The main structure for the network analysis routines *)

(* Author: John D. Ramsdell *)

(* This program should report a version number somehow *)

(* This section is all for argument processing *)

(* Bdd defaults *)

let utn = ref 1
let uts = ref 509
let ctn = ref 1
let cts = ref 509

exception Bad_arg of int

let check_arg loc int =
  if int > 0 then
    loc := int
  else
    raise (Bad_arg int)

let default loc =
  " (default " ^ string_of_int !loc ^ ")"

(* file names *)

let input_file = ref "-"

let output_file = ref "-"

let anon_var = ref 0

let anon_fun str =
  match !anon_var with
    0 -> 
      input_file := str;
      anon_var := 1
  | 1 ->
      output_file := str;
      anon_var := 2
  | _ ->
      ()

(* savant server default *)

let path = ref ""

(* AGA mode *)

let net_model = ref ""
let reach_spec = ref ""
let prop_out = ref "prop.dat"

(* set up Arg.parse *)

let arg_spec =
  [("-n", Arg.String((:=) net_model), "net_file - file containing network model");
   ("-r", Arg.String((:=) reach_spec), "reach_spec - file containing reachability specification");
	 ]

let usage_msg = "Usage: nar -n net_file -r reach_spec";;

Arg.parse arg_spec anon_fun usage_msg;;

(* init bdd *)

Bdd.init(!utn, !uts, !ctn, !cts);;

(*
if !path = "" then
  Reachable.propagate_file !input_file !output_file
else
  Srv.savant_server !path;;
*)

if (!net_model = "") || (!reach_spec = "") then
	Printf.printf "Bad arguments.\n"
else
	(Printf.printf "Arguments ok.\n";
	 let graph = Reachable.load_file !net_model in
	 let spec = Reachable.read_spec !reach_spec in
	 let propres = Reachable.get_spec graph spec Savant.savant in
	 let result = Srv.savant_call propres in
	 Printf.printf "Spec term: ";
   Term.print_term_nl spec;
	 Printf.printf "Propagation result: ";
	 Term.print_term_nl propres;
	 Printf.printf "Result: ";
	 Term.print_term_nl result
	 );

exit 0
