(* $Id: lexer.mll,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* scanner for Otter terms in pure prefix form *)

(* Author: John D. Ramsdell *)

{
open Parser
} 

(* Note that the parser handles signed numbers. *)

let comment = '%' [^ '\n' ]* '\n'
let whitespace = [' ' '\t' '\r' '\n']
let ordinary = ['a' - 'z' 'A' - 'Z' '0' - '9' '$' '_']+
let special = ['*' '+' '-' '/' '\\' '^' '<' '>' '=' '`'
	      '~' ':' '?' '@' '&' '!' ';' '#']+
let doublequote = '"'[^ '"']* '"'
let singlequote = '\''[^ '\'']* '\''
rule token = parse
  comment       { token lexbuf }
| whitespace    { token lexbuf }
| '-'           { MINUS }  (* '-' and '+' are names requiring special *)
| '+'           { PLUS }   (* handling because they can be prefix ops *)
| ordinary      { NAME(Lexing.lexeme lexbuf) }
| special       { NAME(Lexing.lexeme lexbuf) }
| doublequote   { NAME(Lexing.lexeme lexbuf) }
| singlequote   { NAME(Lexing.lexeme lexbuf) }
| '('           { LPAR }
| ')'           { RPAR }
| '['           { LBRA }
| ']'           { RBRA }
| ','           { COMMA }
| '|'           { VBAR }
| '.'           { PERIOD }
| eof           { EOF }
