(* $Id: ippkts.ml,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

open Term
open Spec

exception Bad_ippkt

let name2ip s =
  let n = String.length(s) - 1 in
  let rec loop i d l =
    if i >= n then
      d :: l
    else
      let c = String.get s i in
      let i = i + 1 in
      if c == '.' then
	loop i 0 (d :: l)
      else if c >= '0' && c <= '9' then
	loop i (10*d + (Char.code(c) - Char.code('0'))) l
      else
	raise Bad_ippkt in
  match loop 1 0 [] with
    [d4; d3; d2; d1] -> Ip(d1, d2, d3, d4) 
  | _ -> raise Bad_ippkt

let cmp d =
  255 land lnot d

let complement_ip(Ip(d1, d2, d3, d4))
  = Ip(cmp d1, cmp d2, cmp d3, cmp d4) 

let int_range_element = function
    Name s -> 
      let port = int_of_string(s) in
      (port, port)
  | Complex("$cons", [Name lower; Name upper]) ->
      (int_of_string(lower), int_of_string(upper))
  | Complex("$pair", [Name lower; Name upper]) ->
      (int_of_string(lower), int_of_string(upper))
  | _ -> raise Bad_ippkt

let port_range t =
  Range(16, term2list int_range_element t)

let protocol_range t =
  Range(2, term2list int_range_element t)

let names2kindlist(src_pat, src_mask, src_port,
		   dst_pat, dst_mask, dst_port,
		   protocol) = 
  [Addr(name2ip(src_pat), complement_ip(name2ip(src_mask)));
    port_range(src_port);
    Addr(name2ip(dst_pat), complement_ip(name2ip(dst_mask)));
    port_range(dst_port);
    protocol_range protocol]

let term2spec = function
    Complex("permit", 
	    [Name src_pat;
	      Name src_mask;
	      src_port;
	      Name dst_pat;
	      Name dst_mask;
	      dst_port;
	      protocol]) ->
		Permit(names2kindlist(src_pat, src_mask, src_port,
				      dst_pat, dst_mask, dst_port,
				      protocol))
  | Complex("deny", 
	    [Name src_pat;
	      Name src_mask;
	      src_port;
	      Name dst_pat;
	      Name dst_mask;
	      dst_port;
	      protocol]) ->
		Deny(names2kindlist(src_pat, src_mask, src_port,
				    dst_pat, dst_mask, dst_port,
				    protocol))
  | _ -> raise Bad_ippkt
	
	
let term2ippkts = function
    Complex("ippkts", [specs]) ->
      List.rev(term2list term2spec specs)
  | _ -> raise Bad_ippkt

