/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache\@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation, and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.ibm.com .  For more information
 * on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

/*
 * $Log: mdlgen.cpp,v $
 * Revision 1.5  2004/03/05 00:06:12  alex
 * *** empty log message ***
 *
 * Revision 1.4  2004/03/04 23:41:29  alex
 * *** empty log message ***
 *
 * Revision 1.2  2004/02/17 00:39:29  alex
 * Calculating performance numbers
 *
 * Revision 1.1.1.1  2003/10/28 22:15:44  rl
 * Initial import
 *
 * Revision 1.1  2003/04/03 12:52:01  RL
 * full xml_comp version
 *
 * Revision 1.1  2001/05/11 19:17:14  oleg
 * Initial revision
 *
 */

 
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/XMLUniDefs.hpp>
#include <xercesc/framework/XMLFormatter.hpp>
#include <xercesc/util/TranscodingException.hpp>


#include <xercesc/dom/deprecated/DOM_DOMException.hpp>

#include <xercesc/dom/deprecated/DOMParser.hpp>
/*#include <xercesc/dom/DOMWriter.hpp>
#include <xercesc/dom/DOMImplementationRegistry.hpp>
#include <xercesc/dom/DOMImplementationLS.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>*/
#include <xercesc/dom/deprecated/DOM.hpp>
#include "ErrorReporter.hpp"
#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include <fstream>

#include <ext/hash_map>
#include <outpost.h>
#include <sys/time.h>

#include "Network.hpp"
#include "cint.h"

//RL
#include "DOMPrint.hpp"

#ifndef NO_ODBC
#include "odbc.hpp"
#endif

#ifndef NO_REACH
#include <caml/callback.h>
#endif

#define  MAXNAMELEN 100

void     usage();
// ---------------------------------------------------------------------------
//  Local data
// ---------------------------------------------------------------------------
static char*                    gXmlFile               = 0;

void InitializeCompiler();
void GenerateNetwork( AuxilaryParserData *auxilary, Network *network, DOM_Element *element );


//RL DOMPrint
static XMLFormatter::UnRepFlags gUnRepFlags            = XMLFormatter::UnRep_CharRef;

XMLCh*                   gEncodingName          = 0;
XMLFormatter*            gFormatter             = 0;

static void start_timer( struct timeval *start_time)
{
  gettimeofday(start_time, NULL );
}

static void report_performence(const string &performance_file, struct timeval *start_time, long mem )
{
  struct timeval stop;
  double seconds;
  char snum[255];
    
  gettimeofday(&stop, NULL );
  seconds = (stop.tv_sec-start_time->tv_sec) + ((double)stop.tv_usec-(double)start_time->tv_usec)/1000000;
  
  if ( !performance_file.empty() ){
    ofstream pout( performance_file.c_str(), ios::out | ios::app );
    
    if ( pout.is_open() ) {
      sprintf(snum, " %.3f,%ld", seconds, /*(double)clock() / (double)CLOCKS_PER_SEC,*/ mem);
      pout << string((const char*)snum);
      pout.close();
    }
  }
  
  sprintf( snum, "%.3f", seconds );
  cout << endl << "Performance time: " << snum << endl;
  cout << "Memory used:       " << mem << endl << endl;
}

static long calc_mem_size( Network *network, AuxilaryParserData *auxilary )
{
  long res = 0;
  res += network->GetMemSize() + sizeof(Network);
  res += sizeof( AuxilaryParserData );
  res += sizeof(DOMString) * END_MARKER;
  for ( int i = 0; i < END_MARKER; i++)
    res += ModelMemUsage::GetDOMStringSizeEx(auxilary->enames[i]);
  return res;
}

// ---------------------------------------------------------------------------
//
//  main
//
// ---------------------------------------------------------------------------
int main(int argc, char* argv[])
{
  int  retval = 0;
  long mem_used = 0;
  struct timeval start_time;
  string performance_file = "";
  Network network;
  AuxilaryParserData auxilary;

  // Initialize the XML4C2 system
  try
    {
      XMLPlatformUtils::Initialize();
    }

  catch(const XMLException& toCatch)
    {
      cerr << "Error during Xerces-c Initialization.\n"
	   << "  Exception message:"
	   << DOMString(toCatch.getMessage()) << endl;
      return 1;
    }

  // Check command line and extract arguments.
  if (argc < 2)
    {
      usage();
      XMLPlatformUtils::Terminate();
      return 1;
    }

  // Watch for special case help request
  if (!strcmp(argv[1], "-?"))
    {
      usage();
      XMLPlatformUtils::Terminate();
      return 2;
    }

  char opt;
  string target("*unspecified*");
  string xmlname("");
  string graphname("");
  string xml_output("");
  bool NuSMV_out = true;
  bool SPIN_out = true;
  while ((opt = getopt(argc, argv, "-t:sno:x:p:")) != -1) {
    switch (opt) {
    case 't':
      {
        target = optarg;
        cout << "Target host: " << target << endl;
        break;
      }
    case 's':
      {
        NuSMV_out = false;
        break;
      }
    case 'n':
      {
        SPIN_out = false;
        break;
      }
    case 'o':
      {
        graphname = optarg;
        cout << "Graph output file: " << graphname << endl;
        break;
      }
    case '\1':
      {
        xmlname = optarg;
        break;
      }
    case 'x':
      {
        xml_output = optarg;  
        break;
      }
    case 'p':
      performance_file = optarg;
      break;
    
    default:
      {
        break;
      }
    }
  }

  auxilary.Initialize();
  
  start_timer( &start_time );
  // gXmlFile = xmlname.c_str();

  //
  //  Create our parser, then attach an error handler to the parser.
  //  The parser will call back to methods of the ErrorHandler if it
  //  discovers errors during the course of parsing the XML document.
  //
  DOMParser *parser = new DOMParser;
  ErrorHandler *errReporter = new DOMTreeErrorReporter();
  parser->setErrorHandler(errReporter);

#ifndef NO_REACH
  // CAML startup
  CamlStartup(argv);
#endif

#ifndef NO_ODBC
  // ODBC startup
  auxilary.Odbc.EstablishDBConnection();
#endif
  
  /*
  // Test Outpost
  auxilary.Outpost.EstablishDBConnection();

  auxilary.Odbc.DBGetData("smilla.mitre.org", IP_BY_HOST, BUF_LEN_128, "1780");  
  exit(0);
  */
  
//RL Registration of nessus scanner
  char      *home_path = getenv("HOME");
  char       pref_path[255];
  string     host_name;
  string     port;
  string     user_name;
  string     user_password;

  sprintf(pref_path, "%s/.sgraph/mdlgen/nessus/preferences", home_path);
    
  ifstream   in_stream( (const char*)pref_path );
    
  if ( in_stream.is_open() )
  {
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    host_name = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    port = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    user_name = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    user_password = string( pref_path );
    
    in_stream.close();
  }


  StringList  reg_info;
  reg_info.push_back(host_name);  
  reg_info.push_back(port);  
  reg_info.push_back(user_name);
  reg_info.push_back(user_password);
 
  NessusScanner *scanner = new NessusScanner();
  scanner->set_register_data(reg_info);
  
  auxilary.scan_mang.ScannerRegistration(scanner);
  
  
  //
  //  Parse the XML file, catching any XML exceptions that might propogate
  //  out of it.
  //
  bool errorsOccured = false;
  try
    {
      parser->parse(xmlname.c_str());
    }

  catch (const XMLException& e)
    {
      cerr << "An error occured during parsing\n   Message: "
	   << DOMString(e.getMessage()) << endl;
      errorsOccured = true;
    }

 
  catch (const DOM_DOMException& e)
    {
      cerr << "An error occured during parsing\n   Message: "
	   << DOMString(e.msg) << endl;
      errorsOccured = true;
    }

  catch (...)
    {
      cerr << "An error occured during parsing\n " << endl;
      errorsOccured = true;
    }


  InitializeCompiler();
  
  // If the parse was successful, output the document data from the DOM tree
  if (!errorsOccured) {
/*  	XMLCh tempStr[100];
		XMLString::transcode("LS", tempStr, 99);
		DOMImplementation *impl          = DOMImplementationRegistry::getDOMImplementation(tempStr);
		DOMWriter         *writer = ((DOMImplementationLS*)impl)->createDOMWriter();
    LocalFileFormatTarget out_file("/home/rl/xml.out");*/
    
    DOM_Node doc = parser->getDocument();
    DOM_Node child = doc.getFirstChild();
    
    network.SetDocument((DOM_Document *)&doc);
    while (child != 0) {
      DOMString nodeName = child.getNodeName();

      if (nodeName.equals(auxilary.enames[NETWORK])) {
        DOM_Element *element = (DOM_Element *) &child;
        GenerateNetwork( &auxilary, &network, element );
        break;
      }
      child = child.getNextSibling();
    }
    
    // calculate mem. size of XML parsed tree
    mem_used += ModelMemUsage::GetDOM_DocumentSize( &doc );
/*    writer->writeNode(out_file, doc);*/
     
    
    if (xml_output != "") {
      ofstream out_stream(xml_output.c_str());
    DOMPrintFormatTarget* formatTarget = new DOMPrintFormatTarget(out_stream);

    if (gEncodingName == 0)
    {
      DOMString encNameStr("UTF-8");
      DOM_Node aNode = doc.getFirstChild();
      if (aNode.getNodeType() == DOM_Node::XML_DECL_NODE)
      {
        DOMString aStr = ((DOM_XMLDecl &)aNode).getEncoding();
        if (aStr != "")
        {
          encNameStr = aStr;
        }
      }
      
      unsigned int lent = encNameStr.length();
      gEncodingName = new XMLCh[lent + 1];
      XMLString::copyNString(gEncodingName, encNameStr.rawBuffer(), lent);
      gEncodingName[lent] = 0;
    }

    try 
    {
      gFormatter = new XMLFormatter(gEncodingName, formatTarget,
                                    XMLFormatter::NoEscapes, gUnRepFlags);
      out_stream << doc;
      *gFormatter << chLF; // add linefeed in requested output encoding
      out_stream << flush;
    }
    catch (XMLException& e)
    {
      cerr << "An error occurred during creation of output transcoder. Msg is:"
           << endl
           << DOMString(e.getMessage()) << endl;
    }

    delete formatTarget;
    delete gFormatter;
    }
  }
  //
  //  Clean up the error handler. The parser does not adopt handlers
  //  since they could be many objects or one object installed for multiple
  //  handlers.
  //
  delete errReporter;

  //
  //  Delete the parser itself.  Must be done prior to calling Terminate, below.
  //
  delete parser;

  char inputFileName[MAXNAMELEN+1];
  inputFileName[MAXNAMELEN] = '\0';
  strncpy(inputFileName, xmlname.c_str(), MAXNAMELEN);
  char *FileName = strtok(inputFileName, ".");
  char outputFileName[MAXNAMELEN+5];

  fstream out;

  // Generate SMV
  if (NuSMV_out) {
    if (!graphname.empty() && !SPIN_out)
      strcpy(outputFileName, graphname.c_str());
    else
      sprintf(outputFileName, "%s.smv", FileName);
    out.open(outputFileName, ios::out);
    network.GenerateSMV(out, target);
    out.close();
  }

  // Generate SPIN
  if (SPIN_out) {
    if (!graphname.empty() && !NuSMV_out)
      strcpy(outputFileName, graphname.c_str());
    else
      sprintf(outputFileName, "%s.promela", FileName);
    out.open(outputFileName, ios::out);
    network.GenerateSPIN(out, target);
    out.close();
  }
  
  // calculate mem. size of global structures
  mem_used += calc_mem_size( &network, &auxilary );

  // Output the initial state information to a file.
  ofstream infoFile("stateinfo.txt");
  
  infoFile << auxilary.theNet;
  
  // And call the termination method
  // XMLPlatformUtils::Terminate();
  // DomMemDebug().print();

  // Close data sources
  // auxilary.Outpost.TerminateDBConnection();

  //
  //  The DOM document and its contents are reference counted, and need
  //  no explicit deletion.
  //

  // Test OCAML interface
  // bool reach = network.Reachable("network.dat", 2, 0, 80);
  // printf("\nReachability test: %s\n\n", reach ? "true" : "false");
  
  report_performence(performance_file, &start_time, mem_used );
  
  return retval;
}
