(* $Id: spine.mli,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* Convertions between spine lists and bdds *)

(* Author: John D. Ramsdell *)

(* Copyright (C) 2001 The MITRE Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)

open Bdd

(* A spine is path and a boolean value which is true if the sense of
   the path should be negated. *)

type spine = bool * path
val spine2bdd : spine -> bdd
val filter : spine list -> bdd -> bdd -> bdd
val spines2bdd : spine list -> bdd
val bdd2spines : bdd -> spine list
