/* $Id: parser.mly,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ */

/* scanner for a frame geometry */

/* Author: John D. Ramsdell */

/*
Copyright (C) 2001 The MITRE Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

%{
open Graph

open Actions
%}

%token <string> STRING
%token LPAR, RPAR, LBRA, RBRA, PERIOD, COMMA
%token NODE, EDGE, ACCEPT, REJECT
%token EOF
%start main
%type <Graph.geometry list> main
%%

main:
  specs EOF     { $1 }
;

specs:
                { [] }
| specs spec    { $2 :: $1 }
;
 
spec:
  NODE LPAR STRING COMMA LBRA actions RBRA RPAR PERIOD
                { Node ($3, $6) }
| EDGE LPAR STRING COMMA STRING COMMA LBRA actions RBRA RPAR PERIOD
                { Edge ($3, $5, $8) }
;

actions:
                { [] }
| acts          { List.rev $1 }
;

acts:
  action        { [$1] }
| acts COMMA action
                { $3 :: $1 }
;

action:
  ACCEPT LPAR STRING COMMA STRING RPAR
                { Accept($3, $5) }
| REJECT LPAR STRING COMMA STRING RPAR
                { Reject($3, $5) }
;
