(* $Id: graph.mli,v 1.1.1.1 2003/10/28 22:15:44 rl Exp $ *)

(* Data types used for the frame propagation computation. *)

(* Author: John D. Ramsdell *)

(* Copyright (C) 2001 The MITRE Corporation

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *)

open Bdd

open Actions

type node =
  { label: string;
    mutable frames: bdd;
    mutable out: edge list }
and edge = { filter: bdd; dest: node }

type graph = (string, node) Hashtbl.t

type geometry =
    Node of string * action list
  | Edge of string * string * action list

val create : int -> graph
val init_graph_table_size : int
val make : unit -> graph
val clear : graph -> unit
val find : graph -> string -> node
val graph2nodes : graph -> node list
val load : graph -> geometry list -> unit
val unload : graph -> geometry list
val print_geometries : geometry list -> unit
