#ifndef _STATEINFO_H_
#define _STATEINFO_H_

#include <map>
#include <string>
#include <cstring>
#include <set>
#include <xercesc/dom/deprecated/DOM.hpp>
#include <iostream>

using namespace std;

// to make inserting into a multimap less painful
typedef multimap<string,int>::value_type mType;

typedef map<string,int> Valuation;

// class to store info for initial state for a generic FSM
class StateInfo
{
public:
  // number of variables in initial state
  int numVars;

  // number of variables to ignore, if any
  int numIVars;

  // mappings for initial state variables
  multimap<string,int> vars;

  // names of "variables" we can ignore
  set<string> ignore;
};


// structure to store information about the network
class NetInfo : public StateInfo
{
public:
  int numHosts;
  int numAttacks;
  int numServices;
  
  // mapping from names to numbers
  map<string,int> hosts;
  map<string,int> attacks;
  /* services: name -> id * port */
  map<string,pair<int,int> > services;
};

//extern NetInfo net;

// utility function to output a NetInfo struct
ostream &operator<<( ostream &out, NetInfo &net );

// parse function for NetInfo struct
void ParseNetInfo( istream &in, NetInfo &net );

// function to convert an integer to a string
char *itoa( int n, char *storage );

// utility to convert user privileges to integers
int priv2int( DOMString priv );

#endif // _STATEINFO_H_
