
#ifndef _EVENTS_H_
#define _EVENTS_H_

#include "drawing.h"

namespace GraphGraphics
{

/**
* This class represents OS-independent mouse event and contains all necessary event context.
*/
class Event
{
public:
   /**
   * Constants for Low-level mouse event types.
   */
   enum Events 
   {
      MOUSE_MOVE = 1,
      MOUSE_PRESSED,
      MOUSE_RELEASED,
   };
   
   /**
   * Constants for pressed mouse button.
   */
   enum Keys
   {
      MOUSE_LEFT_BUTTON = 1,
      MOUSE_RIGHT_BUTTON,
      MOUSE_MIDDLE_BUTTON,
   };
   
   /**
   * Masks for pressed modifier keys. 
   */
   enum MaskModifiers
   {
     SHIFT_MASK = 1,
     CTRL_MASK  = 2,
     ALT_MASK   = 4
   };
   // ...
private:
   EventType    m_type;       /**< Event type (one of the <code>::Events</code> constants).*/
   KeyCode      m_modifiers;  /**< Pressed modifier keys (ored combination of <code>::MaskModifiers</code> constants).*/
   KeyCode      m_key;        /**< Pressed key.*/
   KeyCode      m_mouse_button; /**< Pressed mouse button (one of the <code>::Keys</code> constants).*/
   TwoDPoint    m_point;      /**< Mouse cursor coordinates.*/
   GraphicArea *m_draw_area;  /**< Drawing context.*/
      
public:
   Event() 
   {
      m_type = 0;
      m_modifiers = 0;
      m_key = 0;
      m_mouse_button = 0;
      m_draw_area = 0;
   }
   
   ~Event() {}
   
   void set_type( EventType type ) { m_type = type; }
   void set_modifiers( KeyCode modifiers ) { m_modifiers = modifiers; }
   void set_key( KeyCode key ) { m_key = key; }
   void set_button_code( KeyCode mouse_button ) { m_mouse_button = mouse_button; }
   void set_point( TwoDPoint point ) { m_point = point; }
   void set_graphic_area( GraphicArea *g ) { m_draw_area = g; }

public:
   EventType         get_type() const { return m_type; }
   KeyCode           get_modifiers() const { return m_modifiers; }
   TwoDPoint         get_point() const { return m_point; }
   KeyCode           get_button_code() const { return m_mouse_button; }
   KeyCode           get_key() const { return m_key; }
   GraphicArea      *get_graphic_area() const { return m_draw_area; }
};

};
#endif

