
#ifndef _UNIX_VIEW_PROPERTIES_GUI_H_
#define _UNIX_VIEW_PROPERTIES_GUI_H_

#include <gtk/gtk.h>

#include "../OS_indep/graphics.h"
#include "../OS_indep/GUIWindows.h"

namespace GraphGraphics
{

class GTKViewPropertiesGUI: public GraphViewPropertiesGUI
{
private:
  GtkWidget *prop_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *notebook4;
  GtkWidget *vbox7;
  GtkWidget *frame3;
  GtkWidget *table4;
  GtkWidget *label42;
  GtkWidget *label43;
  GtkWidget *label45;
  GtkWidget *label40;
  GtkWidget *frame4;
  GtkWidget *checkbutton_Spline;
  GtkWidget *label44;
  GtkWidget *label37;
  GtkWidget *vbox8;
  GtkWidget *frame5;
  GtkWidget *vbox9;
  GtkWidget *hbox3;
  GtkWidget *label59;
  GtkWidget *entry_Back;
  GtkWidget *hbuttonbox1;
  GtkWidget *button_Back_Choose;
  GtkWidget *hbox4;
  GtkWidget *label60;
  GtkWidget *entry_Sel;
  GtkWidget *hbuttonbox2;
  GtkWidget *button_Sel_Choose;
  GtkWidget *label50;
  GtkWidget *label38;
  GtkWidget *hbox5;
  GtkWidget *label_edge_c;
  GtkWidget *hbuttonbox3;
  GtkWidget *entry_Edge;
  GtkWidget *button_Edge_Choose;
  GtkWidget *frame6;
  GtkWidget *hbox6;
  GtkWidget *label_edge_w;
  GtkObject *pen_spinbutton_adj;
  GtkWidget *pen_spinbutton;
  GtkObject *hor_spinbutton_adj;
  GtkWidget *hor_spinbutton;
  GtkObject *vert_spinbutton_adj;
  GtkWidget *vert_spinbutton;
  GtkObject *radius_spinbutton_adj;
  GtkWidget *radius_spinbutton;
  
  GtkWidget *edge_page_label;
  GtkWidget *edge_vbox;
  GtkWidget *edge_frame;
  GtkWidget *edge_frame_vbox;
  GtkWidget *outgoing_hbox ;
  GtkWidget *outgoing_label;
  GtkWidget *entry_Outgoing;
  GtkWidget *outgoing_hbuttonbox;
  GtkWidget *button_Outgoing_Choose;
  GtkWidget *incoming_hbox ;
  GtkWidget *incoming_label;
  GtkWidget *entry_Incoming;
  GtkWidget *incoming_hbuttonbox;
  GtkWidget *button_Incoming_Choose;
  GtkWidget *between_hbox ;
  GtkWidget *between_label;
  GtkWidget *entry_Between;
  GtkWidget *between_hbuttonbox;
  GtkWidget *button_Between_Choose;
  
  GraphView *m_view;
  GraphGUI  *m_gui;
  
  int       m_changes_level;

private:
  void create();
  Color convert_color(char* text_color);
  void coose_color( GtkWidget *entry );

public:
  GTKViewPropertiesGUI( GraphView *view, GraphGUI  *gui )
  {
    m_view = view;
    m_gui = gui;
    m_changes_level = PROPERTIES_UNCHANGED;
  }
  ~GTKViewPropertiesGUI() {}
  
  int run();
    
  int get_changes_level() { return m_changes_level; }
    
  void handle_button_Back_Choose_clicked_event( );
  void handle_button_Sel_Choose_clicked_event( );
  void handle_button_Edge_Choose_clicked_event( );
  void GTKViewPropertiesGUI::handle_button_Incoming_Choose_clicked_event( );
  void GTKViewPropertiesGUI::handle_button_Outgoing_Choose_clicked_event( );
  void GTKViewPropertiesGUI::handle_button_Between_Choose_clicked_event( );
};

};
  
#endif

