
#ifndef _UNIX_PREFERENCE_DIALOG_H_
#define _UNIX_PREFERENCE_DIALOG_H_

#include <gtk/gtk.h>

#include "../OS_indep/graphics.h"
#include "../OS_indep/GUIWindows.h"
#include "../OS_indep/ScenarioApp.h"

namespace GraphGraphics
{

class GTKPreferenceGUI: public GraphGUIModalWindow
{
private:
  GtkWidget *core_preferences;
  GtkWidget *dialog_vbox;
  GtkWidget *pref_notebook;
  GtkWidget *graph_view_table;
  GtkWidget *layout_combo;
  GList *layout_combo_items;
  GtkWidget *layout_combo_entry;
  GtkWidget *layout_label;
  GtkWidget *view_page_label;
  GtkWidget *comp_table;
  GtkWidget *comp_scrolledwindow;
  GtkWidget *comp_treeview;
  GtkWidget *comp_combo;
  GtkWidget *comp_combo_entry;
  GList *comp_combo_items;
  GtkWidget *add_button;
  GtkWidget *delete_button;
  GtkWidget *comp_page_label;
  GtkWidget *modes_table;
  GtkWidget *single_aw_checkbutton;
  GtkWidget *single_iw_checkbutton;
  GtkWidget *show_a_on_mm_checkbutton;
  GtkWidget *close_ld_checkbutton;
  GtkWidget *edge_s_checkbutton;
  
  GtkWidget *select_attr_label;
  GtkWidget *select_attr_checkbutton;
  GtkWidget *docking_table;
  GtkWidget *attr_dock_checkbutton;
  GtkWidget *info_dock_label;
  GtkWidget *attr_dock_label;
  GtkWidget *info_dock_checkbutton;
  GtkWidget *docking_page_label;
  GtkWidget *aliases_label;
  GtkWidget *aliases_checkbutton;
  GtkWidget *graph_metrics_label;
  GtkWidget *graph_metrics_checkbutton;
  
  GtkWidget *iw_label;
  GtkWidget *aw_label;
  GtkWidget *mm_label;
  GtkWidget *cl_label;
  GtkWidget *es_label;
  GtkWidget *modes_page_label;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancel_button;
  GtkWidget *ok_button;
  
  GtkTreeModel *list_model;

  GraphView *m_view;
  ScenarioApp *m_comp_manager;
  bool         m_apply;

private:
  void create();
  bool find_in_list( const string &name, GtkTreeIter *res_iter = 0 );
  bool add_to_list( const string &name, GtkTreeIter *res_iter = 0 );
    
public:
  GTKPreferenceGUI( ScenarioApp *comp_man, GraphView *view, bool apply = false )
  {
    m_comp_manager = comp_man;
    m_view = view;
    layout_combo_items = NULL;
    comp_combo_items = NULL;
    m_apply = apply;
  }
  ~GTKPreferenceGUI(){}
    
  void on_add();
  void on_delete();
  int run();
};
};
  
#endif
