
#ifndef _UNIXNODESEARCHGUI_H_
#define _UNIXNODESEARCHGUI_H_

#include <gtk/gtk.h>
#include "UnixTemplateCreationGUI.h"
#include "../OS_indep/GUIWindows.h"

namespace GraphGraphics
{

class GTKNodeSearchDialog: public GraphNodeSearchGUI
{
private:
  GtkWidget *node_seach_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget  *new_window_checkbutton;

  bool     m_in_new_window;
  
  GTKGraphAttrTemplateCreationView m_search_template_creation;

private:
  void create();

public:
  
  GTKNodeSearchDialog( GraphAttrNameStorage *name_storage ): 
          m_search_template_creation( name_storage, UnixGraphAttrView::ATTRIBUTE_TEMPLATE, "Attribute template",
                                      UnixGraphAttrView::ATTRIBUTE_EXPRESSION, "Search template" )
  { 
    m_in_new_window = false; 
  }
  ~GTKNodeSearchDialog() {}
  
  void set_attr_template_string( const string &attr_string ) { m_search_template_creation.set_base_template( attr_string ); }
  string get_result_attr_string() { return m_search_template_creation.get_result_attr_string(); }
  
  bool get_in_new_window_flag() { return m_in_new_window; }
  int run();
};
  
};


#endif

