
#ifndef _UNIX_GRAPH_SAVE_GUI_H_
#define _UNIX_GRAPH_SAVE_GUI_H_

#include <gtk/gtk.h>

#include "../OS_indep/ScenarioApp.h"
#include "../OS_indep/GUIWindows.h"

namespace GraphGraphics
{

class GTKGraphSaveGUI: public GraphSaveGUI
{
private:
  GtkWidget *save_graph_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *main_table;
  GtkWidget *file_entry;
  GtkWidget *file_button;
  GtkWidget *file_label;
  GtkWidget *name_entry;
  GtkWidget *name_label;
  GtkWidget *format_label;
  GtkWidget *format_combo;
  GList *format_combo_items;
  GtkWidget *format_combo_entry;
  GtkWidget *version_entry;
  GtkWidget *version_label;
  GtkWidget *comm_label;
  GtkWidget *comm_entry;
  GtkWidget *model_label;
  GtkWidget *model_entry;
  GtkWidget *model_button;
  GtkWidget *hseparator1;
  GtkWidget *gr_alignment;
  GtkWidget *graph_checkbutton;
  GtkWidget *gr_label;
  GtkWidget *vis_label;
  GtkWidget *vis_checkbutton;
  GtkWidget *dialog_action_area;
  GtkWidget *cancel_button;
  GtkWidget *ok_button;
  
  ScenarioApp    *m_app;
  GraphGUI       *m_gui;
  static GraphFileInfo m_last_file_info;
  static bool     m_init;
  
private:
  void create();

public:
  GTKGraphSaveGUI( ScenarioApp *app ) 
  { 
    m_app = app; 
    m_gui = m_app->get_GUI( );
    
    if ( m_init )
    {
      m_last_file_info.comment = "The file is generated by Graph View";
      m_last_file_info.graph_name = "";
      m_last_file_info.file_name = "";
      m_last_file_info.file_format = GraphFileInfo::BIN16_FORMAT;
      m_last_file_info.version = "001.000";
      m_last_file_info.model_file = "";
      m_last_file_info.save_graph = true;
      m_last_file_info.save_view = true;
      m_init = false;
    }
    format_combo_items = NULL;
  }
  ~GTKGraphSaveGUI() {}
    
  void set_file_info( const GraphFileInfo &info ) { m_last_file_info = info; }
  
  int run();
  
  void handle_file_button_clicked_event( );
  void handle_model_button_clicked_event(); 
};

};
  
#endif

