
#ifndef  _UNIX_GENERATE_GUI_H_
#define  _UNIX_GENERATE_GUI_H_

#include "GUIWindows.h"
#include "ScenarioApp.h"

namespace GraphGraphics
{
  
class GTKUnixGraphGenerationWindow: public GraphGenerationGUI
{
public:
  static const char *PROMELA_GENERATOR_DIR;
  static const char *NUSMV_GENERATOR_DIR;
  static const char *MDLGEN_COMPILER_DIR;
  
  static const char  *PROMELA_GENERATOR_FILE;
  static const char  *NUSMV_GENERATOR_FILE;
  static const char  *MDLGEN_GENERATOR_FILE;
  
  /*Path to original scenario files*/
  static const char  *PROMELA_SCENARIO_DIR;
  
  /*Name of scenario directory where scenario files will be generated*/
  static const char *SCENARIO_DIR; 
  
private:
  static const int   scenario_files_count;
  static const char *unch_scenario_files[];    

  ScenarioApp         *m_app;
/*  GUIGraphLoadHandler *m_load_handler;
  GUICloseHandler     *m_close_handler;*/

  string               m_title;

  GtkWidget *GraphGenerationWindow;
  GtkWidget *main_vbox;
  GtkWidget *Edit_frame;
  GtkWidget *Editor_table;
  GtkWidget *Editor_entry;
  GtkWidget *Editor_combo;
  GList *Editor_combo_items;
  GtkWidget *Editor_combo_entry;
  GtkWidget *Editor_button;
  GtkWidget *label1;
  GtkWidget *XML_frame;
  GtkWidget *XML_table;
  GtkWidget *XML_entry;
  GtkWidget *label6;
  GtkWidget *XMLSelect_button;
  GtkWidget *XMLEdit_button;
  GtkWidget *label2;
  GtkWidget *Generator_frame;
  GtkWidget *Generator_table;
  GtkWidget *Model_entry;
  GtkWidget *TL_entry;
  GtkWidget *TL_formula_entry; 
  GtkWidget *TL_def_entry;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label7;
  GtkWidget *label_TL_formula;  
  GtkWidget *label_TL_def;    
  GtkWidget *ModelSelect_button;
  GtkWidget *ModelEdit_button;
  GtkWidget *TLEdit_button;
  GtkWidget *TLSelect_button;
  GtkWidget *TLDefAdd_button;
  GtkWidget *TLGen_button;  
  GtkWidget *TLDefRemove_button;    
  GtkWidget *GenCombo_alignment;
  GtkWidget *Generator_combo;
  GList *Generator_combo_items;
  GtkWidget *Generator_combo_entry;
  GtkWidget *TL_checkbutton;
  GtkWidget *Formula_checkbutton;  
 // GtkWidget *Attack_checkbutton;
  GtkWidget *label3;
  GtkWidget *Graph_frame;
  GtkWidget *Graph_table;
  GtkWidget *label10;
  GtkWidget *Graph_entry;
  GtkWidget *GraphSelect_button;
  GtkWidget *GraphEdit_button;
  GtkWidget *label4;
  GtkWidget *Compilation_frame;
  GtkWidget *Compilation_table;
  GtkWidget *Output_scrolledwindow;
  GtkWidget *Output_textview;
  GtkWidget *label13;
  GtkWidget *label12;
  GtkWidget *label11;
  GtkWidget *Run_alignment;
  GtkWidget *Run_button;
  GtkWidget *GenParams_entry;
  GtkWidget *XMLParams_entry;
  GtkWidget *Radio_hbox;
  GtkWidget *XML_radiobutton;
  GtkWidget *Graph_load_radiobutton;
  GSList *Graph_load_radiobutton_group;
  GtkWidget *Generation_radiobutton;
  GtkWidget *XML_Gen_radiobutton;
  GtkWidget *label5;
  GtkWidget *close_button_alignment;
  GtkWidget *Close_button;
  GtkTooltips *tooltips;
  GtkWidget *Clear_alignment;
  GtkWidget *Clear_button;
  GtkWidget *ScenarioParam_label;
  GtkWidget *ScenarioParam_entry;
  
  bool            can_TL_enabled;
  string          TL_def_string;

private:
  char *copy_str( const char* str );
  char *get_full_path( const char *var_name, const char* app_name, bool is_dir );

  int make_cmd_args( string str_args, const string &file, char ***cmd_args );
  void make_XML_argv( char ***argv );
  void make_Generator_argv( char ***argv, char* tmp_path );
  void make_Scenario_argv( char ***argv, char* tmp_path );
  void delete_argv( char **argv );
  void make_TL_Generator_argv( char ***argv );
  bool file_names_are_not_empty( );
  string make_default_file_name( const string &file_name, const string &file_extension );
  
  void set_TL_entry_active( bool enabled );
  void set_TL_formula_entry_active( bool enabled );
  void set_TL_active( bool enabled );
  void set_Gen_active( bool enabled );
  void set_Graph_active( bool enabled );
  void set_Compilator_active( bool enabled );
  void set_dialog_action_active( bool enabled );
  void set_XML_active( bool enabled );
  void set_all_active( bool enabled );

  void done_XML_changes( const string &file_name );
  void done_Model_changes( const string &file_name );
  
  void load_editor( char** cmd_args );
  void create();

public:
  
  GTKUnixGraphGenerationWindow( ScenarioApp *app, const string &title )
  { 
    m_app = app; 
    GraphGenerationWindow = NULL;
    Generator_combo_items = NULL;
    Editor_combo_items = NULL;
    Graph_load_radiobutton_group = NULL;
    TL_def_string = "";
    m_title = title;
    create();
  };
  
  ~GTKUnixGraphGenerationWindow()
  {
    destroy( true );
  }
  
  void graph_load( const string &file_name, bool graph_only_flag = false );
  void set_run_active( bool enabled );
  GtkWidget *get_widget() { return GraphGenerationWindow;};
  

  void   show( bool show_window );
  string get_model_file_name();
  string get_graph_file_name();
  string get_XML_file_name();
  bool   destroy( bool force_close );
  
  //Events handling
  void handle_Editor_combo_entry_changed_event( );
  void handle_Editor_button_clicked_event( );
  void handle_XMLSelect_button_clicked_event( );
  void handle_XMLEdit_button_clicked_event( );
  void handle_ModelSelect_button_clicked_event( );
  void handle_ModelEdit_button_clicked_event( );
  void handle_TLEdit_button_clicked_event( );
  void handle_TLSelect_button_clicked_event( );
  void handle_TLDefAdd_button_clicked_event( );
  void handle_TLGen_button_clicked_event( );
  void handle_TLDefRemove_button_clicked_event( );
  void handle_Generator_combo_entry_changed_event( );
  void handle_TL_checkbutton_clicked_event( );
  void handle_Formula_checkbutton_clicked_event( );
  void handle_GraphSelect_button_clicked_event( );
  void handle_Run_button_clicked_event( );
  void handle_Graph_load_radiobutton_activate_event( );
  void handle_XML_radiobutton_activate_event( );
  void handle_Generation_radiobutton_activate_event( );
  void handle_XML_Gen_radiobutton_activate_event( );
  void handle_XML_entry_changed_event( );
  void handle_Model_entry_changed_event( );
  void handle_Clear_button_clicked_event( ); 
};

};

#endif

