
#ifndef _UNIX_CREATE_FILTER_GUI_H_
#define _UNIX_CREATE_FILTER_GUI_H_

#include <gtk/gtk.h>
#include "UnixTemplateCreationGUI.h"
#include "../OS_indep/GUIWindows.h"

namespace GraphGraphics
{

class GTKCreateFilterGUI: public GraphGUIModalWindow
{
private:
  
  GtkWidget *dialog;
  GtkWidget *name_hbox;
  GtkWidget *node_seach_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget  *name_label;
  GtkWidget  *name_entry;

  string     m_filter_name;
  
  GTKGraphAttrTemplateCreationView m_search_template_creation;

private:
  void create();

public:
  
  GTKCreateFilterGUI( GraphAttrNameStorage *name_storage ): 
          m_search_template_creation( name_storage, UnixGraphAttrView::ATTRIBUTE_TEMPLATE, "",
                                      UnixGraphAttrView::ATTRIBUTE_TEMPLATE, "Filter template" )
  { 
    m_filter_name = "";
  }
  ~GTKCreateFilterGUI() {}
  
  void set_filter_name( const string &name ) { m_filter_name = name; }
  string get_filter_name( ) { return m_filter_name; }
  void set_attr_template( const string &attr_string ) { m_search_template_creation.set_base_template( attr_string ); }
  void set_filter_template( const string &attr_string ) { m_search_template_creation.set_init_result_template( attr_string ); }
  string get_filter_template() { return m_search_template_creation.get_result_attr_string(); }
  
  int run();
};
  
};


#endif

