
#ifndef _UNIX_COLOR_COOSE_VIEW_H_
#define _UNIX_COLOR_COOSE_VIEW_H_

#include <gtk/gtk.h>
#include "../OS_indep/drawing.h"

namespace GraphGraphics
{
  
class GTKColorCooseView
{
private:
  Color  m_foreground_color;
  Color  m_background_color;
  
  GtkWidget *view_hbox;

  GtkWidget *color_drawingarea;
  GtkWidget *color_button;

private:
  void create( );

public:
  GTKColorCooseView() 
  {
    m_foreground_color = Color::BLACK;
    m_background_color = Color::WHITE;
    view_hbox = 0;
    color_drawingarea = 0;
    color_button = 0;
    
    create();
  }
  ~GTKColorCooseView() { }
  
  void set_foreground_color( const Color &color ) { m_foreground_color = color; }
  void set_background_color( const Color &color ) { m_background_color = color; }
  Color get_foreground_color() { return m_foreground_color; }
  void set_enabled( bool enable );
  bool get_enabled( );
  
  GtkWidget *get_widget( ) { return view_hbox; }
  GtkWidget *get_drawing_area( ) { return color_drawingarea; }
  GtkWidget *get_button( ) { return color_drawingarea; }
  
};

};
  
#endif
