
#ifndef _UNIXATTRTREEVIEW_H_
#define _UNIXATTRTREEVIEW_H_

#include <gtk/gtk.h>
#include <vector>
#include <string>
#include <iostream>
#include <sstream>

#include "../OS_indep/nodeattr.h"
#include "../OS_indep/GUIWindows.h"

using namespace std;

namespace GraphGraphics
{

struct AttrView
{
  bool   is_string_type;
  string type;
  string name;
  string value_op;
  string value;
};

typedef vector<AttrView> AttrViewVector;
struct MetaAttrView;
typedef map<string, MetaAttrView*> MetaAttrViewMap;
typedef vector<MetaAttrView*> MetaAttrViewVector;

struct MetaAttrView
{
  string name;
  MetaAttrViewMap meta;
  AttrViewVector  attr;
  
  MetaAttrViewVector meta_order;
  
  MetaAttrView(): name("") {}
    
  void clear( )
  {
    for (MetaAttrViewMap::iterator it = meta.begin(); it != meta.end(); it++ )
      delete it->second;
    
    meta.clear();
    attr.clear();
    meta_order.clear();
    name = "";
  }
  ~MetaAttrView() { clear(); }
};

struct AttrExprView;
typedef list<AttrExprView*> AttrExprList;
struct AttrExprView
{
  enum MetaType
  {
    ATTR = 0,
    META_ATTR = 1,
    PARENTHESES = 2
  };
  
  string          op;
  bool            negation;
  string          name;
  MetaType        meta_type;
  string          value_op;
  string          value;
  bool            is_string_type;
  
  AttrExprView(): op(""), negation(false), name(""), 
                  meta_type(ATTR), value_op(""), value("0"), is_string_type(false) {}
  
  AttrExprList attr_list;
  ~AttrExprView()
  {
    for (AttrExprList::iterator it = attr_list.begin(); it != attr_list.end(); it++ )
      delete *it;
  }
};
typedef AttrExprList::iterator AttrExprListIt;


class UnixGraphAttrView: public GraphNodeAttributesGUI
{
public:
  enum AttrValueType
  {
    INTEGER_VALUE = 0,
    STRING_VALUE
  };
  
  enum AttrViewModes
  {
    ATTRIBUTE_DIALOG = 1,
    ATTRIBUTE_TEMPLATE,
    SEARCH_TEMPLATE,
    ATTRIBUTE_EXPRESSION    
  };
  
  static const string EMPTY_META_NAME;
  static const string EXPR_PARENTHESES;
 
private:
  /*  enum Columnes
  {
    EXPR_BIN_OPERATOR_COLUMN = 0,
    EXPR_UN_OPERATOR_COLUMN,
    ATTRIBUTE_COLUMN,
    OPERATION_COLUMN,
    VALUE_COLUMN,
  };
  */

  GtkWidget      *dialog;
  GtkWidget      *scrolledwindow;
  GtkWidget      *m_tree;
  
  ostringstream   m_stream;
  GtkTreeStore   *m_store;
  AttrViewModes   m_mode;
  bool            m_docked;
  StringContainer m_attr_string_list;
  GraphAttrNameStorage *m_name_storage;

  set<string> m_expanded_rows;
  
  int TYPE_COLUMN;
  int EXPR_BIN_OPERATOR_COLUMN;
  int EXPR_UN_OPERATOR_COLUMN;
  int ATTRIBUTE_COLUMN;
  int OPERATION_COLUMN;
  int VALUE_COLUMN;
  
private:
  GtkTreeIter  add_to_storage( GtkTreeStore *store, GtkTreeIter *parent_iter, const string &op, bool negation, const string &name, const string &value_op, const string &value, int type = INTEGER_VALUE );
  unsigned int add_to_storage( GtkTreeStore *store, GtkTreeIter *paren_iter, const NodeAttributeList &attr_lists, unsigned int attr_ind, const string &end_cond = NodeAttribute::ATTR_END );
  void         add_to_storage( AttrExprView* attr_view, GtkTreeStore *store, GtkTreeIter *parent_iter );
  void         get_path( GtkTreeModel *model, GtkTreeIter *iter, vector<string> &path );
  void         make_string( GtkTreeModel *model, GtkTreeIter *iter, string &str );
  void         create();

  unsigned int make_attr_view( AttrExprView *attr_view, StringContainer &full_attr_name, const NodeAttributeList &attr_list, unsigned int ind, 
                             const string &parent_meta_value, bool opened );

  unsigned int make_alias_attr_map( MetaAttrView &res_meta, StringContainer &full_attr_name, const NodeAttributeList &attr_list, unsigned int ind, bool opened );
  void set_alias_meta( MetaAttrView *meta, GtkTreeIter *parent_iter );
  void set_alias_attributes( const NodeAttributeList &attr_list );

  string make_aliased_attr_to_string( GtkTreeModel *model );
  void make_string( MetaAttrView *meta, string &res_str );
  void make_attr_alias_map( MetaAttrView &res_meta, StringContainer &full_alias_name, GtkTreeModel *model, GtkTreeIter *parent_iter, bool opened );
  void make_string( AttrExprView *attr, string &res_str );
  void make_attr_expr_view( AttrExprView* meta, StringContainer &full_name, GtkTreeModel *model, GtkTreeIter *parent_iter, const string &parent_meta_value, bool opened );
  void optimize_attr_expr( AttrExprView *attr );
  bool unite_meta_attr( AttrExprView *meta_attr1,  AttrExprView *meta_attr2, bool first );
  AttrExprListIt optimize_attr_ored_expr( AttrExprList &attr_list, AttrExprListIt first_it, AttrExprListIt last_it );
  AttrExprListIt optimize_attr_anded_expr( AttrExprList &attr_list, AttrExprListIt first_it, AttrExprListIt last_it );
  void remove_redundant_parentheses( AttrExprView *attr );

  void expand_rows();
  
public:
  UnixGraphAttrView( GraphAttrNameStorage *name_storage, UnixGraphAttrView::AttrViewModes mode );
  ~UnixGraphAttrView() 
  { 
    g_object_unref( G_OBJECT(m_store) ); 
    handle_close_event(); 
  }
  
  void handle_close_event();
  void set_attributes( const StringContainer &attr_lists );
  void set_attributes( const vector<NodeAttributeList> &attr_lists );
  
  string get_label();
  void make_docked( bool docked );
  bool is_docked();
  void* get_dockable();
  
  bool is_dock_handler_registered() { return !m_dock_menu_handler_list.empty(); }
  GtkWidget *get_widget() { return m_tree; }
  GtkTreeStore *get_store() { return m_store; }
  void show_dialog();
  bool get_selected_path( vector<string> &path);
  void insert_path_value( const vector<string> &path, const string &value, const string &relation = "=", bool negation = false, const string &logical_op = "", bool is_string = false );
  void remove_selected();
  void get_expanded_pathes( set<string> &pathes ) { pathes = m_expanded_rows; }
  void set_expanded_pathes( const set<string> &pathes ) { m_expanded_rows = pathes; }
  void expand_all()
  {
    if ( GTK_IS_WIDGET( m_tree ) )
    {
      gtk_tree_view_expand_all( GTK_TREE_VIEW(m_tree) );
    }
  }
  void set_attribute_string( const string& attr_string );
  
  bool is_empty();
    
  string get_string();
  
  void show( bool show_window );
  
  void handle_dock_menu_event( bool docked );
  void handle_treeview_row_expanded_collapsed_event( GtkTreePath *path, bool expand );
};

};

//GtkWidget* create_attribute_window ( const vector<string> &attr_list );

#endif /* _UNIXATTRTREEVIEW_H_ */
