
#ifndef _UNIXATTRFILTER_H_
#define _UNIXATTRFILTER_H_

#include <gtk/gtk.h>
#include "../OS_indep/graphics.h"
#include "../OS_indep/GUIWindows.h"
#include "UnixAttrTreeView.h"

namespace GraphGraphics
{
  
class GTKAttrFilterGUI: public GraphAttrFilterGUI
{
private:
  GtkWidget *filter_dialog;
  GtkWidget *dialog_vbox2;
  GtkWidget *main_table;
  GtkWidget *filter_combo;
  GtkWidget *filter_combo_entry;
  GtkWidget *add_button;
  GtkWidget *del_button;
  GtkWidget *filter_scrolledwindow;
  GtkWidget *filter_treeview;
  GtkWidget *filter_entry;
  GtkWidget *filter_label;
  GtkWidget *dialog_action_area2;
  GtkWidget *cancel_button;
  GtkWidget *ok_button;
  GList     *filter_combo_items;

  UnixGraphAttrView m_tree_view;
  AttrStringTemplateStorage* m_filters;
  string            m_attr_template;
  GraphAttrNameStorage *m_name_storage;

private:
  void create();

public:
  GTKAttrFilterGUI( GraphAttrNameStorage *name_storage ): m_tree_view( name_storage, UnixGraphAttrView::ATTRIBUTE_TEMPLATE) 
    { filter_combo_items = NULL; m_filters = 0; m_name_storage = name_storage; }
  ~GTKAttrFilterGUI() { delete m_filters; }
    
  void set_attr_template( const string &attr_template ) { m_attr_template = attr_template; }
  void set_filters( AttrStringTemplateStorage* filter_storage ) { m_filters = new AttrStringTemplateStorage( *filter_storage ); }
  AttrStringTemplateStorage* get_filetrs() { return new AttrStringTemplateStorage( *m_filters ); }
    
  int run();
  
  void handle_add_button_clicked_event( );
  void handle_del_button_clicked_event( );
  void handle_filter_combo_entry_changed_event( );
   
};

};

#endif
