#ifndef _GTKSCENARIOGROUPGUI_H_
#define _GTKSCENARIOGROUPGUI_H_

#include <gtk/gtk.h>
#include <string>

#include "UnixAttrTreeView.h"
#include "GUIWindows.h"

using namespace std;

namespace GraphGraphics
{
class GTKScenarioGroupGUI: public GraphScenarioGroupRestrictionGUI
{
private:
  GtkWidget *scenario_group_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *main_table;
  GtkWidget *exclude_hbox;
  GtkWidget *exclude_set_button;
  GtkWidget *del_exclude_button;
  GtkWidget *inblude_hbox;
  GtkWidget *set_include_button;
  GtkWidget *del_include_button;
  GtkWidget *include_label;
  GtkWidget *exclude_label;
  GtkWidget *dialog_action_area;
  GtkWidget *cancel_button;
  GtkWidget *ok_button;
  GtkWidget *include_scrolledwindow;
  GtkWidget *exclude_scrolledwindow;
  
  UnixGraphAttrView m_include_tree;
  UnixGraphAttrView m_exclude_tree;
  GraphAttrNameStorage *m_name_storage;

  string   m_include_restriction;
  string   m_exclude_restriction;

private:
  void create();

public:
  GTKScenarioGroupGUI( GraphAttrNameStorage *name_storage ):
                       m_include_tree(name_storage, UnixGraphAttrView::ATTRIBUTE_EXPRESSION), 
                       m_exclude_tree(name_storage,UnixGraphAttrView::ATTRIBUTE_EXPRESSION)
  {
    m_name_storage = name_storage;
    m_include_restriction = "";
    m_exclude_restriction = "";
  }
  
  ~GTKScenarioGroupGUI(){}
    
  string get_include_nodes_restriction(){ return m_include_restriction; }
  string get_exclude_nodes_restriction(){ return m_exclude_restriction; }
  
  int run();
  
  void handle_del_include_button_event();
  void handle_set_include_button_event();
  void handle_del_exclude_button_event();
  void handle_set_exclude_button_event();
};
};
  
#endif
