#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <unistd.h>
#include <fcntl.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>

#include <fstream>

#include "GTKNetPreferencesGUI.h"

using namespace GraphGraphics;

void GTKNetPreferencesGUI::create()
{
  layout_combo_items = NULL;
  
  net_preference_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (net_preference_dialog), "Network Preferences");
  gtk_window_set_resizable (GTK_WINDOW (net_preference_dialog), FALSE);

  dialog_vbox = GTK_DIALOG (net_preference_dialog)->vbox;
  gtk_widget_show (dialog_vbox);

  pref_notebook = gtk_notebook_new ();
  gtk_widget_show (pref_notebook);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), pref_notebook, TRUE, TRUE, 0);

  view_main_table = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (view_main_table);
  gtk_container_add (GTK_CONTAINER (pref_notebook), view_main_table);

  layout_frame = gtk_frame_new (NULL);
  gtk_widget_show (layout_frame);
  gtk_table_attach (GTK_TABLE (view_main_table), layout_frame, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  layout_table = gtk_table_new (1, 2, FALSE);
  gtk_widget_show (layout_table);
  gtk_container_add (GTK_CONTAINER (layout_frame), layout_table);

  layout_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (layout_combo)->popwin),
                       "GladeParentKey", layout_combo);
  gtk_widget_show (layout_combo);
  gtk_table_attach (GTK_TABLE (layout_table), layout_combo, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Arbitrary size");
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Fit to window");
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Fit to window width");
  layout_combo_items = g_list_append (layout_combo_items, (gpointer) "Fit to window height");
  gtk_combo_set_popdown_strings (GTK_COMBO (layout_combo), layout_combo_items);
  g_list_free (layout_combo_items);

  layout_combo_entry = GTK_COMBO (layout_combo)->entry;
  gtk_widget_show (layout_combo_entry);
  gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Arbitrary size");

  layout_label = gtk_label_new ("Default graph layout:");
  gtk_widget_show (layout_label);
  gtk_table_attach (GTK_TABLE (layout_table), layout_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 0);
  gtk_label_set_justify (GTK_LABEL (layout_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (layout_label), 0, 0.5);

  layout_frame_label = gtk_label_new ("");
  gtk_widget_show (layout_frame_label);
  gtk_frame_set_label_widget (GTK_FRAME (layout_frame), layout_frame_label);
  gtk_label_set_justify (GTK_LABEL (layout_frame_label), GTK_JUSTIFY_LEFT);

  view_label = gtk_label_new ("Network graph view ");
  gtk_widget_show (view_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_notebook), 0), view_label);
  gtk_label_set_justify (GTK_LABEL (view_label), GTK_JUSTIFY_LEFT);

  nessus_main_table = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (nessus_main_table);
  gtk_container_add (GTK_CONTAINER (pref_notebook), nessus_main_table);

  server_frame = gtk_frame_new (NULL);
  gtk_widget_show (server_frame);
  gtk_table_attach (GTK_TABLE (nessus_main_table), server_frame, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  server_table = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (server_table);
  gtk_container_add (GTK_CONTAINER (server_frame), server_table);

  host_label = gtk_label_new ("Host:   ");
  gtk_widget_show (host_label);
  gtk_table_attach (GTK_TABLE (server_table), host_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (host_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (host_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (host_label), 3, 0);

  port_label = gtk_label_new ("Port:          ");
  gtk_widget_show (port_label);
  gtk_table_attach (GTK_TABLE (server_table), port_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (port_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (port_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (port_label), 3, 0);

  host_entry = gtk_entry_new ();
  gtk_widget_show (host_entry);
  gtk_table_attach (GTK_TABLE (server_table), host_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  port_entry = gtk_entry_new ();
  gtk_widget_show (port_entry);
  gtk_table_attach (GTK_TABLE (server_table), port_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  server_label = gtk_label_new ("Nessus server");
  gtk_widget_show (server_label);
  gtk_frame_set_label_widget (GTK_FRAME (server_frame), server_label);
  gtk_label_set_justify (GTK_LABEL (server_label), GTK_JUSTIFY_LEFT);

  user_frame = gtk_frame_new (NULL);
  gtk_widget_show (user_frame);
  gtk_table_attach (GTK_TABLE (nessus_main_table), user_frame, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  user_table = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (user_table);
  gtk_container_add (GTK_CONTAINER (user_frame), user_table);

  login_label = gtk_label_new ("Login:");
  gtk_widget_show (login_label);
  gtk_table_attach (GTK_TABLE (user_table), login_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (login_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (login_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (login_label), 3, 0);

  password_label = gtk_label_new ("Password:");
  gtk_widget_show (password_label);
  gtk_table_attach (GTK_TABLE (user_table), password_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (password_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (password_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (password_label), 3, 0);

  login_entry = gtk_entry_new ();
  gtk_widget_show (login_entry);
  gtk_table_attach (GTK_TABLE (user_table), login_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  password_entry = gtk_entry_new ();
  gtk_widget_show (password_entry);
  gtk_table_attach (GTK_TABLE (user_table), password_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (password_entry), FALSE);

  user_label = gtk_label_new ("Nessus user");
  gtk_widget_show (user_label);
  gtk_frame_set_label_widget (GTK_FRAME (user_frame), user_label);
  gtk_label_set_justify (GTK_LABEL (user_label), GTK_JUSTIFY_LEFT);

  nessus_label = gtk_label_new ("Nessus scanner");
  gtk_widget_show (nessus_label);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (pref_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (pref_notebook), 1), nessus_label);
  gtk_label_set_justify (GTK_LABEL (nessus_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (nessus_label), 1, 0);

  dialog_action_area1 = GTK_DIALOG (net_preference_dialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (net_preference_dialog), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (net_preference_dialog), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);
}

int GTKNetPreferencesGUI::run()
{
  char      *s_entry;
  char      *home_path = getenv("HOME");
  char       pref_path[255];
  string     host_name = "localhost";
  string     port      = "1241";
  string     user_name;
  string     user_password;
  ofstream   out_stream;
  
  memset( pref_path, 0, sizeof(pref_path) );
  
  create();
  
  switch ( m_view->get_layout() )
  {
    case GraphView::FIT_TO_WINDOW:
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window");
      break;
    case GraphView::FIT_TO_WIDTH:      
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window width");
      break;
    case GraphView::FIT_TO_HEIGHT:
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Fit to window height");
      break;
    case GraphView::ARBITRARY_SIZE:      
      gtk_entry_set_text (GTK_ENTRY (layout_combo_entry), "Arbitrary size");
      break;
  }
  
  sprintf(pref_path, "%s/.sgraph/mdlgen/nessus/preferences", home_path);
    
  ifstream   in_stream( (const char*)pref_path );
    
  if ( in_stream.is_open() )
  {
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    host_name = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    port = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    user_name = string( pref_path );
    
    memset( pref_path, 0, sizeof(pref_path) );
    in_stream.getline( pref_path, sizeof(pref_path) );
    user_password = string( pref_path );
    
    in_stream.close();
  }
  
  gtk_entry_set_text( GTK_ENTRY(host_entry), host_name.c_str() );
  gtk_entry_set_text( GTK_ENTRY(port_entry), port.c_str() );
  gtk_entry_set_text( GTK_ENTRY(login_entry), user_name.c_str() );
  gtk_entry_set_text( GTK_ENTRY(password_entry), user_password.c_str() );
  
  gint result = gtk_dialog_run( GTK_DIALOG(net_preference_dialog) );
  
  
  if ( result == GTK_RESPONSE_OK )
  {
    s_entry = (char*)gtk_entry_get_text (GTK_ENTRY (layout_combo_entry));
    
    if (strcmp(s_entry, "Fit to window") == 0)
      m_view->set_layout( GraphView::FIT_TO_WINDOW );
    else if (strcmp(s_entry, "Fit to window width") == 0)
      m_view->set_layout( GraphView::FIT_TO_WIDTH );
    else if (strcmp(s_entry, "Fit to window height") == 0)
      m_view->set_layout( GraphView::FIT_TO_HEIGHT );
    else if (strcmp(s_entry, "Arbitrary size") == 0)
      m_view->set_layout( GraphView::ARBITRARY_SIZE );
    
    memset( pref_path, 0, sizeof(pref_path) );
    
    sprintf(pref_path, "%s/.sgraph/netgraph/preferences", home_path);
    
    out_stream.open( (const char*)pref_path );
    
    if ( out_stream.is_open() )
    {
      unsigned char layout = m_view->get_layout();
      out_stream.put( layout );
      out_stream.close( );
    }
    
    host_name       = string( gtk_entry_get_text( GTK_ENTRY(host_entry) ) );
    port            = string( gtk_entry_get_text( GTK_ENTRY(port_entry) ) );
    user_name       = string( gtk_entry_get_text( GTK_ENTRY(login_entry) ) );
    user_password   = string( gtk_entry_get_text( GTK_ENTRY(password_entry) ) );
    
    memset( pref_path, 0, sizeof(pref_path) );
    sprintf(pref_path, "%s/.sgraph/mdlgen/nessus/preferences", home_path);
    
    out_stream.open( (const char*)pref_path );
    
    if ( out_stream.is_open() )
    {
      out_stream << host_name << "\n";
      out_stream << port << "\n";
      out_stream << user_name << "\n";
      out_stream << user_password;
      
      out_stream.close( );
    }
  }
  
  gtk_widget_destroy( net_preference_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
