#ifndef _GTK_MEASURE_GUI_H
#define _GTK_MEASURE_GUI_H

#include <gtk/gtk.h>

#include "graphics.h"
#include "NetGUIWindows.h"

namespace GraphGraphics
{
  
class GTKMeasuresGUI: public NetAttackMeasuresGUI
{
private:
  GtkWidget *attak_measure_dialog;
  GtkWidget *dialog_vbox;
  GtkWidget *main_vbox;
  GtkWidget *measures_scrolledwindow;
  GtkWidget *measures_treeview;
  GtkWidget *hbox3;
  GtkWidget *add_button;
  GtkWidget *edit_button;
  GtkWidget *delete_button;
  GtkWidget *load_button;
  GtkWidget *save_button;
  GtkWidget *dialog_action_area;
  GtkWidget *cancel_button;
  GtkWidget *ok_button;

  GtkTreeModel      *m_tree_model;

  AttackMeasuresSet  m_measures_set;
  Network           *m_network;
  GraphGUI          *m_gui;
  Graph             *m_scenario_graph;

private:
  void create();
  GtkTreeIter get_top_measure_iter( GtkTreeIter *child_iter );
  void set_values( GtkTreeIter *iter, const string &name, const string &attack, const string &src, const string &dst, int id );
  GtkTreeIter add_measure( AttackMeasureID id );
  bool find_measure( GtkTreeIter *res_iter, AttackMeasureID id );
  AttackMeasureID get_measure_id( GtkTreeIter *iter );
  AttackMeasure get_measure( GtkTreeIter *iter );
  void update_measure( GtkTreeIter *iter, AttackMeasureID id );
  void remove_measure( GtkTreeIter *iter );

public:
  GTKMeasuresGUI( Network* network, Graph *scenario_graph, GraphGUI *gui )
  {
    m_network = network;
    m_gui = gui;
    m_scenario_graph = scenario_graph;
  }
  
  ~GTKMeasuresGUI(){}
  
  int run();
  
  void              init_measure_set( const AttackMeasuresSet& measure_set) { m_measures_set = measure_set; }
  AttackMeasuresSet get_result_measure_set() { return m_measures_set; }
  
  void handle_add_button_clicked_event();
  void handle_edit_button_clicked_event();
  void handle_delete_button_clicked_event();
  void handle_load_button_clicked_event();
  void handle_save_button_clicked_event();
};

};

#endif
