
#include "GTKAttacksGUI.h"

using namespace GraphGraphics;

const char * GTKAttacksGUI::ALL_POSSIBLE = "All";
const string GTKAttacksGUI::FW_PREFIX = "Firewall: ";

bool GTKAttacksGUI::is_dest_firewall( const string &dest )
{
  return (dest.find(FW_PREFIX) == 0);
}

string GTKAttacksGUI::get_dest_data( const string &dest )
{
  string res = "";
  
  if ( is_dest_firewall(dest) )
    res = dest.substr( FW_PREFIX.size() );
  else
    res = dest;
  
  return res;
}

GtkTreeIter GTKAttacksGUI::add_attack( const string &attack_name, const string &source_host, const string &target_host )
{
  GtkTreeIter iter;
  
  gtk_list_store_append( GTK_LIST_STORE( m_list_model ), &iter );
  gtk_list_store_set( GTK_LIST_STORE( m_list_model ), &iter, 0, attack_name.c_str(), 1, source_host.c_str(), 2, target_host.c_str(), -1 );
  
  return iter;
}

void GTKAttacksGUI::set_attack( GtkTreeIter *iter, const string &attack_name, const string &source_host, const string &target_host )
{
  gtk_list_store_set( GTK_LIST_STORE( m_list_model ), iter, 0, attack_name.c_str(), 1, source_host.c_str(), 2, target_host.c_str(), -1 );
}

void GTKAttacksGUI::remove_attack( GtkTreeIter *iter )
{
  gtk_list_store_remove( GTK_LIST_STORE( m_list_model ), iter );
}

void GTKAttacksGUI::remove_all_attack()
{
  gtk_list_store_clear( GTK_LIST_STORE( m_list_model ) );
}

bool GTKAttacksGUI::find_attack( const string &attack_name, const string &source_host, const string &target_host, GtkTreeIter *res_iter) 
{
  char     *attack_data = 0;
  char     *src_data = 0;
  char     *dest_data = 0;
  GtkTreeIter iter;
  
  bool    res = false;
  
  gboolean valid = gtk_tree_model_get_iter_first( m_list_model, &iter );
  
  while ( valid )
  {
    gtk_tree_model_get( m_list_model, &iter, 0, &attack_data, 1, &src_data, 2, &dest_data, -1 );
    
    if ( (res = (attack_name == string(attack_data) &&
         source_host == string(src_data) &&
         target_host == string(dest_data))) )
    {
      if ( res_iter != 0 )
        *res_iter = iter;
      res = true;      
      
      break;
    }
    valid = gtk_tree_model_iter_next( m_list_model, &iter );
  }
  
  return res;
}

gboolean GTKAttacksGUI::handle_attacks_treeview_button_release_event()
{
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( attacks_treeview ) );
  GtkTreeIter       sel_iter;
  GtkTreeModel     *model;
  char             *attack_data;
  char             *src_data;
  char             *dest_data;
  
  if ( gtk_tree_selection_get_selected( selection, &model, &sel_iter) )
  {
    gtk_tree_model_get( model, &sel_iter, 0, &attack_data, 1, &src_data, 2, &dest_data, -1 );
    
    gtk_entry_set_text( GTK_ENTRY(attack_combo_entry), attack_data );
    gtk_entry_set_text( GTK_ENTRY(source_combo_entry), src_data );
    gtk_entry_set_text( GTK_ENTRY(target_combo_entry), dest_data );
  }
  
  return TRUE; 
}

void GTKAttacksGUI::handle_add_button_clicked_event()
{
  GtkTreeIter iter;
  string      attack_name = string( gtk_entry_get_text( GTK_ENTRY(attack_combo_entry) ));
  string      source_host = string( gtk_entry_get_text( GTK_ENTRY(source_combo_entry) ));
  string      dest_host = string( gtk_entry_get_text( GTK_ENTRY(target_combo_entry) ));
  AttackTriple attack;
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( attacks_treeview ) );
  int i;
  vector<string> attack_names;
  vector<string> source_hosts;
  vector<string> dest_hosts;
typedef vector<string>::const_iterator VSIterator;
    
  if ( attack_name == ALL_POSSIBLE )
  {
    for ( i = 0; i < m_network->GetNumAttacks(); i++ )
      attack_names.push_back(m_network->GetAttack( i )->GetName().transcode());
  }
  else
    attack_names.push_back( attack_name );
  
  if ( source_host == ALL_POSSIBLE )
  {
    for ( i = 0; i < m_network->GetNumHosts(); i++ )
      source_hosts.push_back(m_network->GetHost( i )->GetName().transcode());
  }
  else
    source_hosts.push_back( source_host );
  
  if ( dest_host == ALL_POSSIBLE )
  {
    string name;
    for ( i = 0; i < m_network->GetNumHosts(); i++ )
      dest_hosts.push_back(m_network->GetHost( i )->GetName().transcode());
    
    for (i = 0; i < (int)m_network->GetFirewallNumber(); i++)
    {
      name = FW_PREFIX + m_network->GetFirewallName( i ).transcode();
      dest_hosts.push_back(name);
    }
  }
  else
    dest_hosts.push_back( dest_host );
  
  for ( VSIterator a_iter = attack_names.begin(); a_iter != attack_names.end(); a_iter++ )
    for ( VSIterator s_iter = source_hosts.begin(); s_iter != source_hosts.end(); s_iter++ )
      for ( VSIterator d_iter = dest_hosts.begin(); d_iter != dest_hosts.end(); d_iter++ )
      {
        if ( attack.make_attack_triple(*a_iter, *s_iter, get_dest_data(*d_iter), m_network, is_dest_firewall(*d_iter)) )
        {
          if ( !find_attack( *a_iter, *s_iter, *d_iter, &iter ) )
          {
            m_measure.insert( attack );
            iter = add_attack( *a_iter, *s_iter, *d_iter );
          }
          gtk_tree_selection_select_iter( selection, &iter ); 
        }    
      }
}

void GTKAttacksGUI::handle_edit_button_clicked_event()
{
  GtkTreeIter iter;
  string      attack_name = string( gtk_entry_get_text( GTK_ENTRY(attack_combo_entry) ));
  string      source_host = string( gtk_entry_get_text( GTK_ENTRY(source_combo_entry) ));
  string      dest = string( gtk_entry_get_text( GTK_ENTRY(target_combo_entry) ));
  AttackTriple attack;
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( attacks_treeview ) );
  GtkTreeIter sel_iter;
  GtkTreeModel *model;
  
  if (gtk_tree_selection_get_selected( selection, &model, &sel_iter ))
  {  
    if ( !(attack_name == ALL_POSSIBLE) && 
         !(source_host == ALL_POSSIBLE) && 
         !(dest == ALL_POSSIBLE) )
    {
      if ( attack.make_attack_triple(attack_name, source_host, get_dest_data(dest), m_network, is_dest_firewall(dest)) )
      {
        if ( !find_attack( attack_name, source_host, dest, &iter ) )
        {
          if ( memcmp( &iter, &sel_iter, sizeof(GtkTreeIter) ) != 0 )
          {
            char             *attack_data;
            char             *src_data;
            char             *dest_data;
            AttackTriple      old_attack;
            
            gtk_tree_model_get( m_list_model, &sel_iter, 0, &attack_data, 1, &src_data, 2, &dest, -1 );
            old_attack.make_attack_triple( string(attack_data), string(src_data), get_dest_data(dest), m_network, is_dest_firewall(dest) );
            
            AttackMeasure::iterator p = m_measure.find( old_attack );
            if ( p != m_measure.end() )
            {
              m_measure.erase( p );
              m_measure.insert( attack );
              set_attack( &sel_iter, attack_name, source_host, dest );
            }
          }
        }
        else    
          gtk_tree_selection_select_iter( selection, &iter );
      }    
    }
  }
}

void GTKAttacksGUI::handle_delete_button_clicked_event()
{
  string      attack_name = string( gtk_entry_get_text( GTK_ENTRY(attack_combo_entry) ));
  string      source_host = string( gtk_entry_get_text( GTK_ENTRY(source_combo_entry) ));
  string      dest = string( gtk_entry_get_text( GTK_ENTRY(target_combo_entry) ));
  AttackTriple attack;
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( attacks_treeview ) );
  GtkTreeIter sel_iter;
  GtkTreeModel *model;
  
  if (gtk_tree_selection_get_selected( selection, &model, &sel_iter ) )
  {
    remove_attack( &sel_iter );
      
    if ( attack.make_attack_triple( attack_name, source_host, get_dest_data(dest), m_network, is_dest_firewall(dest) ) )
      m_measure.erase( attack );
    
    gtk_entry_set_text( GTK_ENTRY(attack_combo_entry), "" );
    gtk_entry_set_text( GTK_ENTRY(source_combo_entry), "" );
    gtk_entry_set_text( GTK_ENTRY(target_combo_entry), "" );
  }
}

void GTKAttacksGUI::handle_all_button_clicked_event()
{
  GraphAttributes	*attr;
  Node            *node;
  AttackTriple     attack;
  string           name;
  
  for ( NodeIndex ind = 1; ind < m_scenario_graph->count_nodes(); ind++ )
  {
    node = m_scenario_graph->get_node( ind );
    attr = node->get_attributes();
    
    if ( attack.make_attack_triple( attr ) )
      m_measure.insert( attack );
  }
  
  remove_all_attack();
  
  for ( AttackMeasure::const_iterator p = m_measure.begin(); p != m_measure.end(); p++ )
  {
    NetworkInfo *info = p->get_network_info( m_network );
    
    if ( info != 0 )
    {
      if ( info->dest_host != 0 )
        add_attack( (info->attack->GetName()).transcode(),
                    (info->src_host->GetName()).transcode(),
                    (info->dest_host->GetName()).transcode() );
      else if ( info->dest_firewall != 0 )
      {
        name = FW_PREFIX + (info->dest_firewall->GetName()).transcode();
        add_attack( (info->attack->GetName()).transcode(),
                    (info->src_host->GetName()).transcode(),
                     name );
      }
      delete info;
    }
  }
}

void GTKAttacksGUI::handle_load_button_clicked_event()
{
  string file_name = m_gui->run_fileselection_dialog ( "Select attack measure file", "", "" );
  string name;
  
  if ( !file_name.empty() )
  {
    remove_all_attack();
    
    if ( m_measure.load_from_file( file_name, m_network ) )
    {
      for ( AttackMeasure::const_iterator p = m_measure.begin(); p != m_measure.end(); p++ )
      {
        NetworkInfo *info = p->get_network_info( m_network );
        
        if ( info != 0 )
        {
          if ( info->dest_host != 0 )
            add_attack( (info->attack->GetName()).transcode(),
                        (info->src_host->GetName()).transcode(),
                        (info->dest_host->GetName()).transcode() );
          else if ( info->dest_firewall != 0 )
          {
            name = FW_PREFIX + (info->dest_firewall->GetName()).transcode();
            add_attack( (info->attack->GetName()).transcode(),
                        (info->src_host->GetName()).transcode(),
                         name );
          }
          delete info;
        }
      }
      
      if ( m_measure_flag )
        gtk_entry_set_text( GTK_ENTRY(name_entry), m_measure.get_name().c_str() ); 
    }
  }
}

void GTKAttacksGUI::handle_save_button_clicked_event()
{
  string file_name = m_gui->run_fileselection_dialog ( "Select attack measure file", "", "" );
  
  if ( !file_name.empty() )
  {
    if ( m_measure_flag )
      m_measure.set_name( gtk_entry_get_text( GTK_ENTRY(name_entry) ) ); 
    m_measure.save_into_file( file_name, m_network );
  }
}

static gboolean on_attacks_treeview_button_release_event( GtkWidget *widget, GdkEventButton  *event, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  return dialog->handle_attacks_treeview_button_release_event();
}

static void on_add_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  dialog->handle_add_button_clicked_event();
}

static void on_edit_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  dialog->handle_edit_button_clicked_event();
}

static void on_delete_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  dialog->handle_delete_button_clicked_event();
}

static void on_all_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  dialog->handle_all_button_clicked_event();
}

static void on_load_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  dialog->handle_load_button_clicked_event();
}

static void on_save_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKAttacksGUI *dialog = (GTKAttacksGUI*)user_data;
  dialog->handle_save_button_clicked_event();
}

void GTKAttacksGUI::create()
{
  GtkTreeViewColumn *column = 0;
  GtkCellRenderer   *render = 0;
  GList             *combo_items = 0;
  int                i = 0;
  
  attack_dialog = gtk_dialog_new ();
  gtk_window_set_title( GTK_WINDOW (attack_dialog), (m_measure_flag? "Attack measure": "Attack triples") );
  gtk_window_set_modal( GTK_WINDOW (attack_dialog), TRUE );

  dialog_vbox = GTK_DIALOG (attack_dialog)->vbox;
  gtk_widget_show (dialog_vbox);

  main_table = gtk_table_new (4, 3, FALSE);
  gtk_widget_show (main_table);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), main_table, TRUE, TRUE, 0);

  attack_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (attack_combo)->popwin),
                       "GladeParentKey", attack_combo);
  gtk_widget_show (attack_combo);
  gtk_table_attach (GTK_TABLE (main_table), attack_combo, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (attack_combo, 150, 21);
  //gtk_combo_set_value_in_list (GTK_COMBO (attack_combo), TRUE, FALSE);
  
  combo_items = g_list_append( combo_items, (gpointer)(ALL_POSSIBLE) );
  
  for ( i = 0; i < m_network->GetNumAttacks(); i++ )
    combo_items = g_list_append( combo_items, (gpointer)(m_network->GetAttack( i )->GetName().transcode()) );
  
  gtk_combo_set_popdown_strings (GTK_COMBO (attack_combo), combo_items);
  g_list_free (combo_items);
  combo_items = NULL;


  attack_combo_entry = GTK_COMBO (attack_combo)->entry;
  gtk_widget_show (attack_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (attack_combo_entry), FALSE);

  source_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (source_combo)->popwin),
                       "GladeParentKey", source_combo);
  gtk_widget_show (source_combo);
  gtk_table_attach (GTK_TABLE (main_table), source_combo, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (source_combo, 150, 21);
  //gtk_combo_set_value_in_list (GTK_COMBO (source_combo), TRUE, FALSE);
  
  combo_items = g_list_append( combo_items, (gpointer)(ALL_POSSIBLE) );
  
  for ( i = 0; i < m_network->GetNumHosts(); i++ )
    combo_items = g_list_append( combo_items, (gpointer)(m_network->GetHost( i )->GetName().transcode()) );
  
  gtk_combo_set_popdown_strings (GTK_COMBO (source_combo), combo_items);
  g_list_free (combo_items);
  combo_items = NULL;


  source_combo_entry = GTK_COMBO (source_combo)->entry;
  gtk_widget_show (source_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (source_combo_entry), FALSE);

  target_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (target_combo)->popwin),
                       "GladeParentKey", target_combo);
  gtk_widget_show (target_combo);
  gtk_table_attach (GTK_TABLE (main_table), target_combo, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request( target_combo, 150, 21 );
  
  //gtk_combo_set_value_in_list (GTK_COMBO (target_combo), TRUE, FALSE);
  
  combo_items = g_list_append( combo_items, (gpointer)(ALL_POSSIBLE) );
  
  for ( i = 0; i < m_network->GetNumHosts(); i++ )
     combo_items = g_list_append( combo_items, (gpointer)(m_network->GetHost( i )->GetName().transcode()) );
  
  string name;
  for ( i = 0; i < (int)m_network->GetFirewallNumber(); i++ )
  {
    name = FW_PREFIX + (m_network->GetFirewallName( i )).transcode();
    combo_items = g_list_append( combo_items, (gpointer)(name.c_str()) );
  }
  
  gtk_combo_set_popdown_strings (GTK_COMBO (target_combo), combo_items);
  g_list_free (combo_items);

  target_combo_entry = GTK_COMBO (target_combo)->entry;
  gtk_widget_show (target_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (target_combo_entry), FALSE);

  attacks_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (attacks_scrolledwindow);
  gtk_table_attach (GTK_TABLE (main_table), attacks_scrolledwindow, 0, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 3);
  gtk_widget_set_usize (attacks_scrolledwindow, 450, 200);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (attacks_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (attacks_scrolledwindow), GTK_SHADOW_IN);

  m_list_model = (GtkTreeModel *)gtk_list_store_new( 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING );
  
  attacks_treeview = gtk_tree_view_new_with_model( m_list_model );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Attack name", render, "text", 0, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( attacks_treeview ), column );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Source host", render, "text", 1, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( attacks_treeview ), column );
  
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "Destination", render, "text", 2, NULL );
  
  gtk_tree_view_append_column( GTK_TREE_VIEW( attacks_treeview ), column );

  gtk_widget_show (attacks_treeview);
  gtk_container_add (GTK_CONTAINER (attacks_scrolledwindow), attacks_treeview);
  
  if ( m_measure_flag )
  {
    name_entry = gtk_entry_new ();
    gtk_widget_show (name_entry);
    gtk_table_attach (GTK_TABLE (main_table), name_entry, 1, 2, 0, 1,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
  
    name_label = gtk_label_new ( "Attack measure name: " );
    gtk_widget_show (name_label);
    gtk_table_attach (GTK_TABLE (main_table), name_label, 0, 1, 0, 1,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (0), 2, 0);
    gtk_label_set_justify (GTK_LABEL (name_label), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (name_label), 0, 0.5);
  }
  else
  {
    name_entry = 0;
    name_label = 0;
  }
  
  buttons_hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (buttons_hbox);
  gtk_table_attach (GTK_TABLE (main_table), buttons_hbox, 0, 3, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

  add_button = gtk_button_new_with_mnemonic ( "Add" );
  gtk_widget_show (add_button);
  gtk_box_pack_start (GTK_BOX (buttons_hbox), add_button, TRUE, TRUE, 0);

  edit_button = gtk_button_new_with_mnemonic ( "Replace" );
  gtk_widget_show (edit_button);
  gtk_box_pack_start (GTK_BOX (buttons_hbox), edit_button, TRUE, TRUE, 0);

  delete_button = gtk_button_new_with_mnemonic ( "Delete" );
  gtk_widget_show (delete_button);
  gtk_box_pack_start (GTK_BOX (buttons_hbox), delete_button, TRUE, TRUE, 0);

  all_button = gtk_button_new_with_mnemonic( "Add all" );
  gtk_widget_show (all_button);
  gtk_box_pack_start (GTK_BOX (buttons_hbox), all_button, TRUE, TRUE, 0);

  load_button = gtk_button_new_with_mnemonic( "Load from file" );
  gtk_widget_show (load_button);
  gtk_box_pack_start (GTK_BOX (buttons_hbox), load_button, TRUE, TRUE, 0);

  save_button = gtk_button_new_with_mnemonic("Save into file" );
  gtk_widget_show (save_button);
  gtk_box_pack_start (GTK_BOX (buttons_hbox), save_button, TRUE, TRUE, 0);

  dialog_action_area = GTK_DIALOG (attack_dialog)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (attack_dialog), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (attack_dialog), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (attacks_treeview), "button_release_event",
                      GTK_SIGNAL_FUNC (on_attacks_treeview_button_release_event),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (edit_button), "clicked",
                      GTK_SIGNAL_FUNC (on_edit_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (delete_button), "clicked",
                      GTK_SIGNAL_FUNC (on_delete_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (all_button), "clicked",
                      GTK_SIGNAL_FUNC (on_all_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (load_button), "clicked",
                      GTK_SIGNAL_FUNC (on_load_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (save_button), "clicked",
                      GTK_SIGNAL_FUNC (on_save_button_clicked),
                      (gpointer)this);
}

int GTKAttacksGUI::run()
{
  bool valid = ( m_network != 0 );
  string name;
  
  if ( valid )
    valid = (m_network->GetNumHosts() > 0 && m_network->GetNumAttacks() > 0);
  
  if ( !valid )
  {
    m_gui->show_message_dialog( "There is no nettwork information." );
    return GraphGUIModalWindow::CANCELED;
  }
  
  AttackTriple  attack;
  NetworkInfo  *net_info;
  
  create();
  
  for ( AttackMeasure::const_iterator p = m_measure.begin(); p != m_measure.end(); p++ )
  {
    net_info = p->get_network_info( m_network );
    
    if ( net_info != 0 )
    {
      if ( net_info->dest_host != 0 )
        add_attack( (net_info->attack->GetName()).transcode(),
                    (net_info->src_host->GetName()).transcode(),
                    (net_info->dest_host->GetName()).transcode() );
      else if ( net_info->dest_firewall != 0 )
      {
        name = FW_PREFIX + (net_info->dest_firewall->GetName()).transcode();
        add_attack( (net_info->attack->GetName()).transcode(),
                    (net_info->src_host->GetName()).transcode(),
                     name );
      }
      
      delete net_info;
    }
  }
  
  if ( m_measure_flag )
    gtk_entry_set_text( GTK_ENTRY(name_entry), m_measure.get_name().c_str() );
    
  gint result = gtk_dialog_run( GTK_DIALOG(attack_dialog) );
  
  if ( result == GTK_RESPONSE_OK )
  {
    if ( m_measure_flag )
      m_measure.set_name( gtk_entry_get_text( GTK_ENTRY(name_entry) ) ); 
  }
  else
  {
    m_measure.clear();
    m_measure.set_name( "" );
  }
  
  gtk_widget_destroy( attack_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
