
#include <stdlib.h>
#include "spin.h"
#include "version.h"
#include "y.tab.h"

/**********************/
/*<AR> from pangen3.c */

//extern Symbol	*lastfnm;
//extern Symbol	lastdef;
//extern int	lastfrom;
//extern SRC	*frst;
extern SRC	*skip;
/*<AR> from pangen3.c */
/**********************/
extern Queue	*qtab;

#define blurb(fd, e)	{ fprintf(fd, "\n"); if (!merger) fprintf(fd, "\t\t/* %s:%d */\n", \
				e->n->fn->name, e->n->ln); }

#define tr_map(m, e)	{ if (!merger) fprintf( tc, "\t\ttr_2_src(%d, %s, %d);\n", \
				m, e->n->fn->name, e->n->ln); }

#define DELTA	500	/* sets an upperbound on nr of chan names */

extern ProcList	*rdy;

/*extern RunList	*run;
*/
extern Symbol	*Fname, *oFname, *owner, *context;
extern char	*claimproc, *eventmap;
extern int	lineno, verbose, Npars, Mpars;
extern int	m_loss, Nid, has_remote, merger, rvopt, separate;
extern int	Ntimeouts, Etimeouts, deadvar;
extern int	u_sync, u_async, nrRdy, nqs;
extern int	GenCode, IsGuard, Level, TestOnly;

static int modifier = 0;
/*extern char	*NextLab[];
*/


/*<AR> the global variables are not used for transition table initialization
   but some of them are used in another generation modules */
int	OkBreak = -1;
short	nocast=0;	/* to turn off casts in lvalues */
short	terse=0;	/* terse printing of varnames */
short	no_arrays=0;
short	has_last=0;	/* spec refers to _last */
short	has_badelse=0;	/* spec contains else combined with chan refs */
short	has_enabled=0;	/* spec contains enabled() */
short	has_pcvalue=0;	/* spec contains pc_value() */
short	has_np=0;	/* spec contains np_ */
short	has_sorted=0;	/* spec contains `!!' (sorted-send) operator */
short	has_random=0;	/* spec contains `??' (random-recv) operator */
short	has_xu=0;	/* spec contains xr or xs assertions */
short	has_unless=0;	/* spec contains unless statements */
short	has_provided=0;	/* spec contains PROVIDED clauses on procs */
short	_isok=0;	/* checks usage of predefined varble _ */
short	evalindex=0;	/* evaluate index of var names */
short	withprocname=0;	/* prefix local varnames with procname */
int	mst=0;		/* max nr of state/process */
int	multi_oval;	/* set in merges, used also in pangen4.c */
/*<AR> end*/

static int	uniq = 1;

int bool_ind = 0;

typedef struct UndoElement{
    unsigned short status;
    struct UndoSeqList *sub;
    struct UndoSeqList *esc;
    struct UndoElement *nxt;
    struct UndoElement *Nxt;
} UndoElement;

typedef struct UndoSequence{
    UndoElement *frst;
} UndoSequence;

typedef struct UndoSeqList{
    UndoSequence *this;
    struct UndoSeqList *nxt;
} UndoSeqList;

typedef struct TransEl
{
  short atom;
  int   forw;	
  int   st;       /* next state */
/*  char  tp[256];       // src txt of statement */
  unsigned char a_start;

  int   t_id;	         /* transition id, unique within proc   */

  struct TransEl *nxt;
} Trans;  
  
Trans **trans_table = 0;
int     trans_table_size = 0;
int     trans_table_len = 0;
int     init_state = 0;

int     forwards_len = 0;
unsigned char    *forwards_table = 0;

unsigned char   *accpstate = 0;
unsigned char   *progstate = 0;
unsigned char   *finalstate = 0;


static void add_to_trans_table( int t_id, short atom, int st, int forw, unsigned char a_start, int glob );
static void delete_tarns_table();

static int get_forw_enabled( int forw );
static void print_labs();

static UndoSequence* copy_seq_status( Sequence *s );
static void restore_seq_status( Sequence *s, UndoSequence *us, int b_free );
static UndoElement* copy_el_status( Element *e );
static void restore_el_status( Element *e, UndoElement *ue, int b_free );
static UndoSeqList* copy_slst_status( SeqList *sl );
static void restore_slst_status( SeqList *lst, UndoSeqList *ulst, int b_free );

#define MAXMERGE	65536	/* max nr of bups per merge sequence */

static short	CnT[MAXMERGE];
static Lextok	XZ, YZ[MAXMERGE];
static int	didcase, YZmax, YZcnt;


static Lextok	*Nn[2];
static int	TPE[2], EPT[2];
static int	T_sum, T_mus, t_cyc;
static short	AllGlobal=0;	/* set if process has provided clause */

FILE	*tc, *th, *ts, *tt, *tv, *tm, *ti;
ProcList	*cur_proc;

int	Pid;		/* proc currently processed */
static int	Det;	/* set if deterministic */
int	claimnr = -1;	/* claim process, if any */
int	eventmapnr = -1; /* event trace, if any */

typedef struct CaseCache {
	int m, b, owner;
	Element *e;
	Lextok *n;
	FSM_use *u;
	struct CaseCache *nxt;
} CaseCache;

CaseCache *casing[6];

static void gen_class_header( ProcList *p );
static void gen_class_constr( ProcList *p );

static void gen_globals( FILE *th, FILE *tc, FILE *tt );
static void gen_others( FILE *th, FILE *tc );

void gen_set_table( ProcList *p, FILE *tc );
/* modification of put_seq(...) for init transition table*/
void put_seq_init( Sequence *s, int Tt0, int Tt1);
/* modification of put_el(...) for init transition table*/
static void put_el_init( Element *e, int Tt0, int Tt1 );
/* modification of case_cache(...) for init transition table*/
static int case_cache_init( Element *e, int a );
/* modification of put_sub(...) for init transition table*/
static void put_sub_init( Element *e, int Tt0, int Tt1 );
/* modification of scan_seq(...)*/
static int scan_seq_init( Sequence *s );
/* modification of put_escp(...) for init transition table*/
static void put_escp_init( Element *e );

void calc_proc_table( FILE *tc, ProcList *p );
void calc_seq_init( Sequence *s, int Tt0, int Tt1);
static void calc_el_init( Element *e, int Tt0, int Tt1 );
static int calc_case_cache_init( Element *e, int a );
static void calc_sub_init( Element *e, int Tt0, int Tt1 );
static void calc_escp_init( Element *e );


static void nested_unless( Element *e, Element *g );
static void mark_seq( Sequence *s );
Element * target( Element *e );
static Element * find_target( Element *e );
int has_global( Lextok *n );
static void	Tpe(Lextok *);
static void typ_seq( Sequence *s );
static void	patch_atomic( Sequence *s );

/* RL*/
static int scan_seq( Sequence *s );
static void put_escp(FILE *fd, Element *e);
static int nr_bup(Element *e);
static int nrhops(Element *e);
static int fproc(char *s);
/*****/

/**************************************************************/
/*<AR> the functions are not used for automata initialisation 
   but they are used in another generation modules */
void putname(FILE *fd, char *pre, Lextok *n, int m, char *suff); 
static void put_seq(FILE *fd, Sequence *s, int Tt0, int Tt1);
static void put_sub(FILE *fd, Element *e, int Tt0, int Tt1);
static void doforward(FILE *fd, Element *e);
static int case_cache(FILE *fd, Element *e, int a);
static void put_el(FILE *fd, Element *e, int Tt0, int Tt1);


void putstmnt(FILE *fd, Lextok *now, int m);


void putremote(FILE *fd, Lextok *n, int m);	


int has_typ(Lextok *n, int m)
{
	if (!n) return 0;
	if (n->ntyp == m) return 1;
	return (has_typ(n->lft, m) || has_typ(n->rgt, m));
}

static int runcount;

void do_count(Lextok *n)
{
}

void count_runs(Lextok *n)
{
}

void Done_case(char *nm, Symbol *z)
{	

}
/* <AR> end                                     */
/************************************************/
static void gen_tranmove_code( ProcList *p, FILE *fd );
static void putproc(FILE *fd, ProcList *p);

/*char * cpp_dir = "scenario/%s"; */
char* scenario_dir; 

/* names of generated files*/
char * cpp_file[] = 
{ 
   "autom.h", 
   "autom.cpp", 
   "gstructs.h",
   "vars.txt",
   "trace.cpp",
   "move.cpp",
   "table.cpp"
};



/* the function generate unique automaton class name
   for the Proc*/
char *get_autom_class_name( ProcList *p )
{
   char *ClassName = 0;
   char *ClassNamePrefix = "CAutom_";
   char name[256];
   unsigned int i, j;

   memset( name, 0, sizeof(name) );
   for ( i = 0, j = 0; i < strlen( p->n->name ); i++ )
   {
      switch ( p->n->name[i] )
      {
      case '_': /* replace N '_' with N+1 '_' (to produce more than one '_')*/
         if ( p->n->name[ i + 1 ] != '_' )
         {
            strcat( name + j, "__" );
            j += 2;
            break;
         }
         /* fall through*/
      case ':': /* replace ':' with one '_'*/
         name[j++] = '_';
         break;

      default:
         name[j++] = p->n->name[i];
      }
   }

   ClassName = emalloc( strlen( ClassNamePrefix ) + strlen( name ) + 1 );

   if ( ClassName != 0 )
   {   
      ClassName[0] = 0;
      strcat( ClassName, ClassNamePrefix );
      strcat( ClassName, name );
   }

   return ClassName;
}

void gensrc( void ) 
{	
   ProcList *p;
   char   path[255]; 

   if (strlen(scenario_dir) == 0)
     strcpy(scenario_dir, "scenario/%s");
  
   sprintf(path, scenario_dir, cpp_file[0]);
   if ( !(th = fopen(path, "w")))  		/* header file   */
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }
    
   sprintf(path, scenario_dir, cpp_file[1]);
   if ( !(tc = fopen(path, "w")))     /* main routines */
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }

   sprintf(path, scenario_dir, cpp_file[2]);
   if ( !(ts = fopen(path, "w")))     /* types of global structures */		   
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }
   
   sprintf(path, scenario_dir, cpp_file[3]);
   if ( !(tt = fopen(path, "w")))     /* names of global variables  */		   
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }
   
   sprintf(path, scenario_dir, cpp_file[4]);
   if ( !(tv = fopen(path, "w")))     /* names of global variables  */		   
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }
   
   sprintf(path, scenario_dir, cpp_file[5]);
   if ( !(tm = fopen(path, "w")))     /* names of global variables  */		   
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }
   
   sprintf(path, scenario_dir, cpp_file[6]);
   if ( !(ti = fopen(path, "w")))     /* names of global variables  */		   
   {	
      printf("spin: cannot create %s\n", path );
		  alldone(1);
   }

   free(scenario_dir);
   /********************************************
    put includes statment
    ********************************************/
   fprintf( tc, "#include <stdarg.h>\n" );
   fprintf( tc, "#include \"%s\"\n", cpp_file[0] );
   fprintf( th, "#include \"%s\"\n\n", cpp_file[2] );
   fprintf( ts, "#include \"AutomBase.h\"\n\n" );
   fprintf( tm, "#include <stdarg.h>\n" );
   fprintf( tm, "#include \"%s\"\n\n", cpp_file[0] );
   fprintf( tv, "#include <stdarg.h>\n" );
   fprintf( tv, "#include \"%s\"\n\n", cpp_file[0] );
   fprintf( ti, "#include <stdarg.h>\n" );
   fprintf( ti, "#include \"%s\"\n\n", cpp_file[0] );
//   fprintf( ts, "typedef unsigned char uchar;\n" );
//   fprintf( ts, "typedef int QueueRef;\n\n" );

   /********************************************
   put global structures\types and initialize
   global state (init. global variables, add 
   global queues and add init process)
   ********************************************/
   gen_globals( ts, tc, tt );

   /*******************************************
    generate automata classes
    *******************************************/
   for (p = rdy; p; p = p->nxt)
   {
      uniq = 3;
      /*******************************************
       generate set_trans_table() and initialize 
       some global structures for 
       generation automaton header and  constructors
       *******************************************/
      gen_set_table( p, ti );

       /*******************************************
       generate automaton header
       *******************************************/
      gen_class_header( p );

      /*******************************************
       generate automaton constructors/destructors
       *******************************************/
      gen_class_constr( p );

      /*******************************************
       generate new_state()
       *******************************************/
      gen_tranmove_code ( p, tm );
       /*cur_proc = p;*/

      fprintf( tc, "/********************************************/\n" );
      fprintf( tc, "/********************************************/\n\n" );
      
      delete_tarns_table();
      
   }
 

   /*******************************************
    generate the other
    *******************************************/
   gen_queue_el_classes( th, tc, qtab );
   
   gen_others( th, tc );
   
   fclose( th );
   fclose( tc );
   fclose( tt );
   fclose( tv );
   fclose( tm );
   fclose( ts );
   fclose( ti );
}

static void gen_globals( FILE *th, FILE *tc, FILE *tt )
{
   int gvc = 0;
   int bool_count;
   ProcList *p;
   int i;
   int has_queues = doglobal( th, 0, "", CHANCOUNT );
  
   for (p = rdy; p && !has_queues; p = p->nxt)
   {
     has_queues = dolocal( th, "", CHANCOUNT, p->n->name );
   }

   /*<RL> modified*/
/*   InitVarTable();
   doglobal(0, "", BOOLV);
   for (i = 0; i < GetVarCount(); i++){
     printf("var_name = %s\n", FindVarByInd(i));
   }*/
           
   fprintf(th, "class BoolArr;\n");
   /* put user defined types*/
   putunames( th );

   /* put global variables */
   fprintf( th, "typedef struct { // global variables\n");
   gvc = doglobal( th, 0, "\t", PUTV );
   if ( gvc == 0 )
      fprintf( th, "\tuchar __noname;\n" );
   bool_count = doglobal( 0, 0, "\t\t", BOOLCOUNT);
/*   fprintf(th, "\tBoolArr *bit_arr;\n");*/
   fprintf( th, "} GlobalVarStruct;\n" );
   
   /* put global boolean variables. Actually all variables are of type unsigned long and contains indexes of correspondent boolean varibale inside 
   boolean bit array*/
   
   fprintf( th, "struct GlobalBoolIndStruct{ // global boolean variables indexes\n");
   gvc = doglobal( th, 0, "\t", PUTBOOLV );
   if ( gvc == 0 )
      fprintf( th, "\tuchar __noname;\n" );
   fprintf( th, "\t GlobalBoolIndStruct();\n" );      
   fprintf( th, "};\n\n" );
   
   fprintf( th, "class State: public StateBase\n" );
   fprintf( th, "{\n" );
   if ( has_queues )
   {
      fprintf( th, "private:\n" );
      fprintf( th, "\tvector<Queue*> m_queue_list;\n" );
      fprintf( th, "\tshort   m_boq; // contains id of blocked channel if any or -1 otherwise\n" );
   }
   fprintf( th, "private:\n" );
   fprintf( th, "\tvoid trace_vars( unsigned long trace_action, long extra_info = 0, const string &line_prefix = \"\" );\n" );
   fprintf( th, "public:\n" );
   if ( bool_count )
      fprintf( th, "\tBoolArr bit_arr;\n" );
   fprintf( th, "\tGlobalVarStruct globals;\n" );
   fprintf( th, "\tstatic GlobalBoolIndStruct globals_bool;\n" );   
   fprintf( th, "public:\n" );
   fprintf( th, "\tbool initialize( );\n" );
   
   fprintf( th, "\tState()" );
   if ( !has_queues )
     fprintf( th, " { state_in_memory++; if ( state_in_memory > max_state_in_memory ) max_state_in_memory = state_in_memory; initialize( ); }\n" );
   else
   {
     fprintf( th, "\n\t{\n" );
     fprintf( th, "\t\tstate_in_memory++;\n" );
     fprintf( th, "\t\tif ( state_in_memory > max_state_in_memory )\n" );
     fprintf( th, "\t\t  max_state_in_memory = state_in_memory;\n" );
     fprintf( th, "\t\tm_queue_list.reserve( 1 );\n" );
     fprintf( th, "\t\tm_queue_list.resize( 0, 0 );\n" );
     fprintf( th, "\t\tm_boq = -1;\n" );
     fprintf( th, "\t\tinitialize( );\n" );
     fprintf( th, "\t}\n" );
   }
   
   fprintf( th, "\t~State()" );
   if ( !has_queues )
     fprintf( th, " { state_in_memory--; delete_automs(); }\n" );
   else
     fprintf( th, ";\n" );
   
   fprintf( th, "\tbool compare_global_vars( State *OtherState )\n" );
   fprintf( th, "\t{\n" );
   fprintf( th, "\t\tif (memcmp(&(globals), &(OtherState->globals), sizeof(GlobalVarStruct)) != 0)\n" );
   fprintf( th, "\t\t   return false;\n" );
   if ( bool_count )
   {
     fprintf( th, "\t\tif (bit_arr != OtherState->bit_arr)\n" );
     fprintf( th, "\t\t   return false;\n" ); 
   }
   fprintf( th, "\t\treturn true;\n" );
   fprintf( th, "\t}\n\n" );
   
   if ( !has_queues )
   {
     fprintf( th, "\tState( int a_size ) \n" );
     fprintf( th, "\t{\n" );
     fprintf( th, "\t\tstate_in_memory++;\n" );
     fprintf( th, "\t\tif ( state_in_memory > max_state_in_memory )\n" );
     fprintf( th, "\t\t  max_state_in_memory = state_in_memory;\n" );
     fprintf( th, "\t\tm_autom_list.reserve( a_size );\n" );
     fprintf( th, "\t\tm_autom_list.resize( a_size, 0 );\n" );
     fprintf( th, "\t\tm_ltl = 0;\n" );
     fprintf( th, "\t}\n" );
   }
   else
   {
      fprintf( th, "\tState( int q_size, int a_size )\n" );
      fprintf( th, "\t{\n" );
      fprintf( th, "\t\tstate_in_memory++;\n" );
      fprintf( th, "\t\tif ( state_in_memory > max_state_in_memory )\n" );
      fprintf( th, "\t\t  max_state_in_memory = state_in_memory;\n" );
      fprintf( th, "\t\tm_queue_list.reserve( q_size );\n" );
      fprintf( th, "\t\tm_queue_list.resize( q_size, 0 );\n" );
      fprintf( th, "\t\tm_autom_list.reserve( a_size );\n" );
      fprintf( th, "\t\tm_autom_list.resize( a_size, 0 );\n" );
      fprintf( th, "\t\tm_ltl = 0;\n" );
      fprintf( th, "\t}\n" );
     
     {
      const char *quemethodth = "\tint add_queue( unsigned int max_len, QueueTypeCarrier* q_type_carrier );\n"
                           "\tinline Queue* get_queue( int q_num )\n"
                           "\t{\n"
                           "\t\tq_num--;\n"
                           "\t\tif ( q_num >= m_queue_list.size() || q_num < 0 )\n"
                           "\t\t\treturn 0;\n\n"
                           "\t\treturn m_queue_list[q_num];\n"
                           "\t}\n\n"
                           "\tinline void del_queue( QueueRef q_num )\n"
                           "\t{\n"
                           "\t\tq_num--;\n"
                           "\t\tif ( q_num < m_queue_list.size() && q_num >= 0 )\n"
                           "\t\t{\n"
                           "\t\t\tif ( m_queue_list[q_num] != 0 )\n"
                           "\t\t\t{\n"
                           "\t\t\t   delete m_queue_list[q_num];\n"
                           "\t\t\t   m_queue_list[q_num] = 0;\n"
                           "\t\t\t}\n"
                           "\t\t}\n"
                           "\t}\n\n"
                           "\tinline int queue_count() { return m_queue_list.size(); }\n";
      fprintf( th, quemethodth );
     }
      fprintf( th, "\tint  get_boq() { return m_boq;}\n" );
      fprintf( th, "\tvoid set_boq( int boq ) { m_boq = boq;}\n" );
   }
   
   if ( bool_count )
   {
/*      fprintf( th, "\tvoid set_global_bool_vars(GlobalBoolIndStruct &globals, BoolArr &arr);\n" );*/
/*      fprintf( th, "\tvoid get_global_bool_vars(GlobalBoolIndStruct &globals, BoolArr &arr);\n" );*/
   }
   fprintf( th, "\tunsigned int calc_size()\n" );
   fprintf( th, "\t{\n" );
   fprintf( th, "\t\tint i;\n" ); 
   fprintf( th, "\t\tunsigned int size = sizeof(*this);\n" );
   fprintf( th, "\t\tsize += StateBase::calc_size();\n" );   
   if ( bool_count )
        fprintf( th, "\t\tsize += bit_arr.get_size() / 8 + ((bit_arr.get_size() % 8)? 1: 0);\n" );
  
   if ( has_queues )
   {
     fprintf( th, "\t\tsize += m_queue_list.size() * sizeof(Queue*);\n" ); 
     fprintf( th, "\t\tfor ( i = 0; i < m_queue_list.size(); i++ )\n" ); 
     fprintf( th, "\t\t  if ( m_queue_list[i] != 0 )\n" ); 
     fprintf( th, "\t\t     size += m_queue_list[i]->calc_size();\n" ); 
   }  
   fprintf( th, "\t\treturn size;\n" );
   fprintf( th, "\t}\n" );
   fprintf( th, "\tvoid trace( unsigned long trace_action, long extra_info = 0, const string &line_prefix = \"\" )\n" );
   fprintf( th, "\t{\n" );
   fprintf( th, "\t\tStateBase::trace( trace_action, extra_info, line_prefix );\n" );
   if ( has_queues )
   {
     const char *que = "\t  if ( (trace_action & GRAPH_ATTR_FORMAT) ) {\n"
               "\t\tif ( (trace_action & TRACE_QUEUE) )\n"
               "\t\t{\n"
               "\t\t\tif ( m_queue_list.size() > 0 )\n"
               "\t\t\t{\n"
               "\t\t\t   print_attr( ATTR_START, \"Channels\" );\n"
               "\t\t\t   for ( int i = 0; i < m_queue_list.size(); i++ )\n"
               "\t\t\t   {\n"
               "\t\t\t     if ( m_queue_list[i] == 0 )\n"
               "\t\t\t     {\n"
               "\t\t\t        print_attr( ATTR_START,  \"\", i );\n"
               "\t\t\t        print_attr( ATTR_END );"
               "\t\t\t     }\n"
               "\t\t\t     else\n"
               "\t\t\t        m_queue_list[i]->trace( trace_action, i, line_prefix );\n"
               "\t\t\t   }\n"
               "\t\t\t   print_attr( ATTR_END, \"Channels\" );\n"
               "\t\t\t}\n"
               "\t\t}}\n"
               "\t  else\n"
               "\t\tif ( (trace_action & TRACE_QUEUE) )\n"
               "\t\t{\n"
               "\t\t\tif ( (trace_action & LEFTY_INPUT) == 0 )\n"
               "\t\t\t   print( line_prefix, TAB + \"Queues:\" + EOL );\n"
               "\t\t\tfor ( int i = 0; i < m_queue_list.size(); i++ )\n"
               "\t\t\t{\n"
               "\t\t\t  if ( m_queue_list[i] == 0 )\n"
               "\t\t\t  {\n"
               "\t\t\t    if ( (trace_action & LEFTY_INPUT) == 0 )\n"
               "\t\t\t      print( line_prefix + TAB + \"  \" + \"id: \", i + 1, \" = (Queue)0\" + EOL);\n"
               "\t\t\t  }\n"
               "\t\t\t  else\n"
               "\t\t\t    m_queue_list[i]->trace( trace_action, i + 1, line_prefix + TAB + \"  \" );\n"
               "\t\t\t}\n"
               "\t\t}\n";
       fprintf( th, que );
     
   }
   
   fprintf( th, "\t\tif ( trace_action & TRACE_GL_VAR )\n" );
   fprintf( th, "\t\t\ttrace_vars( trace_action, extra_info, line_prefix + TAB );\n\n" );
   
   fprintf( th, "\t\tif ( (m_tracing_flags & TRACE_MEM) && ( (trace_action & LEFTY_INPUT) == 0 ) )\n" ); 
   fprintf( th, "\t\t{\n" ); 
   fprintf( th, "\t\t\tlong size = calc_size();\n" ); 
   fprintf( th, "\t\t\tprint( line_prefix + TAB + \"State size: \", size, EOL );\n" ); 
   fprintf( th, "\t\t}\n" ); 
   fprintf( th, "\t}\n" );
   
   
   fprintf( th, "\tClonable* clone( )\n" );
   fprintf( th, "\t{\n" );
   if ( !has_queues )
     fprintf( th, "\t\tState *the_clone = new State( m_autom_list.size() );\n" );
   else
   {  
      fprintf( th, "\t\tState *the_clone = new State( m_queue_list.size(), m_autom_list.size() );\n" );
      fprintf( th, "\t\tClonable *t_clone = 0;\n" );
      fprintf( th, "\t\tQueue *q = 0;\n" );
      fprintf( th, "\t\tunsigned int i = 0;\n" );
        
      fprintf( th, "\t\tfor ( i = 0; i < m_queue_list.size(); i++ )\n" );
      fprintf( th, "\t\t{\n" );
      fprintf( th, "\t\t\tif ( m_queue_list[i] == 0 )\n" );
      fprintf( th, "\t\t\t   the_clone->m_queue_list[i] = 0;\n" );
      fprintf( th, "\t\t\telse\n" );
      fprintf( th, "\t\t\t{\n" );
      fprintf( th, "\t\t\t   t_clone = m_queue_list[i]->clone();\n" );
      fprintf( th, "\t\t\t   q = dynamic_cast<Queue*>(t_clone);\n" );
      fprintf( th, "\t\t\t   the_clone->m_queue_list[i] = q;\n" );
      fprintf( th, "\t\t\t}\n" );
      fprintf( th, "\t\t}\n" );
   
      fprintf( th, "\t\tthe_clone->m_boq = m_boq;\n" );
   }  
   fprintf( th, "\t\tcopy_to( the_clone );\n" );
   
   
   fprintf( th, "\t\tmemcpy( &(the_clone->globals), &globals, sizeof(GlobalVarStruct) );\n" );
   if ( bool_count )
      fprintf( th, "\t\tthe_clone->bit_arr = bit_arr;\n" );
   fprintf( th, "\t\treturn the_clone;\n" );
   fprintf( th, "\t}\n" );
   
   fprintf( th, "\tint get_state_byte_array( uchar **arr_st );\n");
   
   fprintf( th, "};\n" );
   
   fprintf( tc, "GlobalBoolIndStruct State::globals_bool;\n\n" );
      
   fprintf( tc, "GlobalBoolIndStruct::GlobalBoolIndStruct()\n{\n" );      
   doglobal( tc, 0, "", SETBOOL);      
   fprintf( tc, "}\n" );
   
   /* get_state_byte_array - for creating hash key*/
   fprintf( tc, "int State::get_state_byte_array( uchar **arr_st )\n");
   fprintf( tc, "{\n" );
   fprintf( tc, "\tint state_size = sizeof(GlobalVarStruct);\n" );
   fprintf( tc, "\tunsigned int i;\n" );
   
   fprintf( tc, "\tif ( m_ltl != 0 )\n" );
   fprintf( tc, "\t  state_size += get_never_claim()->get_autom_byte_array( 0 );\n\n" );
   
   fprintf( tc, "\tfor ( i = 0; i < m_autom_list.size() ;i++ )\n" );
   fprintf( tc, "\t  if ( m_autom_list[i] != 0 )\n" );
   fprintf( tc, "\t     state_size += m_autom_list[i]->get_autom_byte_array( 0 );\n\n" );
   
   if ( bool_count )
    fprintf( tc, "\tstate_size += (bit_arr.get_size()-1)/CHAR_BIT+1;\n\n" );
   
   fprintf( tc, "\tif ( arr_st != 0 )\n" );
   fprintf( tc, "\t{\n" );
   fprintf( tc, "\t  uchar *buff_st = *arr_st = new uchar[state_size];\n" );
   fprintf( tc, "\t  int    curr_st;\n" );    
   fprintf( tc, "\t  int    offset = 0;\n\n" );
   fprintf( tc, "\t  memset( buff_st, 0, state_size * sizeof(uchar) );\n\n" );
     
   fprintf( tc, "\t  if ( m_ltl != 0 )\n" );
   fprintf( tc, "\t  {\n" );
   fprintf( tc, "\t    offset = get_never_claim()->get_autom_byte_array( buff_st );\n" );
   fprintf( tc, "\t    buff_st += offset;\n" );
   fprintf( tc, "\t  }\n\n" );
     
   fprintf( tc, "\t  for ( i = 0; i < m_autom_list.size() ;i++ )\n" );
   fprintf( tc, "\t    if ( m_autom_list[i] != 0 )\n" );
   fprintf( tc, "\t    {\n" );
   fprintf( tc, "\t      offset = m_autom_list[i]->get_autom_byte_array( buff_st );\n" );
   fprintf( tc, "\t      buff_st += offset;\n" );
   fprintf( tc, "\t    }\n\n" );
     
   fprintf( tc, "\t  memcpy( buff_st, (void*)&globals, sizeof(GlobalVarStruct) );\n" );
   fprintf( tc, "\t  buff_st += sizeof(GlobalVarStruct);\n" );
   
   if ( bool_count )   
   {
     fprintf( tc, "\t  bit_arr.copy_bit_arr( buff_st );\n" );
     /*fprintf( tc, "\t  buff_st += (bit_arr.get_size()-1)/CHAR_BIT+1;\n" );*/
   }
     
   fprintf( tc, "\t}\n\n" );
   
   fprintf( tc, "\treturn state_size;\n" );
   
   fprintf( tc, "}\n" );
   
   /* put global variables initializing */
   fprintf( tc, "bool State::initialize( )\n" );
   fprintf( tc, "{\n" );
   fprintf( tc, "\tmemset( &globals, 0, sizeof(GlobalVarStruct) );\n" );
   doglobal( tc, 0, "globals.", INIV );
   
/*   if ( gvc == 0 )
      fprintf( tc, "\tglobals.__noname = 0;\n" );*/
   if ( bool_count )
      fprintf( tc, "\tbit_arr.set_size(%i);\n", bool_count);
   
/*   if ( bool_count )
      fprintf( tc, "\n\tset_global_bool_vars(globals_bool, bit_arr);\n");*/

   for (p = rdy; p; p = p->nxt)
   {
      if ( strcmp(p->n->name, ":init:" ) == 0 )
      {
         fprintf( tc, "\tCAutomBase *init = new CAutom__init_( this );\n" );
         fprintf( tc, "\tadd_proc( init );\n\n" );
      }
      else if ( strcmp(p->n->name, ":never:" ) == 0 )
      {
         fprintf( tc, "\tCAutomBase *never = new CAutom__never_( this );\n" );
         fprintf( tc, "\tm_ltl = never;\n\n" );
      }
   }
   fprintf( tc, "\treturn true;\n" );
   fprintf( tc, "}\n" );
   
   if ( has_queues )
   {
      fprintf( tc, "State::~State( )\n" );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tstate_in_memory--;\n" );
      fprintf( tc, "\tdelete_automs();\n" );
      fprintf( tc, "\tfor ( unsigned int i = 0; i < m_queue_list.size(); i++ )\n" );
      fprintf( tc, "\t\tif ( m_queue_list[i] != 0 )\n" );
      fprintf( tc, "\t\t{\n" );
      fprintf( tc, "\t\t   delete m_queue_list[i];\n" );
      fprintf( tc, "\t\t   m_queue_list[i] = 0;\n" );
      fprintf( tc, "\t\t}\n" );
      fprintf( tc, "}\n\n" );
      fprintf( tc, "int State::add_queue( unsigned int max_len, QueueTypeCarrier* q_type_carrier ) \n" );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tQueue *q = new Queue( max_len, q_type_carrier );\n" );

      fprintf( tc, "\tif ( q == 0 )\n" );
      fprintf( tc, "\t\treturn 0;\n" );
   
      fprintf( tc, "\tm_queue_list.push_back( q );\n" );
      fprintf( tc, "\treturn m_queue_list.size();\n" );
      fprintf( tc, "}\n" );
   }

   /* put global variables tracing */
   fprintf( tv, "void State::trace_vars( unsigned long trace_action, long extra_info, const string &line_prefix )\n" );
   fprintf( tv, "{\n" );

   if ( gvc )
   {
/*      if (bool_count)
      {
        fprintf( tc, "\n\tGlobalBoolIndStruct globals_bool;");   
        fprintf( tc, "\n\tset_global_bool_vars(globals_bool, bit_arr);\n");
      }*/
     
     
      fprintf( tv, "\tQueue *q = 0;\n" );
      fprintf( tv, "\tstring chan_type = \"chan\";\n" );
      fprintf( tv, "\tstring bool_type = \"bool\";\n" );
      fprintf( tv, "\tstring byte_type = \"byte\";\n" );
      fprintf( tv, "\tstring int_type = \"int\";\n" );
      fprintf( tv, "\tstring short_type = \"short\";\n" );
      fprintf( tv, "\tbool trace_queue = (trace_action & TRACE_QUEUE);\n" );
     /* fprintf( tv, "\tbool lefty_input = ((trace_action & LEFTY_INPUT) != 0 && (trace_action & GRAPH_ATTR_FORMAT) == 0);\n\n" );
      fprintf( tv, "\tif ( !lefty_input )\n");
      fprintf( tv, "\t\tprint( line_prefix ); print_attr( Tracer::ATTR_START, \"GlobalVariables\" );\n\n" );
     */
      fprintf( tv, "\tprint_attr( Tracer::ATTR_START, \"GlobalVariables\" );\n\n" );
      doglobal( tv, tt, "line_prefix + TAB", TRACEV );
      /*fprintf( tv, "\n\tif ( !lefty_input )\n");
      fprintf( tv, "\t\tprint( line_prefix ); print_attr(  Tracer::ATTR_END, \"GlobalVariables\" );\n" );
      */
      fprintf( tv, "\tprint_attr(  Tracer::ATTR_END, \"GlobalVariables\" );\n" );
   }

   fprintf( tv, "}\n" );
   
   /* put setting and getting of global boolean variables */
   bool_ind = 0;
   if ( bool_count )
   {
/*      fprintf( tc, "void State::set_global_bool_vars(GlobalBoolIndStruct &bool_globals, BoolArr &arr)\n" );   
      fprintf( tc, "{\n" );
      doglobal( tc, "", SETBOOL);   
      fprintf( tc, "}\n" );   
      bool_ind = 0;*/
/*      fprintf( tc, "void State::get_global_bool_vars(GlobalBoolIndStruct &bool_globals, BoolArr &arr)\n" );
      fprintf( tc, "{\n" );
      doglobal( tc, "", GETBOOL );   
      fprintf( tc, "}\n" );   */
   }
}

static void gen_others( FILE *th, FILE *tc )
{
   ProcList *p;
   char *class_name = 0;
  
  /*global make_state_attr_format_string function*/
   fprintf( tc, "void make_state_attr_format( unsigned long format_flags, ostream *file_stream )\n" );
   fprintf( tc, "{\n" );
   fprintf( tc, "\tunsigned long flags = Tracer::get_flags( );\n" );
   fprintf( tc, "\tostream *curr_stream = Tracer::get_curr_stream( );\n" );  
   fprintf( tc, "\tState st;\n" );
    
   for (p = rdy; p; p = p->nxt)
   {
      if ( strcmp(p->n->name, ":init:" ) != 0 && strcmp(p->n->name, ":never:" ) != 0 )
      {
         class_name = get_autom_class_name( p );
         fprintf( tc, "\tst.add_proc( new %s( &st ) );\n", class_name );
         efree( class_name, strlen( class_name ) + 1 );
      }
   }
   
   fprintf( tc, "\n\tTracer::init_tracing( file_stream, Tracer::GRAPH_ATTR_FORMAT | Tracer::ATTR_INIT | format_flags );\n" ); 
   fprintf( tc, "\tTracer::trace( &st );\n" );
   fprintf( tc, "\tTracer::init_tracing( curr_stream, flags );\n" );
   fprintf( tc, "}\n" );
}

static void gen_class_header( ProcList *p )
{
   char *ClassName = get_autom_class_name( p );
   char *par_name = 0;
   int   par_arr_range = 0;
   Lextok	*v = 0;
   Lextok	*nxtp = 0;
   int bool_count = 0;
   
   fprintf( th, "//(proc: %s, proctype: %d)\n", p->n->name, p->tn );

   fprintf( th, "class %s: public CAutomBase\n", ClassName );
   fprintf( th, "{\n" );
   /*fprintf( th, " friend uchar pack_state_hash_key( State* st, uchar **key );\n" );*/
   /* put class private section */
   fprintf( th, "private:\n" );
   if ( haslocal( p->n->name ) )
   {
      fprintf( th, "typedef struct {\n" );
      dolocal( th, "", PUTV, p->n->name );
      fprintf( th, "} SLocalVariables;\n\n" );
      fprintf( th, "\tSLocalVariables locals;\n" );
      bool_count = dolocal( 0, "", BOOLCOUNT, p->n->name);
     
      if ( bool_count )
        fprintf( th, "\tBoolArr autom_bit_arr;\n" );
     
   }

   /* put global boolean variables. Actually all variables are of type unsigned long and contains indexes of correspondent boolean varibale inside 
   boolean bit array*/
   
   fprintf( th, "struct SLocalBoolIndStruct { // global boolean variables indexes\n");
   dolocal( th, "", PUTBOOLV, p->n->name);
   fprintf( th, "\tSLocalBoolIndStruct() {\n" );
   dolocal( th, "", SETBOOL, p->n->name);   
   fprintf( th, "\t}\n" );   
   
   fprintf( th, "} ;\n" );
   
   fprintf( th, "\tstatic SLocalBoolIndStruct locals_bool;\n" );   
   fprintf( th, "\tstatic bool* m_accpstate;\n" );
   fprintf( th, "\tstatic bool* m_finalstate;\n" );
   fprintf( th, "\tstatic bool* m_progstate;\n" );
   fprintf( th, "\tstatic Trans** m_sst_table;\n" );
   fprintf( th, "\tstatic int m_sst_ref_count;\n" );
   fprintf( th, "\tstatic int m_init_st;\n" );
   fprintf( th, "\tstatic int m_sst_table_length;\n\n" );

   /* put class protected section*/
   fprintf( th, "protected:\n /*Parameterless constructor is used for cloning*/\n" );
   fprintf( th, "\t%s( )\n", ClassName );
   fprintf( th, "\t{\n");
   fprintf( th, "\t\tm_stop = 0;\n");
   fprintf( th, "\t\tset_state_number( %d );\n", p->s->maxel );
   if ( haslocal( p->n->name ) )
   {
     fprintf( th, "\t\tmemset( &locals, 0, sizeof(SLocalVariables) );\n");
     if ( bool_count )
        fprintf( th, "\tautom_bit_arr.set_size(%i);\n", bool_count);
   }

   fprintf( th, "\t}\n");
   fprintf( th, "\tbool set_trans_table( );\n" );

   /* put class public section*/
   fprintf( th, "public:\n" );

   /* public constructor */
   fprintf( th, "\t%s( State *state", ClassName );

   for ( v = p->p; v; v = v->rgt )
   {
      par_name = get_var_type_string( v->lft->sym, &par_arr_range );

      for ( nxtp = v->lft; nxtp != 0; nxtp = nxtp->rgt )
      {
         if ( par_arr_range > 0 )
            fprintf( th, ", %s _%s[%d] = 0", par_name, nxtp->sym->name, par_arr_range );
         else
            fprintf( th, ", %s _%s = 0", par_name, nxtp->sym->name );
      }

      efree( par_name, strlen(par_name) + 1 );
	}

   fprintf( th, " );\n" );

   fprintf( th, "\t~%s( )\n", ClassName );
   fprintf( th, "\t{\n" );
   fprintf( th, "\t\tdel_table( &m_sst_table, m_sst_ref_count, m_sst_table_length );\n\n" );
   fprintf( th, "\t\tif ( m_sst_ref_count == 0 )\n\t\t{\n" );
   fprintf( th, "\t\t   m_sst_table = 0;\n" );
   fprintf( th, "\t\t   m_sst_table_length = m_state_number;\n" );
   fprintf( th, "\t\t   delete[] m_accpstate;\n" );
   fprintf( th, "\t\t   delete[] m_progstate;\n" );
   fprintf( th, "\t\t   delete[] m_finalstate;\n" );
   fprintf( th, "\t\t   m_init_st = 0;\n" );
   fprintf( th, "\t\t   m_progstate = 0;\n" );
   fprintf( th, "\t\t   m_finalstate = 0;\n" );
   fprintf( th, "\t\t   m_accpstate = 0;\n\t\t}\n" );

   fprintf( th, "\t}\n" );

   /* put setting and getting of local boolean variables */
   bool_ind = 0;
/*   if ( bool_count )
   {
      fprintf( th, "\tvoid set_local_bool_vars(SLocalBoolIndStruct &bool_locals, BoolArr &arr)\n" );
      fprintf( th, "\t{\n" );
      dolocal( th, "", SETBOOL, p->n->name);   
      fprintf( th, "\t}\n" );   
      bool_ind = 0;
      fprintf( th, "\tvoid get_local_bool_vars(SLocalBoolIndStruct &bool_locals, BoolArr &arr)\n" );
      fprintf( th, "\t{\n" );
      dolocal( th, "", GETBOOL, p->n->name);   
      fprintf( th, "\t}\n" );   
   }*/
  
   /* public overridden virtual methods */      
   fprintf( th, "\tClonable* clone( );\n" );
   fprintf( th, "\tbool new_state( State *state, int trans_id);\n" );
   fprintf( th, "\tint get_first_trans_id( int st )\n\t{\n" );
   fprintf( th, "\t\tif ( st < 1 || st >= m_state_number || m_sst_table == 0 )\n\t\t   return 0;\n" );
   fprintf( th, "\t\tif ( m_sst_table[st] == 0 )\n\t\t   return 0;\n" );
   fprintf( th, "\t\treturn m_sst_table[st]->t_id;\n\t}\n" );
   fprintf( th, "\tint get_next_trans_id( int trans_id )\n\t{\n" );
   fprintf( th, "\t\tif ( trans_id < 1 || trans_id >= m_sst_table_length || m_sst_table == 0 )\n\t\t   return 0;\n" );
   fprintf( th, "\t\tif ( m_sst_table[trans_id] == 0 )\n\t\t   return 0;\n\n" );
   fprintf( th, "\t\tTrans *trans = m_sst_table[trans_id];\n" );
   fprintf( th, "\t\tif ( trans->nxt == 0 || (trans->atom & CAutomBase::D_ATOM))\n\t\t   return 0;\n" );
   fprintf( th, "\t\ttrans = trans->nxt;\n" );
   fprintf( th, "\t\treturn trans->t_id;\n\t}\n" );

   /**/
   fprintf( th, "\tbool is_state_accepted( int st )\n\t{\n" );
   fprintf( th, "\t\tif ( st < 0 || st >= m_state_number )\n\t\treturn false;\n" );
   fprintf( th, "\t\treturn m_accpstate[st];\n" );
   fprintf( th, "\t}\n" );
   /**/
   fprintf( th, "\tbool is_state_final( int st )\n\t{\n" );
   fprintf( th, "\t\tif ( st < 0 || st >= m_state_number )\n\t\treturn false;\n" );
   fprintf( th, "\t\treturn m_finalstate[st];\n" );
   fprintf( th, "\t}\n" );
   /**/
   fprintf( th, "\tbool is_state_in_progress( int st )\n\t{\n" );
   fprintf( th, "\t\tif ( st < 0 || st >= m_state_number )\n\t\treturn false;\n" );
   fprintf( th, "\t\treturn m_progstate[st];\n" );
   fprintf( th, "\t}\n" );
   
   /* trace */
   fprintf( th, "\n\tvoid trace( unsigned long trace_action, long extra_info = 0, const string &line_prefix = \"\" );\n" );
   /**/
   fprintf( th, "\tint  get_autom_byte_array( uchar *arr );\n" );
   fprintf( th, "};\n" );

   fprintf( tc, "bool* %s::m_accpstate = 0;\n", ClassName );
   fprintf( tc, "bool* %s::m_progstate = 0;\n", ClassName );
   fprintf( tc, "bool* %s::m_finalstate = 0;\n", ClassName );
   fprintf( tc, "Trans** %s::m_sst_table = 0;\n", ClassName );
   fprintf( tc, "int %s::m_init_st = 0;\n", ClassName );
   fprintf( tc, "int %s::m_sst_ref_count = 0;\n", ClassName );
   fprintf( tc, "int %s::m_sst_table_length = %d;\n\n", ClassName, p->s->maxel );
   

   efree(ClassName, strlen( ClassName ) + 1 );
}

static void gen_class_constr( ProcList *p )
{
   char *ClassName = get_autom_class_name( p );
   int j = 0;
   char *par_name = 0;
   int   par_arr_range = 0;
   Lextok* v = 0, *nxtp = 0;
   int bool_count = 0;
	
   fprintf( tc, "%s::SLocalBoolIndStruct %s::locals_bool;\n", ClassName, ClassName);        
   fprintf( tc, "//Cunstructor (proc: %s, proctype: %d)\n", p->n->name, p->tn );
   fprintf( tc, "%s::%s( State *state", ClassName, ClassName );
   for ( v = p->p; v; v = v->rgt )
   {
      par_name = get_var_type_string( v->lft->sym, &par_arr_range );

      for ( nxtp = v->lft; nxtp != 0; nxtp = nxtp->rgt )
      {
         if ( par_arr_range > 0 )
            fprintf( tc, ", %s _%s[%d]", par_name, nxtp->sym->name, par_arr_range );
         else
            fprintf( tc, ", %s _%s", par_name, nxtp->sym->name );
      }

      efree( par_name, strlen(par_name) + 1 );
   }

   fprintf( tc, " )\n" );
   fprintf( tc, "{\n" );
   /* p->s->maxel is the number of automaton state */
   fprintf( tc, "\tbool res = set_state_number( %d );\n", p->s->maxel );
   fprintf( tc, "\tm_stop = 0;\n");

      
   skip = (SRC *) 0; /* <AR> What about free memory????????????*/
   
   fprintf( tc, "\tif ( m_sst_ref_count == 0 )\n\t{\n" );
   fprintf( tc, "\t\tm_accpstate = new bool[m_state_number + 1];\n" );
   fprintf( tc, "\t\tmemset( m_accpstate, 0, sizeof(bool) * (m_state_number + 1));\n" );
   fprintf( tc, "\t\tm_progstate = new bool[m_state_number + 1];\n" );
   fprintf( tc, "\t\tmemset( m_progstate, 0, sizeof(bool) * (m_state_number + 1));\n" );
   fprintf( tc, "\t\tm_finalstate = new bool[m_state_number + 1];\n" );
   fprintf( tc, "\t\tmemset( m_finalstate, 0, sizeof(bool) * (m_state_number + 1));\n" );
   print_labs();
   //end_labs( tc, p->n, p->tn );

   fprintf( tc, "\t}\n" );

   if ( haslocal( p->n->name ) )
   {
     fprintf( tc, "\tmemset( &locals, 0, sizeof(SLocalVariables) );\n" );
     bool_count = dolocal( 0, "", BOOLCOUNT, p->n->name);
     if ( bool_count )
        fprintf( tc, "\tautom_bit_arr.set_size(%i);\n", bool_count);
   }
   
   fprintf( tc, "\tset_trans_table( );\n\n" );

   if ( haslocal( p->n->name ) )
   {
      if ( p->p != 0 )
      {
         fprintf( tc, "\t/*Set proc parameters*/\n" );
         /* <AR> initialize parameters */
         for ( v = p->p; v; v = v->rgt )
         {
            for ( nxtp = v->lft; nxtp != 0; nxtp = nxtp->rgt )
            {
               if ( v->lft->sym->nel > 1 )
               {
                 
                  fprintf( tc, "\tif ( _%s == 0 )\n", nxtp->sym->name );
                  fprintf( tc, "\t\tmemset( locals.%s, 0, sizeof(_%s) );\n", nxtp->sym->name, nxtp->sym->name );
                  fprintf( tc, "\telse\n" );
                  fprintf( tc, "\t{\n" );
                 
                  for ( j = 0; j < nxtp->sym->nel; j++ )
                     fprintf( tc, "\t\tlocals.%s[%d] = _%s[%d];\n", nxtp->sym->name, j, nxtp->sym->name, j );
                  
                  fprintf( tc, "\t}\n" );
               }
               else
                  fprintf( tc, "\tlocals.%s = _%s;\n", nxtp->sym->name, nxtp->sym->name );
            }
         }
         fprintf( tc, "\n" );
      }

      /* <AR> initialize local variables*/
      dolocal( tc, "locals.", INIV, p->n->name );
   }

   fprintf( tc, "}\n\n" );

   /* put Clonable* clone( ) implementation*/
   fprintf( tc, "Clonable* %s::clone( )\n", ClassName );
   fprintf( tc, "{\n" );
   fprintf( tc, "\t%s *the_clone = new %s( );\n", ClassName, ClassName );
   fprintf( tc, "\tif ( the_clone != 0 )\n" );
   fprintf( tc, "\t{\n" );
   fprintf( tc, "\t\tthe_clone->m_state_number = m_state_number;\n" );
   fprintf( tc, "\t\tthe_clone->m_stop = m_stop;\n" );
   fprintf( tc, "\t\tthe_clone->_pid = _pid;\n" );
/*   fprintf( tc, "\t\tif (m_flags&1) the_clone->m_test_enabled |= 1;\n" );*/
   fprintf( tc, "\t\tthe_clone->m_curr_state = m_curr_state;\n" );
/*   fprintf( tc, "\t\tthe_clone->m_moved = m_moved;\n" );   */
   fprintf( tc, "\t\tthe_clone->m_flags = m_flags;\n" );   
   fprintf( tc, "\t\tm_sst_ref_count++;\n" );
   /*fprintf( tc, "\t\tmemcpy( the_clone->m_reached, m_reached, m_state_number * sizeof(uchar) );\n" );*/
   if ( haslocal( p->n->name ) )
   {
      fprintf( tc, "\t\tmemcpy( &(the_clone->locals), &locals, sizeof(SLocalVariables) );\n" );
   }
   
   if ( bool_count )
      fprintf( tc, "\t\tthe_clone->autom_bit_arr = autom_bit_arr;\n");
   
   fprintf( tc, "\t}\n" );
   fprintf( tc, "\treturn the_clone;\n" );
   fprintf( tc, "}\n\n" );


   /* put void trace(...)*/
   fprintf( tv, "void %s::trace( unsigned long trace_action, long extra_info, const string &line_prefix )\n", ClassName );
   fprintf( tv, "{\n" );
   fprintf( tv, "\tbool graph_attr = (trace_action & GRAPH_ATTR_FORMAT);\n" );
   fprintf( tv, "\tbool lefty_input = ((trace_action & LEFTY_INPUT) != 0 && !graph_attr);\n\n" );

/*   fprintf( tc, "\n\tSLocalBoolIndStruct locals_bool;" );
   if ( dolocal( tc, "", BOOLCOUNT, "" ) )
      fprintf( tc, "\n\tset_local_bool_vars(locals_bool, autom_bit_arr);");*/
   
   if ( strcmp( p->n->name, ":init:") == 0 )
     fprintf( tv, "\ttrace_autom_base( trace_action, extra_info, \"init\", line_prefix );\n" );
   else if ( strcmp( p->n->name, ":never:") == 0 )
     fprintf( tv, "\ttrace_autom_base( trace_action, extra_info, \"never\", line_prefix );\n" );
   else
     fprintf( tv, "\ttrace_autom_base( trace_action, extra_info, \"%s\", line_prefix );\n", p->n->name );
   
   fprintf( tv, "\tif ( graph_attr )\n");
   fprintf( tv, "\t{\n" );
   fprintf( tv, "\t\tprint_attr( \"short\", \"state\", m_curr_state );\n" );
   fprintf( tv, "\t}\n" );
   
   if ( haslocal( p->n->name ) )
   {
      fprintf( tv, "\tif ( trace_action & TRACE_LOC_VAR )\n" );
      fprintf( tv, "\t{\n" );
      fprintf( tv, "\t\tQueue *q = 0;\n" );
      fprintf( tv, "\t\tState *state = dynamic_cast<State*>(m_owner);\n" );
      fprintf( tv, "\t\tbool trace_queue = ((trace_action & TRACE_QUEUE) && !graph_attr);\n\n" );
      fprintf( tv, "\t\tif ( !lefty_input )\n\t\t{\n");
      fprintf( tv, "\t\t\tprint( line_prefix + TAB ); print_attr( Tracer::ATTR_START, \"LocalVariables\" );\n\t\t}\n\n" );
      dolocal( tv, "line_prefix + TAB + TAB", TRACEV, p->n->name );
      fprintf( tv, "\n\t\tif ( !lefty_input )\n\t\t{\n");
      fprintf( tv, "\t\t\tprint( line_prefix +  TAB ); print_attr( Tracer::ATTR_END, \"LocalVariables\" );\n\t\t}\n" );
      fprintf( tv, "\t}\n" );
   }
   fprintf( tv, "\tif ( (trace_action & TRACE_TABLE) != 0 && !lefty_input && !graph_attr)\n" );
   fprintf( tv, "\t{\n" );
   fprintf( tv, "\t\tprint( line_prefix + TAB + \"Table length: \", m_sst_table_length, EOL);\n" );
   fprintf( tv, "\t\tprint( line_prefix + TAB + \"State number: \", m_state_number, EOL);\n" );
   fprintf( tv, "\t\tprint( line_prefix + TAB + \"Init state:   \", m_init_st, EOL);\n" );
   fprintf( tv, "\t\ttrace_table( trace_action, &m_sst_table, m_state_number, m_accpstate, m_progstate, extra_info, line_prefix + TAB);\n" );
   fprintf( tv, "\t}\n" );
   
   fprintf( tv, "\tif ( graph_attr )\n");
   if ( strcmp( p->n->name, ":init:") == 0 )
     fprintf( tv, "\t\ttrace_autom_end( trace_action, \"init\", line_prefix );\n" );
   else if ( strcmp( p->n->name, ":never:") == 0 )
     fprintf( tv, "\t\ttrace_autom_end( trace_action, \"never\", line_prefix );\n" );
   else
     fprintf( tv, "\t\ttrace_autom_end( trace_action, \"%s\", line_prefix );\n", p->n->name );
   

   fprintf( tv, "}\n\n" );
   
   fprintf( tc, "int  %s::get_autom_byte_array( uchar *arr )\n",  ClassName );
   fprintf( tc, "{\n" );
   fprintf( tc, "\tint arr_size = sizeof(m_curr_state);\n" );
   if ( haslocal( p->n->name ) )
   {
     fprintf( tc, "\tarr_size += sizeof(SLocalVariables);\n" );
     
     if ( bool_count )
       fprintf( tc, "\tarr_size += (autom_bit_arr.get_size()-1)/CHAR_BIT+1;\n" );
   }
   
   fprintf( tc, "\tif ( arr != 0 )\n" );
   fprintf( tc, "\t{\n" );
   fprintf( tc, "\t  int offset  = 0;\n" );
   fprintf( tc, "\t  memcpy( arr, &m_curr_state, sizeof(m_curr_state) ); offset += sizeof(m_curr_state); \n" );
   if ( haslocal( p->n->name ) )
   {
     fprintf( tc, "\t  memcpy( arr + offset, &locals, sizeof(SLocalVariables) );offset += sizeof(SLocalVariables);\n" );
     if ( bool_count )
       fprintf( tc, "\t  autom_bit_arr.copy_bit_arr( arr + offset );\n" );
   }
   fprintf( tc, "\t}\n" );
   fprintf( tc, "\treturn arr_size;\n" );
   fprintf( tc, "}\n\n" );

   efree( ClassName, strlen( ClassName ) + 1 );
}

static UndoSequence* copy_seq_status( Sequence *s )
{
    UndoSequence *seq = 0;
   
    if ( s != 0 )
    {
        seq = (UndoSequence*)emalloc( sizeof(UndoSequence) );
   
        if ( seq == 0 ) 
            fatal( "memory deplited", "" );

        seq->frst = copy_el_status( s->frst );
    }
   
    return seq;
}

static void restore_seq_status( Sequence *s, UndoSequence *us, int b_free )
{
    if ( s == 0 || us == 0 )
	   return;

    restore_el_status( s->frst, us->frst, b_free );
    
    if ( b_free )
      efree( us, sizeof( UndoSequence ) );
}

static UndoElement* copy_el_status( Element *e )
{
   UndoElement *el = 0;
       
   if ( e != 0 && e->status != 0xFFFF )
   {
      el = (UndoElement*) emalloc( sizeof(UndoElement) );
   
      if ( el == 0 ) 
         fatal( "memory deplited", "" );

	   el->status = e->status;    
      e->status = 0xFFFF;

      el->Nxt = copy_el_status( e->Nxt );
	   el->nxt = copy_el_status( e->nxt );
	   el->sub = copy_slst_status( e->sub );
	   el->esc = copy_slst_status( e->esc );
   }
   
   return el;
}

static void restore_el_status( Element *e, UndoElement *ue, int b_free )
{
   if ( e == 0 || ue == 0 )
	   return;
	
   e->status = ue->status;

   restore_el_status( e->Nxt, ue->Nxt, b_free ); 
   restore_el_status( e->nxt, ue->nxt, b_free );
   restore_slst_status( e->sub, ue->sub, b_free );
   restore_slst_status( e->esc, ue->esc, b_free );
    
   if ( b_free )
      efree( ue, sizeof(UndoElement) );
}

static UndoSeqList* copy_slst_status( SeqList *sl )
{
   UndoSeqList *list = 0;
   
   if ( sl != 0 )
   {
      list = (UndoSeqList*) emalloc( sizeof(UndoSeqList) );
   
      if ( list == 0 ) 
         fatal( "memory deplited", "" );

      list->this = copy_seq_status( sl->this );
	   list->nxt = copy_slst_status( sl->nxt );
   }
   
   return list;
}

static void restore_slst_status( SeqList *lst, UndoSeqList *ulst, int b_free )
{
   if ( lst == 0 || ulst == 0 )
	   return;
	
   restore_seq_status( lst->this, ulst->this, b_free );
   restore_slst_status( lst->nxt, ulst->nxt, b_free );

   if ( b_free )
      efree( ulst, sizeof(UndoSeqList) );	    
} 

/* <AR> save initial state of ProcList (used in gen_set_table) */
static UndoSequence*  save_init_state( ProcList *p )
{
   UndoSequence* seq = copy_seq_status( p->s );

   if ( seq != 0 )
      restore_seq_status( p->s, seq, 0 );

   return seq;		
}

/* <AR> restore initial state of ProcList and global environment (used in gen_set_table) */
static void srestore_init_state( ProcList *p, UndoSequence* seq )
{
    if ( seq != 0 && p != 0 )
      restore_seq_status( p->s, seq, 1 );

    memset( casing, 0, sizeof(CaseCache *) * 6 );
    uniq = 3;
}

static void add_to_trans_table( int t_id, short atom, int st, int forw, unsigned char a_start, int glob )
{
  Trans *t = 0;
   
  if ( t_id < 0 || t_id >= trans_table_len )
    return;

  t = (Trans*)emalloc( sizeof(Trans) );
  //memset( t, 0, sizeof(Trans) );
  t->t_id = t_id;
  t->forw = forw;
  t->st   = st;
  if ( atom & L_ATOM )
       atom |= ATOM;

   t->atom = atom & (ATOM | 32);	/* only (2|8|32) have meaning */;
   if ( !glob )
      t->atom |= 8;	/* no global references */
   
   t->a_start = a_start && ((atom & ATOM) == 0);

/*  memcpy( t->tp, tp, (sizeof(t->tp) < tp_len)? tp_len: sizeof(t->tp) );*/
  
  if ( trans_table[t_id] == 0 )
    trans_table[t_id] = t;
  else
  {
    Trans *t_next = trans_table[t_id];
    for ( ; t_next->nxt != 0; t_next = t_next->nxt );

    t_next->nxt = t;
  }
  
  if ( init_state == 0 )
    init_state = t_id;
}

static void delete_tarns_table()
{
  int i;
  for ( i = 0; i < trans_table_len; i++ )
    if ( trans_table[i] != 0 )
    {
      Trans *t = trans_table[i];
      for (; t != 0; t = t->nxt )
        efree( t, sizeof(Trans) );
      
    }
    
    efree( trans_table, sizeof(Trans*) * trans_table_len );
    trans_table = 0;
    init_state = 0;
    
    efree( forwards_table, sizeof(unsigned char) * forwards_len );
    forwards_table = 0;
    forwards_len = 0;
    efree( accpstate, trans_table_len * sizeof(unsigned char) );
    efree( progstate, trans_table_len * sizeof(unsigned char) );
    efree( finalstate, trans_table_len * sizeof(unsigned char) );
    
    trans_table_len = 0;
    trans_table_size = 0;
}

static int get_forw_enabled( int forw )
{
  if ( forwards_table == 0 || forwards_len <= forw || forw < 3 )
    return 0;
  
  return (int)forwards_table[forw];
}

static void print_labs()
{
  int i = 0;
  if ( accpstate != 0 )
    for ( i = 0; i < trans_table_len; i++ )
      if ( trans_table[i] != 0 && accpstate[i] != 0 )
        fprintf( tc, "\t\tm_accpstate[%d] = true;\n", i );
      
  if ( progstate != 0 )
    for ( i = 0; i < trans_table_len; i++ )
      if ( trans_table[i] != 0 && progstate[i] != 0  )
        fprintf( tc, "\t\tm_progstate[%d] = true;\n", i );
      
  if ( finalstate != 0 )
    for ( i = 0; i < trans_table_len; i++ )
      if ( trans_table[i] != 0 && finalstate[i] != 0  )
        fprintf( tc, "\t\tm_finalstate[%d] = true;\n", i );
    
}

void find_reached( Trans **sst_table, unsigned char *reached, int sst_len, int init_st )
{
  Trans *T, *T0;
   if ( init_st < sst_len && init_st > 0 && sst_table[init_st] != 0 )
      for( T = sst_table[init_st]; !reached[init_st]; T = sst_table[T->st] )
      {
         reached[init_st] = 1;
         find_reached( sst_table, reached, sst_len, T->st );

         for( T0 = T->nxt; T0 != 0; T0 = T0->nxt )
         {
            find_reached( sst_table, reached, sst_len, T0->st );
         }
      }
}

int calc_max_forward()
{
   int i, max_forw = 0;
   Trans *T0;
  
   for( i = 0; i < trans_table_len; i++ )
   {
      T0 = trans_table[i];
      for( ; T0 != 0; T0 = T0->nxt )
        if ( max_forw < T0->forw )
          max_forw = T0->forw;
   }
   
   return max_forw;
};

void imed( unsigned char *accpstate, unsigned char *progstate, unsigned char *finalstate, int st1, int st2 )	/* set intermediate state */
{	
   accpstate[st1] = (accpstate[st1] || accpstate[st2]);
   progstate[st1] = (progstate[st1] || progstate[st2]);
   finalstate[st1] = (finalstate[st1] || finalstate[st2]);
}

void rebuild_trans_table()
{
   Trans *T0, *T1, *T2, *T3;
   int i, j;
   int cnt;
   unsigned char *reached = emalloc( sizeof(unsigned char) * trans_table_len  );
   //memset( reached, 0, sizeof(unsigned char) * trans_table_len );
  
   do 
   {
	   for (i = 1, cnt = 0; i < trans_table_len; i++)
      {	
         T2 = trans_table[i];
         T1 = T2? T2->nxt: 0;

	      //
         for ( T0 = T1; T0; T0 = T0->nxt )
         {	
	         //
	         if (  T0->st && 
		            trans_table[T0->st] &&  
		            trans_table[T0->st]->nxt
		         )
		         break;
         }

         if ( T0 )
	         for ( T0 = T1; T0; T0 = T0->nxt )
	         {	
		          T3 = trans_table[T0->st];

		          if ( !T3->nxt )
		          {	
                T2->nxt = (Trans*)emalloc( sizeof(Trans) );
                memcpy( T2->nxt, T0, sizeof(Trans) );
			          T2 = T2->nxt;
                imed( accpstate, progstate, finalstate, T2->st, T0->st );
		          }
              else
              {
		            do 
		            {	
			            T3 = T3->nxt;
               
			            T2->nxt = (Trans*)emalloc( sizeof(Trans) );
                  memcpy( T2->nxt, T3, sizeof(Trans) );
			            T2 = T2->nxt;
                  
                  imed( accpstate, progstate, finalstate, T2->st, T0->st );

			          } 
                while ( T3->nxt );
		            cnt++;
               }
	         }
      }
   } 
   while ( cnt );

   for (i = 1; i < trans_table_len; i++)
   {	
      if ( trans_table[i] != 0 && trans_table[i]->nxt != 0 ) // optimize 
      {	
         T1 = trans_table[i]->nxt;
         if ( trans_table[T1->st] == 0 ) 
            continue;
         
         T0 = (Trans*)emalloc( sizeof(Trans) );
         memcpy( T0, trans_table[T1->st], sizeof(Trans) );
         trans_table[i] = T0;
         T0->t_id = i;
                  
         imed( accpstate, progstate, finalstate, T0->st, T1->st );
         
         for (T1 = T1->nxt; T1; T1 = T1->nxt)
         {
	         if ( trans_table[T1->st] == 0 ) 
               continue;

            if ( T1->a_start ) 
            {
               //T0 = T0->nxt;
               T0->nxt = T1;
               //T0 = T0->nxt;
               //T0->t_id = i;
               //continue;
            }
            else
            {
	            T0->nxt = (Trans*)emalloc( sizeof(Trans) );
              memcpy( T0->nxt, trans_table[T1->st], sizeof(Trans) );
            }
	          T0 = T0->nxt;
            T0->t_id = i;
            
            imed( accpstate, progstate, finalstate, T0->st, T1->st );
         }
         
      }	
   }

   find_reached( trans_table, reached, trans_table_len, init_state );

   /* remove unreached */
   for ( i = 1; i < trans_table_len; i++ )
   {
      if ( !reached[i] && trans_table[i] != 0 )
      {
         for ( T0 = trans_table[i]->nxt; T0 != 0; )
         {
            T1 = T0;
            T0 = T1->nxt;
            efree( T0, sizeof(Trans) );
         }
         efree( trans_table[i], sizeof(Trans) );

         trans_table[i] = 0;
      }
   }
   
   /*finish atomic*/
   for ( i = 1; i < trans_table_len; i++ )
   {
      T0 = trans_table[i];
      if ( T0 != 0 )
      {
         unsigned char atomic = 0;
         unsigned char has_else = 0;
         for ( T1 = T0, j = 0; T1 != 0; T1 = T1->nxt, j++ ) {
           if ( !atomic )
            atomic = (T1->atom & ATOM) != 0;
           
           if ( !has_else )
             has_else = (T1->forw == 2);
         }

         if ( atomic && T0->nxt != 0)
            for ( T1 = T0; T1 != 0; T1 = T1->nxt )
            {
              // deterministic atomic cycle with else
              if ( has_else && j <= 2 )
                T1->atom |= (ATOM | 64);
              else
              {
                T1->atom &= ~ATOM;
                T1->atom |= 16;/*ND_ATOM;*/
              }
            }
      }
   }

   /* remove skip/goto */
   for ( j = 1; j < trans_table_len; j++ )
   {
      T0 = trans_table[j];
      if ( T0 != 0 )
         if ( T0->forw == 1 && 
              T0->nxt == 0 && 
              T0->t_id != T0->st && 
              !(accpstate[T0->t_id]) && 
              !(progstate[T0->t_id]) &&
              !(finalstate[T0->t_id])
              )
         {
            for ( i = 1; i < trans_table_len; i++ )
            {
               if ( trans_table[i] != 0 && T0->t_id != i )
               {
                  for ( T1 = trans_table[i]; T1 != 0; T1 = T1->nxt )
                  {
                     if ( T1->st == T0->t_id )
                        T1->st = T0->st;
                  }
               }
            }
            
            if ( T0->t_id == init_state )
               init_state = T0->st;
            
            imed( accpstate, progstate, finalstate, T0->st, T0->t_id );

            trans_table[j] = 0;
            efree( T0, sizeof(Trans) );
         }
   }

   efree( reached, sizeof(unsigned char) * trans_table_len );
   forwards_len = calc_max_forward();
   forwards_table = emalloc( sizeof(unsigned char) * forwards_len );
   //memset( forwards_table, 0, sizeof(unsigned char) * forwards_len );
   
   for( i = 0, cnt = 0; i < trans_table_len; i++ )
   {
      T0 = trans_table[i];
      for( ; T0 != 0; T0 = T0->nxt )
      {
        if ( forwards_table[T0->forw] == 0 )
          forwards_table[T0->forw] = 1;
      }
   }
}

void print_trans_table( FILE *tc )
{
  int i = 0;
  Trans *T = 0;
  
  fprintf( tc, "\tm_curr_state = %d;\n", init_state );
  
  for ( i = 0; i < trans_table_len; i++ )
  {
    T = trans_table[i];
    
    for (; T != 0; T = T->nxt )
      fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, %d, %d );\n", T->t_id, T->atom, T->st, T->forw );
  }
    
}

void calc_proc_table( FILE *tc, ProcList *p )
{
  trans_table_size = trans_table_len = p->s->maxel;
  trans_table = (Trans**)emalloc( trans_table_size * sizeof(Trans*) ); 
  //memset( trans_table, 0, trans_table_size * sizeof(Trans*) );
  accpstate = emalloc( trans_table_len * sizeof(unsigned char) );
  //memset( accpstate, 0, trans_table_len * sizeof(unsigned char) );
  progstate = emalloc( trans_table_len * sizeof(unsigned char) );
  //memset( progstate, 0, trans_table_len * sizeof(unsigned char) );
  finalstate = emalloc( trans_table_len * sizeof(unsigned char) );
  //memset( finalstate, 0, trans_table_len * sizeof(unsigned char) );
  
  
  calc_end_labs( accpstate, progstate, finalstate, p->n, p->tn );
  
  calc_seq_init( p->s, 2, 0 );
  
  rebuild_trans_table();
  
  print_trans_table( tc );
}

void gen_set_table( ProcList *p, FILE *tc )
{
   char *ClassName = get_autom_class_name( p );

   UndoSequence* save_state = save_init_state( p );

   Pid = p->tn;
   Det = p->det;

   /* put comment */
   fprintf( tc, "// Init transition table of %s automaton (proc: %s, proctype: %d)\n", ClassName, p->n->name, Pid );

   /* begin generating set_trans_table  */
   fprintf( tc, "bool %s::set_trans_table(  )\n", ClassName );
   fprintf( tc, "{\n" );
   fprintf( tc, "\tTrans ***t = &m_sst_table;\n" ); 
   fprintf( tc, "\tint nr = m_sst_ref_count;\n" ); 
   fprintf( tc, "\tint t_len = m_sst_table_length;\n\n" ); 
   fprintf( tc, "\tstart_table_init( t, m_sst_ref_count, m_sst_table_length );\n\n" );
   
   calc_proc_table( tc, p );
   /*put_seq_init( p->s, 2, 0 );*/
   
   fprintf( tc, "\n\tend_table_init( t, m_accpstate, m_progstate, m_sst_ref_count, m_sst_table_length, m_init_st );\n" );
   
   /* end generating set_trans_table()  */
   fprintf( tc, "\treturn true;\n" );
   fprintf( tc, "}\n\n" );

   srestore_init_state( p, save_state );

   efree( ClassName, strlen( ClassName ) + 1 );
}

void calc_seq_init( Sequence *s, int Tt0, int Tt1 )
{
   SeqList *h = 0;
   Element *e = 0, *g = 0;
   int a, deadlink;

   for (e = s->frst; e; e = e->nxt)
	 {
      if ( (e->status & DONE) == 0 )
      {
        e->status |= DONE;
        if ( e->n->ntyp == UNLESS )
        {	
           calc_seq_init(e->sub->this, Tt0, Tt1);
        } 
        else if ( e->sub )
        {	
           add_to_trans_table( e->seqno,  e->status & (ATOM | L_ATOM), 0, 0, 0, (e->status&I_GLOB)?1:0 );
/*           fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, 0, 0, 0, \"", e->seqno, e->status & (ATOM | L_ATOM) );
            
           comment( tc, e->n, e->seqno );
*/            
           if ( e->status & CHECK2 )
				      e->status |= I_GLOB;
/*
            fprintf( tc, "\", %d, %d, %d );", (e->status&I_GLOB)?1:0, Tt0, Tt1);
            blurb( tc, e );
*/            
            for ( h = e->sub; h; h = h->nxt )
            {	
/*               putskip( h->this->frst->seqno );*/

               g = huntstart(h->this->frst);

               if (g->esc)
                  nested_unless(e, g);

               a = g->seqno;

               if ( g->n->ntyp == 'c' &&
				          g->n->lft->ntyp == CONST &&
				          g->n->lft->val == 0 &&   /* 0 or false */
				          !g->esc )
               {	
                  deadlink = 1;
               } else
                deadlink = 0;
               
              if ( g->status & CHECK2 )
					      h->this->frst->status |= I_GLOB;

              add_to_trans_table( e->seqno, e->status & (ATOM | L_ATOM), a,  0, 0, (h->this->frst->status&I_GLOB)?1:0 );
/*				      fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, %d, 0, 0,\"", e->seqno, e->status & (ATOM | L_ATOM), a );

				      comment( tc, e->n, e->seqno );
*/
				      
/*				      fprintf( tc, "\", %d, %d, %d);", (h->this->frst->status&I_GLOB)?1:0, Tt0, Tt1 );
				      blurb(tc, e);

				      if ( deadlink )
					      fprintf( tc, "#endif\n" );
*/
			      }

			      for ( h = e->sub; h; h = h->nxt )
				      calc_seq_init( h->this, Tt0, Tt1 );

		     } 
         else
		     {	
            if ( e->n->ntyp == ATOMIC ||
			        e->n->ntyp == D_STEP ||
			        e->n->ntyp == NON_ATOMIC )
               calc_sub_init( e, Tt0, Tt1 );
			      else 
				      calc_el_init( e, Tt0, Tt1 );
		     }
      }

      if (e == s->last)
			  break;
   }
}

/* modification of put_seq(...) for init transition table*/
/*
void put_seq_init( Sequence *s, int Tt0, int Tt1 )
{
   SeqList *h = 0;
   Element *e = 0, *g = 0;
   int a, deadlink;

   for (e = s->frst; e; e = e->nxt)
   {
      if ( (e->status & DONE) == 0 )
      {
		   e->status |= DONE;

		   if ( e->n->ntyp == UNLESS )
		   {	
            put_seq_init(e->sub->this, Tt0, Tt1);
		   } 
         else if ( e->sub )
		   {	
            fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, 0, 0, 0, \"", e->seqno, e->status & (ATOM | L_ATOM) );
            
			   comment( tc, e->n, e->seqno );
            
			   if ( e->status & CHECK2 )
				   e->status |= I_GLOB;

            fprintf( tc, "\", %d, %d, %d );", (e->status&I_GLOB)?1:0, Tt0, Tt1);
			   blurb( tc, e );
            
			   for ( h = e->sub; h; h = h->nxt )
			   {	
               putskip( h->this->frst->seqno );

				   g = huntstart(h->this->frst);

				   if (g->esc)
					   nested_unless(e, g);

				   a = g->seqno;

				   if ( g->n->ntyp == 'c' &&
				        g->n->lft->ntyp == CONST &&
				        g->n->lft->val == 0 &&   
				       !g->esc )
				   {	
                  fprintf( tc, "#if 0\n\t/* dead link: \n");
					   deadlink = 1;
					   if (verbose&32)
					      printf("spin: line %3d  %s, Warning: condition is always false\n",
						      g->n->ln, g->n->fn?g->n->fn->name:"");
				   } else
					   deadlink = 0;

				    fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, %d, 0, 0,\"", e->seqno, e->status & (ATOM | L_ATOM), a );

				   comment( tc, e->n, e->seqno );

				   if ( g->status & CHECK2 )
					   h->this->frst->status |= I_GLOB;
				   fprintf( tc, "\", %d, %d, %d);", (h->this->frst->status&I_GLOB)?1:0, Tt0, Tt1 );
				   blurb(tc, e);

				   if ( deadlink )
					   fprintf( tc, "#endif\n" );
			   }

			   for ( h = e->sub; h; h = h->nxt )
				   put_seq_init( h->this, Tt0, Tt1 );

		   } 
         else
		   {	
            if ( e->n->ntyp == ATOMIC ||
			        e->n->ntyp == D_STEP ||
			        e->n->ntyp == NON_ATOMIC )
               put_sub_init( e, Tt0, Tt1 );
			   else 
				   put_el_init( e, Tt0, Tt1 );
		   }
      }

      if (e == s->last)
			break;
   }
}
*/
static void calc_el_init( Element *e, int Tt0, int Tt1 )
{
   int a = 0, casenr = 0, Global_ref = 0;
   int non_generic = 0;
   Element *g = ZE;

   if ( e->n->ntyp == GOTO )
   {	
      g = get_lab( e->n, 1 );
      g = huntele( g, e->status, -1 ); 
      cross_dsteps( e->n, g->n );
      a = g->seqno;
   } 
   else if (e->nxt)
   {	
      g = huntele( e->nxt, e->status, -1 );
      a = g->seqno;
   }

   if ( g &&
	    ( g->status & CHECK2 ||   /* entering remotely ref'd state */
	      e->status & CHECK2 ) )	/* leaving  remotely ref'd state */
      e->status |= I_GLOB;

	/* don't remove dead edges in here, to preserve structure of fsm */

  if ( g )
    if ( g->n->ntyp == STOP )
    {
      e->merge_start = 0;      
      e->merge = 0;
    }
    
   if ( e->merge_start || e->merge )
   {
      if ( e->n->ntyp == '.' )
         casenr = 1;
      else
         non_generic = 1;

   }
   else
   {
      switch ( e->n->ntyp ) 
      {
      case ELSE:
		   casenr = 2; /* standard else */
		   break;

      case '.':
      case GOTO:
      case BREAK:

		   casenr = 1; /* standard goto */

   		break;
   case PRINT:
		   if ( e->n->lft == ZN )
		   {	
          casenr = 1;
		   }
       else
            non_generic = 1;

         break;
	   case 'c':
		   if ( e->n->lft->ntyp == CONST &&
		        e->n->lft->val == 1 )	/* generic skip or true */
		   {	
            casenr = 1;
            break;
		   }
       
    default:
         non_generic = 1;

		   break;
	   }
   }

   Global_ref = (e->status & I_GLOB)? 1: has_global( e->n );
   
   if ( e->n->ntyp == STOP )
   {
      casenr = uniq++;
      finalstate[e->seqno] = 1;
      accpstate[e->seqno] = 1;
      add_to_trans_table( e->seqno, e->status & (ATOM | L_ATOM), e->seqno, casenr, 0, Global_ref );
   }
   else if ( non_generic == 0 )
   {
      /* generic_case */
      putskip( e->seqno );
      add_to_trans_table( e->seqno, e->status & (ATOM | L_ATOM), a, casenr, 0, Global_ref );
/*		  fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, %d, %d, 0, \"", e->seqno, e->status & (ATOM | L_ATOM), a, casenr );*/
   }
   else
   {
      casenr = calc_case_cache_init( e, a );

		if ( casenr < 0 ) 
         return;	/* unreachable state */
   }

	/* tailend of settr(...); */
	//Global_ref = (e->status & I_GLOB)? 1: has_global( e->n );
/*	comment( tc, e->n, e->seqno );
	fprintf( tc, "\", %d, ", Global_ref );
*/
	if ( Tt0 == 2 )
    Tpe( e->n );	/* sets EPT */

	calc_escp_init( e );
}

/******************************************************************/
/* <AR> Start CaseCache routines                                        */ 
/******************************************************************/
static int identical( Lextok *p, Lextok *q )
{
	if ( (!p && q) || (p && !q) )
		return 0;

	if ( !p )
		return 1;

	if ( p->ntyp    != q->ntyp	||  
        p->ismtyp  != q->ismtyp ||  
        p->val     != q->val ||  
        p->indstep != q->indstep	||  
        p->sym     != q->sym ||  
        p->sq      != q->sq ||  
        p->sl      != q->sl
      )
		return 0;

	return	identical( p->lft, q->lft ) && identical( p->rgt, q->rgt );
}

static int samedeads( FSM_use *a, FSM_use *b )
{	
   FSM_use *p, *q;

	for ( p = a, q = b; p && q; p = p->nxt, q = q->nxt )
		if (  p->var != q->var	||  
            p->special != q->special )
			return 0;

	return (!p && !q);
}

static Element *findnext( Element *f )
{	
   Element *g;

	if ( f->n->ntyp == GOTO )
	{	
      g = get_lab( f->n, 1 );
		return huntele( g, f->status, -1 );
	}

	return f->nxt;
}

static Element *advance( Element *e, int stopat )
{	
   Element *f = e;

	if ( stopat )
	   while ( f && f->seqno != stopat )
	   {	
         f = findnext( f );
		   switch ( f->n->ntyp ) 
         {
		   case GOTO:
		   case '.':
		   case PRINT:
			   break;

		   default:
			   return f;
		   }
	   }
	return (Element *) 0;
}

static int equiv_merges( Element *a, Element *b )
{	
   Element *f, *g;
	int stopat_a, stopat_b;

	if ( a->merge_start )
		stopat_a = a->merge_start;
	else
		stopat_a = a->merge;

	if ( b->merge_start )
		stopat_b = b->merge_start;
	else
		stopat_b = b->merge;

	if ( !stopat_a && !stopat_b )
		return 1;

	for (;;)
	{
		f = advance( a, stopat_a );
		g = advance( b, stopat_b );
		if ( !f && !g )
			return 1;

		if ( f && g )
			return identical( f->n, g->n );
		else
			return 0;
	}
	return 1;
}


/* <AR> without changes 
   Get existing CaseCache for Element *e (see case_cache_init(...))
*/
static CaseCache * prev_case( Element *e, int owner )
{	
   int j; 
   CaseCache *nc;

	switch ( e->n->ntyp ) 
   {
	case 'r':	
      j = 0; break;
	case 's':	
      j = 1; break;
	case 'c':	
      j = 2; break;
	case ASGN:	
      j = 3; break;
	case ASSERT:	
      j = 4; break;
	default:	
      j = 5; break;
	}

	for ( nc = casing[j]; nc; nc = nc->nxt )
		if ( identical( nc->n, e->n ) &&
		     samedeads( nc->u, e->dead )	&&  
           equiv_merges( nc->e, e ) &&  
           (nc->owner == owner)
         )
			return nc;

	return (CaseCache *) 0;
}

/* <AR> without changes
   Initialize new CaseCache for Element *e (see case_cache_init(...))
*/
static void new_case( Element *e, int m, int b, int owner )
{	
   int j; CaseCache *nc;

	switch (e->n->ntyp) 
   {
	case 'r':	
      j = 0; break;
	case 's':	
      j = 1; break;
	case 'c':	
      j = 2; break;
	case ASGN:	
      j = 3; break;
	case ASSERT:	
      j = 4; break;
	default:	
      j = 5; break;
	}
	nc = (CaseCache *) emalloc(sizeof(CaseCache));
	nc->m = m;
	nc->b = b;
	nc->owner = owner;
	nc->e = e;
	nc->n = e->n;
	nc->u = e->dead;
	nc->nxt = casing[j];
	casing[j] = nc;
}
/******************************************************************/
/* <AR> End CaseCache routines                                    */ 
/******************************************************************/

static void lab_transfer( Element *to, Element *from )
{	
   Symbol *ns, *s = has_lab( from, (1|2|4) );
	Symbol *oc;
	int ltp, usedit=0;

	if ( !s ) 
      return;

	/* from could have all three labels -- rename
	 * to prevent jumps to the transfered copies
	 */
	oc = context;	/* remember */
	for ( ltp = 1; ltp < 8; ltp *= 2 )	/* 1, 2, and 4 */
		if ( s = has_lab( from, ltp ) ) 
		{	
         ns = (Symbol *) emalloc( sizeof(Symbol) );
			ns->name = (char *) emalloc( strlen(s->name) + 4 );
			sprintf( ns->name, "%s%d", s->name, modifier );

			context = s->context;
			set_lab( ns, to );
			usedit++;
		}
	context = oc;	/* restore */

	if ( usedit )
	{	
      if ( modifier++ > 990 )
			fatal( "modifier overflow error", (char *) 0 );
	}
}

static int calc_case_cache_init( Element *e, int a )
{
  int bupcase = 0, casenr = uniq, fromcache = 0;
	CaseCache *Cached = (CaseCache *) 0;
	Element *f, *g;
	int j, mark, target;
  FSM_use *u;
  int nCnT = 0;
	extern int ccache;
  /* <AR> 'didcase' flag is declared as local*/
  int didcase = 0;

	mark = (e->status & (ATOM | L_ATOM)); /* could lose atomicity in a merge chain */

	if ( e->merge_mark > 0 ||
	      (merger && e->merge_in == 0))
	{	/* state nominally unreachable (part of merge chains) */

      if (  e->n->ntyp != '.' &&
		      e->n->ntyp != GOTO )
      {	
        add_to_trans_table( e->seqno, 0, 0, 0, 0, 0 );
/*			fprintf( tc, "\tadd_transition( t, nr, t_len, %d, \"", e->seqno );
			comment( tc, e->n, e->seqno );
			fprintf( tc, "\");\n");
*/
      } 
      else
      {	
	      if (e->merge_start)
		      a = e->merge_start;
	      else if (e->merge)
		      a = e->merge;
        
        add_to_trans_table( e->seqno, mark, a, casenr, 0, (e->status & I_GLOB)? 1: has_global( e->n ) );
/*	      fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, %d, %d, %d, \"", e->seqno, mark, a, casenr, bupcase );*/

	      return casenr;
      }

		return -1;
	}

	/* <AR> fprintf(tt, "\ttrans[%d][%d]\t= ", Pid, e->seqno); */

   if ( ccache &&
	     Pid != claimnr &&
	     Pid != eventmapnr &&
	     (Cached = prev_case( e, Pid ))/* <AR> get casing[j] CaseCache that is filled by new_case below in the function*/ )
   {	
      bupcase = Cached->b;
      casenr  = Cached->m;
      fromcache = 1;

		/*goto gotit;
*/
   }
   else
   {
	   uniq++;
	   
	   nCnT = 0;
	   
      didcase = 0;

	   /*doforward(tm, e);*/
	   if ( deadvar )
	      for (u = e->dead; u; u = u->nxt)
	      {	
		      switch (u->special) 
            {
		      case 2:		/* dead after write -- lval already bupped */
			      if ( (e->n->ntyp == ASGN && 
                     e->n->rgt->ntyp == CONST && 
                     e->n->rgt->val == 0) ||
                     e->n->ntyp != 'r')	/* could be recv or asgn */
			         break;
			      			         
			      /* else fall through */
		      case 1:		/* dead after read -- add asgn of rval -- needs bup */
			      nCnT++;		/* ... this step added bups */
			      break;
	         }	
         }

      if ( any_undo( e->n ) || nCnT != 0 )
         didcase ++;

	   if (e->merge_start)
		   target = e->merge_start;
	   else
		   target = e->merge;

	   if ( target )
	   {	
         f = e;

         do
         {
   	      if ( f->n->ntyp == GOTO )
		      {	
               g = get_lab( f->n, 1 );
			      if ( g->seqno == target )
				      f = g;
			      else
				      f = huntele( g, f->status, target );
		      } 
            else
			      f = f->nxt;

		      if ( f && f->seqno != target )
		      {
			      
			        nCnT = 0;
               /* <AR> it needs to be verified more carefully */
			        lab_transfer(e, f);
               /* <AR> we need the 'mark'*/
               if ( ((f->status & (ATOM | L_ATOM)) != 0) )
			         mark = f->status & (ATOM | L_ATOM); /* last step wins */
			      /*doforward(tm, f);*/
               if ( deadvar && !didcase )
               {
                  for (u = f->dead; u; u = u->nxt)
	               {	
		               switch (u->special) 
                     {
		               case 2:		/* dead after write -- lval already bupped */
			               if ( (f->n->ntyp == ASGN && 
                              f->n->rgt->ntyp == CONST && 
                              f->n->rgt->val == 0) || /* could be recv or asgn */
                              f->n->ntyp != 'r')	
			                  break;
			      			                  
			               /* else fall through */
		               case 1:		/* dead after read -- add asgn of rval -- needs bup */
			               nCnT++;		/* this step added bups */
			               break;
	                  }	
                  }
                  /* <AR> dobackward(f, casenr);*/
                  if ( any_undo( f->n ) || nCnT != 0 )
                     didcase ++;
               }

               /* <AR> used above in the function. Need to be restored after init function finished*/
			      if ( f->merge_in == 1 ) 
                  f->merge_mark++;
	         }
         }
         while ( f && f->seqno != target );
      }
	   

	   if ( (e->merge || e->merge_start) && (!didcase) )
	      didcase++;
		
	   if ( didcase )
	      bupcase = casenr;

	   if ( !e->merge && !e->merge_start ) /* fill casing[j] (CaseCache structure) that used*/
		   new_case( e, casenr, bupcase, Pid );
   }

/*gotit:*/
	j = a;
	if (e->merge_start)
		j = e->merge_start;
	else if (e->merge)
		j = e->merge;

  add_to_trans_table( e->seqno, mark, j, casenr, 0, (e->status & I_GLOB)? 1: has_global( e->n ) );
/*	fprintf( tc, "%sadd_transition( t, nr, t_len, %d, %d, %d, %d, %d, \"", fromcache? "/ c   ": "\t", e->seqno, mark, j, casenr, bupcase );*/

	return (fromcache)?0:casenr;
}

/* modification of case_cache(...) for init transition table*/
/* merger, ccache and deadvar are optimization flag (see main.c)*/
static void calc_sub_init( Element *e, int Tt0, int Tt1 )
{
  Sequence *s = e->n->sl->this;
	Element *g = ZE;
	int a;
  int inherit = (e->status & (ATOM | L_ATOM));

   /* <AR> the function changes e->status*/
	patch_atomic( s );

	putskip( s->frst->seqno );
	g = huntstart( s->frst );
	a = g->seqno;

/*	if ( (e->n->ntyp == ATOMIC ||
	      e->n->ntyp == D_STEP) &&
	      scan_seq_init( s ) )
*/
      /* <AR> the function changes e->status*/
		mark_seq( s );

	s->last->nxt = e->nxt;

	typ_seq(s);	/* sets TPE */

	if (e->n->ntyp == D_STEP)
	{	
      uniq++;
	
		  if ( e->nxt )
			  a = huntele( e->nxt, e->status, -1 )->seqno;
		  else
			  a = 0;
      
      add_to_trans_table( e->seqno, D_ATOM | inherit, a, uniq-1, 0, (s->frst->status & I_GLOB)? 1: 0 );      
/*      fprintf( tc, "/*->  add_transition( t, nr, t_len, %d, %d, %d, %d, %d , \"", e->seqno, D_ATOM | inherit, a, uniq-1, uniq-1 );
		comment( tc, e->n, e->seqno );
		fprintf( tc, "\", %d, ", (s->frst->status & I_GLOB)? 1: 0 );
		fprintf( tc, "%d, %d);\n", TPE[0], TPE[1] );
*/
		calc_escp_init( e );
	} 
   else
	{	/* ATOMIC or NON_ATOMIC */
    
      if ( (e->status & CHECK2) ||
		     (g->status & CHECK2))
			  s->frst->status |= I_GLOB;
    
      if ( e->n->ntyp == NON_ATOMIC )
      {
         add_to_trans_table( e->seqno, inherit, 0, 0, 1, (s->frst->status & I_GLOB)? 1: 0 );
/*         fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, 0, 0, 0, \"",	e->seqno, 0 );

		   comment( tc, e->n, e->seqno );
*/
      }

		add_to_trans_table( e->seqno, inherit, a, 0, 1, (s->frst->status & I_GLOB)? 1: 0 );
    
/*		fprintf( tc, "\tadd_transition( t, nr, t_len, %d, %d, %d, 0, 0, \"", e->seqno, 0, a );
      comment( tc, e->n, e->seqno );
		fprintf( tc, "\", %d, ", (s->frst->status & I_GLOB)? 1: 0);
*/
		if (e->n->ntyp == NON_ATOMIC)
		{	
/*         fprintf( tc, "%d, %d);", Tt0, Tt1 );
			blurb( tc, e );
*/
			calc_seq_init( s, Tt0, Tt1 );
		} 
      else
		{	
/*         fprintf( tc, "%d, %d);", TPE[0], TPE[1] );
			blurb( tc, e);
*/			calc_seq_init( s, TPE[0], TPE[1] );
		}
	}
}

static void calc_escp_init( Element *e )
{
	SeqList *x;

	if ( e->esc && e->n->ntyp != GOTO && e->n->ntyp != '.' )
	{	
		for ( x = e->esc; x; x = x->nxt )
		{	
			 calc_seq_init( x->this, 2, 0 );	/* args?? */
		}
	}
}

/* <AR> without changes */
static Element * find_target(Element *e)
{	
   Element *f;

	if ( !e ) return e;

	if ( t_cyc++ > 32)
	{	
      fatal("cycle of goto jumps", (char *) 0);
	}
	switch ( e->n->ntyp ) 
   {
	case  GOTO:
		f = get_lab( e->n,1 );
		cross_dsteps( e->n, f->n );
		f = find_target( f );
		break;
	case BREAK:
		if ( e->nxt )
		f = find_target( huntele(e->nxt, e->status, -1) );
		/* else fall through */
	default:
		f = e;
		break;
	}
	return f;
}

/* <AR> without changes */
Element * target(Element *e)
{
	if (!e) return e;
	lineno = e->n->ln;
	Fname  = e->n->fn;
	t_cyc = 0;
	return find_target(e);
}

static int scan_seq_init( Sequence *s )
{	
   Element *f, *g;
	SeqList *h;

	for ( f = s->frst; 1; f = f->nxt )
	{	
      if ( (f->status & CHECK2) || has_global(f->n) )
			return 1;

		if ( f->n->ntyp == GOTO )	/* may reach other atomic */
		{	
         g = target( f );
			if ( g	&& !(f->status & L_ATOM) && !(g->status & (ATOM | L_ATOM)) )
			{	
            fprintf( tc, "	/* goto mark-down, ");
				fprintf( tc, "line %d - %d */\n", f->n->ln, (g->n)? g->n->ln: 0 );

				return 1; /* assume worst case */
		   }	
      }

		for ( h = f->sub; h; h = h->nxt )
			if ( scan_seq_init( h->this ) )
				return 1;

		if ( f == s->last )
			break;
	}

	return 0;
}

static void patch_atomic( Sequence *s )	/* catch goto's that break the chain */
{	
   Element *f, *g;
	SeqList *h;

	for ( f = s->frst; ; f = f->nxt )
	{	
      if ( f->n && f->n->ntyp == GOTO )
      {	
         g = get_lab( f->n, 1 );
         cross_dsteps( f->n, g->n );
         if ( (f->status & (ATOM | L_ATOM) )	&& 
               !(g->status & (ATOM | L_ATOM)) )
         {	
            f->status &= ~ATOM;
            f->status |= L_ATOM;
         }
/* new - bridges atomics */
         if ( (f->status & L_ATOM) &&  
             (g->status & (ATOM | L_ATOM)) )
         {	
            f->status &= ~L_ATOM;
            f->status |= ATOM;
         }
/* end */
      } 
      else
         for (h = f->sub; h; h = h->nxt)
            patch_atomic(h->this);

      if ( f == s->extent )
         break;
   }
}

/* <AR> without changes */
static void mark_seq( Sequence *s )
{	
   Element *f;
	SeqList *h;

	for (f = s->frst; ; f = f->nxt)
	{	
      f->status |= I_GLOB;
		for (h = f->sub; h; h = h->nxt)
			mark_seq( h->this );

		if (f == s->last)
			return;
	}
}

/* <AR> without changes */
static void nested_unless( Element *e, Element *g )
{	
   struct SeqList *y = e->esc, *z = g->esc;

	for ( ; y && z; y = y->nxt, z = z->nxt)
		if ( z->this != y->this )
			break;

	if ( !y && !z )
		return;

	if ( g->n->ntyp != GOTO &&
	     g->n->ntyp != '.'  &&
	     e->sub->nxt )
	{	
      printf( "error: (%s:%d) saw 'unless' on a guard:\n", (e->n)?e->n->fn->name:"-",
			                              (e->n)? e->n->ln: 0 );
		printf( "=====>instead of\n" );
		printf( "	do (or if)\n" );
		printf( "	:: ...\n" );
		printf( "	:: stmnt1 unless stmnt2\n" );
		printf( "	od (of fi)\n" );
		printf( "=====>use\n" );
		printf( "	do (or if)\n" );
		printf( "	:: ...\n" );
		printf( "	:: stmnt1\n" );
		printf( "	od (or fi) unless stmnt2\n" );
		printf( "=====>or rewrite\n" );
	}
}

/* <AR> without changes */
static int glob_args( Lextok *n )
{	
   int result = 0;
	Lextok *v;

	for ( v = n->rgt; v; v = v->rgt )
	{	
      if ( v->lft->ntyp == CONST )
			continue;

		if ( v->lft->ntyp == EVAL )
			result += has_global( v->lft->lft );
		else
			result += has_global( v->lft );
	}

	return result;
}

/* <AR> without changes */
int has_global( Lextok *n )
{	
   Lextok *v; 
   extern int runsafe;

	if ( !n ) 
      return 0;

	if ( AllGlobal ) 
      return 1;	/* global provided clause */

	switch ( n->ntyp ) 
   {
	case '.': case BREAK: case GOTO: case CONST:
		return 0;

	case ELSE: 
      return n->val; /* true if combined with chan refs */

	case NAME: 
      return (n->sym->context || (n->sym->hidden & 64))? 0: 1;

	case 's': 
      return glob_args( n ) !=0 || ((n->sym->xu & (XS | XX)) != XS);

	case 'r': 
      return glob_args( n ) != 0 || ((n->sym->xu & (XR|XX)) != XR);

	case 'R': 
      return glob_args( n ) != 0 || (((n->sym->xu) & (XR | XS | XX)) != (XR | XS));

	case NEMPTY: 
      return ((n->sym->xu & (XR | XX)) != XR);

	case NFULL: 
      return ((n->sym->xu & (XS | XX)) != XS);

	case FULL: 
      return ((n->sym->xu & (XR | XX)) != XR);

	case EMPTY: 
      return ((n->sym->xu & (XS | XX)) != XS);

	case LEN:   
      return (((n->sym->xu) & (XR | XS | XX)) != (XR | XS));

	case RUN: 
      return 1 - runsafe;

	case ENABLED: case PC_VAL: case NONPROGRESS:
	case 'p': 
   case 'q':
	case TIMEOUT:
		return 1;

	/* 	@ was 1 (global) since 2.8.5
		in 3.0 it is considered local and
		conditionally safe, provided:
			II is the youngest process
			and nrprocs < MAXPROCS
	*/
	case '@': 
      return 0;

	case '!': case UMIN: case '~': case ASSERT:
		return has_global( n->lft );

	case '/': case '*': case '-': case '+':
	case '%': case LT:  case GT: case '&': case '^':
	case '|': case LE:  case GE:  case NE: case '?':
	case EQ:  case OR:  case AND: case LSHIFT:
	case RSHIFT: case 'c': case ASGN:
		return has_global( n->lft ) || has_global( n->rgt );

	case PRINT:
		for (v = n->lft; v; v = v->rgt)
			if ( has_global( v->lft ) ) 
            return 1;

		return 0;
	}
	return 0;
}

/*******************************************************************/
/* <AR> Start TPE routines (need to be verified )
/*******************************************************************/
static void addTpe( int x )
{	
   int i;

	if ( x <= 2 ) 
      return;

	for ( i = 0; i < T_sum; i++ )
		if ( TPE[i] == x )
			return;

	TPE[ (T_sum++) % 2 ] = x;
}

static void cnt_seq( Sequence *s )
{	
   Element *f;
	SeqList *h;

	if ( s )
	   for ( f = s->frst; ; f = f->nxt )
	   {	
         Tpe( f->n );	/* sets EPT */
		   addTpe( EPT[0] );
		   addTpe( EPT[1] );

		   for ( h = f->sub; h; h = h->nxt )
			   cnt_seq( h->this );

		   if ( f == s->last )
			   break;
	   }
}

static void typ_seq( Sequence *s )
{
	T_sum = 0;
	TPE[0] = 2; 
   TPE[1] = 0;
	cnt_seq( s );
	if ( T_sum > 2 )		/* more than one type */
	{	
      TPE[0] = 5 * DELTA;	/* non-mixing */
		TPE[1] = 0;
	}
}

static int hidden( Lextok *n )
{
	if ( n )
	   switch ( n->ntyp ) 
      {
	   case  FULL: case  EMPTY:
	   case NFULL: case NEMPTY: case TIMEOUT:
		   Nn[ (T_mus++) % 2 ] = n;
		   break;

	   case '!': case UMIN: case '~': case ASSERT: case 'c':
		   (void) hidden( n->lft );
		   break;

	   case '/': case '*': case '-': case '+':
	   case '%': case LT:  case GT: case '&': case '^':
	   case '|': case LE:  case GE:  case NE: case '?':
	   case EQ:  case OR:  case AND: case LSHIFT: case RSHIFT:
		   (void) hidden( n->lft );
		   (void) hidden( n->rgt );
		   break;
	   }

	return T_mus;
}

static int getNid( Lextok *n )
{
	if ( n->sym->type == STRUCT &&  
        n->rgt && n->rgt->lft )
		return getNid( n->rgt->lft );

	if ( n->sym->Nid == 0 )
	{	
      fatal( "bad channel name '%s'", (n->sym)? n->sym->name: "no name" );
	}

	return n->sym->Nid;
}

static int valTpe( Lextok *n )
{	
   int res = 2;
	/*
	2 = local
	2+1	    .. 2+1*DELTA = nfull,  's'	- require q_full==false
	2+1+1*DELTA .. 2+2*DELTA = nempty, 'r'	- require q_len!=0
	2+1+2*DELTA .. 2+3*DELTA = empty	- require q_len==0
	2+1+3*DELTA .. 2+4*DELTA = full		- require q_full==true
	5*DELTA = non-mixing (i.e., always makes the selection global)
	6*DELTA = timeout (conditionally safe)
	7*DELTA = @, process deletion (conditionally safe)
	 */
	switch ( n->ntyp ) 
   { /* a series of fall-thru cases: */
	case   FULL:	
      res += DELTA;		/* add 3*DELTA + chan nr */
	case  EMPTY:	
      res += DELTA;		/* add 2*DELTA + chan nr */
	case    'r':
	case NEMPTY:	
      res += DELTA;		/* add 1*DELTA + chan nr */
	case    's':
	case  NFULL:	
      res += getNid(n->lft);	/* add channel nr */
		break;

	case TIMEOUT:	
      res = 6 * DELTA; 
      break;
	case '@':	
      res = 7 * DELTA; 
      break;

	default:	
      break;
	}
	return res;
}

static void Tpe( Lextok *n )	/* mixing in selections */
{
	EPT[0] = 2; 
   EPT[1] = 0;

	if ( !n ) 
      return;

	T_mus = 0;
	Nn[0] = Nn[1] = ZN;

	if ( n->ntyp == 'c' )
	{	
      if ( hidden( n->lft ) > 2 )
		{	
         EPT[0] = 5 * DELTA; /* non-mixing */
			EPT[1] = 0;
			return;
		}
	} 
   else
		Nn[0] = n;

	if ( Nn[0] ) 
      EPT[0] = valTpe( Nn[0] );

	if ( Nn[1] ) 
      EPT[1] = valTpe( Nn[1] );
}
/*******************************************************************/
/* <AR> End TPE routines (need to be verified )
/*******************************************************************/



/**********************************************************************
********************  RL code  ****************************************
***********************************************************************/

static void gen_tranmove_code( ProcList *p, FILE *tc )
{
   char *ClassName = get_autom_class_name( p );
	
   fprintf( tc, "\nbool %s::new_state( State *state, int trans_id )\n{", ClassName );
	 fprintf( tc, "\n		 /* PROC %s */\n", p->n->name);
   fprintf( tc, "\n\tif (m_sst_table[trans_id] == 0) return false;");
   
   fprintf( tc, "\n\tQueue *q;");      
   fprintf( tc, "\n\tQueueEl *el;");      
   fprintf( tc, "\n\tint XX;");      
   fprintf( tc, "\n\tCAutomBase *atm;");

	 fprintf( tc, "\n\tint loc_trans_id = trans_id;");

   fprintf( tc, "\n\tbool skip;"); 
   fprintf( tc, "\n\tbool bool_tmp;");
   fprintf( tc, "\n\tbool stop_passed = false;");
   fprintf( tc, "\n\tbool next_trans = false;\n");

   fprintf( tc, "\n\tif (is_test_enabled() && (m_sst_table[loc_trans_id]->atom & CAutomBase::D_ATOM)) return true;\n");  
/*   fprintf( tc, "\n\tGlobalBoolIndStruct globals_bool;");   
  
   fprintf( tc, "\n\tSLocalBoolIndStruct locals_bool;" );*/

   fprintf( tc, "\n\tdo{");
/*   if ( doglobal( tc, "", BOOLCOUNT ) )
      fprintf( tc, "\n\tstate->set_global_bool_vars(globals_bool, state->bit_arr);");
   if ( dolocal( tc, "", BOOLCOUNT, "" ) )
      fprintf( tc, "\n\tset_local_bool_vars(locals_bool, autom_bit_arr);");*/
   
   
   fprintf( tc, "\n\t\tskip = false;"); 
   fprintf( tc, "\n\t\tnext_trans = false;");  

   fprintf( tc, "\n\n\tswitch (m_sst_table[loc_trans_id]->forw){\n");

  
	 fprintf(tc, "\n\tdefault: exit(0);");  /*RL Must have more inteligent handling of errors*/
	 fprintf(tc, "\n\tcase 0:	/* if without executable clauses */");
   fprintf(tc, "\n\t\tset_curr_state(m_sst_table[loc_trans_id]->st);");
   fprintf(tc, "\n\t\tloc_trans_id = trans_id = get_first_trans_id(get_curr_state());");
   fprintf(tc, "\n\t\tif (m_sst_table[loc_trans_id]->atom & ND_ATOM) { set_first_skip_trans(true); set_inside_atomic(true); }"); 
   fprintf(tc, "\n\t\tif (!(m_sst_table[loc_trans_id]->atom & ND_ATOM) && (is_test_enabled()))");
   fprintf(tc, "\n\t\t\tskip = true;");
	 fprintf(tc, "\n\t\tcontinue;");

   fprintf(tc, "\n\tcase 1: /* generic 'goto' or 'skip' */");
	 if (separate != 2)
		fprintf(tc, "\n\t\tif (state->get_boq() != -1) return false;");
	 fprintf(tc, "\n\t\tbreak;\n");
	 
   fprintf(tc, "\n\tcase 2: /* generic 'else' */\n");
   fprintf(tc, "\n\t\tif ((m_sst_table[loc_trans_id]->atom & CAutomBase::D_ATOM))");
   fprintf(tc, "\n\t\t {if (state->get_boq() != -1) return false;}\n\t\telse {");
   
   fprintf(tc, "\n\t\t\tset_else_passed(true);");

	 if (separate == 2)
		 fprintf(tc, "\n\t\t\tif (is_moved()) return false");
	 else
   {	
		 fprintf(tc, "\n\t\t\tif (state->get_boq() != -1) return false;");
		 fprintf(tc, "\n\t\t\tif (is_moved()) return false;");
   }
   fprintf(tc, "\n\t\t}\n");
	 fprintf(tc, "\n\t\tbreak;\n");

   putproc( tc, p ); 

  fprintf( tc, "\n\t\t}\n");
   
  fprintf(tc, "\n\tif (is_test_enabled()) break;");
  
  fprintf(tc, "\n\tif ( next_trans )");
  fprintf(tc, "\n\t\tloc_trans_id = m_sst_table[loc_trans_id]->nxt->t_id;");
  fprintf(tc, "\n\telse");
  fprintf(tc, "\n\t{");
  fprintf(tc, "\n\t\tset_curr_state(m_sst_table[loc_trans_id]->st);");
  fprintf(tc, "\n\t\tloc_trans_id = get_first_trans_id(get_curr_state());");
  fprintf(tc, "\n\t}");

/*AR  fprintf(tc, "\n\tif (!is_test_enabled()) { set_curr_state(m_sst_table[loc_trans_id]->st); ");*/
  
/*  if ( doglobal(tc, "", BOOLCOUNT) )
    fprintf(tc, "state->get_global_bool_vars(globals_bool, state->bit_arr); " );
  if ( dolocal(tc, "", BOOLCOUNT, "") )
    fprintf(tc, "get_local_bool_vars(locals_bool, autom_bit_arr);");*/
/* AR  fprintf(tc, "}\n\telse break;");    
  fprintf(tc, "\n\tloc_trans_id = get_first_trans_id(get_curr_state());");
*/
  fprintf( tc, "\n\t}\n");
  fprintf(tc, "\n\twhile ((m_sst_table[loc_trans_id] != 0 && ((m_sst_table[loc_trans_id]->atom & CAutomBase::ATOM) && !stop_passed)) || skip);");

  fprintf(tc, "\n\tif ((m_sst_table[loc_trans_id] != 0 && (m_sst_table[loc_trans_id]->atom & CAutomBase::ND_ATOM))) \n\t\tset_inside_atomic(true); \n\telse \n\t\tset_inside_atomic(false);");

  fprintf(tc, "\n\treturn true;");
  fprintf( tc, "\n}\n");
}

/*******************************************************************/
/* <RL> Put proc transitings to the sources
*******************************************************************/
static void putproc(FILE *tc, ProcList *p)
{	
  Pid = p->tn;
	Det = p->det;

	if (Pid != claimnr
	&&  separate == 2)
		return;

	AllGlobal = (p->prov)?1:0;	/* process has provided clause */

  put_seq(tc, p->s, 2, 0);
	
/*  dumpsrc(p->s->maxel, Pid);*/
}

/*******************************************************************/
/* <RL> Put sequence list to the sources
*******************************************************************/
static void put_seq(FILE *tc, Sequence *s, int Tt0, int Tt1)
{	
  SeqList *h;
	Element *e, *g;
	int a, deadlink;

	for (e = s->frst; e; e = e->nxt)
	{	
    if (e->status & DONE)
			goto checklast;
		e->status |= DONE;

/*		if (e->n->ln)
			putsrc(e);*/

		if (e->n->ntyp == UNLESS)
		{	
      put_seq(tc, e->sub->this, Tt0, Tt1);
		} 
    else if (e->sub)
		{	
			if (e->status & CHECK2)
				e->status |= I_GLOB;

			for (h = e->sub; h; h = h->nxt)
			{	
/*        putskip(h->this->frst->seqno);*/
				g = huntstart(h->this->frst);
				
        if (g->esc)
					nested_unless(e, g);
				
        a = g->seqno;

				if (g->n->ntyp == 'c'
				    &&  g->n->lft->ntyp == CONST
				    &&  g->n->lft->val == 0		/* 0 or false */
				    && !g->esc)
				{	
					deadlink = 1;
					if (verbose&32)
  					printf("spin: line %3d  %s, Warning: condition is always false\n",
						g->n->ln, g->n->fn?g->n->fn->name:"");
				} 
        else
					deadlink = 0;

				if (g->status&CHECK2)
					h->this->frst->status |= I_GLOB;
			}

      for (h = e->sub; h; h = h->nxt)
				put_seq(tc, h->this, Tt0, Tt1);

		} 
    else
		{	
      if (e->n->ntyp == ATOMIC
			    ||  e->n->ntyp == D_STEP
			    ||  e->n->ntyp == NON_ATOMIC)
				put_sub(tc, e, Tt0, Tt1);
			else 
				put_el(tc, e, Tt0, Tt1);
		}
checklast:	if (e == s->last)
			break;
	}
}

static void
put_sub(FILE *tc, Element *e, int Tt0, int Tt1)
{	Sequence *s = e->n->sl->this;
	Element *g = ZE;
	int a;

	patch_atomic(s);
	putskip(s->frst->seqno);
	g = huntstart(s->frst);
	a = g->seqno;

	if ((e->n->ntyp == ATOMIC
	||  e->n->ntyp == D_STEP)
	&&  scan_seq(s))
		mark_seq(s);
	s->last->nxt = e->nxt;

	typ_seq(s);	/* sets TPE */

	if (e->n->ntyp == D_STEP)
	{	
    int inherit = (e->status&(ATOM|L_ATOM));
		fprintf(tc, "\tcase %d: ", uniq++);
		fprintf(tc, "/* STATE %d - line %d %s - [",
			e->seqno, e->n->ln, e->n->fn->name);
		comment(tc, e->n, 0);
		fprintf(tc, "] */\n\t\t");

		if (s->last->n->ntyp == BREAK)
			OkBreak = target(huntele(s->last->nxt,
				s->last->status, -1))->Seqno;
		else
			OkBreak = -1;

		if (!putcode(tc, s, e->nxt, 0, e->n->ln, e->seqno))
		{	
/*      fprintf(tc, "\t\tm = %d", getweight(s->frst->n));*/
			
/*      if (m_loss && s->frst->n->ntyp == 's')
				fprintf(tc, "+delta_m; delta_m = 0");
*/
			fprintf(tc, "\n\t\tbreak;\n");
		}
	
		if (e->nxt)
			a = huntele(e->nxt, e->status, -1)->seqno;
		else
			a = 0;

		tr_map(uniq-1, e);

		put_escp(tc, e);
	} 
  else
	{	/* ATOMIC or NON_ATOMIC */
    if ((e->status&CHECK2)
		    ||(g->status&CHECK2))
			s->frst->status |= I_GLOB;

		if (e->n->ntyp == NON_ATOMIC)
		{	
			put_seq(tc, s, Tt0, Tt1);
		} else
		{	
			put_seq(tc, s, TPE[0], TPE[1]);
		}
	}
}

static void put_el(FILE *tc, Element *e, int Tt0, int Tt1)
{	
  int a, casenr, Global_ref;
	Element *g = ZE;

	if (e->n->ntyp == GOTO)
	{	
    g = get_lab(e->n, 1);
		g = huntele(g, e->status, -1);
		cross_dsteps(e->n, g->n);
		a = g->seqno;
	} 
  else if (e->nxt)
	{	
    g = huntele(e->nxt, e->status, -1);
		a = g->seqno;
	} 
  else
		a = 0;
	
  if (g
	&&  (g->status&CHECK2	/* entering remotely ref'd state */
	||   e->status&CHECK2))	/* leaving  remotely ref'd state */
		e->status |= I_GLOB;

	/* don't remove dead edges in here, to preserve structure of fsm */

	if (e->merge_start || e->merge)
   {
      if ( e->n->ntyp == '.' )
         casenr = 1;
      else
		   goto non_generic;
   }

	/*** avoid duplicate or redundant cases in pan.m ***/
	switch (e->n->ntyp) {
	case ELSE:
		casenr = 2; /* standard else */
/*		putskip(e->seqno);*/
		goto generic_case;
		break;
	case '.':
	case GOTO:
	case BREAK:
/*		putskip(e->seqno); */
		casenr = 1; /* standard goto */
generic_case:	
		break;

#ifndef PRINTF
	case PRINT:
		if (e->n->lft == ZN)
		{	
      casenr = 1;
/*			putskip(e->seqno);*/
			goto generic_case;
		}
		goto non_generic;
#endif
	case 'c':
		if (e->n->lft->ntyp == CONST
		&&  e->n->lft->val == 1)	/* generic skip or true */
		{	
      casenr = 1;
/*			putskip(e->seqno);*/
			goto generic_case;
		}
		goto non_generic;
    
  default:
non_generic:
		casenr = case_cache(tc, e, a);

		if (casenr < 0) return;	/* unreachable state */

		break;
	}
	/* tailend of settr(...); */
	Global_ref = (e->status&I_GLOB)?1:has_global(e->n);
	
  if (Tt0 == 2)
	{	
    Tpe(e->n);	/* sets EPT */
	}

	put_escp(tc, e);
}

static int case_cache(FILE *tc, Element *e, int a)
{	
  int bupcase = 0, casenr = uniq, fromcache = 0;
	CaseCache *Cached = (CaseCache *) 0;
	Element *f, *g;
	int j, nrbups, mark, target;
	extern int ccache;

	mark = (e->status&ATOM); /* could lose atomicity in a merge chain */

	if (e->merge_mark > 0
	  ||  (merger && e->merge_in == 0))
	{	/* state nominally unreachable (part of merge chains) */

		if (!(e->n->ntyp != '.'
		  &&  e->n->ntyp != GOTO))
		{	
			goto gotit; /* pakula's example */
		}

		return -1;
	}


	if (ccache
	  &&  Pid != claimnr
	  &&  Pid != eventmapnr
	  && (Cached = prev_case(e, Pid)))
	{	
    bupcase = Cached->b;
		casenr  = Cached->m;
		fromcache = 1;

		fprintf(tc, "/* STATE %d - line %d %s - [",
			e->seqno, e->n->ln, e->n->fn->name);
		comment(tc, e->n, 0);
		fprintf(tc, "] (%d:%d - %d) same as %d (%d:%d - %d) */\n",
			e->merge_start, e->merge, e->merge_in,
			casenr,
			Cached->e->merge_start, Cached->e->merge, Cached->e->merge_in);

		goto gotit;
	}

	fprintf(tc, "\n\tcase %d: /* STATE %d - line %d %s - [",
		uniq++, e->seqno, e->n->ln, e->n->fn->name);
	comment(tc, e->n, 0);
	nrbups = (e->merge || e->merge_start) ? nrhops(e) : nr_bup(e);
	fprintf(tc, "] (%d:%d:%d - %d) */\n\t\t",
		e->merge_start, e->merge, nrbups, e->merge_in);

	if (nrbups > MAXMERGE-1)
		fatal("merge requires more than 256 bups", (char *)0);

	if (e->n->ntyp != 'r' && Pid != claimnr && Pid != eventmapnr)
		fprintf(tc, "if (state->get_boq() != -1) return false;\n\t\t");

/*	if (multi_needed != 0 || multi_undo != 0)
		fatal("cannot happen, case_cache", (char *) 0);

	if (nrbups > 1)
	{	
    multi_oval = 1;
		multi_needed = nrbups; *//* allocated after edge condition */
/*	} 
  else
		multi_oval = 0;*/

	memset(CnT, 0, sizeof(CnT));
	YZmax = YZcnt = 0;
	/* the src xrefs have the numbers in e->seqno builtin */
/*	fprintf(tc, "reached[%d][%d] = 1;\n\t\t", Pid, e->seqno);*/
	/* pan.t optimizations may change state number in t->st, so add: */
/*	fprintf(tc, "reached[%d][t->st] = 1;\n\t\t", Pid);	*//* true next state */
/*	fprintf(tc, "reached[%d][tt] = 1;\n\t\t", Pid);		*//* true current state */

	doforward(tc, e);

	if (e->merge_start)
		target = e->merge_start;
	else
		target = e->merge;

	if (target)
	{	
    f = e;

more:		if (f->n->ntyp == GOTO)
		{	g = get_lab(f->n, 1);
			if (g->seqno == target)
				f = g;
			else
				f = huntele(g, f->status, target);
		} else
			f = f->nxt;

		if (f && f->seqno != target)
		{
			fprintf(tc, "/* merge: ");
			comment(tc, f->n, 0);
			fprintf(tc,  "(%d, %d, %d) */\n\t\t", f->merge, f->seqno, target);
/*			fprintf(tc, "reached[%d][%d] = 1;\n\t\t", Pid, f->seqno);
			fprintf(tc, "reached[%d][t->st] = 1;\n\t\t", Pid);
			fprintf(tc, "reached[%d][tt] = 1;\n\t\t", Pid);
*/
			YZcnt++;
			lab_transfer(e, f);
			mark = f->status&(ATOM|L_ATOM); /* last step wins */
			doforward(tc, f);
			if (f->merge_in == 1) f->merge_mark++;

			goto more;
	}	}
	
/*  fprintf(tc, "m = %d", getweight(e->n));
	if (m_loss && e->n->ntyp == 's') fprintf(tc, "+delta_m; delta_m = 0");*/
	fprintf(tc, "\n\n\t\tbreak; /* %d */\n", YZcnt);

/*	multi_needed = 0;*/
	didcase = 0;

/*	if (target)
		lastfirst(target, e, casenr); *//* mergesteps only */

/*	dobackward(e, casenr);		*/	/* the original step */

/*	fprintf(tb, ";\n\t\t");

	if (e->merge || e->merge_start)
	{	
    if (!didcase)
		{	
      fprintf(tb, "\n\tcase %d: ", casenr);
			fprintf(tb, " /* STATE %d * ", e->seqno);
			didcase++;
		} 
    else
			fprintf(tb, ";");
	} else
		fprintf(tb, ";");
	fprintf(tb, "\n\t\t");


	if (multi_undo)
	{	fprintf(tb, "ungrab_ints(trpt->bup.ovals, %d);\n\t\t",
			multi_undo);
		multi_undo = 0;
	}
	if (didcase)
	{	fprintf(tb, "goto R999;\n");
		bupcase = casenr;
	}
*/
	
  if (!e->merge && !e->merge_start)
		new_case(e, casenr, bupcase, Pid);

gotit:
	j = a;
	
  if (e->merge_start)
		j = e->merge_start;
	else if (e->merge)
		j = e->merge;

	return (fromcache)?0:casenr;
}


static void doforward(FILE *tc, Element *e)
{	
  FSM_use *u;

	putstmnt(tc, e->n, e->seqno);

/*	if (e->n->ntyp != ELSE && Det)
	{	
    fprintf(tc, ";\n\t\tif (trpt->o_pm&1)\n\t\t");
		fprintf(tc, "\tuerror(\"non-determinism in D_proctype\")");
	}
	
  if (deadvar)
	for (u = e->dead; u; u = u->nxt)
	{	fprintf(tc, ";\n\t\t/* dead %d: %s *  ",
			u->special, u->var->name);

		switch (u->special) {*/
//		case 2:		/* dead after write -- lval already bupped */
//			if (e->n->ntyp == ASGN)	/* could be recv or asgn */
//			{	if (e->n->rgt->ntyp == CONST
//				&&  e->n->rgt->val == 0)
//					continue;	/* already set to 0 */
/*			}
			if (e->n->ntyp != 'r')
			{	XZ.sym = u->var;
				putname(tc, "", &XZ, 0, " = 0");
				break;
			} *//* else fall through */
//		case 1:		/* dead after read -- add asgn of rval -- needs bup */
//			YZ[YZmax].sym = u->var;	/* store for pan.b */
//			CnT[YZcnt]++;		/* this step added bups */
/*			if (multi_oval)
			{	check_needed();
				fprintf(tc, "(trpt+1)->bup.ovals[%d] = ",
					multi_oval-1);
				multi_oval++;
			} else
				fprintf(tc, "(trpt+1)->bup.oval = ");
			putname(tc, "", &YZ[YZmax], 0, "");
			putname(tc, ";\n\t\t", &YZ[YZmax], 0, " = 0");
			YZmax++;
			break;
	}	}
	fprintf(tc, ";\n\t\t");*/
}

static void
Bailout(FILE *fd, char *str)
{
	if (!GenCode)
  {
    fprintf(fd, "if ((m_sst_table[loc_trans_id]->atom & CAutomBase::D_ATOM))");
    fprintf(fd, "\n\t\t\t{ next_trans = true; break;}");
    fprintf(fd, "\n\t\t\telse\n\t\t\t\t");
		fprintf(fd, "return false%s", str);
    
/*RL!!(d_step related code)!! 	else if (IsGuard)
		fprintf(fd, "%s%s", NextLab[Level], str);*/
  }
	else
		fprintf(fd, "Tracer::put_error(\"block in step seq\")%s", str);
}


const char  FIND_MESG[] =
"\n\t\tint msg_ind = -1;"
"\n\t\tfor (int i = 0; i < q->get_lenght(); i++){"
"\n\t\t\tq->look_message((void**)&el);"      
"\n\t\t\tif (el == el_curr)"
"\n\t\t\t\t{ msg_ind = i; break; }"
"\n\t\t}"
"\n\t\tif (msg_ind == -1)"
"\n\t\t\t";

#define cat0(x)   	putstmnt(fd,now->lft,m); fprintf(fd, x); \
			putstmnt(fd,now->rgt,m)
#define cat1(x)		fprintf(fd,"("); cat0(x); fprintf(fd,")")
#define cat2(x,y)  	fprintf(fd,x); putstmnt(fd,y,m)
#define cat3(x,y,z)	fprintf(fd,x); putstmnt(fd,y,m); fprintf(fd,z)

int   c_exist = 0;  /* if it is > 0 then "if !(..)" should be put to the sources */
int   d_step = 0;   /* if it is > 0 then next statement should not be tested for true or false */ 
int   if_test_RUN = 1;  /* if 1 we should test if RUN is enabled */

void
putstmnt(FILE *fd, Lextok *now, int m)
{	Lextok *v;
	int i, j;
  int count;
  char  str[255];
  ProcList *p;
  int   is_bool;

	if (!now) { fprintf(fd, "0"); return; }
	lineno = now->ln;
	Fname  = now->fn;

/*  if (now->ntyp != 's' && now->ntyp != 'r' && now->ntyp != 'R' && c_exist == 1)
  {
		fprintf(fd, "if (!(");
  }*/
  if (now->ntyp != RUN)
    if_test_RUN = 0;

  switch (now->ntyp) {
	case CONST:	fprintf(fd, "%d", now->val); break;
	case '!':	cat3(" !(", now->lft, ")"); break;
	case UMIN:	cat3(" -(", now->lft, ")"); break;
	case '~':	cat3(" ~(", now->lft, ")"); break;

	case '/':	cat1("/");  break;
	case '*':	cat1("*");  break;
	case '-':	cat1("-");  break;
	case '+':	cat1("+");  break;
	case '%':	cat1("%%"); break;
	case '&':	cat1("&");  break;
	case '^':	cat1("^");  break;
	case '|':	cat1("|");  break;
	case LT:	cat1("<");  break;
	case GT:	cat1(">");  break;
	case LE:	cat1("<="); break;
	case GE:	cat1(">="); break;
	case NE:	cat1("!="); break;
	case EQ:	cat1("=="); break;
	case OR:	cat1("||"); break;
	case AND:	cat1("&&"); break;
	case LSHIFT:	cat1("<<"); break;
	case RSHIFT:	cat1(">>"); break;

	case TIMEOUT:

	  fprintf(tc, "\n\t\t(!is_moved())");

    if (GenCode)
		  printf("spin: line %3d, warning: 'timeout' in d_step sequence\n",
			  lineno);
		/* is okay as a guard */
		break;

	case RUN:
		if (claimproc
		&&  strcmp(now->sym->name, claimproc) == 0)
			fatal("claim %s, (not runnable)", claimproc);
		if (eventmap
		&&  strcmp(now->sym->name, eventmap) == 0)
			fatal("eventmap %s, (not runnable)", eventmap);

		if (GenCode)
		  fatal("'run' in d_step sequence (use atomic)",
			(char *)0);


	  for (p = rdy; p; p = p->nxt)
		  if (strcmp(p->n->name, now->sym->name) == 0)
			  break;

    if (p == 0 && c_exist == 0)
      fatal("can't find proc %s", now->sym->name);
    else if (p == 0 && c_exist == 1)
		  Bailout(fd, ";");
    else
    {
      if (if_test_RUN == 1 || c_exist == 1)
	      fprintf(fd, "\n\t\tif (is_test_enabled()) return true;");
    
      fprintf(fd, "\n\t\tstate->add_proc(new %s(state", get_autom_class_name(p));

  		for (v = now->lft, i = 0; v; v = v->rgt, i++)
	  	{	
        cat2(", ", v->lft);
		  }

/*		  if (i > Npars)
			  fatal("too many parameters in run %s(...)",
			  now->sym->name);

		  for ( ; i < Npars; i++)
			  fprintf(fd, ", 0");*/
		  fprintf(fd, "));");

    }

    if (c_exist == 1)
      c_exist = 0;

		break;

	case ENABLED:
		cat3("\n\t\tstate->get_enable_flag(", now->lft, ")");
/*		cat3("enabled(II, ", now->lft, ")");*/
		break;

	case NONPROGRESS:
		/* o_pm&4=progress, tau&128=claim stutter */
	  fprintf(fd, "\n\t\tstate->get_progress_flag()");
		break;

	case PC_VAL:
/*		cat3("((P0 *) Pptr(", now->lft, "+BASE))->_p");*/
		cat3("state->get_curr_state(", now->lft, ")");
		break;

	case LEN:
/*RL!!		if (!terse && !TestOnly && has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&1) || ");
			putname(fd, "q_R_check(", now->lft, m, "");
			fprintf(fd, ", II)) &&\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&2) || ");
			putname(fd, "q_S_check(", now->lft, m, ", II)) &&");
			fprintf(fd, "\n#endif\n\t\t");
		}*/
    putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");
    fprintf(fd, "\n\t\t&&(q->get_len())");

		break;

	case FULL:
/*RL!!		if (!terse && !TestOnly && has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&1) || ");
			putname(fd, "q_R_check(", now->lft, m, "");
			fprintf(fd, ", II)) &&\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&2) || ");
			putname(fd, "q_S_check(", now->lft, m, ", II)) &&");
			fprintf(fd, "\n#endif\n\t\t");
		}*/

    putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");
    fprintf(fd, "\n\t\t&&(q->is_full())");

		break;

	case EMPTY:
/*RL!!		if (!terse && !TestOnly && has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&1) || ");
			putname(fd, "q_R_check(", now->lft, m, "");
			fprintf(fd, ", II)) &&\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&2) || ");
			putname(fd, "q_S_check(", now->lft, m, ", II)) &&");
			fprintf(fd, "\n#endif\n\t\t");
		}*/

    putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");
    fprintf(fd, "\n\t\t&&(q->get_len() == 0)");

		break;

	case NFULL:
/*RL!!		if (!terse && !TestOnly && has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&2) || ");
			putname(fd, "q_S_check(", now->lft, m, ", II)) &&");
			fprintf(fd, "\n#endif\n\t\t");
		}*/

    putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");
    fprintf(fd, "\n\t\t&&(!q->is_full())");

		break;

	case NEMPTY:
/*RL!!		if (!terse && !TestOnly && has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&1) || ");
			putname(fd, "q_R_check(", now->lft, m, ", II)) &&");
			fprintf(fd, "\n#endif\n\t\t");
		}*/
    putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");
    fprintf(fd, "\n\t\t&&(q->get_len() > 0)");

		break;

	case 's':
/*<RL>!!		if (Pid == eventmapnr)
		{	fprintf(fd, "if ((ot == EVENT_TRACE && _tp != 's') ");
			putname(fd, "|| _qid+1 != ", now->lft, m, "");
			for (v = now->rgt, i=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST
				&&  v->lft->ntyp != EVAL)
					continue;
				fprintf(fd, " \\\n\t\t|| qrecv(");
				putname(fd, "", now->lft, m, ", ");
				putname(fd, "q_len(", now->lft, m, ")-1, ");
				fprintf(fd, "%d, 0) != ", i);
				if (v->lft->ntyp == CONST)
					putstmnt(fd, v->lft, m);*/
//				else /* EVAL */
/*					putstmnt(fd, v->lft->lft, m);
			}
			fprintf(fd, ")\n");
			fprintf(fd, "\t\t	continue");
			putname(th, " || (x_y3_ == ", now->lft, m, ")");
			break;
		}*/

    if (now->lft->sym->context == 0)
    {
      putname(fd, "\n\t\tq = state->get_queue(", now->lft, m, ");");
    }
    else
    {
      putname(fd, "\n\t\tq = state->get_queue(", now->lft, m, ");");      
    }
    
    if (c_exist == 1)
		{	
/*<RL>!!      if (m_loss)
				fprintf(fd, "1");
			else*/
				fprintf(fd, "\n\t\tif (q->is_full()) return false; \n");
			break;
		}
/*<RL>!!		if (has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "if (q_claim[", now->lft, m, "]&2) ");
			putname(fd, "q_S_check(", now->lft, m, ", II);");
			fprintf(fd, "\n#endif\n\t\t");
		}*/
//		fprintf(fd, "if (state->q_%s",
//			(u_sync > 0 && u_async == 0)?"len":"full");

/*		  fprintf(fd, "if (state->get_queue",
  		putname(fd, "(", now->lft, m, "))->");*/

    fprintf(fd, "\n\t\tif (q->is_full())");

/*<RL>!!		if (m_loss)
			fprintf(fd, "\t\t{ nlost++; delta_m = 1; } else {");
		else*/
		{	fprintf(fd, "\n\t\t\t");
			Bailout(fd, ";");
		}

// <RL> end!!!

//		if (has_enabled)

//RL If it is only test case then return true because curent transiting is possible
    if (d_step == 0)
		  fprintf(fd, "\n\t\tif (is_test_enabled()) return true;");

/*<RL>!! #if 1
		if (u_sync && !u_async && rvopt)
			fprintf(fd, "\n\n\t\tif (no_recvs(II)) continue;\n");
#endif*/

//		putname(fd, "\n\t\tqsend(", now->lft, m, "");
//		fprintf(fd, ", %d", now->val);

//RL Add an element to the channel
    fprintf(fd, "\n\t\tel = q->create_el();");

/*    str = get_queue_el_class_name(now->lft->sym->name);
    fprintf(fd, "\n\t\tel = new %s();", str);
    efree(str, strlen(str) + 1 );*/

    for (v = now->rgt, i=0; v; v = v->rgt, i++);

    
    fprintf(fd, "\n\t\tel->set(%i,", i);

		if (now->rgt)
    {
      putstmnt(fd, now->rgt->lft, m);
      i = 1;
    }

    for (v = now->rgt->rgt; v; v = v->rgt, i++)
		{	
/*    if (i == 0)
        putstmnt(fd, v->lft, m);
      else*/
        cat2(", ", v->lft);
		}

    if (i > Mpars)
		{	putname(stdout, "channel name: ", now->lft, m, "\n");
			printf("	%d msg parameters\n", i);
			fatal("too many pars in send", "");
		}

		for ( ; i < Mpars; i++)
			fprintf(fd, ", 0");
		fprintf(fd, ");");

    fprintf(fd, "\n\t\tq->send(el)");

//////////////////////////////////

/*		if (u_sync)*/
		{	fprintf(fd, ";\n\t\t");
/*			if (u_async)*/
			  fprintf(fd, "if (q->is_rvz()){");
			
/*      fprintf(fd, "\n\t\t\tstate->set_boq(%s)", str);*/
      putname(fd, "\n\t\t\tstate->set_boq(", now->lft, m, ")");                  
			
      if (GenCode)
			  fprintf(fd, "; Tracer::put_error(\"rv-attempt in d_step\")");

			fprintf(fd, ";");
			fprintf(fd, "\n\t\t}");
		}

/*<RL>!!		if (m_loss)
			fprintf(fd, ";\n\t\t}\n\t\t"); *//* end of m_loss else */
		break;

	case 'r':
/*<RL>!!		if (Pid == eventmapnr)
		{	fprintf(fd, "if ((ot == EVENT_TRACE && _tp != 'r') ");
			putname(fd, "|| _qid+1 != ", now->lft, m, "");
			for (v = now->rgt, i=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST
				&&  v->lft->ntyp != EVAL)
					continue;
				fprintf(fd, " \\\n\t\t|| qrecv(");
				putname(fd, "", now->lft, m, ", ");
				fprintf(fd, "0, %d, 0) != ", i);
				if (v->lft->ntyp == CONST)
					putstmnt(fd, v->lft, m);*/
//				else /* EVAL */
/*					putstmnt(fd, v->lft->lft, m);
			}
			fprintf(fd, ")\n");
			fprintf(fd, "\t\t	continue");

			putname(tc, " || (x_y3_ == ", now->lft, m, ")");

			break;
		}*/

    if (now->lft->sym->context == 0)
    {
      putname(fd, "\n\t\tq = state->get_queue(", now->lft, m, ");");
    }
    else
    {
      putname(fd, "\n\t\tq = state->get_queue(", now->lft, m, ");");      
    }

/*RL!!
		if (TestOnly)
		{	fprintf(fd, "((");
			if (u_sync)
				fprintf(fd, "(boq == -1 && ");
			putname(fd, "q_len(", now->lft, m, ")");
			if (u_sync && now->val <= 1)
			{ putname(fd, ") || (boq == ",  now->lft,m," && ");
			  putname(fd, "q_zero(", now->lft,m,"))");
			}
			fprintf(fd, ")");
			if (now->val == 0 || now->val == 2)
			{	for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
				{ if (v->lft->ntyp == CONST)
				  { cat3("\n\t\t&& (", v->lft, " == ");
				    putname(fd, "qrecv(", now->lft, m, ", ");
				    fprintf(fd, "0, %d, 0))", i);
				  } else if (v->lft->ntyp == EVAL)
				  { cat3("\n\t\t&& (", v->lft->lft, " == ");
				    putname(fd, "qrecv(", now->lft, m, ", ");
				    fprintf(fd, "0, %d, 0))", i);
				  } else
				  {	j++; continue;
				  }
				}
				fprintf(fd, ")");
			} else
			{	fprintf(fd, "\n\t\t&& Q_has(");
				putname(fd, "", now->lft, m, "");
				for (v = now->rgt, i=0; v; v = v->rgt, i++)
				{	if (v->lft->ntyp == CONST)
					{	fprintf(fd, ", 1, ");
						putstmnt(fd, v->lft, m);
					} else if (v->lft->ntyp == EVAL)
					{	fprintf(fd, ", 1, ");
						putstmnt(fd, v->lft->lft, m);
					} else
					{	fprintf(fd, ", 0, 0");
				}	}
				for ( ; i < Mpars; i++)
					fprintf(fd, ", 0, 0");
				fprintf(fd, "))");
			}
			break;
		}*/

/*RL!!		if (has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "if (q_claim[", now->lft, m, "]&1) ");
			putname(fd, "q_R_check(", now->lft, m, ", II);");
			fprintf(fd, "\n#endif\n\t\t");
		}
*/

    if (now->val >= 2)
    {
      fprintf(fd, "\n\t\tif (q->is_rvz()) exit(0);");
      fprintf(fd, "\n\t\telse if (state->get_boq() != -1) return false;");
    }
    else
    {
      fprintf(fd, "\n\t\tif (q->get_len() == 0) return false;");
      fprintf(fd, "\n\t\tif (q->is_rvz()){");
/*      fprintf(fd, "\n\t\t\tif (state->get_boq() != %s) ", str);*/
      putname(fd, "\n\t\t\tif (state->get_boq() != ", now->lft, m, ")");            
      Bailout(fd, "; }");
      fprintf(fd, "\n\t\telse if (state->get_boq() != -1) ");
      Bailout(fd, ";");
    }

		fprintf(fd, "\n\t\tif (q->get_len() == 0) ");
		Bailout(fd, "");

		for (v = now->rgt, j=0, count=0; v; v = v->rgt, count++)
		{	if (v->lft->ntyp != CONST
			&&  v->lft->ntyp != EVAL)
				j++;	/* count settables */
		}
		fprintf(fd, ";\n\n\t\tXX=0;");

    
    if (j != count)
    {
     	if (now->val == 0 || now->val == 2)   /* test */
	  	{	
        fprintf(fd, "\n\t\tq->look(&el);");      

        for (v = now->rgt, i=0; v; v = v->rgt, i++)
			  {	
          if (v->lft->ntyp == CONST)
				  { 
             fprintf(fd, "\n\t\tif (!el->equal_fld(%i", i);
			      cat3(", ", v->lft, ")) ");
				    Bailout(fd, ";");
				  } 
          else if (v->lft->ntyp == EVAL)
				  { 
            fprintf(fd, "\n\t\tif (!el->equal_fld(%i", i);
			      cat3(", ", v->lft->lft, ")) ");
				    Bailout(fd, ";");

			    }	
        }

		  } else	/* random receive: val 1 or 3 */
		  {	
        fprintf(fd, "\n\t\tel = q->create_el();");        

        fprintf(fd, "\n\t\tel->set(");


  			for (v = now->rgt, i=0; v; v = v->rgt, i++);

        fprintf(fd, "%i, ", i);

  			for (v = now->rgt, i=0; v; v = v->rgt, i++)
	  		{	
          if (v->lft->ntyp == CONST)
			  		putstmnt(fd, v->lft, m);
          else if (v->lft->ntyp == EVAL)
	  				putstmnt(fd, v->lft->lft, m);
          else
            fprintf(fd, "0");

          if (v->rgt != 0)
            fprintf(fd, ", ");
        }

        for ( ; i < Mpars; i++)
				  fprintf(fd, ", 0");

        fprintf(fd, ");");

/*        fprintf(fd, ";\n\t\tif (!(XX = q->has(");*/
        fprintf(fd, "\n\t\tif ((XX = q->has(\"");
        for (v = now->rgt, i=0; v; v = v->rgt, i++)
	  		{	
          if (v->lft->ntyp == CONST)
            fprintf(fd, "1");
          else if (v->lft->ntyp == EVAL)
            fprintf(fd, "1");
          else
            fprintf(fd, "0");
        }
			
        for ( ; i < Mpars; i++)
				  fprintf(fd, "0");

			  fprintf(fd, "\", el)) < 0) ");
			  Bailout(fd, ";");
      }
    }

/*		if (has_enabled)*/
    if (d_step == 0)
		  fprintf(fd, "\n\t\tif (is_test_enabled()) return true;");
/*			fprintf(fd, ";\n\t\tif (TstOnly) return 1");*/

//RL!!		if (j == 0 && now->val >= 2)
//		{	
//      fprintf(fd, ";\n\t\t");
//			break;	/* poll without side-effect */
//		}

/* <RL>!!		if (!GenCode)
		{	int jj = 0;
			fprintf(fd, ";\n\t\t");*/
			/* no variables modified */
/*			if (j == 0 && now->val == 0)
			{	fprintf(fd, "if (q_flds[((Q0 *)qptr(");
				putname(fd, "", now->lft, m, "-1))->_t]");
				fprintf(fd, " != %d)\n\t", i);
				fprintf(fd, "\t\tUerror(\"wrong nr of msg fields in rcv\");\n\t\t");
			}
#if 0
			putname(fd, "bup_q(II, ", now->lft, m, ");\n\t\t");
#else
			for (v = now->rgt; v; v = v->rgt)
				if ((v->lft->ntyp != CONST
				&&   v->lft->ntyp != EVAL))
					jj++;	*//* nr of vars needing bup */

/*			if (jj)
			for (v = now->rgt, i = 0; v; v = v->rgt, i++)
			{	char tempbuf[64];

				if ((v->lft->ntyp == CONST
				||   v->lft->ntyp == EVAL))
					continue;

				if (multi_oval)
				{	check_needed();
					sprintf(tempbuf, "(trpt+1)->bup.ovals[%d] = ",
						multi_oval-1);
					multi_oval++;
				} else
					sprintf(tempbuf, "(trpt+1)->bup.oval = ");

				if (v->lft->sym && !strcmp(v->lft->sym->name, "_"))
				{	fprintf(fd, tempbuf);
					putname(fd, "qrecv(", now->lft, m, "");
					fprintf(fd, ", XX-1, %d, 0);\n\t\t", i);
				} else
				{	_isok++;
					cat3(tempbuf, v->lft, ";\n\t\t");
					_isok--;
				}
			}
#endif
		}*/

    fprintf(fd, "\n\t\tif (XX >= 0) q->look(XX, &el);");

/* set */	for (v = now->rgt, i = 0; v; v = v->rgt, i++)
		{	if ((v->lft->ntyp == CONST
			||   v->lft->ntyp == EVAL) && v->rgt)
				continue;
			fprintf(fd, ";\n\t\t");

			if (v->lft->ntyp != CONST
			&&  v->lft->ntyp != EVAL
			&&  strcmp(v->lft->sym->name, "_") != 0)
			{	nocast=1;
				_isok++;
			  fprintf(fd, "\n\t\tel->get(%i, &",i);
        
        if ((is_bool = is_bool_var(v->lft)))
        {
          fprintf(fd, "bool_tmp");
          fprintf(fd, ");\n");          
          
          if (!is_local_var(v->lft))
            fprintf(fd, "\n\t\tstate->bit_arr.set_var(");
          else
            fprintf(fd, "\n\t\tautom_bit_arr.set_var(");        
				  putstmnt(fd, v->lft, m);
          fprintf(fd, ", bool_tmp);\n");                    
        }
        else
        {
        /*        fprintf(fd, "\n\t\t",i);*/
				  putstmnt(fd, v->lft, m);
          fprintf(fd, ");");          
        }
        
				_isok--;
				nocast=0;
			}

/*			if (v->lft->ntyp != CONST
			&&  v->lft->ntyp != EVAL
			&& strcmp(v->lft->sym->name, "_") != 0
			&&  (v->lft->ntyp != NAME
			||   v->lft->sym->type != CHAN))
			{	fprintf(fd, ";\n#ifdef VAR_RANGES");
				fprintf(fd, "\n\t\tlogval(\"");
				withprocname = terse = nocast = 1;
				_isok++;
				putstmnt(fd,v->lft,m);
				withprocname = terse = nocast = 0;
				fprintf(fd, "\", ");
				putstmnt(fd,v->lft,m);
				_isok--;
				fprintf(fd, ");\n#endif\n");
				fprintf(fd, "\t\t");
			}*/
		}
		fprintf(fd, ";\n\t\t");


    if (now->val < 2)
      fprintf(fd, "\n\t\tif (XX >= 0) q->del(XX);");

    fprintf(fd, "\n\t\tif (q->is_rvz()) state->set_boq(-1);");

/*<RL>!!		if (u_sync)
		{	putname(fd, "if (q_zero(", now->lft, m, "))");
			fprintf(fd, "\n\t\t{	boq = -1;\n");

			fprintf(fd, "#ifndef NOFAIR\n"); 
			fprintf(fd, "\t\t\tif (fairness\n");
			fprintf(fd, "\t\t\t&& !(trpt->o_pm&32)\n");
			fprintf(fd, "\t\t\t&& (now._a_t&2)\n");
			fprintf(fd, "\t\t\t&&  now._cnt[now._a_t&1] == II+2)\n");
			fprintf(fd, "\t\t\t{	now._cnt[now._a_t&1] -= 1;\n");
			fprintf(fd, "#ifdef VERI\n");
			fprintf(fd, "\t\t\t	if (II == 1)\n");
			fprintf(fd, "\t\t\t		now._cnt[now._a_t&1] = 1;\n");
			fprintf(fd, "#endif\n");
			fprintf(fd, "#ifdef DEBUG\n");
			fprintf(fd, "\t\t\tprintf(\"%%3d: proc %%d fairness \", depth, II);\n");
			fprintf(fd, "\t\t\tprintf(\"Rule 2: --cnt to %%d (%%d)\\n\",\n");
			fprintf(fd, "\t\t\t	now._cnt[now._a_t&1], now._a_t);\n");
			fprintf(fd, "#endif\n");
			fprintf(fd, "\t\t\t	trpt->o_pm |= (32|64);\n");
			fprintf(fd, "\t\t\t}\n");
			fprintf(fd, "#endif\n");

			fprintf(fd, "\n\t\t}");
		}*/
		break;

	case 'R':
/*    fprintf(fd, "\n\t\t{");*/

/*RL!!		if (!terse && !TestOnly && has_xu)
		{	fprintf(fd, "\n#ifndef XUSAFE\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&1) || ");
			fprintf(fd, "q_R_check(");
			putname(fd, "", now->lft, m, ", II)) &&\n\t\t");
			putname(fd, "(!(q_claim[", now->lft, m, "]&2) || ");
			putname(fd, "q_S_check(", now->lft, m, ", II)) &&");
			fprintf(fd, "\n#endif\n\t\t");
		}
		if (u_sync>0)
			putname(fd, "not_RV(", now->lft, m, ") && \\\n\t\t");
*/


/*    if (now->lft->sym->context == 0)
      fprintf(fd, "\n\t\t(q = state->get_queue(state->globals.%s))", now->lft->sym->name);
    else
      fprintf(fd, "\n\t\t(q = state->get_queue(locals.%s))", now->lft->sym->name);*/
    
    if (now->lft->sym->context == 0)
      putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");
    else
      putname(fd, "\n\t\t(q = state->get_queue(", now->lft, m, "))");      

    for (v = now->rgt, i=j=0; v; v = v->rgt, i++)
			if (v->lft->ntyp != CONST
			&&  v->lft->ntyp != EVAL)
			{	j++; continue;
			}


    	if (now->val == 0)   /* test */
	  	{	
/*        fprintf(fd, "\n\t\tif (!(q->look(&el)))\n\t\t\t");
        Bailout(fd, ";");        */

        fprintf(fd, "\n\t\t&&(q->look(&el))");

/*        if ( c_exist == 1 )
        {
		      fprintf(fd, "\n\t\tif (!(");
        }*/

		    fprintf(fd, "&&(");

        for (v = now->rgt, i=0; v; v = v->rgt, i++)
			  {	
          if (v->lft->ntyp == CONST)
				  { 
            fprintf(fd, "\n\t\tel->equal_fld(%i", i);
			      cat3(", ", v->lft, ")");
				  } 
          else if (v->lft->ntyp == EVAL)
				  { 
            fprintf(fd, "\n\t\tel->equal_fld(%i", i);
			      cat3(", ", v->lft->lft, ")");
			    }	
        }

		  } else	/* random receive: val 1 or 3 */
		  {	
/*        fprintf(fd, "\n\t\tel = q->create_el();");        */
        fprintf(fd, "&&(el = q->create_el())");        

/*        fprintf(fd, "\n\t\tel->set(");*/
        fprintf(fd, "&&(el->set(");
  			for (v = now->rgt, i=0; v; v = v->rgt, i++)
	  		{	
          if (v->lft->ntyp == CONST)
			  		putstmnt(fd, v->lft, m);
          else if (v->lft->ntyp == EVAL)
	  				putstmnt(fd, v->lft->lft, m);
          else
            fprintf(fd, "0");

          if (v->rgt != 0)
            fprintf(fd, ", ");
        }

        for ( ; i < Mpars; i++)
				  fprintf(fd, ", 0");

/*        fprintf(fd, ");");*/
        fprintf(fd, "))");

/*        if ( c_exist == 1 )
        {
		      fprintf(fd, "if (!(");
        }*/
	      fprintf(fd, "&&(");

        fprintf(fd, "\n\t\tq->has(\"");
        for (v = now->rgt, i=0; v; v = v->rgt, i++)
	  		{	
          if (v->lft->ntyp == CONST)
            fprintf(fd, "1");
          else if (v->lft->ntyp == EVAL)
            fprintf(fd, "1");
          else
            fprintf(fd, "0");
        }
			
        for ( ; i < Mpars; i++)
				  fprintf(fd, "0");

			  fprintf(fd, "\", el) >= 0)");
      }





/*if (now->val == 0 || i == j)
		{	putname(fd, "(q_len(", now->lft, m, ") > 0");
			for (v = now->rgt, i=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp != CONST
				&&  v->lft->ntyp != EVAL)
					continue;
				fprintf(fd, " \\\n\t\t&& qrecv(");
				putname(fd, "", now->lft, m, ", ");
				fprintf(fd, "0, %d, 0) == ", i);
				if (v->lft->ntyp == CONST)
					putstmnt(fd, v->lft, m);
				else 
					putstmnt(fd, v->lft->lft, m);
			}
			fprintf(fd, ")");
		} else
		{	putname(fd, "Q_has(", now->lft, m, "");
			for (v = now->rgt, i=0; v; v = v->rgt, i++)
			{	if (v->lft->ntyp == CONST)
				{	fprintf(fd, ", 1, ");
					putstmnt(fd, v->lft, m);
				} else if (v->lft->ntyp == EVAL)
				{	fprintf(fd, ", 1, ");
					putstmnt(fd, v->lft->lft, m);
				} else
					fprintf(fd, ", 0, 0");
			}	
			for ( ; i < Mpars; i++)
				fprintf(fd, ", 0, 0");
			fprintf(fd, ")");
		}
*/

/*    if ( c_exist == 1 )
    {
		  fprintf(fd, "))\n\t\t\t");
		  Bailout(fd, ";");
      c_exist = 0;
    }
    
    fprintf(fd, "\n\t\t}");*/
    fprintf(fd, ")\n\t\t");

		break;

	case 'c':
    if (now->lft->ntyp != 'r' && now->lft->ntyp != 's' && now->lft->ntyp != RUN)
    {
		  cat3("if (!(", now->lft, "))\n\t\t\t");
		  Bailout(fd, ";");
    }
    else
    {
      c_exist = 1;
	  	cat3("", now->lft, "");
    }

		break;

	case  ELSE:
		if (!GenCode)
		{	
/*      if (separate == 2)
				fprintf(fd, "if (state->is_moved())\n\t\t\t");
			else*/
			fprintf(fd, "if (is_moved())\n\t\t\t");
			Bailout(fd, ";");
		} 
    else
		{	
      fprintf(fd, "/* else */");
		}
		break;

	case '?':
		cat3("( (", now->lft, ") ? ");
		cat3("(", now->rgt->lft, ") : ");
		cat3("(", now->rgt->rgt, ") )");
		break;

	case ASGN:
    if (d_step == 0)    
		  fprintf(fd, "\n\t\tif (is_test_enabled()) return true;");		
    
    _isok++;

/*RL!! (d_step related code)!!		if (!GenCode)
		{	if (multi_oval)
			{	char tempbuf[64];
				check_needed();
				sprintf(tempbuf, "(trpt+1)->bup.ovals[%d] = ",
					multi_oval-1);
				multi_oval++;
				cat3(tempbuf, now->lft, ";\n\t\t");
			} else
			{	cat3("(trpt+1)->bup.oval = ", now->lft, ";\n\t\t");
		}	}*/
		
    fprintf(fd,"\n\t\t");
    nocast = 1;
    
    if ((is_bool = is_bool_var(now->lft)))
      if (!is_local_var(now))
        fprintf(fd, "state->bit_arr.set_var(");
      else
        fprintf(fd, "autom_bit_arr.set_var(");        
      
    putstmnt(fd,now->lft,m); 
    
    nocast = 0;
    if (!is_bool)    
		  fprintf(fd," = ");
    else
      fprintf(fd,", ");
		_isok--;

    if_test_RUN = 0;
	  putstmnt(fd,now->rgt,m);
        
    if (!is_bool)
		  fprintf(fd,";");
    else 
    {
      fprintf(fd, ");");
      fprintf(fd,";");
    }
      

/*		if (now->sym->type != CHAN
		||  verbose > 0)
		{	fprintf(fd, ";\n#ifdef VAR_RANGES");
			fprintf(fd, "\n\t\tlogval(\"");
			withprocname = terse = nocast = 1;
			_isok++;
			putstmnt(fd,now->lft,m);
			withprocname = terse = nocast = 0;
			fprintf(fd, "\", ");
			putstmnt(fd,now->lft,m);
			_isok--;
			fprintf(fd, ");\n#endif\n");
			fprintf(fd, "\t\t");
		}*/
		break;

	case PRINT:
/*RL!!		if (has_enabled)
		fprintf(fd, "if (TstOnly) return 1;\n\t\t");
#ifdef PRINTF
		fprintf(fd, "printf(%s", now->sym->name);
#else
		fprintf(fd, "Printf(%s", now->sym->name);
#endif
		for (v = now->lft; v; v = v->rgt)
		{	cat2(", ", v->lft);
		}
		fprintf(fd, ")");*/
		break;

	case NAME:
		if (!nocast/* && now->sym && Sym_typ(now) < SHORT*/)
    {
      if (!is_bool_var(now))
			  putname(fd, "", now, m, "");
      else
        if (!is_local_var(now))
          putname(fd, "state->bit_arr.is_var_enabled(", now, m, ")");        
        else
          putname(fd, "autom_bit_arr.is_var_enabled(", now, m, ")");                  
    }
		else
			putname(fd, "", now, m, "");
		break;

	case   'p':
/*		putremote(fd, now, m);*/
    cat3("\n\t\t((state->get_proc(", now->lft->lft, "))->get_curr_state())");
		break;

	case   'q':
		if (terse)
			fprintf(fd, "%s", now->sym->name);
		else
			fprintf(fd, "%d", remotelab(now));
		break;

	case ASSERT:
    if (d_step == 0)
		  fprintf(fd, "\n\t\tif (is_test_enabled()) return true;");

		cat3("\n\t\tassert(", now->lft, ");");
/*		terse = nocast = 1;
		cat3("\"", now->lft, "\", II, tt, t)");
		terse = nocast = 0;*/
		break;

	case '.':
	case BREAK:
	case GOTO:
		if (Pid == eventmapnr)
			fprintf(fd, "Tracer::put_error(\"cannot get here\")");
		putskip(m);
		break;

	case '@':
		if (Pid == eventmapnr)
		{	fprintf(fd, "return 0");
			break;
		}

/*		if (has_enabled)
		{	fprintf(fd, "if (TstOnly)\n\t\t\t");
			fprintf(fd, "return (II+1 == now._nr_pr);\n\t\t");
		}
		fprintf(fd, "if (!delproc(1, II)) ");
		Bailout(fd, "");*/
		break;
    
  case STOP:
		  fprintf(fd, "\n\t\tstop_passed = true;\n");    
  
      fprintf(fd, "\n\t\tswitch( m_stop )\n\t\t{");    
      fprintf(fd, "\n\t\tcase FIRST_STOP:");    
      fprintf(fd, "\n\t\t   m_stop = (uchar)CONTINUE_STOP;");    
      fprintf(fd, "\n\t\tcase CONTINUE_STOP:");    
      fprintf(fd, "\n\t\t   break;");    
      fprintf(fd, "\n\t\tdefault:");    
      fprintf(fd, "\n\t\t   m_stop = (uchar)FIRST_STOP;\n\t\t};");    
    break;
  
	default:
		printf("spin: bad node type %d (.m) - line %d\n",
			now->ntyp, now->ln);
		alldone(1);
	}

  if_test_RUN = 1;
/*  if (now->ntyp != 's' && now->ntyp != 'r' && now->ntyp != 'R' && c_exist == 1)
  {
		fprintf(fd, "if (!(");
    fprintf(fd, "))\n\t\t\t");
		Bailout(fd, "");

    c_exist = 0;
  }
*/
}



int is_bool_var(Lextok *n) /* varref */
{	
  Symbol *s = n->sym;
  
	if (!s)
		fatal("no name - putname", (char *) 0);

  if (s->type == BIT)
    return 1;
  else if (s->type == STRUCT && n->rgt && n->rgt->lft)
    return is_bool_var(n->rgt->lft);
	else
    return 0;
}

int is_local_var(Lextok *n) /* varref */
{	
  Symbol *s = n->sym;
	lineno = n->ln; Fname = n->fn;

	if (!s)
		fatal("no name - putname", (char *) 0);

	if (s->context && context && s->type)
		s = findloc(s);		/* it's a local var */

	if (!s)
		return;

	if (!s->type)	/* not a local name */
		s = lookup(s->name);	/* must be a global */

	if (s->type == PROCTYPE)
		fatal("proctype-name '%s' used as array-name", s->name);

	if (!terse && !s->owner && evalindex != 1)
	{	
    if (s->context
		    ||  strcmp(s->name, "_p") == 0
		    ||  strcmp(s->name, "_pid") == 0)
      return 1;
    else
      return 0;
  }
  else
      return 0;
}


void
putname(FILE *fd, char *pre, Lextok *n, int m, char *suff) /* varref */
{	Symbol *s = n->sym;
	lineno = n->ln; Fname = n->fn;

	if (!s)
		fatal("no name - putname", (char *) 0);

	if (s->context && context && s->type)
		s = findloc(s);		/* it's a local var */

	if (!s)
	{	
    fprintf(fd, "%s%s%s", pre, n->sym->name, suff);
		return;
	}
	if (!s->type)	/* not a local name */
		s = lookup(s->name);	/* must be a global */

	if (!s->type)
	{	if (strcmp(pre, ".") != 0)
		non_fatal("undeclared variable '%s'", s->name);
		s->type = INT;
	}

	if (s->type == PROCTYPE)
		fatal("proctype-name '%s' used as array-name", s->name);

	fprintf(fd, pre);
	if (!terse && !s->owner && evalindex != 1)
	{	if (s->context
		||  strcmp(s->name, "_p") == 0
		||  strcmp(s->name, "_pid") == 0)
		{	
      if (!is_bool_var(n))
        fprintf(fd, "locals.");
      else
        fprintf(fd, "locals_bool.");
		} else
		{	
      int x = strcmp(s->name, "_");
			if (/*!(s->hidden&1) && */x != 0)
        if (!is_bool_var(n))
				  fprintf(fd, "state->globals.");
        else
				  fprintf(fd, "state->globals_bool.");          
			if (x == 0 && _isok == 0)
				fatal("attempt to read value of '_'", 0);
	  }	
  }
  else
    if (strcmp(pre, ".") != 0)
      if (!is_bool_var(n))
        fprintf(fd, "state->globals.");
      else
			  fprintf(fd, "state->globals_bool.");                  

/*RL!!	if (withprocname
	&&  s->context
	&&  strcmp(pre, "."))
		fprintf(fd, "%s:", s->context->name);*/

	if (evalindex != 1)
		fprintf(fd, "%s", s->name);

	if (s->nel != 1)
	{	if (no_arrays)
		{
		non_fatal("ref to array element invalid in this context",
			(char *)0);
		printf("\thint: instead of, e.g., x[rs] qu[3], use\n");
		printf("\tchan nm_3 = qu[3]; x[rs] nm_3;\n");
		printf("\tand use nm_3 in sends/recvs instead of qu[3]\n");
		}
		/* an xr or xs reference to an array element
		 * becomes an exclusion tag on the array itself -
		 * which could result in invalidly labeling
		 * operations on other elements of this array to
		 * be also safe under the partial order reduction
		 * (see procedure has_global())
		 */

		if (evalindex == 2)
		{	
      fprintf(fd, "[%%d]");
		} 
    else if (evalindex == 1)
		{	
      evalindex = 0;		/* no good if index is indexed array */
			cat3(", ", n->lft, "");
			evalindex = 1;
		} 
    else
		{	
      if (terse
			|| (n->lft && n->lft->ntyp == CONST	&& n->lft->val < s->nel)
			|| (!n->lft && s->nel > 0))
			{	
        cat3("[", n->lft, "]");
			} 
      else
			{	
/*RL!!(old code)!!        cat3("[ Index(", n->lft, ", ");
				fprintf(fd, "%d) ]", s->nel);
        
	      cat3("\n\t\tassert(", n->lft, ">= 0);");
	      cat3("\n\t\tassert(", n->lft, "<");
        fprintf(fd, "%d);", s->nel);*/

        cat3("[", n->lft, "]");
			}
		}
	}
	if (s->type == STRUCT && n->rgt && n->rgt->lft)
	{	
    putname(fd, ".", n->rgt->lft, m, "");
	}

	fprintf(fd, suff);
}

void
putremote(FILE *fd, Lextok *n, int m)	/* remote reference */
{	int promoted = 0;

	if (terse)
	{	fprintf(fd, "%s[", n->lft->sym->name);
		putstmnt(fd, n->lft->lft, m);
		fprintf(fd, "].%s", n->sym->name);
	} else
	{	if (Sym_typ(n) < SHORT)
		{	promoted = 1;
			fprintf(fd, "((int)");
		}
		fprintf(fd, "((P%d *)Pptr(",
			fproc(n->lft->sym->name));
		fprintf(fd, "BASE+");
		putstmnt(fd, n->lft->lft, m);
		fprintf(fd, "))->%s", n->sym->name);
	}
	if (n->rgt)
	{	fprintf(fd, "[");
		putstmnt(fd, n->rgt, m);
		fprintf(fd, "]");
	}
	if (promoted) fprintf(fd, ")");
}

static int
getweight(Lextok *n)
{	/* this piece of code is a remnant of early versions
	 * of the verifier -- in the current version of Spin
	 * only non-zero values matter - so this could probably
	 * simply return 1 in all cases.
	 */
	switch (n->ntyp) {
	case 'r':     return 4;
	case 's':     return 2;
	case TIMEOUT: return 1;
	case 'c':     if (has_typ(n->lft, TIMEOUT)) return 1;
	}
	return 3;
}

static void put_escp(FILE *tc, Element *e)
{	
  int n;
	SeqList *x;

	if (e->esc && e->n->ntyp != GOTO && e->n->ntyp != '.')
	{	
    for (x = e->esc, n=0; x; x = x->nxt, n++)
		{	
			put_seq(tc, x->this, 2, 0);	/* args?? */
		}
		
	}
}

static int nr_bup(Element *e)
{	
  FSM_use *u;
	Lextok *v;
	int nr = 0;

	switch (e->n->ntyp) {
	case ASGN:
		nr++;
		break;
	case  'r':
		if (e->n->val >= 1)
			nr++;	/* random recv */
		for (v = e->n->rgt; v; v = v->rgt)
		{	if ((v->lft->ntyp == CONST
			||   v->lft->ntyp == EVAL))
				continue;
			nr++;
		}
		break;
	default:
		break;
	}
	
  for (u = e->dead; u; u = u->nxt)
	{	
    switch (u->special) {
		case 2:		/* dead after write */
			if (e->n->ntyp == ASGN
			&&  e->n->rgt->ntyp == CONST
			&&  e->n->rgt->val == 0)
				break;
			nr++;
			break;
		case 1:		/* dead after read */
			nr++;
			break;
	  }	
  }
	
  return nr;
}

static int nrhops(Element *e)
{	
  Element *f = e, *g;
	int cnt = 0;
	int stopat;

	if (e->merge_start)
		stopat = e->merge_start;
	else
		stopat = e->merge;

	do {
		cnt += nr_bup(f);

		if (f->n->ntyp == GOTO)
		{	
      g = get_lab(f->n, 1);
			if (g->seqno == stopat)
				f = g;
			else
				f = huntele(g, f->status, stopat);
		} 
    else
			f = f->nxt;

		  if (f && !f->merge && !f->merge_single && f->seqno != stopat)
		  {
			  fprintf(tc, "\n\t\tbad hop %s:%d -- at %d, <",
				  f->n->fn->name,f->n->ln, f->seqno);
			  comment(tc, f->n, 0);
			  fprintf(tc, "> looking for %d -- merge %d:%d:%d\n\t\t",
				  stopat, f->merge, f->merge_start, f->merge_single);
		 	  break;
		  }
	} while (f && f->seqno != stopat);

	return cnt;
}

static int fproc(char *s)
{	
  ProcList *p;

	for (p = rdy; p; p = p->nxt)
		if (strcmp(p->n->name, s) == 0)
			return p->tn;

	fatal("proctype %s not found", s);
	return -1;
}

static int scan_seq(Sequence *s)
{	
  Element *f, *g;
	SeqList *h;

	for (f = s->frst; ; f = f->nxt)
	{	
    if ((f->status & CHECK2) ||  has_global(f->n))
			return 1;

    if (f->n->ntyp == GOTO)	/* may reach other atomic */
		{	
      g = target(f);
			if (g
			&& !(f->status & L_ATOM)
			&& !(g->status & (ATOM|L_ATOM)))
			{	/*fprintf(tt, "	/* goto mark-down, ");
				fprintf(tt, "line %d - %d *\n",
					f->n->ln, (g->n)?g->n->ln:0);*/
				return 1; /* assume worst case */
		}	}
		for (h = f->sub; h; h = h->nxt)
			if (scan_seq(h->this))
				return 1;
		if (f == s->last)
			break;
	}
	return 0;
}

/*int
has_typ(Lextok *n, int m)
{
	if (!n) return 0;
	if (n->ntyp == m) return 1;
	return (has_typ(n->lft, m) || has_typ(n->rgt, m));
}

static int runcount;

void
do_count(Lextok *n)
{
	if (!n) return;
	if (n->ntyp == RUN) runcount++;
	do_count(n->lft);
	do_count(n->rgt);
}

void
count_runs(Lextok *n)
{
	runcount = 0;
	do_count(n);
	if (runcount > 1)
		fatal("more than one run operator in expression", "");
}*/
