/***** spin: pangen1.c *****/

/* Copyright (c) 1991-2000 by Lucent Technologies - Bell Laboratories     */
/* All Rights Reserved.  This software is for educational purposes only.  */
/* Permission is given to distribute this code provided that this intro-  */
/* ductory message is not removed and no monies are exchanged.            */
/* No guarantee is expressed or implied by the distribution of this code. */
/* Software written by Gerard J. Holzmann as part of the book:            */
/* `Design and Validation of Computer Protocols,' ISBN 0-13-539925-4,     */
/* Prentice Hall, Englewood Cliffs, NJ, 07632.                            */
/* Send bug-reports and/or questions to: gerard@research.bell-labs.com    */
#include <stdlib.h>
#include "spin.h"
#ifdef PC
#include "y_tab.h"
#else
#include "y.tab.h"
#endif
#include "pangen1.h"
#include "pangen3.h"

extern FILE	*tc, *th, *tt;
extern Label	*labtab;
extern Ordered	*all_names;
extern ProcList	*rdy;
extern Queue	*qtab;
extern Symbol	*Fname;
extern int	lineno, verbose, Pid, separate;
extern int	nrRdy, nqs, mst, Mpars, claimnr, eventmapnr;
extern short	has_sorted, has_random, has_provided;

int	Npars=0, u_sync=0, u_async=0;

static int var_ind = 0;

static Symbol	*LstSet=ZS;
static int	acceptors=0, progressors=0, nBits=0;
static int	Types[] = { UNSIGNED, BIT, BYTE, CHAN, MTYPE, SHORT, INT, STRUCT };

static void	dohidden(void);
static void	do_init(FILE *, Symbol *, int);
/*static void	put_ptype(char *, int, int, int);*/
static void	tc_predef_np(void);
/*static void	put_pinit(ProcList *);*/

static void
reverse_names(ProcList *p)
{
	if (!p) return;
	reverse_names(p->nxt);
	fprintf(th, "   \"%s\",\n", p->n->name);
}

/*void
genheader(void)
{	ProcList *p; int i;

	if (separate == 2) goto here;

	fprintf(th, "#define SYNC	%d\n", u_sync);
	fprintf(th, "#define ASYNC	%d\n\n", u_async);

	putunames(th);

	fprintf(tc, "short Air[] = { ");
	for (p = rdy, i=0; p; p = p->nxt, i++)
		fprintf(tc, "%s (short) Air%d", (p!=rdy)?",":"", i);
	fprintf(tc, ", (short) Air%d", i);	/* np_ */
/*	fprintf(tc, " };\n");

	fprintf(th, "char *procname[] = {\n");
		reverse_names(rdy);
	fprintf(th, "   \":np_:\",\n");
	fprintf(th, "};\n\n");

here:
	for (p = rdy; p; p = p->nxt)
		put_ptype(p->n->name, p->tn, mst, nrRdy+1);
		/* +1 for np_ */
/*	put_ptype("np_", nrRdy, mst, nrRdy+1);

	ntimes(th, 0, 1, Head0);

	if (separate != 2)
		ntimes(th, 0, 1, Header);
	ntimes(th, 0, 1, Head1);

	LstSet = ZS;
	(void) doglobal("", PUTV);
	fprintf(th, "	uchar sv[VECTORSZ];\n");
	fprintf(th, "} State");
#ifdef SOLARIS
	fprintf(th,"\n#ifdef GCC\n");
	fprintf(th, "\t__attribute__ ((aligned(8)))");
	fprintf(th, "\n#endif\n\t");
#endif
	fprintf(th, ";\n\n");

	if (separate != 2)
		dohidden();
}
*/
/*void
genaddproc(void)
{	ProcList *p;
	int i;

	if (separate ==2) goto shortcut;

	fprintf(tc, "int\naddproc(int n");
	for (i = 0; i < Npars; i++)
		fprintf(tc, ", int par%d", i);

	ntimes(tc, 0, 1, Addp0);
	ntimes(tc, 1, nrRdy+1, R5); /* +1 for np_ */
/*	ntimes(tc, 0, 1, Addp1);

	if (has_provided)
	{	fprintf(tt, "\nint\nprovided(int II, int ot, ");
		fprintf(tt, "int tt, Trans *t)\n");
		fprintf(tt, "{\n\tswitch(ot) {\n");
	}
shortcut:
	tc_predef_np();
	for (p = rdy; p; p = p->nxt)
	{	Pid = p->tn;
		put_pinit(p);
	}
	if (separate == 2) return;

	Pid = 0;
	if (has_provided)
	{	fprintf(tt, "\tdefault: return 1; /* e.g., a claim *//*\n");
		fprintf(tt, "\t}\n\treturn 0;\n}\n");
	}

	ntimes(tc, i, i+1, R6);
	if (separate == 0)
		ntimes(tc, 1, nrRdy+1, R5); /* +1 for np_ */
/* else
		ntimes(tc, 1, nrRdy, R5);
	ntimes(tc, 0, 1, R8a);
}
*/
/*void
genother(void)
{	ProcList *p;

	switch (separate) {
	case 2:
		if (claimnr >= 0)
		ntimes(tc, claimnr, claimnr+1, R0); /* claim only */
/*		break;
	case 1:
		ntimes(tc,     0,    1, Code0);
		ntimes(tc, 0, claimnr, R0);	/* all except claim */
/*		ntimes(tc, claimnr+1, nrRdy, R0);
		break;
	case 0:
		ntimes(tc,     0,    1, Code0);
		ntimes(tc,     0, nrRdy+1, R0); /* +1 for np_ */
/*		break;
	}

	for (p = rdy; p; p = p->nxt)
		end_labs(p->n, p->tn);

	switch (separate) {
	case 2:
		if (claimnr >= 0)
		ntimes(tc, claimnr, claimnr+1, R0a); /* claim only */
/*		return;
	case 1:
		ntimes(tc, 0, claimnr, R0a);	/* all except claim */
/*		ntimes(tc, claimnr+1, nrRdy, R0a);
		fprintf(tc, "	if (state_tables)\n");
		fprintf(tc, "		ini_claim(%d, 0);\n", claimnr);
		break;
	case 0:
		ntimes(tc, 0, nrRdy, R0a);	/* all */
/*		break;
	}

	ntimes(tc, 0,     1, R0b);
	if (separate == 1 && acceptors == 0)
		acceptors = 1;	/* assume at least 1 acceptstate */
/*	ntimes(th, acceptors,   acceptors+1,   Code1);
	ntimes(th, progressors, progressors+1, Code3);
	ntimes(th, nrRdy+1, nrRdy+2, R2); /* +1 for np_ */

/*	fprintf(tc, "	iniglobals();\n");
	ntimes(tc, 0,     1, Code2);
	ntimes(tc, 0,     nrRdy, R4);
	fprintf(tc, "}\n\n");

	fprintf(tc, "void\n");
	fprintf(tc, "iniglobals(void)\n{\n");
	if (doglobal("", INIV) > 0)
	{	fprintf(tc, "#ifdef VAR_RANGES\n");
		(void) doglobal("logval(\"", LOGV);
		fprintf(tc, "#endif\n");
	}
	ntimes(tc, 1, nqs+1, R3);
	fprintf(tc, "\tMaxbody = max(Maxbody, sizeof(State)-VECTORSZ);");
	fprintf(tc, "\n}\n\n");
}
*/

void
gensvmap(void)
{
	ntimes(tc, 0, 1, SvMap);
}

static struct {
	char *s,	*t;		int n,	m,	p;
} ln[] = {
/* <AR> temporally are not in use
   {"end",  	"stopstate",	3,	0,	0},
*/	{"progress",	"m_progstate",	8,	0,	1},

   {"accept",	"m_accpstate",	6,	1,	0},
	{0,		0,		0,	0,	0},
};

void calc_end_labs(char *accpstate, char *progstate, char *finalstate, Symbol *s, int i)
{
  int oln = lineno;
	Symbol *ofn = Fname;
	Label *l;
	int j; char foo[128];

	if ((i == claimnr && separate == 1)
	||  (i != claimnr && separate == 2))
		return;

	for (l = labtab; l; l = l->nxt)
	   for (j = 0; ln[j].n; j++)
		   if ( strncmp(l->s->name, ln[j].s, ln[j].n) == 0 &&  
              strcmp(l->c->name, s->name) == 0)
		   {	
         if ( ln[j].m )
         {
           accpstate[l->e->seqno] = 1;
           if (strcmp(l->s->name, "accept_all") == 0 )
              finalstate[l->e->seqno] = 1;
         }
         else if ( ln[j].p )
            progstate[l->e->seqno] = 1;
/*
         acceptors += ln[j].m;
			   progressors += ln[j].p;
*/
		   }	
	lineno = oln;
	Fname  = ofn;

};

void end_labs(FILE *tc, Symbol *s, int i)
{	
  int oln = lineno;
	Symbol *ofn = Fname;
	Label *l;
	int j; char foo[128];

	if ((i == claimnr && separate == 1)
	||  (i != claimnr && separate == 2))
		return;

	for (l = labtab; l; l = l->nxt)
	   for (j = 0; ln[j].n; j++)
		   if ( strncmp(l->s->name, ln[j].s, ln[j].n) == 0 &&  
              strcmp(l->c->name, s->name) == 0)
		   {	
            fprintf(tc, "\t\t%s[%d] = true;\n",ln[j].t, l->e->seqno);
            acceptors += ln[j].m;
			   progressors += ln[j].p;
			   if (l->e->status & D_ATOM)
			   {	
               sprintf(foo, "%s label inside d_step",	ln[j].s );
				   lineno = l->e->n->ln;
				   Fname  = l->e->n->fn;
				   printf("generator: %3d:%s, warning, %s - is invisible\n",lineno, Fname?Fname->name:"-", foo);
			   }

			   if (j > 0 && (l->e->status & ATOM))
			   {	
               sprintf(foo, "%s label inside atomic",	ln[j].s);
	         	lineno = l->e->n->ln;
				   Fname  = l->e->n->fn;
				   printf("generator: %3d:%s, warning, %s - is invisible\n", lineno, Fname?Fname->name:"-", foo);
			   }
		   }	
	/* visible states -- through remote refs: */
	/*for (l = labtab; l; l = l->nxt)
		if (l->visible
		&&  strcmp(l->s->context->name, s->name) == 0)
		fprintf(tc, "\tvisstate[%d][%d] = 1;\n",
				i, l->e->seqno);
   */
	lineno = oln;
	Fname  = ofn;
}

void
ntimes(FILE *fd, int n, int m, char *c[])
{
	int i, j;
	for (j = 0; c[j]; j++)
	for (i = n; i < m; i++)
	{	fprintf(fd, c[j], i, i, i, i, i, i);
		fprintf(fd, "\n");
	}
}

void
prehint(Symbol *s)
{	Lextok *n;

	printf("spin: warning, ");
	if (!s) return;

	n = (s->context != ZS)?s->context->ini:s->ini;
	if (n)
	printf("line %3d %s, ", n->ln, n->fn->name);
}

void
checktype(Symbol *sp, char *s)
{	char buf[128]; int i;

	if (!s
	|| (sp->type != BYTE
	&&  sp->type != SHORT
	&&  sp->type != INT))
		return;

	if (sp->hidden&16)	/* formal parameter */
	{	ProcList *p; Lextok *f, *t;
		int posnr = 0;
		for (p = rdy; p; p = p->nxt)
			if (p->n->name
			&&  strcmp(s, p->n->name) == 0)
				break;
		if (p)
		for (f = p->p; f; f = f->rgt) /* list of types */
		for (t = f->lft; t; t = t->rgt, posnr++)
			if (t->sym
			&&  strcmp(t->sym->name, sp->name) == 0)
			{	checkrun(sp, posnr);
				return;
			}

	} else if (!(sp->hidden&4))
	{	if (!(verbose&32)) return;
		sputtype(buf, sp->type);
		i = strlen(buf);
		while (buf[--i] == ' ') buf[i] = '\0';
		prehint(sp);
		if (sp->context)
			printf("proctype %s:", s);
		else
			printf("global");
		printf(" '%s %s' could be declared 'bit %s'\n",
			buf, sp->name, sp->name);
	} else if (sp->type != BYTE && !(sp->hidden&8))
	{	if (!(verbose&32)) return;
		sputtype(buf, sp->type);
		i = strlen(buf);
		while (buf[--i] == ' ') buf[i] = '\0';
		prehint(sp);
		if (sp->context)
			printf("proctype %s:", s);
		else
			printf("global");
		printf(" '%s %s' could be declared 'byte %s'\n",
			buf, sp->name, sp->name);
	}
}

int haslocal( char *s )
{
   int j, k=0; extern int nr_errs;
	Ordered *walk;
	Symbol *sp;
   
	   for ( walk = all_names; walk; walk = walk->next )
	   {	
         sp = walk->entry;
         for ( j = 0; j < 8; j++ )
		   if ( sp->context && 
              !sp->owner  &&  
              sp->type == Types[j] &&  
              strcmp(s, sp->context->name) == 0 )
              return 1;
      }

   return 0;
}

static int bool_count = 0;
static int chan_count = 0;
/* <AR> modified */
int dolocal(FILE *ofd, char *pre, int dowhat, char *s)
{	
   int h, j, k=0; extern int nr_errs;
	Ordered *walk;
	Symbol *sp;
//	char buf[64], buf2[128], buf3[128];
  bool_count = 0;
  
	for ( j = 0; j < 8; j++ )
	   for ( h = 0; h <= 1; h++ )
	      for ( walk = all_names; walk; walk = walk->next )
	      {	
            sp = walk->entry;
		      if ( sp->context && 
               !sp->owner  &&  
               sp->type == Types[j] &&  
               ((h == 0 && sp->nel == 1) || (h == 1 && sp->nel > 1)) &&  
               strcmp(s, sp->context->name) == 0 )
		      {	
            switch (dowhat) 
            {
/*			      case LOGV:
				      if ( sp->type == CHAN &&  
                       verbose == 0)
					      break;

				      sprintf(buf, "%s%s:", pre, s);
				      /*{ 
                     sprintf(buf2, "\", ((P%d *)pptr(h))->", p);
				         sprintf(buf3, ");\n");
				      }
                  */
/*				      do_var(ofd, 0, dowhat, "", sp, buf, "", "", 1);
				      break;
*/
			      case INIV:
				      checktype(sp, s); /* fall through */
				      if ( sp->hidden&16 ) 
                  { 
                     k++; 
                     break; 
                  }

			      case PUTV:
				      do_var(ofd, 0, dowhat, pre, sp, "\t", " = ", ";\n", 1);
				      k++;
				      break;

            case TRACEV:
              do_var(ofd, 0, dowhat, "", sp, "\t", pre, "\";\" + EOL", 1);
				      k++;
				      break;
            
            case SETBOOL:
              k++;
              do_var( ofd, 0, dowhat, "", sp, "", pre, "", 1);
            break;

            case GETBOOL:
              k++;
              do_var( ofd, 0, dowhat, "", sp, "", pre, "", 1);
            break;

			      case PUTBOOLV:
              k++; 
				      do_var( ofd, 0, dowhat, pre, sp, "\t", " = ", ";\n", 1 );
				      break;
            
            case BOOLV:
              k++;
              do_var( 0, 0, dowhat, "", sp, "", pre, "", 1);
            break;
            
            case BOOLCOUNT:
              do_var( 0, 0, dowhat, "", sp, "", pre, "", 1);
              break;
            
            case CHANCOUNT:
              do_var( 0, 0, dowhat, "", sp, "", pre, "", 1);
              break;
			      }
			      if (strcmp(s, ":never:") == 0)
			      {	
                  printf("error: %s defines local %s\n", s, sp->name );
				      nr_errs++;
            }	
          }	
       }
  
  if (dowhat == BOOLCOUNT)
    return bool_count;
  
  if (dowhat == CHANCOUNT)
    return chan_count;
  
	return k;
}

/* <AR> modified */
int doglobal( FILE *tc, FILE *tt, char *pre, int dowhat )
{	
  Ordered *walk;
  Symbol *sp;
  int j, cnt = 0;
  
  bool_count = 0;
  chan_count = 0;
  var_ind = 2;
  
  for ( j = 0; j < 8; j++ )
     for (walk = all_names; walk; walk = walk->next)
     {	
       sp = walk->entry;

  	   if ( !sp->context &&  
            !sp->owner &&  
             sp->type == Types[j] )
  	   {	
            if (Types[j] != MTYPE || !ismtype(sp->name))
			      switch (dowhat) 
               {
      /*			case LOGV:
				      if (sp->type == CHAN
				      &&  verbose == 0)
					      break;
				      if (sp->hidden&1)
					      break;
				      do_var(tc, dowhat, "", sp,
					      pre, "\", now.", ");\n");
				      break;
      */
			      case INIV:
				      checktype(sp, (char *) 0);
				      /* fall through */
			      case PUTV:
              cnt++; 
				      do_var( tc, 0, dowhat, pre, sp, "\t", " = ", ";\n", 0 );
				      break;

            case SETBOOL:
              cnt++;
              do_var( tc, 0, dowhat, "", sp, "", pre, "", 0);
              break;

            case GETBOOL:
              cnt++;
              do_var( tc, 0, dowhat, "", sp, "", pre, "", 0);
              break;

			      case PUTBOOLV:
              cnt++; 
				      do_var( tc, 0, dowhat, pre, sp, "\t", " = ", ";\n", 0 );
				      break;

            case TRACEV:
              cnt++; 
				      do_var( tc, tt, dowhat, "", sp, "\t", pre, "\";\" + EOL", 0 );
				      break;
	            	
            case BOOLV:
              cnt++;
              do_var( 0, 0, dowhat, "", sp, "", pre, "", 0);
              break;
            
            case BOOLCOUNT:
              do_var( 0, 0, dowhat, "", sp, "", pre, "", 0);
              break;
            
            case CHANCOUNT:
              do_var( 0, 0, dowhat, "", sp, "", pre, "", 0);
              break;
          }
         }	
     }
     
  switch( dowhat )
  {
  case BOOLCOUNT:
    return bool_count;
  case CHANCOUNT:
    return chan_count;
  }

	return cnt;
}

/*static void
dohidden(void)
{	Ordered *walk;
	Symbol *sp;
	int j;

	for (j = 0; j < 8; j++)
	for (walk = all_names; walk; walk = walk->next)
	{	sp = walk->entry;
		if ((sp->hidden&1)
		&&  sp->type == Types[j])
		{	if (sp->context || sp->owner)
			fatal("cannot hide non-globals (%s)", sp->name);
			if (sp->type == CHAN)
			fatal("cannot hide channels (%s)", sp->name);
			fprintf(th, "/* hidden variable: *//*");
			typ2c(sp);
	}	}
	fprintf(th, "int _; /* a predefined write-only variable *//*\n\n");
}
*/

/* <AR> modified accoring to new class model*/
extern int bool_ind;

int do_var(
   FILE *ofd,
   FILE *tfd,   
   int dowhat, 
   char *s, 
   Symbol *sp,
	char *pre, 
   char *sep, 
   char *ter,
   int islocal
)
{	
   int i;
   int arr_range = 0;
   char *type = get_var_type_string( sp, &arr_range );
   int count = 1;
   
	switch(dowhat) 
   {
	case PUTV:

		/*if (sp->hidden&1) break;*/
      
		/*typ2c(sp);*/
    if (sp->type != BIT)
    {
      if ( arr_range > 0 )
         fprintf( ofd, "%s%s %s[%d]%s", pre, type, sp->name, arr_range, ter );
      else
         fprintf( ofd, "%s%s %s%s", pre, type, sp->name, ter );
    }

		break;
    
	case PUTBOOLV:

		/*if (sp->hidden&1) break;*/
      
		/*typ2c(sp);*/
    if (sp->type == BIT)
    {
      if ( arr_range > 0 )
         fprintf( ofd, "%s%s %s[%d]%s", pre, "int", sp->name, arr_range, ter );
      else
         fprintf( ofd, "%s%s %s%s", pre, "int", sp->name, ter );
    }
    else if (sp->type == STRUCT)
    {
      if ( arr_range > 0 )
         fprintf( ofd, "%s%s_bool %s[%d]%s", pre, type, sp->name, arr_range, ter );
      else
         fprintf( ofd, "%s%s_bool %s%s", pre, type, sp->name, ter );
    }

		break;
    
/*	case LOGV:*/
	case INIV:
		if (sp->type == STRUCT)
		{	/* struct may contain a chan */
			walk_struct(ofd, tfd, dowhat, s, sp, pre, sep, ter, islocal);
			break;
		}
		if (!sp->ini /*&& dowhat != LOGV*/)	/* it defaults to 0 */
			break;
    
    if (sp->type==BIT)
      break;

    if (sp->nel == 1)
		{

      if ( sp->type == CHAN || sp->ini->ntyp != CONST || sp->ini->val != 0 )
      {        
         fprintf(ofd, "%s%s%s%s", pre, s, sp->name, sep);
/*	<AR>		if (dowhat == LOGV)
				fprintf(ofd, "%s%s", s, sp->name);
			else
*/
         do_init(ofd, sp, islocal);
			   fprintf(ofd, "%s", ter);
      }
		} 
      else
		   for (i = 0; i < sp->nel; i++)
		   {	
         if ( sp->type == CHAN || sp->ini->ntyp != CONST || sp->ini->val != 0 )
         {
            fprintf(ofd, "%s%s%s[%d]%s", pre, s, sp->name, i, sep);

/* <AR>	   if (dowhat == LOGV)
				   fprintf(ofd, "%s%s[%d]", s, sp->name, i);
			   else
*/
            do_init(ofd, sp, islocal );
			      fprintf(ofd, "%s", ter);
         }
		   }
		break;

   case SETBOOL:
      if ( sp->type == STRUCT )
      {	
         /* struct may contain a chan */
         walk_struct(ofd, tfd, dowhat, s, sp, pre, sep, ter, islocal);
      }
      else if (sp->type == BIT)
      {
         if (sp->nel <= 1)
         {
/*            fprintf( ofd, "\t%s.%s%s = arr.is_var_enabled(%i) ? 1 : 0;\n", ((islocal)? "bool_locals": "bool_globals"), s, sp->name, bool_ind++ );*/
            fprintf( ofd, "\t\t%s%s%s = %i;\n", ((islocal)? "": ""), s, sp->name, bool_ind++ );  
           
         }
         else
         {
            for ( i = 0; i < sp->nel; i++ )
/*               fprintf( ofd, "\t%s.%s%s[%d] = arr.is_var_enabled(%i) ? 1 : 0;\n", ((islocal)? "bool_locals": "bool_globals"), s, sp->name, i, bool_ind++ );*/
              fprintf( ofd, "\t%s%s%s[%d] = %i;\n", ((islocal)? "": ""), s, sp->name, i, bool_ind++ );            
         }
      }

      break;
     
   case GETBOOL:
      if ( sp->type == STRUCT )
      {	
         /* struct may contain a chan */
         walk_struct(ofd, tfd, dowhat, s, sp, pre, sep, ter, islocal);
      }
      else if (sp->type == BIT)
      {
         if (sp->nel <= 1)
         {
            fprintf( ofd, "\t\tarr.set_var(%i, %s.%s%s > 0);\n", bool_ind++, ((islocal)? "bool_locals": "bool_globals"), s, sp->name );
         }
         else
         {
            for ( i = 0; i < sp->nel; i++ )
               fprintf( ofd, "\t\tarr.set_var(%i, %s.%s%s[%d] > 0);\n", bool_ind++, ((islocal)? "bool_locals": "bool_globals"), s, sp->name, i );
         }
      }

      break;

   case TRACEV:
      if ( sp->type == STRUCT )
      {	
         /* struct may contain a chan */
         walk_struct(ofd, tfd, dowhat, s, sp, pre, sep, ter, islocal);
      }
      else if ( sp->type == CHAN ) 
      {
         if (sp->nel <= 1)
         {
            //fprintf( ofd, "%sprint( %s + \" chan: %s%s=\" );\n", pre, sep, s, sp->name );
            fprintf( ofd, "%sif ( trace_queue && (trace_action & GRAPH_ATTR_FORMAT) == 0 )\n", pre );
            fprintf( ofd, "%s\tq = %sget_queue(%s.%s%s);\n", pre, ((islocal)? "state->": ""), ((islocal)? "locals": "globals"), s, sp->name );
            fprintf( ofd, "%sif ( q != 0 )\n%s{\n", pre, pre );
            fprintf( ofd, "%s\tprint( %s + \" chan: %s%s=\" );\n", pre, sep, s, sp->name );
            fprintf( ofd, "%s\tq->trace( trace_action | ACTION_VAR | TRACE_QUEUE, %s.%s%s, %s + TAB );\n", pre, ((islocal)? "locals": "globals"), s, sp->name, sep );
            fprintf( ofd, "%s}\n", pre );
            fprintf( ofd, "%selse\n", pre );
            if ( tfd != 0 )
            {
              fprintf( tfd, "%s%s\n", s, sp->name );
              fprintf( ofd, "%s\tprint_attr_ind( chan_type, %d, %s.%s%s - 1 );\n", pre, var_ind++, ((islocal)? "locals": "globals"), s, sp->name );
            }
            else
              fprintf( ofd, "%s\tprint_attr( \"chan\", \"%s%s\", %s.%s%s - 1 );\n", pre, s, sp->name, ((islocal)? "locals": "globals"), s, sp->name );
         }
         else
         {
            for ( i = 0; i < sp->nel; i++ )
            {
              fprintf( ofd, "%sif ( trace_queue && (trace_action & GRAPH_ATTR_FORMAT) == 0 )\n", pre );
              fprintf( ofd, "%s\tq = %sget_queue(%s.%s%s[%d]);\n", pre, ((islocal)? "state->": ""), ((islocal)? "locals": "globals"), s, sp->name, i );
              fprintf( ofd, "%sif ( q != 0 )\n%s{\n", pre, pre );
              fprintf( ofd, "%s\tprint( %s + \" chan: %s%s[%d]=\" );\n", pre, sep, s, sp->name, i );
              fprintf( ofd, "%s\tq->trace( trace_action | ACTION_VAR | TRACE_QUEUE, %s.%s%s[%d], %s + TAB );\n", pre, ((islocal)? "locals": "globals"), s, sp->name, i, sep );
              fprintf( ofd, "%s}\n", pre );
              fprintf( ofd, "%selse\n", pre );
              if ( tfd != 0 )
              {
                fprintf( tfd, "%s%s[%d]\n", s, sp->name, i );
                fprintf( ofd, "%s\tprint_attr_ind( chan_type, %d, %s.%s%s - 1 );\n", pre, var_ind++, ((islocal)? "locals": "globals"), s, sp->name, i );
              }
              else
                fprintf( ofd, "%s\tprint_attr( \"chan\", \"%s%s[%d]\", %s.%s%s[%d] - 1 );\n", pre, s, sp->name, i, ((islocal)? "locals": "globals"), s, sp->name, i );
            }
         }
      }
      else 
      {
         const char *str_type = get_base_type_str( sp->type );           
         if (sp->nel <= 1)
         {
            /*
            fprintf( ofd, "%sprint( %s ); ", pre, sep );
            */
           
            if (sp->type != BIT)  
            {              
              if ( tfd != 0 )
              {
                fprintf( tfd, "%s%s\n", s, sp->name );
                fprintf( ofd, "\tprint_attr_ind( %s_type, %d, %s.%s%s );\n", ((strcmp( str_type, "uchar") == 0)? "byte": str_type), var_ind++, ((islocal)? "locals": "globals"), s, sp->name );
              }
              else
                fprintf( ofd, "\tprint_attr( \"%s\", \"%s%s\", %s.%s%s );\n", ((strcmp( str_type, "uchar") == 0)? "byte": str_type), s, sp->name, ((islocal)? "locals": "globals"), s, sp->name );
            }
            else
            {
              if ( tfd != 0 )
              {
                fprintf( tfd, "%s%s\n", s, sp->name );
                fprintf( ofd, "\tprint_attr_ind( bool_type, %d, %sbit_arr.is_var_enabled(%s.%s%s) );\n", var_ind++, ((islocal)? "autom_": ""), ((islocal)? "locals_bool": "globals_bool"), s, sp->name );
              }
              else
                fprintf( ofd, "\tprint_attr( \"%s\", \"%s%s\", %sbit_arr.is_var_enabled(%s.%s%s) );\n", "bool", s, sp->name, ((islocal)? "autom_": ""), ((islocal)? "locals_bool": "globals_bool"), s, sp->name );
            }
         }
         else
         {
            for ( i = 0; i < sp->nel; i++ )
            {
              /*fprintf( ofd, "%sprint( %s + \" %s: %s%s[%d]=\", %s.%s%s[%d], %s );\n", pre, sep, ((strcmp( str_type, "uchar") == 0)? "byte": str_type), s, sp->name, i, ((islocal)? "locals": "globals"), s, sp->name, i, ter );*/
              
              /*
              fprintf( ofd, "%sprint( %s ); ", pre, sep);
              */
              if (sp->type != BIT)  
              {              
                if ( tfd != 0 )
                {
                  fprintf( tfd, "%s%s[%d]\n", s, sp->name, i );
                  fprintf( ofd, "\tprint_attr_ind( %s_type, %d, %s.%s%s[%d] );\n", ((strcmp( str_type, "uchar") == 0)? "byte": str_type), var_ind++, ((islocal)? "locals": "globals"), s, sp->name, i );
                }
                else
                  fprintf( ofd, "\tprint_attr( \"%s\", \"%s%s[%d]\", %s.%s%s[%d] );\n", ((strcmp( str_type, "uchar") == 0)? "byte": str_type), s, sp->name, i, ((islocal)? "locals": "globals"), s, sp->name, i );
              }
              else
              {
                if ( tfd != 0 )
                {
                  fprintf( tfd, "%s%s[%d]\n", s, sp->name, i );
                  fprintf( ofd, "\tprint_attr_ind( bool_type, %d, %sbit_arr.is_var_enabled(%s.%s%s[%d]) );\n", var_ind++, ((islocal)? "autom_": ""), ((islocal)? "locals_bool": "globals_bool"), s, sp->name, i );
                }
                else
                  fprintf( ofd, "\tprint_attr( \"%s\", \"%s%s[%d]\", %sbit_arr.is_var_enabled(%s.%s%s[%d]) );\n", "bool", s, sp->name, i, ((islocal)? "autom_": ""), ((islocal)? "locals_bool": "globals_bool"), s, sp->name, i );
              }
            }
         }
      }

      break;
      
   case BOOLCOUNT:
      if (sp->type == BIT)
      {
        bool_count += count * sp->nel;
        count = 1;
        break;
      }
      else if (sp->type == STRUCT)      
        walk_struct(ofd, tfd, dowhat, s, sp, pre, sep, ter, islocal);
     
      if (sp->nel > 1)
        count *= sp->nel;
      
      break;
      
   case CHANCOUNT:
      if (sp->type == CHAN)
      {
        chan_count += count * sp->nel;
        count = 1;
        break;
      }
      else if (sp->type == STRUCT)      
        walk_struct(ofd, tfd, dowhat, s, sp, pre, sep, ter, islocal);
     
      if (sp->nel > 1)
        count *= sp->nel;
      
      break;
	}

   efree( type, strlen( type ) + 1 );
      
   return 0;   
}

/* <AR> modified */
static void do_init(FILE *ofd, Symbol *sp, int islocal )
{	
   int i = 0; 
   extern Queue *ltab[];
   char *q_class = 0;

   if ( sp->ini	&&  
        sp->type == CHAN && 
        ((i = qmake(sp)) > 0) )
   {	
      q_class = get_q_type_carrier_class_name( ltab[i-1]->qcid );

      if ( sp->ini->ntyp == CHAN )
         fprintf(ofd, "%sadd_queue( %d, new %s() )", ((islocal)? "state->": ""), ltab[i-1]->nslots, q_class );
		  else
      {
         /*for variables and constants??????????*/
         //fprintf(ofd, "%d", i);
         putstmnt(ofd, sp->ini, 0);
      }

      efree( q_class, strlen( q_class ) + 1 );
   } 
   else
		putstmnt(ofd, sp->ini, 0);
}

static int
blog(int n)	/* for small log2 without rounding problems */
{	int m=1, r=2;

	while (r < n) { m++; r *= 2; }
	return 1+m;
}

/*static void
put_ptype(char *s, int i, int m0, int m1)
{	int k;

	fprintf(th, "typedef struct P%d { /* %s *//*\n", i, s);
	fprintf(th, "	unsigned _pid : 8;  /* 0..255 *//*\n");
	fprintf(th, "	unsigned _t   : %d; /* proctype *//*\n", blog(m1));
	fprintf(th, "	unsigned _p   : %d; /* state    *//*\n", blog(m0));
	LstSet = ZS;
	nBits = 8 + blog(m1) + blog(m0);
	k = dolocal(tc, "", PUTV, i, s, "");	/* includes pars */
/*	fprintf(th, "} P%d;\n", i);
	if (!LstSet && k > 0)
		fprintf(th, "#define Air%d	0\n", i);
	else
	{	fprintf(th, "#define Air%d	(sizeof(P%d) - ", i, i);
		if (k == 0)
		{	fprintf(th, "%d", (nBits+7)/8);
			goto done;
		}
		if ((LstSet->type != BIT && LstSet->type != UNSIGNED)
		||   LstSet->nel != 1)
		{	fprintf(th, "Offsetof(P%d, %s%s) - %d*sizeof(",
				i, LstSet->name,
#if 1
				"",
#else
				(LstSet->nel > 1)?"[0]":"",
#endif
				LstSet->nel);
		}
		switch(LstSet->type) {
		case UNSIGNED:
			fprintf(th, "%d", (nBits+7)/8);
			break;
		case BIT:
			if (LstSet->nel == 1)
			{	fprintf(th, "%d", (nBits+7)/8);
				break;
			}	/* else fall through */
/*		case MTYPE: case BYTE: case CHAN:
			fprintf(th, "uchar)"); break;
		case SHORT:
			fprintf(th, "short)"); break;
		case INT:
			fprintf(th, "int)"); break;
		default:
			fatal("cannot happen Air %s",
				LstSet->name);
		}
done:		fprintf(th, ")\n");
	}
}
*/
static void
tc_predef_np(void)
{	int i = nrRdy;	/* 1+ highest proctype nr */

	fprintf(th, "#define _NP_	%d\n", i);
	if (separate == 2) fprintf(th, "extern ");
	fprintf(th, "uchar reached%d[3];  /* np_ */\n", i);

	fprintf(th, "#define nstates%d	3 /* np_ */\n", i);
	fprintf(th, "#define endstate%d	2 /* np_ */\n\n", i);
	fprintf(th, "#define start%d	0 /* np_ */\n", i);

	fprintf(tc, "\tcase %d:	/* np_ */\n", i);
	if (separate == 1)
	{	fprintf(tc, "\t\tini_claim(%d, h);\n", i);
	} else
	{	fprintf(tc, "\t\t((P%d *)pptr(h))->_t = %d;\n", i, i);
		fprintf(tc, "\t\t((P%d *)pptr(h))->_p = 0;\n", i);
		fprintf(tc, "\t\treached%d[0] = 1;\n", i);
		fprintf(tc, "\t\taccpstate[%d][1] = 1;\n", i);
	}
	fprintf(tc, "\t\tbreak;\n");
}
/*
static void
put_pinit(ProcList *P)
{	Lextok	*fp, *fpt, *t;
	Element	*e = P->s->frst;
	Symbol	*s = P->n;
	Lextok	*p = P->p;
	int	 i = P->tn;
	int	ini, j, k;

	if (i == claimnr
	&&  separate == 1)
	{	fprintf(tc, "\tcase %d:	/* %s *//*\n", i, s->name);
		fprintf(tc, "\t\tini_claim(%d, h);\n", i);
		fprintf(tc, "\t\tbreak;\n");
		return;
	}
	if (i != claimnr
	&&  separate == 2)
		return;

	ini = huntele(e, e->status, -1)->seqno;
	fprintf(th, "#define start%d	%d\n", i, ini);
	if (i == claimnr)
	fprintf(th, "#define start_claim	%d\n", ini);
	if (i == eventmapnr)
	fprintf(th, "#define start_event	%d\n", ini);

	fprintf(tc, "\tcase %d:	/* %s *//*\n", i, s->name);

	fprintf(tc, "\t\t((P%d *)pptr(h))->_t = %d;\n", i, i);
	fprintf(tc, "\t\t((P%d *)pptr(h))->_p = %d;", i, ini);
	fprintf(tc, " reached%d[%d]=1;\n", i, ini);

	if (has_provided)
	{	fprintf(tt, "\tcase %d: /* %s *//*\n\t\t", i, s->name);
		if (P->prov)
		{	fprintf(tt, "if (");
			putstmnt(tt, P->prov, 0);
			fprintf(tt, ")\n\t\t\t");
		}
		fprintf(tt, "return 1;\n");
		if (P->prov)
			fprintf(tt, "\t\tbreak;\n");
	}

	fprintf(tc, "\t\t/* params: *//*\n");
	for (fp  = p, j=0; fp; fp = fp->rgt)
	for (fpt = fp->lft; fpt; fpt = fpt->rgt, j++)
	{	t = (fpt->ntyp == ',') ? fpt->lft : fpt;
		if (t->sym->nel != 1)
		{	lineno = t->ln;
			Fname  = t->fn;
			fatal("array in parameter list, %s",
			t->sym->name);
		}
		fprintf(tc, "\t\t((P%d *)pptr(h))->", i);
		if (t->sym->type == STRUCT)
		{	if (full_name(tc, t, t->sym, 1))
			{	lineno = t->ln;
				Fname  = t->fn;
				fatal("hidden array in parameter, %s",
				t->sym->name);
			}
		} else
			fprintf(tc, "%s", t->sym->name);
		fprintf(tc, " = par%d;\n", j);
	}
	fprintf(tc, "\t\t/* locals: *//*\n");
	k = dolocal(tc, "", INIV, i, s->name, "");
	if (k > 0)
	{	fprintf(tc, "#ifdef VAR_RANGES\n");
		(void) dolocal(tc, "logval(\"", LOGV, i, s->name, "");
		fprintf(tc, "#endif\n");
	}
	dumpclaims(tc, i, s->name);
	fprintf(tc, "\t	break;\n");
}
*/
Element *
huntstart(Element *f)
{	Element *e = f;

	if (e->n)
	{	if (e->n->ntyp == '.' && e->nxt)
			e = e->nxt;
#if 0
		else if (e->n->ntyp == ATOMIC
		     ||  e->n->ntyp == D_STEP
		     ||  e->n->ntyp == NON_ATOMIC)
			e->n->sl->this->last->nxt = e->nxt;
#endif
		else if (e->n->ntyp == UNLESS)
			return e->sub->this->frst;
	}
	return e;
}

Element *
huntele(Element *f, int o, int stopat)
{	Element *g, *e = f;
	int cnt; /* a precaution against loops */

	if (e)
	for (cnt=0; cnt < 10 && e->n; cnt++)
	{
		if (e->seqno == stopat)
			break;

		switch (e->n->ntyp) {
		case GOTO:
			g = get_lab(e->n,1);
			cross_dsteps(e->n, g->n);
			break;
		case '.':
		case BREAK:
			if (!e->nxt)
				return e;
			g = e->nxt;
			break;
		case UNLESS:
			g = huntele(e->sub->this->frst, o, stopat);
			break;
#if 0
		case D_STEP:
		case ATOMIC:
		case NON_ATOMIC:
			e->n->sl->this->last->nxt = e->nxt;
#endif
		default:	/* fall through */
			return e;
		}
		if ((o & ATOM) && !(g->status & ATOM))
			return e;
		e = g;
	}
	return e;
}

static void
ncases(FILE *fd, int p, int n, int m, char *c[])
{	int i, j;

	for (j = 0; c[j]; j++)
	for (i = n; i < m; i++)
	{	fprintf(fd, c[j], i, p, i);
		fprintf(fd, "\n");
	}
}

char* get_var_type_string( Symbol *sp, int *arr_range )
{
   char *ret_str = 0;
   char type_name[256];

	*arr_range = 0;

   memset( type_name, 0, sizeof(type_name) );
	switch ( sp->type ) 
   {
	case UNSIGNED:
    if (sp->hidden&1)
      sprintf( type_name, "uchar" );
    else
      sprintf( type_name, "uint" );
    break;

  case BIT:
    if (sp->nel == 1 && !(sp->hidden&1))
    {	
      sprintf( type_name, "uchar" );
      break;
    } /* else fall through */
    /* AR 
    if (!(sp->hidden&1))
      printf("spin: warning: bit-array %s[%d] mapped to byte-array\n", sp->name, sp->nel);
    */
  case MTYPE:
  case BYTE:
    sprintf( type_name, "uchar" );
    break;

  case CHAN:	
    sprintf( type_name, "QueueRef" );
    break;

  case SHORT:
    sprintf( type_name, "short" );
    break;

  case INT:
    sprintf( type_name, "int" );
    break;

  case STRUCT:
    if (!sp->Snm)
      fatal("undeclared structure element %s", sp->name);
    sprintf( type_name, "struct %s", sp->Snm->name );
    break;

  case PREDEF:
    return ret_str;

  default:
    fatal("variable %s undeclared", sp->name);
  }

   ret_str = emalloc( strlen( type_name ) + 1 );

   if ( ret_str == 0 )
      fatal("memory deplited", "");
   
   memcpy( ret_str, type_name, strlen( type_name ) );
	if (sp->nel != 1)
		*arr_range = sp->nel;


   return ret_str;
}

/* the function generate queue element class name
   by the queue variable name*/
char *get_queue_el_class_name( short cid )
{
   const char* q_prefix = "Queue";
   char *c_name = 0;
   char name[255];

   memset( name, 0, sizeof(name) );

   sprintf( name, "%s%d", q_prefix, cid );
   c_name = emalloc( strlen(name) + 1);

   if ( c_name != 0 )
      sprintf( c_name, "%s", name );

   return c_name;
}

char *get_q_type_carrier_class_name( short cid )
{
   const char* q_prefix = "Queue";
   const char* q_suffix = "TypeCarrier";
   char *c_name = 0;
   char name[255];

   memset( name, 0, sizeof(name) );

   sprintf( name, "%s%d%s", q_prefix, cid, q_suffix );
   c_name = emalloc( strlen(name) + 1);

   if ( c_name != 0 )
      sprintf( c_name, "%s", name );

   return c_name;
}

const char *get_base_type_str( int type )
{
   switch ( type ) 
   {
	case BIT:
   case MTYPE:
   case BYTE:
      return "uchar";
   case CHAN:
      return "QueueRef";
   case SHORT:
		return "short";
	case INT:
		return "int";
	default:
		;
	}

   return "";
}
/* <AR> generate queue element classes analog of 'genaddqueue' from pangen1.c */
void gen_queue_el_classes( FILE *th, FILE *tc, Queue *qtab )
{
   int j;
   Queue *q;
   char *q_class_name = 0;
   char *q_carrier_class_name = 0;
   
   for (q = qtab; q; q = q->nxt)
   {	
      if ( q->qid != q->qcid)
         continue;

      q_class_name = get_queue_el_class_name( q->qcid );
      q_carrier_class_name = get_q_type_carrier_class_name( q->qcid );

      if ( q_class_name == 0 || q_carrier_class_name == 0 )
         fatal("memory deplited in gen_queue_el_classes","");

      fprintf( th, "class %s: public QueueEl\n", q_class_name );
      fprintf( th, "{\n" );
      /* <AR> private section */
      fprintf( th, "private:\n" );
      fprintf( th, "\tstatic const short fld_count;\n" );
      fprintf( th, "public:\n" );
      fprintf( th, "\tstatic const short type_id;\n" );
      
      /* <AR> put fields 
         all fields are public*/
      fprintf( th, "public:\n" );
      for ( j = 0; j < q->nflds; j++ )
      {	
        switch (q->fld_width[j]) 
        {
        case BIT:
            fprintf(th, "\t/* BIT: 1 */\n" );
            fprintf(th, "\tuchar fld%d ;\n", j);
            break;
        case MTYPE:
            fprintf(th, "\t/* MTYPE */\n" );
            fprintf(th, "\tuchar fld%d;\n", j);
            break;
        case BYTE:
            fprintf(th, "\t/* BYTE */\n" );
            fprintf(th, "\tuchar fld%d;\n", j);
            break;
        case CHAN:
            fprintf(th, "\tQueueRef fld%d;\n", j);
            break;
        case SHORT:
            fprintf(th, "\tshort fld%d;\n", j);
            break;
        case INT:
            fprintf(th, "\tint fld%d;\n", j);
            break;
        default:
            fatal("bad channel spec ", "");
        }
      }

      /* <AR> put public declaration of overridden methods*/
      fprintf( th, "public:\n" );
      fprintf( th, "\t%s( )\n\t{\n", q_class_name);
      
      for ( j = 0; j < q->nflds; j++ )
      {
        fprintf( th, "\t\tfld%d = 0;\n", j );
      }
      fprintf( th, "\t}\n" );
      
      fprintf( th, "\t~%s( ) { }\n", q_class_name );
      fprintf( th, "\tvoid set( int count, ... );\n" );
      fprintf( th, "\tbool get( int ind, ... );\n" );
      fprintf( th, "\tbool equal( string fld_mask, QueueEl *el );\n" );
      fprintf( th, "\tbool equal_fld( int ind, ... /*var*/ );\n" );
      fprintf( th, "\tint fld_number() { return fld_count; }\n" );
      fprintf( th, "\tint get_type() { return type_id; }\n" );
      fprintf( th, "\tClonable* clone();\n" );
      fprintf( th, "\n\tvoid trace_fld( unsigned long trace_action, long extra_info = 0, const string &line_prefix = \"\" );\n" );
      
      fprintf( th, "};\n" );
      fprintf( th, "const short %s::fld_count = %d;\n", q_class_name, q->nflds );
      fprintf( th, "const short %s::type_id = %d;\n\n", q_class_name, q->qcid );

      /* <AR> put queue type carrier class */
      fprintf( th, "class %s: public QueueTypeCarrier\n", q_carrier_class_name );
      fprintf( th, "{\n" );
      fprintf( th, "public:\n" );
      fprintf( th, "\t%s() { }\n", q_carrier_class_name );
      fprintf( th, "\t~%s() { }\n", q_carrier_class_name );
      fprintf( th, "\tint get_type() { return %s::type_id; }\n", q_class_name );
      fprintf( th, "\tQueueEl* new_element() { return new %s(); }\n", q_class_name );
      fprintf( th, "\tClonable* clone() { return new %s(); }\n", q_carrier_class_name );
      fprintf( th, "};\n\n" );
                  
      /* <AR> put implementation of overridden methods*/
      /* void set( int count, ... )*/
      fprintf( tc, "void %s::set( int count, ... )\n", q_class_name );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tint fld_count = min( count, fld_number() );\n" );
      fprintf( tc, "\tva_list args;\n" );
      fprintf( tc, "\tva_start( args, count );\n\n" );
      fprintf( tc, "\tfor ( int i = 0; i < fld_count; i++ )\n" );
      fprintf( tc, "\t{\n" );
      fprintf( tc, "\t\tswitch ( i )\n" );
      fprintf( tc, "\t\t{\n" );
      for ( j = 0; j < q->nflds; j++ )
      {
         const char* str_type = get_base_type_str( q->fld_width[j] );
         fprintf( tc, "\t\tcase %d:\n", j );

         if ( strcmp(str_type, "uchar") == 0 )
            fprintf( tc, "\t\t   fld%d = (uchar)va_arg( args, int );\n", j );
         else
            fprintf( tc, "\t\t   fld%d = va_arg( args, %s );\n", j, str_type ); 
         fprintf( tc, "\t\t   break;\n" );
      }
      fprintf( tc, "\t\t}\n" );
      fprintf( tc, "\t}\n" );      
      fprintf( tc, "\n\tva_end( args );\n" );
      fprintf( tc, "}\n\n" );

      /* void get( int ind, ...)*/
      fprintf( tc, "bool %s::get( int ind, ... )\n", q_class_name );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tva_list args;\n\n" );
      fprintf( tc, "\tif ( ind >= fld_number() || ind < 0 )\n" );
      fprintf( tc, "\t   return false;\n\n" );
      fprintf( tc, "\tva_start( args, ind );\n\n" );
      fprintf( tc, "\tswitch( ind )\n" );
      fprintf( tc, "\t{\n" );

      for ( j = 0; j < q->nflds; j++ )
      {
         const char *str_type = get_base_type_str( q->fld_width[j] );
         fprintf( tc, "\tcase %d:\n", j );
         fprintf( tc, "\t  {\n" );
         fprintf( tc, "\t\t%s *tmp = va_arg( args, %s* );\n", str_type, str_type );
         fprintf( tc, "\t\t*tmp = fld%d;\n", j ); 
         fprintf( tc, "\t  }\n" );
         fprintf( tc, "\t  break;\n" );
      }

      fprintf( tc, "\t}\n" );
      fprintf( tc, "\tva_end( args );\n\n" );
      fprintf( tc, "\treturn true;\n" );
      fprintf( tc, "}\n\n" );

      /* bool equal( string fld_mask, QueueEl *el );*/
      fprintf( tc, "bool %s::equal( string fld_mask, QueueEl *el )\n", q_class_name );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tbool res = true;\n" );
      fprintf( tc, "\tif ( el == 0 )\n" );
      fprintf( tc, "\t   return false;\n\n" );
      fprintf( tc, "\tif ( get_type() != el->get_type() )\n" );
      fprintf( tc, "\t   return false;\n\n" );
      fprintf( tc, "\tint fld_count = min( fld_number(), (int)(fld_mask.length()) );\n\n" );
      fprintf( tc, "\t%s *the_el = dynamic_cast<%s*>(el);\n\n", q_class_name, q_class_name );
      fprintf( tc, "\tif ( the_el == 0 )\n" );
      fprintf( tc, "\t   return false;\n\n" );
      fprintf( tc, "\tfor ( int i = 0; (i < fld_count) && res; i++ )\n" );
      fprintf( tc, "\t{\n" );

      fprintf( tc, "\t\tif ( fld_mask[i] == '1' )\n" );
      fprintf( tc, "\t\t{\n" );
      fprintf( tc, "\t\t\tswitch( i )\n" );
      fprintf( tc, "\t\t\t{\n" );

      for ( j = 0; j < q->nflds; j++ )
      {
         fprintf( tc, "\t\t\tcase %d:\n", j );
         fprintf( tc, "\t\t\t  if ( fld%d != the_el->fld%d )\n", j, j ); 
         fprintf( tc, "\t\t\t     res = false;\n" ); 
         fprintf( tc, "\t\t\t  break;\n" ); 
      }

      fprintf( tc, "\t\t\t}\n" );
      fprintf( tc, "\t\t}\n" );
      
      fprintf( tc, "\t}\n\n" );
      fprintf( tc, "\treturn res;\n" );
      fprintf( tc, "}\n\n" );

      /*bool equal_fld( int ind, ... )*/
      fprintf( tc, "bool %s::equal_fld( int ind, ... )\n", q_class_name );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tbool res = false;\n" );
      fprintf( tc, "\tva_list args;\n\n" );
      fprintf( tc, "\tif ( ind >= fld_number() || ind < 0 )\n" );
      fprintf( tc, "\t   return false;\n\n" );
      fprintf( tc, "\tva_start( args, ind );\n\n" );
      fprintf( tc, "\tswitch( ind )\n" );
      fprintf( tc, "\t{\n" );

      for ( j = 0; j < q->nflds; j++ )
      {
         const char *str_type = get_base_type_str( q->fld_width[j] );

         fprintf( tc, "\tcase %d:\n", j );
         if ( strcmp(str_type, "uchar") == 0 )
            fprintf( tc, "\t   res = (fld%d == (uchar)va_arg( args, int ));\n", j );
         else
            fprintf( tc, "\t   res = (fld%d == va_arg( args, %s ));\n", j, str_type );

         fprintf( tc, "\t   break;\n" );
      }

      fprintf( tc, "\t}\n" );
      fprintf( tc, "\tva_end( args );\n\n" );
      fprintf( tc, "\treturn res;\n" );
      fprintf( tc, "}\n\n" );

      /* Clonable* clone() */
      fprintf( tc, "Clonable* %s::clone( )\n", q_class_name );
      fprintf( tc, "{\n" );
      fprintf( tc, "\t%s *the_clone = new %s( );\n\n", q_class_name, q_class_name );
      fprintf( tc, "\tif ( the_clone != 0 )\n" );
      
      fprintf( tc, "\t\tthe_clone->set( %d, ", q->nflds );
      for ( j = 0; j < q->nflds; j++ )
      {
         if (j != 0 )
            fprintf( tc, ", fld%d", j );
         else
            fprintf( tc, "fld%d", j );
      }
      fprintf( tc, " );\n\n" );

      fprintf( tc, "\treturn the_clone;\n" );
      fprintf( tc, "}\n\n" );

      /* void trace_fld(...) */
      fprintf( tc, "void %s::trace_fld( unsigned long trace_action, long extra_info, const string &line_prefix )\n", q_class_name );
      fprintf( tc, "{\n" );
      fprintf( tc, "\tprint( line_prefix + \"{\" );\n" );
      
      for ( j = 0; j < q->nflds; j++ )
      {
        if ( q->fld_width[j] == CHAN )
          fprintf( tc, "\tprint( \" chan: fld%d=\", fld%d, \"%s\" );\n", j, j, "; " );
        else
        {
          const char *str_type = get_base_type_str( q->fld_width[j] );
          fprintf( tc, "\tprint( \" %s: fld%d=\", fld%d, \"%s\" );\n", ((strcmp( str_type, "uchar") == 0)? "byte": str_type), j, j, ";" );
        }
      }
      fprintf( tc, "\tprint( \"}\" + EOL );\n" );
      fprintf( tc, "}\n\n" );


      efree( q_carrier_class_name, strlen( q_carrier_class_name ) + 1 );
      efree( q_class_name, strlen( q_class_name ) + 1 );
	}

}
