
#include <string.h>
#include "never_graph.h"
#include "tl.h"

static int never_node_index = 0;
static int accept_all_node_index = 0;
static int never_graph_printed = 0;

extern State* findstate(char *nm);
extern Graph	*findgraph(char *);
extern void put_uform_to( FILE *fd );

extern int Max_Red;

static void print_ltl_node( FILE *fd, Node *node );

void print_never_graph_header( FILE *fd, const char *comment )
{
  if ( fd != 0 && never_graph_printed == 0 ) 
  {
    never_node_index = 1;
    //header
    fprintf( fd, "graph" );   
    fprintf( fd, "001.000\n" );
    fprintf( fd, "Never clime graph\n" ); 
    fprintf( fd, "ASC\n" );
    
    //extra info
    if ( comment != 0 )
      fprintf( fd, "Comment: %s\n", comment );
    fprintf( fd, "\n" );
    
    //graph info block
    //graph attribute templates
    
    fprintf( fd, "State{ text: label=\"\"; byte: algorithm_stage=0; bool: accept=0; bool: redundant=0; text: ltl_subformula=""; }\n" );
    
    fprintf( fd, ":\n" );
  }
}

void print_never_graph_header_ltl( FILE *fd, State *never, const char *comment )
{
  if ( fd != 0 && never_graph_printed == 0 ) 
  {
    State *s;
    never_node_index = 1;
    accept_all_node_index = 0;
    //header
    fprintf( fd, "graph" );   
    fprintf( fd, "001.000\n" );
    fprintf( fd, "Never clime graph\n" ); 
    fprintf( fd, "ASC\n" );
    
    //extra info
    if ( comment != 0 )
      fprintf( fd, "Comment: %s\n", comment );
    fprintf( fd, "\n" );
    
    //graph info block
    //graph attribute templates
    
    fprintf( fd, "State{ text: label=\"\"; byte: algorithm_stage=0; bool: accept=0; bool: redundant=0; text: ltl_subformula=\"\"; TransitionConditions{" );
    for ( s = never; s != 0; s = s->nxt )
      fprintf( fd, " text: %s=\"\";", s->name->name );
    fprintf( fd, " text: accept_all=\"\";}}\n" );
    
    fprintf( fd, ":\n" );
  }
}

void print_never_graph_end( FILE *fd )
{
  if ( fd != 0 && never_graph_printed == 0 ) 
  {
    //end of graph info block
    fprintf( fd, "\n" );
    //filters
    fprintf( fd, ":\n" );
    //renddering options
    fprintf( fd, "Range: 50\n" );
    fprintf( fd, "V_distance: 40\n" );
    fprintf( fd, "H_distance: 40\n" );
    fprintf( fd, "Spline: true\n" );
    fprintf( fd, ":\n" );
    //general drawing options
    fprintf( fd, ":\n" );
    
    //groups
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: default\n");
    fprintf( fd, "Shape: circle\n");
    fprintf( fd, "Filled: false\n");
    fprintf( fd, "Shape_xy_ratio: 1.0 1.0\n");
    fprintf( fd, "FG_color: 0 0 0 0\n");
    fprintf( fd, "Label_font: 255 0 0 0 8 NORMAL \n");
    fprintf( fd, "Drawing_pen: SOLID 1\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: Accepted\n");
    fprintf( fd, "Shape: double circle\n");
    fprintf( fd, "Assigning: { accept=1; }\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: Algorithm stage 1\n");
    fprintf( fd, "FG_color: 255 20 20 0\n");
    fprintf( fd, "Assigning: { algorithm_stage=1; }\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: Algorithm stage 2\n");
    fprintf( fd, "FG_color: 20 20 255 0\n");
    fprintf( fd, "Assigning: { algorithm_stage=2; }\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: Algorithm stage 3\n");
    fprintf( fd, "FG_color: 0 150 0 0\n");
    fprintf( fd, "Assigning: { algorithm_stage=3; }\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: Redundant never states\n");
    fprintf( fd, "FG_color: 220 220 255 0\n");
    fprintf( fd, "Filled: true\n");
    fprintf( fd, "Assigning: { redundant=1; }\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, "{:\n");
    fprintf( fd, "Name: Init state\n");
    fprintf( fd, "Shape: rectangular\n");
    fprintf( fd, "Shape_xy_ratio: 2.0 1.0\n");
    fprintf( fd, "Assigning: { label >= \"init\"; algorithm_stage <> 3;}\n");
    fprintf( fd, "}:\n");
    
    fprintf( fd, ":\n");
    
    //labels
    fprintf( fd, "{:\n");
    fprintf( fd, "{}\n");
    fprintf( fd, "{::label}\n");
    fprintf( fd, "}:\n");
    //end vis. options
    fprintf( fd, "\n" );
    never_graph_printed = 1;
    fclose(fd);
  }
}

static void print_ltl_operator( FILE *fd, short	ntyp )
{
  switch( ntyp )
  {
  case OR: 
    fprintf(fd, "||");
    break;
  case AND:
    fprintf(fd, "&&");
    break;
  case U_OPER: 
    fprintf(fd, "U");
    break;
  case V_OPER: 
    fprintf(fd, "V");
    break;
#ifdef NXT
  case NEXT:
    fprintf(fd, "X");
    break;
#endif
  case NOT:
    fprintf(fd, "!");
    break;
  case FALSE:
    fprintf(fd, "false");
    break;
  case TRUE:
    fprintf(fd, "true");
    break;
  case PREDICATE:
    fprintf(fd, "PREDICATE" );
    break;
  case -1:
    fprintf(fd, " D ");
    break;
  default:
    printf("Unknown token: %d", ntyp);
    break;
  }
}

static void PrintPinOp( FILE *fd, Node *n )
{
  fprintf(fd, "(");
  if ( n->lft )	
    print_ltl_node( fd, n->lft);
  else
    fprintf( fd, "(true)" );
  fprintf( fd, " " );
  print_ltl_operator( fd, n->ntyp );
  fprintf( fd, " " );
  if ( n->rgt )	
    print_ltl_node( fd, n->rgt);
  else
    fprintf( fd, "(true)" );
  fprintf(fd, ")");
}

static void print_ltl_node( FILE *fd, Node *node )
{
  Node *n = 0;
  
  if ( node == 0 )
    return;
    
  switch(node->ntyp) 
  {
  case OR: 
  case AND:  
  case U_OPER: 
  case V_OPER: 
    PrintPinOp( fd, node ); 
    break;
#ifdef NXT
  case NEXT:
    fprintf(fd, "X");
    fprintf(fd, " (");
    print_ltl_node( fd, node->lft );
    fprintf(fd, ")");
    break;
#endif
  case NOT:
    fprintf(fd, "!");
    fprintf(fd, " (");
    print_ltl_node( fd, node->lft);
    fprintf(fd, ")");
    break;
  case FALSE:
    fprintf(fd, "false");
    break;
  case TRUE:
    fprintf(fd, "true");
    break;
  case PREDICATE:
    fprintf(fd, "(%s)", node->sym->name);
    break;
  case -1:
    fprintf(fd, " D ");
    break;
  default:
    printf("Unknown token: %d", node->ntyp);
    break;
  }
  
  for ( n = node->nxt; n != 0; n = n->nxt )
  {
    fprintf( fd, ", " );
    print_ltl_node( fd, n );
  }
  
}

void print_never_graph_node( FILE *fd, State* state, int put_redundant, int internal ) 
{
  if ( fd != 0 && never_graph_printed == 0 ) 
  {
    Transition *trans;
    
    state->index = never_node_index++;
    fprintf( fd, "%d:State{ ", state->index );
    fprintf( fd, "text: label = \"%s\"; ", state->name->name );
    fprintf( fd, "byte: algorithm_stage = %d; ", internal );
    if ( put_redundant )
      fprintf( fd, "bool: redundant = %d; ", ((state->redundant || !state->reachable)? 1: 0) );
    fprintf( fd, "bool: accept = %d; ", state->accepting );
    
    fprintf( fd, "text: ltl_subformula = \"" );
    print_ltl_node( fd, state->colors->Old );
    fprintf( fd, "\"; " );
    fprintf( fd, "TransitionConditions{" );
    for ( trans = state->trans; trans != 0; trans = trans->nxt )
    {
      fprintf( fd, " text: %s = \"", trans->name->name );
      
      if ( trans->cond )
        print_ltl_node( fd, trans->cond );
      else
        fprintf( fd, "true" );
      fprintf( fd, "\";" );
    }
    
    fprintf( fd, "}" );
    fprintf( fd, "}\n" );
  }
}

void print_never_graph_edges( FILE *fd, State* never )
{
  if ( fd != 0 && never_graph_printed == 0 )
  {
    State *s1;
    State *s2;
    Transition *t;
    
    for ( s1 = never; s1 != 0; s1 = s1->nxt )
    {
      if ( s1->index == 0 )
        continue;
      
      for ( t = s1->trans; t != 0; t = t->nxt )
      {
        if ( strcmp(t->name->name, "accept_all" ) == 0 )
        {  
          if ( accept_all_node_index != 0 )
          fprintf( fd, "%d-> %d\n", s1->index, accept_all_node_index );
        }
        else
        {
          s2 = findstate(t->name->name);
          if ( s2 )
            if ( s2->index != 0 )
              fprintf( fd, "%d-> %d\n", s1->index, s2->index );
        }
      }
    }
  }
}

void print_never_accept_all_node( FILE *fd, int put_redundant, int internal )
{
  if ( fd != 0 && never_graph_printed == 0 )
  {
    Transition *trans;
    
    accept_all_node_index = never_node_index++;
    fprintf( fd, "%d:State{ ", accept_all_node_index );
    fprintf( fd, "text: label = \"accept_all\"; " );
    if ( put_redundant )
      fprintf( fd, "bool: redundant = 0; " );
    fprintf( fd, "byte: algorithm_stage = %d; ", internal );
    fprintf( fd, "bool: accept = 1; " );
    fprintf( fd, "text: ltl_subformula = \"\"; " );
    fprintf( fd, "TransitionConditions{" );
    
    fprintf( fd, " text: accept_all = \"true\";" );
    
    fprintf( fd, "}" );
    fprintf( fd, "}\n" );
  }
}

void print_never_accept_all_edge( FILE *fd )
{
  if ( fd != 0 && never_graph_printed == 0 && accept_all_node_index != 0)
  {
    fprintf( fd, "%d-> %d\n", accept_all_node_index, accept_all_node_index );
  }
}

static void print_never_ltl_node( FILE *fd, Graph *p )
{
  unsigned char i;
  unsigned char j;
  int delta = 0;
  
  p->index = never_node_index++;
  fprintf( fd, "%d:State{ ",  p->index );
  fprintf( fd, "text: label = \"%s\"; ", p->name->name );
  fprintf( fd, "byte: algorithm_stage = 1; " );
  fprintf( fd, "text: original_ltl_formula = \"" );
  put_uform_to( fd );
  fprintf( fd, "\"; " );
/*   
  fprintf( fd, "text: ltl_operator = \"" );
  print_ltl_operator( fd, p->Old->ntyp );
  fprintf( fd, "\"; " );
 
  fprintf( fd, "text: New = \"" );
  print_ltl_node( fd, p->New );
  fprintf( fd, "\"; " );
*/  
  fprintf( fd, "text: Old = \"" );
  print_ltl_node( fd, p->Old );
  fprintf( fd, "\"; " );
  
  fprintf( fd, "text: Next = \"" );
  print_ltl_node( fd, p->Next );
  fprintf( fd, "\"; " );
  
  fprintf( fd, "text: Other = \"" );
  print_ltl_node( fd, p->Other );
  fprintf( fd, "\";" );
  
  fprintf( fd, "byte: acceptance_classes = %d;", Max_Red );
  
  fprintf( fd, "GreenAcceptance{" );
  for ( j = 1; j <= Max_Red; j++ )
  {
    delta = 0;
    for ( i = 0; i < p->grncnt && delta == 0; i++ )
      delta = (p->isgrn[i] == j);
    fprintf( fd, " bool: acceptance[%d] = %d;", j, delta );
  }
  fprintf( fd, "} " );  
    
  fprintf( fd, "RedAcceptance{" );
  for ( j = 1; j <= Max_Red; j++ )
  {
    delta = 0;
    for ( i = 0; i < p->redcnt && delta == 0; i++ )
      delta = p->isred[i] == j;
    fprintf( fd, " bool: acceptance[%d] = %d;", j, delta );
  }
  fprintf( fd, "} " );

  fprintf( fd, "Acceptance{" );
  for ( i = 1; i <= Max_Red; i++ )
  {
    delta = 0;
    int k;
    for (k = 0; k < (int) p->grncnt; k++)
      if (p->isgrn[k] == i)
      {	
        delta = 1;
        break;
      }
          
    if (!delta)
    {	
      delta = 1;
      for (k = 0; k < (int) p->redcnt; k++)
        if (p->isred[k] == i)
        {	
          delta = 0;
          break;
        }
    
    }   
          
   fprintf( fd, " bool: acceptance[%d] = %d;", i, delta );
  }
  fprintf( fd, "} " );  
  
  fprintf( fd, "AcceptanceCounter{" );
  for ( j = 0; j <= Max_Red; j++ )
  {
    int inc_count = 0;
    if ( p->outgoing )
      for ( i = j + 1; i <= Max_Red; i++ )
      {
        delta = 0;
        int k;
        for (k = 0; k < (int) p->grncnt; k++)
          if (p->isgrn[k] == i)
          {	delta = 1;
            break;
          }
          
        if (delta)
        {	
          inc_count++;
          continue;
        }
          
        for (k = 0; k < (int) p->redcnt; k++)
          if (p->isred[k] == i)
          {	delta = 1;
            break;
          }
    
        if ( delta ) break;
          
        inc_count++;
      }
    fprintf( fd, " bool: counter_path[%d] = %d;", j, inc_count );
  }
  
  fprintf( fd, "} " );
  
  
  fprintf( fd, "}\n" );
}

void print_never_ltl_graph( FILE *fd, Graph *g )
{
  if ( fd != 0 && never_graph_printed == 0 )
  {
    Graph *p;
    Graph *p2;
    Symbol *t;
    
    for ( p = g; p; p = p->nxt )
      print_never_ltl_node( fd, p );
    
    for ( p = g; p; p = p->nxt )
    {
      for ( t = p->outgoing; t; t = t->next )
      {
        p2 = findgraph( t->name );
        
        if ( p2 )
          fprintf( fd, "%d-> %d\n", p->index, p2->index );
      }
    }
  }
}

