#include "graphics.h"
#include <iostream>
#include "Layout.h"
#include "shapes.h"

using namespace GraphGraphics;

void GraphLayout::set_edges_coords()
{
	NodeIndex		i;
	VEdge			*e;
	SplineCoords	*s, *s1;
	
	for (i = 0; i < (NodeIndex)m_edges.size(); i++)
	{
		e = m_edges[i];
		if (m_nodes[e->tail_indx]->node_type == NORMAL && m_nodes[e->head_indx]->node_type == NORMAL) 
		{
			s = new SplineCoords();  			
			s->start.set_x(m_nodes[e->tail_indx]->center.get_x());
			s->end.set_x(m_nodes[e->head_indx]->center.get_x());
			s->middle.set_x((s->start.get_x() + s->end.get_x()) / 2);

			if (m_nodes[e->tail_indx]->rank < m_nodes[e->head_indx]->rank)
			{
				s->start.set_y(m_nodes[e->tail_indx]->center.get_y() + m_radius);
				s->end.set_y(m_nodes[e->head_indx]->center.get_y() - m_radius);
			}				
			else
			{
				s->start.set_y(m_nodes[e->tail_indx]->center.get_y() - m_radius);
				s->end.set_y(m_nodes[e->head_indx]->center.get_y() + m_radius);
			}				
			
			s->middle.set_y((s->start.get_y() + s->end.get_y()) / 2);			
			e->coords.push_back(s);
		}
		else if (m_nodes[e->tail_indx]->node_type == VIRTUAL && m_nodes[e->head_indx]->node_type == NORMAL)
		{
			s = new SplineCoords();  			
			s->start.set_x(m_nodes[e->tail_indx]->center.get_x());
			s->start.set_y(m_nodes[e->tail_indx]->center.get_y());			
			s->end.set_x(m_nodes[e->head_indx]->center.get_x());
			s->middle.set_x(s->start.get_x());

			if (m_nodes[e->tail_indx]->rank < m_nodes[e->head_indx]->rank)
			{
				s->middle.set_y(m_nodes[e->tail_indx]->center.get_y() + m_radius);
				s->end.set_y(m_nodes[e->head_indx]->center.get_y() - m_radius);
			}				
			else
			{
				s->middle.set_y(m_nodes[e->tail_indx]->center.get_y() - m_radius);
				s->end.set_y(m_nodes[e->head_indx]->center.get_y() + m_radius);
			}				
			
			e->coords.push_back(s);
		}
		else if (m_nodes[e->tail_indx]->node_type == NORMAL && m_nodes[e->head_indx]->node_type == VIRTUAL)
		{
			s = new SplineCoords();  			
			s->start.set_x(m_nodes[e->tail_indx]->center.get_x());
			s->end.set_x(m_nodes[e->head_indx]->center.get_x());
			s->end.set_y(m_nodes[e->head_indx]->center.get_y());
			s->middle.set_x(s->end.get_x());

			if (m_nodes[e->tail_indx]->rank < m_nodes[e->head_indx]->rank)
			{
				s->start.set_y(m_nodes[e->tail_indx]->center.get_y() + m_radius);
				s->middle.set_y(m_nodes[e->head_indx]->center.get_y() - m_radius);				
			}				
			else
			{
				s->start.set_y(m_nodes[e->tail_indx]->center.get_y() - m_radius);
				s->middle.set_y(m_nodes[e->head_indx]->center.get_y() + m_radius);								
			}				
			
			e->coords.push_back(s);
		}			
		else if (m_nodes[e->tail_indx]->node_type == VIRTUAL && m_nodes[e->head_indx]->node_type == VIRTUAL)
		{
			s = new SplineCoords();  			
			s1 = new SplineCoords();  			
			
			s->start.set_x(m_nodes[e->tail_indx]->center.get_x());
			s->start.set_y(m_nodes[e->tail_indx]->center.get_y());			
			s->middle.set_x(m_nodes[e->tail_indx]->center.get_x());

			s1->end.set_x(m_nodes[e->head_indx]->center.get_x());
			s1->end.set_y(m_nodes[e->head_indx]->center.get_y());			
			s1->middle.set_x(m_nodes[e->head_indx]->center.get_x());

			if (m_nodes[e->tail_indx]->rank < m_nodes[e->head_indx]->rank)
			{
				s->middle.set_y(m_nodes[e->tail_indx]->center.get_y() + m_radius);
				s1->middle.set_y(m_nodes[e->head_indx]->center.get_y() - m_radius);				
			}				
			else
			{
				s->middle.set_y(m_nodes[e->tail_indx]->center.get_y() - m_radius);
				s1->middle.set_y(m_nodes[e->head_indx]->center.get_y() + m_radius);				
			}				
			
			s->end.set_x((s->middle.get_x() + s1->middle.get_x()) / 2);
			s1->start.set_x((s->middle.get_x() + s1->middle.get_x()) / 2);			
			
			s->end.set_y((s->middle.get_y() + s1->middle.get_y()) / 2);
			s1->start.set_y((s->middle.get_y() + s1->middle.get_y()) / 2);			

			e->coords.push_back(s);
			e->coords.push_back(s1);			
		}			
		
	}
}

void GraphLayout::set_edges_coords_new( )
{
	NodeIndex		i;
	VNode			*v_tail, *v_head;
	VNode			*v_tail_neib, *v_head_neib;
	VEdge			*e;
	SplineCoords	*s;
	TwoDPoint		p1, p2, p3, p4, p5, p6, p7, p8, p9, p10;
  	GraphViewPropertyGroup group;
  	GeometryShape 	*shape_tail, *shape_head;
	bool			x_tail_head_order;
	bool			y_tail_head_order;
	
	for (i = 0; i < (NodeIndex)m_edges.size(); i++)
	{
		e = m_edges[i];
		
		if (e->edge_type == SELFEDGE)
			continue;
		
		v_tail = m_nodes[e->tail_indx];
		v_head = m_nodes[e->head_indx];		
    
    if (!(v_tail->rank - v_head->rank == 1 ||	v_tail->rank - v_head->rank == -1 ||
          (v_tail->rank - v_head->rank == 0 && (v_tail->order - v_head->order == 1 || v_tail->order - v_head->order == -1))))
      continue;
		
		x_tail_head_order = v_tail->center.get_x() < v_head->center.get_x();
		y_tail_head_order = v_tail->center.get_y() < v_head->center.get_y();		
		
    group  = v_tail->get_node_properties( );
		 
    shape_tail = group.get_node_shape( v_tail->center, m_radius );
		
    group  = v_head->get_node_properties( );
		 
    shape_head = group.get_node_shape( v_head->center, m_radius );
		
//Processing of tail node
		p1 = shape_tail->get_nearest_to( v_head->center );		
		p4 = shape_head->get_nearest_to( v_tail->center );		
    
    delete shape_tail;
    delete shape_head;
		
		if (v_head->center.get_x() == v_tail->center.get_x())
		{
			if (v_tail->node_type == VIRTUAL)
				p1 = v_tail->center;		
			
			if (v_head->node_type == VIRTUAL)
				p4 = v_head->center;		

			s = new SplineCoords();  			
			s->start.set_x(p1.get_x());
			s->start.set_y(p1.get_y());			
			s->end.set_x(p4.get_x());
			s->end.set_y(p4.get_y());			
/*			s->middle.set_x((p1.get_x() + p4.get_x()) / 2);
			s->middle.set_y((p1.get_y() + p4.get_y()) / 2);			*/
			s->type = LINE;
			
			e->coords.push_back(s);			
		}
		else
		{
			double	k, l;
			double  det_tail, det_head;
			double 	a, b, c;
			
//Checking if the edge can be a straight line 
			v_tail_neib = 0;
			v_head_neib = 0;			
			//finding neighbors of tail and head nodes
			if (v_head->center.get_x() > v_tail->center.get_x())
			{
				for (NodeIndex ind = v_tail->order + 1; ind < (NodeIndex)m_ranks[v_tail->rank]->v.size(); ind++)
					if (m_ranks[v_tail->rank]->v[ind]->node_type == NORMAL)
					{
						v_tail_neib = m_ranks[v_tail->rank]->v[ind];
						break;
					}
					
				for (int ind = v_head->order - 1; ind >= 0; ind--)
					if (m_ranks[v_head->rank]->v[ind]->node_type == NORMAL)
					{
						v_head_neib = m_ranks[v_head->rank]->v[ind];
						break;
					}
			}
			else
			{
				for (int ind = v_tail->order - 1; ind >= 0; ind--)
					if (m_ranks[v_tail->rank]->v[ind]->node_type == NORMAL)
					{
						v_tail_neib = m_ranks[v_tail->rank]->v[ind];
						break;
					}
					
				for (NodeIndex ind = v_head->order + 1; ind < (NodeIndex)m_ranks[v_head->rank]->v.size(); ind++)
					if (m_ranks[v_head->rank]->v[ind]->node_type == NORMAL)
					{
						v_head_neib = m_ranks[v_head->rank]->v[ind];
						break;
					}
			}
			
			//finding of discriminants of corresponding equestions			
			k = (double)(v_head->center.get_y() - v_tail->center.get_y()) / (double)(v_head->center.get_x() - v_tail->center.get_x());
			l = (double)(v_head->center.get_x()*v_tail->center.get_y()  - v_head->center.get_y()*v_tail->center.get_x()) / (double)(v_head->center.get_x() - v_tail->center.get_x());
			
			det_tail = -1.0;
			
			if (v_tail_neib != 0)
			{
				a = (-(double)v_tail_neib->center.get_x() + k*l - k*(double)v_tail_neib->center.get_y());
				b = l - (double)v_tail_neib->center.get_y();
				c = (double)v_tail_neib->center.get_x() * (double)v_tail_neib->center.get_x();
				det_tail = a*a - (1.0+k*k)*(c + b*b - m_radius*m_radius);
			}
			
			k = (double)(v_head->center.get_y() - v_tail->center.get_y()) / (double)(v_head->center.get_x() - v_tail->center.get_x());
			l = (double)(v_head->center.get_x()*v_tail->center.get_y()  - v_head->center.get_y()*v_tail->center.get_x()) / (double)(v_head->center.get_x() - v_tail->center.get_x());
			
			det_head = -1.0;
			
			if (v_head_neib != 0)
			{
				a = (-(double)v_head_neib->center.get_x() + k*l - k*(double)v_head_neib->center.get_y());
				b = l - v_head_neib->center.get_y();
				c = (double)v_head_neib->center.get_x() * (double)v_head_neib->center.get_x();
				det_head = a*a - (1+k*k)*(c + b*b - m_radius*m_radius);
			}

			if (det_tail < 0 && det_head < 0 || v_tail->rank - v_head->rank == 0)
			{
				//edge can be drawn as a straight line
				if ((m_nodes[e->tail_indx]->node_type == NORMAL && m_nodes[e->head_indx]->node_type == NORMAL) || v_tail->rank - v_head->rank == 0)
				{		
					s = new SplineCoords();  			
					s->start.set_x(p1.get_x());
					s->start.set_y(p1.get_y());			
					s->end.set_x(p4.get_x());
					s->end.set_y(p4.get_y());			
					s->type = LINE;
					e->coords.push_back(s);				
				}
				else
				{
					TwoDPoint	last_tail, last_head;
					
					if (v_tail->node_type == VIRTUAL)
					{
						p1 = v_tail->center;
						p2.set_x(p1.get_x());
						if (y_tail_head_order)
							p2.set_y(p1.get_y() + m_radius);					
						else
							p2.set_y(p1.get_y() - m_radius);					
						
						
						last_tail = p2;
					}
					else
						last_tail = p1;

					if (v_head->node_type == VIRTUAL)
					{
						p4 = v_head->center;
						p5.set_x(p4.get_x());
						if (y_tail_head_order)
							p5.set_y(p4.get_y() - m_radius);					
						else
							p5.set_y(p4.get_y() + m_radius);					
						
						last_head = p5;
					}
					else
						last_head = p4;
					

					if (v_tail->node_type == VIRTUAL)					
					{
						p3.set_x((last_tail.get_x() + last_head.get_x()) / 2);
						p3.set_y((last_tail.get_y() + last_head.get_y()) / 2);
						
						s = new SplineCoords();  			
						s->start = p1;
						s->middle = p2;			
						s->end = p3;
						s->type = SPLINE;
						e->coords.push_back(s);				
					}
					else
					{
						s = new SplineCoords();  			
						s->start = p1;
						s->type = PIXEL;
						e->coords.push_back(s);				
					}
					
					if (v_head->node_type == VIRTUAL)
					{
						p6.set_x((last_tail.get_x() + last_head.get_x()) / 2);
						p6.set_y((last_tail.get_y() + last_head.get_y()) / 2);

						
						s = new SplineCoords();  			
						s->start = p6;
						s->middle = p5;			
						s->end = p4;
						s->type = SPLINE;
						e->coords.push_back(s);				

					}
					else
					{
						s = new SplineCoords();  			
						s->start = p4;
						s->type = PIXEL;
						e->coords.push_back(s);				
					}
				}
			}
			else
			{
				TwoDPoint	last_tail, last_head;
				
				if (det_tail > 0 && v_tail->node_type == NORMAL)
				{
					VNodeVector tmp_vec;
					EdgeListIter	e_iter;		
					VEdge			*e_tmp;
					int			x1, y1;

					e_iter = v_tail->out_edges.begin();
					
					if (v_head->center.get_x() > v_tail->center.get_x())
					{
						while (e_iter != v_tail->out_edges.end()) 			
						{
							e_tmp = *e_iter;				
							if (m_nodes[e_tmp->head_indx]->center.get_x() > m_nodes[e_tmp->tail_indx]->center.get_x())
								tmp_vec.push_back(m_nodes[e_tmp->head_indx]);
							e_iter++;
						}
 						sort(tmp_vec.begin(), tmp_vec.end(), VNode_more());												
					}
					else
					{
						while (e_iter != v_tail->out_edges.end()) 			
						{
							e_tmp = *e_iter;				
							if (m_nodes[e_tmp->head_indx]->center.get_x() < m_nodes[e->tail_indx]->center.get_x())
								tmp_vec.push_back(m_nodes[e_tmp->head_indx]);
							e_iter++;							
						}
 						sort(tmp_vec.begin(), tmp_vec.end(), VNode_less());												
					}
					
					NodeIndex or_ind;
					for (or_ind = 0; or_ind < (NodeIndex)tmp_vec.size(); or_ind++)
						if (tmp_vec[or_ind] == m_nodes[e->head_indx])
							break;
					
					x1 = ((m_radius >> 1) / tmp_vec.size());
					x1 = (or_ind == 0) ? x1 : x1*or_ind; 
						
					if (v_head->center.get_x() > v_tail->center.get_x())
						x1 = m_radius - x1;
					else
						x1 -= m_radius;						
					
					if (v_head->center.get_y() > v_tail->center.get_y())
						y1 = (int)sqrt((double)m_radius*m_radius - x1*x1);
					else
						y1 = (int)-sqrt((double)m_radius*m_radius - x1*x1);
					
					p1.set_x(x1 + v_tail->center.get_x());
					p1.set_y(y1 + v_tail->center.get_y());
						
					p2.set_x((v_tail->center.get_x()+v_tail_neib->center.get_x())/2);						
						
					if (v_head->center.get_y() > v_tail->center.get_y())
						p2.set_y(v_tail->center.get_y() + m_radius + ((m_y_separation >> 1) / tmp_vec.size()) * or_ind);
					else
						p2.set_y(v_tail->center.get_y() - m_radius - ((m_y_separation >> 1) / tmp_vec.size()) * or_ind);						
					
					last_tail = p2;					
				
				} 
				else if (v_tail->node_type == VIRTUAL)
				{
					p1 = v_tail->center;
					p2.set_x(p1.get_x());
					if (y_tail_head_order)
						p2.set_y(p1.get_y() + m_radius);					
					else
						p2.set_y(p1.get_y() - m_radius);					
					
					last_tail = p2;
				}
				else if (det_tail <= 0)
					last_tail = p1;
					
				

				
				if (det_head > 0 && v_head->node_type == NORMAL)
				{
					VNodeVector tmp_vec;
					EdgeListIter	e_iter;		
					VEdge			*e_tmp;
					int			x4, y4;
					
					e_iter = v_head->in_edges.begin();
					
					if (v_head->center.get_x() < v_tail->center.get_x())
					{
						while (e_iter != v_head->in_edges.end()) 			
						{
							e_tmp = *e_iter;				
							if (m_nodes[e_tmp->tail_indx]->center.get_x() > m_nodes[e_tmp->head_indx]->center.get_x())
								tmp_vec.push_back(m_nodes[e_tmp->tail_indx]);
							e_iter++;
						}
 						sort(tmp_vec.begin(), tmp_vec.end(), VNode_more());												
					}
					else
					{
						while (e_iter != v_head->in_edges.end()) 			
						{
							e_tmp = *e_iter;				
							if (m_nodes[e_tmp->tail_indx]->center.get_x() < m_nodes[e_tmp->head_indx]->center.get_x())
								tmp_vec.push_back(m_nodes[e_tmp->tail_indx]);
							e_iter++;							
						}
 						sort(tmp_vec.begin(), tmp_vec.end(), VNode_less());												
					}
					
					NodeIndex or_ind;
					for (or_ind = 0; or_ind < (NodeIndex)tmp_vec.size(); or_ind++)
						if (tmp_vec[or_ind] == m_nodes[e->tail_indx])
							break;
					
					x4 = ((m_radius >> 1) / tmp_vec.size());
					x4 = (or_ind == 0) ? x4 : x4*or_ind; 
						
					if (v_head->center.get_x() > v_tail->center.get_x())
						x4 -= m_radius;
					else
						x4 = m_radius - x4;
					
					if (v_head->center.get_y() > v_tail->center.get_y())
						y4 = (int)-sqrt((double)m_radius*m_radius - x4*x4);
					else
						y4 = (int)sqrt((double)m_radius*m_radius - x4*x4);
					
					p4.set_x(x4 + v_head->center.get_x());
					p4.set_y(y4 + v_head->center.get_y());

					p5.set_x((v_head->center.get_x()+v_head_neib->center.get_x())/2);						

					if (v_head->center.get_y() > v_tail->center.get_y())
						p5.set_y(v_head->center.get_y() - m_radius - ((m_y_separation >> 1) / tmp_vec.size()) * or_ind);
					else
						p5.set_y(v_head->center.get_y() + m_radius + ((m_y_separation >> 1) / tmp_vec.size()) * or_ind);						
					
					last_head = p5;					
					
				} else if (v_head->node_type == VIRTUAL)
				{
					p4 = v_head->center;
					p5.set_x(p4.get_x());
					if (y_tail_head_order)
						p5.set_y(p4.get_y() - m_radius);					
					else
						p5.set_y(p4.get_y() + m_radius);					
						
					last_head = p5;
				}
				else
					last_head = p4;
				

				if (v_tail->node_type == VIRTUAL)					
				{
					p3.set_x((last_tail.get_x() + last_head.get_x()) / 2);
					p3.set_y((last_tail.get_y() + last_head.get_y()) / 2);
				} else
				{
					LineSegment l1(last_tail, last_head);					
	            int	x, y1, y2;
					

					if (v_head->center.get_x() > v_tail->center.get_x())
					{
						if (v_tail_neib == 0)
						{
							x = v_tail->center.get_x() + m_radius;
							y1 = v_tail->center.get_y() - m_radius;	
							y2 = v_tail->center.get_y() + m_radius;								
						}
						else
						{
							x = v_tail_neib->center.get_x() + m_radius;
							y1 = v_tail_neib->center.get_y() - m_radius;	
							y2 = v_tail_neib->center.get_y() + m_radius;								
						}
					}
					else
					{
						if (v_tail_neib == 0)
						{
							x = v_tail->center.get_x() - m_radius;
							y1 = v_tail->center.get_y() - m_radius;	
							y2 = v_tail->center.get_y() + m_radius;								
						}
						else
						{
							x = v_tail_neib->center.get_x() - m_radius;
							y1 = v_tail_neib->center.get_y() - m_radius;	
							y2 = v_tail_neib->center.get_y() + m_radius;								
						}
					}
					
					LineSegment l2(TwoDPoint(x, y1), 
								   TwoDPoint(x, y2));					
					
					l1.intersection(l2, &p3);
				}
				
				if (v_head->node_type == VIRTUAL)
				{
					p6.set_x((last_tail.get_x() + last_head.get_x()) / 2);
					p6.set_y((last_tail.get_y() + last_head.get_y()) / 2);
				} else
				{
					LineSegment l3(last_tail, last_head);					
					int	x, y1, y2;
					

					if (v_head->center.get_x() > v_tail->center.get_x())
					{
						if (v_head_neib == 0)
						{
							x = v_head->center.get_x() - m_radius;
							y1 = v_head->center.get_y() - m_radius;	
							y2 = v_head->center.get_y() + m_radius;								
						}
						else
						{
							x = v_head_neib->center.get_x() - m_radius;
							y1 = v_head_neib->center.get_y() - m_radius;	
							y2 = v_head_neib->center.get_y() + m_radius;								
						}
					}
					else
					{
						if (v_head_neib == 0)
						{
							x = v_head->center.get_x() + m_radius;
							y1 = v_head->center.get_y() - m_radius;	
							y2 = v_head->center.get_y() + m_radius;								
						}
						else
						{
							x = v_head_neib->center.get_x() + m_radius;
							y1 = v_head_neib->center.get_y() - m_radius;	
							y2 = v_head_neib->center.get_y() + m_radius;								
						}
					}
					
		
					LineSegment l4(TwoDPoint(x, y1), 
								   TwoDPoint(x, y2));					

					
					l3.intersection(l4, &p6);
				}	

				if (v_tail->node_type == NORMAL && v_head->node_type == NORMAL)
				{		
  			  if ((x_tail_head_order && last_head.get_x() <= last_tail.get_x()) ||
              (!x_tail_head_order && last_head.get_x() >= last_tail.get_x()))
              {
					      s = new SplineCoords();  			
					      s->start.set_x(p1.get_x());
					      s->start.set_y(p1.get_y());			
					      s->end.set_x(p4.get_x());
					      s->end.set_y(p4.get_y());			
					      s->type = LINE;
					      e->coords.push_back(s);				
                
                continue;
              }
        }


        if (det_tail < 0 && v_tail->node_type == NORMAL)					
				{
					s = new SplineCoords();  			
					s->start = p1;
					s->type = PIXEL;
					e->coords.push_back(s);				
				}
				else
				{
					s = new SplineCoords();  			
					s->start = p1;
					s->middle = p2;			
					s->end = p3;
					s->type = SPLINE;
					e->coords.push_back(s);				

				}
					
				if (det_head < 0 && v_head->node_type == NORMAL)
				{
					s = new SplineCoords();  			
					s->start = p4;
					s->type = PIXEL;
					e->coords.push_back(s);				
				}
				else
				{
					s = new SplineCoords();  			
					s->start = p6;
					s->middle = p5;			
					s->end = p4;
					s->type = SPLINE;
					e->coords.push_back(s);				
				}
			}
		}
	}
	
	set_selfedges_coords();	
}

 
void GraphLayout::set_selfedges( )
{
	NodeIndex	i;
	VNode		*v;
	VEdge		*e;

	for (i = 0; i < (NodeIndex)m_nodes.size(); i++)
	{
		v = m_nodes[i];
		if (v->selfedges_count > 0)
		{
			e = new VEdge;
			memset((void*)e, 0, sizeof(VEdge));
			e->edge_type = SELFEDGE;
  			e->real_head_indx = e->real_tail_indx = e->head_indx = e->tail_indx = i;
			v->in_edges.push_back(e);
			v->out_edges.push_back(e);			
			m_edges.push_back(e);
		}
	}
}


void GraphLayout::set_selfedges_coords( )
{
	NodeIndex	i;
	VNode		*v;
	VEdge		*e;
	TwoDPoint	p1, p2, p3, p4, p5, p6;
	int			x, y;
	int			sep;
  	GraphViewPropertyGroup group;
  	GeometryShape 	*shape;
	SplineCoords	*s;	

	for (i = 0; i < (NodeIndex)m_edges.size(); i++)
	{
		e = m_edges[i];
		v = m_nodes[e->tail_indx];					
		if (e->edge_type == SELFEDGE)
		{
      		group = v->get_node_properties();
 	    	shape = group.get_node_shape( v->center, m_radius );
			
			x = ((m_radius >> 1) + (m_radius >> 2));
			sep = 0;
			
			p2.set_x(v->center.get_x() + x);			
			p5.set_x(v->center.get_x() + x);			
			
			y = (int)sqrt(double(m_radius*m_radius - x*x));
			
			p2.set_y(v->center.get_y() + y);			
			p5.set_y(v->center.get_y() - y);			
			
			p1 = shape->get_nearest_to( p2 );								
			p5 = shape->get_nearest_to( p5 );
      
      delete shape;

			p2.set_x(v->center.get_x() + m_radius + (m_x_separation>>2) - sep);
			p4.set_x(v->center.get_x() + m_radius + (m_x_separation>>2) - sep);
			
			p2.set_y(p1.get_y());
			p4.set_y(p5.get_y());			
			
			p3.set_x(p2.get_x());
			p3.set_y(v->center.get_y());			
			
			s = new SplineCoords();
			s->start = p1;
			s->middle = p2;
			s->end = p3;
			s->type = SPLINE;			
			e->coords.push_back(s);

			s = new SplineCoords();
			s->start = p3;
			s->middle = p4;
			s->end = p5;
			s->type = SPLINE;			
			e->coords.push_back(s);
		}
	}
}
