#include "InfoStorage.hpp"

using namespace GraphGraphics;

InfoStorage::InfoStorage()
{
  root_level = new InfoStorageSubLevel("root");
}

InfoStorage::~InfoStorage()
{
  delete root_level;
}

void InfoStorageSubLevel::clear()
{
  vector<InfoStorageLevel*>::iterator iter;

  for (iter = m_child_levels.begin(); iter < m_child_levels.end(); ++iter)
    delete *iter;
  
  m_child_levels.resize(0);
  m_child_levels.clear();
}

InfoStorageSubLevel::~InfoStorageSubLevel()
{
  clear();
} 
  

InfoStorageItemLevel::~InfoStorageItemLevel()
{ 
/*  m_values.resize();*/
  InfoValueListIter iter = m_values.begin();
  InfoValueListIter end_iter = m_values.end();
  
  while (iter != end_iter)
  {
    delete *iter;
    ++iter;
  }
  
  m_values.clear();
}   
   
void InfoStorageSubLevel::add_sublevel(InfoStorageLevel *new_sublevel)
{
  if (new_sublevel != 0)
    m_child_levels.push_back(new_sublevel);
};

InfoStorageLevel* InfoStorageSubLevel::get_sublevel(int i)
{
  InfoStorageLevel  *level;  
  
  if (i < (int)m_child_levels.size())
    level = m_child_levels[i];
  else
    level = 0;
  
  return level;
};
  
void InfoStorageItemLevel::set_values(const InfoValueList& values)
{
  m_values.resize(0);
  m_values.clear();

  m_values.insert(m_values.begin(), values.begin(), values.end());  
};

void InfoStorageItemLevel::add_value(InfoValue *value)
{
  m_values.push_back(value);
};
