
#include "UnixTemplateCreationGUI.h"

using namespace GraphGraphics;

const char *GTKGraphAttrValueDialog::EQUAL = "Equal";
const char *GTKGraphAttrValueDialog::NOT_EQUAL = "Not equal";
const char *GTKGraphAttrValueDialog::LESS = "Less";
const char *GTKGraphAttrValueDialog::NOT_LESS = "Not less";
const char *GTKGraphAttrValueDialog::GREATER = "Greater";
const char *GTKGraphAttrValueDialog::NOT_GREATER = "Not greater";

const char *GTKGraphAttrTemplateCreationView::NONE = "NONE";
const char *GTKGraphAttrTemplateCreationView::OR = "OR";
const char *GTKGraphAttrTemplateCreationView::AND = "AND";

void GTKGraphAttrPredDialog::create( )
{
  GList *op_combo_items = NULL;
  
  attr_pred_dialog = gtk_dialog_new_with_buttons( "Set logical operator", NULL, GTK_DIALOG_MODAL, 
                                            GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL );
  
  gtk_window_set_position (GTK_WINDOW (attr_pred_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (attr_pred_dialog), FALSE);
  
  dialog_vbox1 = GTK_DIALOG (attr_pred_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (1, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  
  op_label = gtk_label_new ("Logical operator:");
  gtk_widget_show (op_label);
  gtk_table_attach (GTK_TABLE (table1), op_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (op_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (op_label), 0, 0.5);

  op_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (op_hbox);
  gtk_table_attach (GTK_TABLE (table1), op_hbox, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  op_combo = gtk_combo_new ();
  gtk_widget_show (op_combo);
  gtk_box_pack_start (GTK_BOX (op_hbox), op_combo, FALSE, TRUE, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (op_combo), TRUE, FALSE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (op_combo), TRUE);
  op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::NONE);
  op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::AND);
  op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::OR);
  gtk_combo_set_popdown_strings (GTK_COMBO (op_combo), op_combo_items);
  g_list_free (op_combo_items);

  op_combo_entry = GTK_COMBO (op_combo)->entry;
  gtk_widget_show (op_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (op_combo_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (op_combo_entry), GTKGraphAttrTemplateCreationView::NONE);
  gtk_entry_set_width_chars (GTK_ENTRY (op_combo_entry), 15);

  not_label = gtk_label_new ("Negation:");
  gtk_widget_show (not_label);
  gtk_box_pack_start (GTK_BOX (op_hbox), not_label, FALSE, TRUE, 4);
  gtk_label_set_justify (GTK_LABEL (not_label), GTK_JUSTIFY_LEFT);

  not_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (not_checkbutton);
  gtk_box_pack_start (GTK_BOX (op_hbox), not_checkbutton, FALSE, TRUE, 2);
  GTK_WIDGET_UNSET_FLAGS (not_checkbutton, GTK_CAN_FOCUS);
}

int GTKGraphAttrPredDialog::run( )
{
  create();
  gint result = gtk_dialog_run( GTK_DIALOG(attr_pred_dialog) );
  char *text = 0;
  string tmp;
  
  switch( result )
  {
  case GTK_RESPONSE_OK:
    text = (char *)gtk_entry_get_text( GTK_ENTRY( op_combo_entry ) );
    tmp = string(text);
    
    if ( tmp == GTKGraphAttrTemplateCreationView::AND )
      m_attr_op = "&";
    else if ( tmp == GTKGraphAttrTemplateCreationView::OR )
      m_attr_op = "|";
    
    m_negation = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( not_checkbutton) );
    break;
      
  default:;  
  }
    
  gtk_widget_destroy( attr_pred_dialog );
  attr_pred_dialog = 0;

  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}

string GTKGraphAttrValueDialog::get_aliased_value()
{
  string res;
  const char *text = gtk_entry_get_text( GTK_ENTRY( value_combo_entry ) );
  res = string(text);
  
  if ( res.empty() )
  {
    stringstream s_str;
    long         ltmp = 0;
    text = (char *)gtk_entry_get_text( GTK_ENTRY( value_entry ) );
      
    sscanf( text, "%ld", &ltmp );
    s_str << ltmp;
    res = s_str.str();
  }
  
  return res;
}

string GTKGraphAttrValueDialog::get_aliased_value_range( )
{
  string res = "";
  GtkTreeIter iter;
  char    *text;
  gboolean    valid = gtk_tree_model_get_iter_first( GTK_TREE_MODEL( m_store ), &iter );
  
  while ( valid )
  {
    gtk_tree_model_get( GTK_TREE_MODEL( m_store ), &iter, 0, &text, -1 );
    
    res += string( text ) + "\n";
    g_free( text );
    valid = gtk_tree_model_iter_next( GTK_TREE_MODEL( m_store ), &iter );
  }
  
  if ( !res.empty() )
    res = res.substr( 0, res.size() - 1 );
  
  return res;
}

void GTKGraphAttrValueDialog::handle_range_checkbutton_event( bool checked )
{
  if ( checked )
  {
    gtk_widget_show( range_scrolledwindow );
    gtk_widget_show( range_buttons_hbox );
  }
  else
  {
    gtk_widget_hide( range_scrolledwindow );
    gtk_widget_hide( range_buttons_hbox );
    
    gtk_window_resize( GTK_WINDOW( attr_value ), 10, 10 );
  }
}

void GTKGraphAttrValueDialog::handle_add_value_button_event( )
{
  string        value = get_aliased_value();
  GtkTreeIter   iter;

  gtk_list_store_append( m_store, &iter );
  
  gtk_list_store_set( m_store, &iter, 0, value.c_str(), -1 );  
}

void GTKGraphAttrValueDialog::handle_remove_value_button_event( )
{
  GtkTreeIter   iter;
  
  GtkTreeModel  *model = 0;
  GtkTreeSelection *selection = gtk_tree_view_get_selection( GTK_TREE_VIEW( range_listview ) );
  bool              selected  = gtk_tree_selection_get_selected( selection, &model, &iter);

  if ( selected )  
    gtk_list_store_remove( m_store, &iter );
}

void GTKGraphAttrValueDialog::handle_value_combo_entry_changed_event( )
{
  char  *text = (char*)gtk_entry_get_text( GTK_ENTRY(value_combo_entry) );
  string tmp = string( text );
  
  if ( !tmp.empty() )
  {
    long value;
    stringstream s_str;
    for ( GraphAttrValueAliasMap::iterator it = m_all_value_aliases.begin(); 
                                         it != m_all_value_aliases.end(); it ++)
    {
      if ( it->second == tmp )
      {
        value = it->first;
        break;
      }
    }
    
    s_str << value;
    tmp = s_str.str();
    
    text = (char*)gtk_entry_get_text( GTK_ENTRY(value_entry) );
    
    if ( tmp != string( text ) )
      gtk_entry_set_text( GTK_ENTRY(value_entry), tmp.c_str() );
  }
}

void GTKGraphAttrValueDialog::handle_value_entry_changed_event( )
{
  if ( m_aliases )
  {
    char  *text = (char*)gtk_entry_get_text( GTK_ENTRY(value_entry) );
    string tmp = string( text );
    
    if ( !tmp.empty() )
    {
      long value;
      string alias = "";
      
      sscanf( text, "%ld", &value );
      
      GraphAttrValueAliasMap::iterator it = m_all_value_aliases.find( value );
  
      if (it != m_all_value_aliases.end())
        alias = it->second;
  
      text = (char*)gtk_entry_get_text( GTK_ENTRY(value_combo_entry) );
      
      if ( alias != string( text ) )
        gtk_entry_set_text( GTK_ENTRY(value_combo_entry), alias.c_str() );
    }
  }
}

static void on_range_checkbutton_toggled( GtkToggleButton *togglebutton, gpointer user_data )
{
  GTKGraphAttrValueDialog *dialog = (GTKGraphAttrValueDialog*)user_data;
  
  dialog->handle_range_checkbutton_event( gtk_toggle_button_get_active( togglebutton ) );
}

static void on_add_value_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKGraphAttrValueDialog *dialog = (GTKGraphAttrValueDialog*)user_data;
  
  dialog->handle_add_value_button_event( );
}

static void on_remove_value_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKGraphAttrValueDialog *dialog = (GTKGraphAttrValueDialog*)user_data;
  
  dialog->handle_remove_value_button_event( );
}

void on_value_combo_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKGraphAttrValueDialog *dialog = (GTKGraphAttrValueDialog*)user_data;
  
  dialog->handle_value_combo_entry_changed_event( );
}

void on_value_entry_changed( GtkEditable *editable, gpointer user_data )
{
  GTKGraphAttrValueDialog *dialog = (GTKGraphAttrValueDialog*)user_data;
  
  dialog->handle_value_entry_changed_event( );
}


void GTKGraphAttrValueDialog::create( )
{
  GList *op_combo_items = NULL;
  GList *value_op_combo_items = NULL;
  GList *value_combo_items = NULL;
  GtkTreeViewColumn *column;
  GtkCellRenderer   *render;
    
  attr_value = gtk_dialog_new_with_buttons( "Set attribute value", NULL, GTK_DIALOG_MODAL, 
                                            GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL );

  gtk_window_set_position (GTK_WINDOW (attr_value), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (attr_value), FALSE);

  dialog_vbox2 = GTK_DIALOG (attr_value)->vbox;
  gtk_widget_show (dialog_vbox2);

  table2 = gtk_table_new (4, 2, FALSE);
  gtk_widget_show (table2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), table2, TRUE, TRUE, 0);

  label4 = gtk_label_new ( "Attribute name:" );
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table2), label4, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 2, 2);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label4), 0, 0.5);

  name_entry = gtk_entry_new ();
  gtk_widget_show (name_entry);
  gtk_table_attach (GTK_TABLE (table2), name_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (name_entry, GTK_CAN_FOCUS);                    
  gtk_entry_set_editable (GTK_ENTRY (name_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (name_entry), m_attr_name.c_str());
  
  value_op_label = gtk_label_new ("Value relation:");
  gtk_widget_show (value_op_label);
  gtk_table_attach (GTK_TABLE (table2), value_op_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 2);
  gtk_label_set_justify (GTK_LABEL (value_op_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (value_op_label), 0, 0.5);

  value_op_alignment = gtk_alignment_new (0, 0.5, 0, 1);
  gtk_widget_show (value_op_alignment);
  gtk_table_attach (GTK_TABLE (table2), value_op_alignment, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  value_op_combo = gtk_combo_new ();
  gtk_widget_show (value_op_combo);
  gtk_container_add (GTK_CONTAINER (value_op_alignment), value_op_combo);
  value_op_combo_items = g_list_append (value_op_combo_items, (gpointer)EQUAL);
  value_op_combo_items = g_list_append (value_op_combo_items, (gpointer)NOT_EQUAL);
  value_op_combo_items = g_list_append (value_op_combo_items, (gpointer)LESS);
  value_op_combo_items = g_list_append (value_op_combo_items, (gpointer)NOT_GREATER);
  value_op_combo_items = g_list_append (value_op_combo_items, (gpointer)GREATER);
  value_op_combo_items = g_list_append (value_op_combo_items, (gpointer)NOT_LESS);
  gtk_combo_set_popdown_strings (GTK_COMBO (value_op_combo), value_op_combo_items);
  g_list_free (value_op_combo_items);

  value_op_combo_entry = GTK_COMBO (value_op_combo)->entry;
  gtk_widget_show (value_op_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (value_op_combo_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (value_op_combo_entry), EQUAL);
  gtk_entry_set_width_chars (GTK_ENTRY (value_op_combo_entry), 15);

  range_label = gtk_label_new ( "Value is range:" );
  gtk_widget_show (range_label);
  gtk_table_attach (GTK_TABLE (table2), range_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 2, 2);
  gtk_label_set_justify (GTK_LABEL (range_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (range_label), 0, 0.5);

  vr_alignment = gtk_alignment_new (0, 0.5, 0, 1);
  gtk_widget_show (vr_alignment);
  gtk_table_attach (GTK_TABLE (table2), vr_alignment, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  
  range_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (range_checkbutton);
  gtk_container_add (GTK_CONTAINER (vr_alignment), range_checkbutton);
  GTK_WIDGET_UNSET_FLAGS (range_checkbutton, GTK_CAN_FOCUS);
  
  gtk_signal_connect (GTK_OBJECT (range_checkbutton), "toggled",
                      GTK_SIGNAL_FUNC (on_range_checkbutton_toggled),
                      (gpointer)this);
  if ( m_is_string_value )       
  {
    gtk_widget_hide( range_label );
    gtk_widget_hide( vr_alignment );
    gtk_widget_hide( range_checkbutton );
  }    

  GtkWidget *vl_alignment = gtk_alignment_new (0, 0.0, 0, 1);
  gtk_widget_show (vl_alignment);
  gtk_table_attach (GTK_TABLE (table2), vl_alignment, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND),
                    (GtkAttachOptions) (GTK_FILL | GTK_EXPAND), 2, 2);
  label5 = gtk_label_new ( "Attribute value:" );
  gtk_widget_show (label5);
  gtk_container_add (GTK_CONTAINER (vl_alignment), label5);
  
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label5), 0, 0.0);
  
  value_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (value_vbox);
  gtk_table_attach (GTK_TABLE (table2), value_vbox, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  range_scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (range_scrolledwindow);
  gtk_box_pack_start (GTK_BOX (value_vbox), range_scrolledwindow, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (range_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (range_scrolledwindow), GTK_SHADOW_ETCHED_IN);

  m_store = gtk_list_store_new( 1, G_TYPE_STRING );
  
  range_listview = gtk_tree_view_new_with_model( GTK_TREE_MODEL(m_store) );
  render = gtk_cell_renderer_text_new( );
  column = gtk_tree_view_column_new_with_attributes( "", render, "text", 0, NULL );
  gtk_tree_view_append_column( GTK_TREE_VIEW( range_listview ), column );
  gtk_widget_show (range_listview);
  gtk_container_add (GTK_CONTAINER (range_scrolledwindow), range_listview);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (range_listview), FALSE);
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (range_listview), FALSE);
  
  gtk_widget_hide(range_scrolledwindow);
  
  value_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (value_hbox);
  gtk_box_pack_start (GTK_BOX (value_vbox), value_hbox, TRUE, TRUE, 0);
//  gtk_table_attach (GTK_TABLE (table2), value_hbox, 1, 2, 2, 3,
//                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
//                      (GtkAttachOptions) (GTK_FILL), 0, 0);
  
  value_entry = gtk_entry_new ();
  gtk_widget_show (value_entry);
  gtk_box_pack_start (GTK_BOX (value_hbox), value_entry, FALSE, TRUE, 0);
  
  gtk_signal_connect (GTK_OBJECT (value_entry), "changed",
                      GTK_SIGNAL_FUNC (on_value_entry_changed),
                      (gpointer)this);
    
  value_combo = gtk_combo_new ();
  gtk_widget_show (value_combo);
  gtk_box_pack_start (GTK_BOX (value_hbox), value_combo, FALSE, TRUE, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (value_combo), TRUE, FALSE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (value_combo), TRUE);
  
  value_combo_entry = GTK_COMBO (value_combo)->entry;
  gtk_widget_show (value_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (value_combo_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (value_combo_entry), "" );
  
  gtk_signal_connect (GTK_OBJECT (value_combo_entry), "changed",
                      GTK_SIGNAL_FUNC (on_value_combo_entry_changed),
                      (gpointer)this);
  
  if ( !m_aliases )
    gtk_widget_hide( value_combo );
  else
  {
    gtk_entry_set_width_chars (GTK_ENTRY (value_entry), 15);
    value_combo_items = g_list_append (value_combo_items, (gpointer)"" );
    
    for (GraphAttrValueAliasMap::const_iterator it = m_all_value_aliases.begin();
                                                it != m_all_value_aliases.end(); it++ )
      value_combo_items = g_list_append (value_combo_items, (gpointer)((it->second).c_str()) );
          
    gtk_combo_set_popdown_strings (GTK_COMBO (value_combo), value_combo_items);
    g_list_free (value_combo_items);
  }

  range_buttons_hbox = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (range_buttons_hbox);
  gtk_box_pack_start (GTK_BOX (value_vbox), range_buttons_hbox, TRUE, TRUE, 0);

  add_value_button = gtk_button_new_with_mnemonic ("Add value");
  gtk_widget_show (add_value_button);
  gtk_box_pack_start (GTK_BOX (range_buttons_hbox), add_value_button, TRUE, TRUE, 0);

  remove_value_button = gtk_button_new_with_mnemonic ("Remove value");
  gtk_widget_show (remove_value_button);
  gtk_box_pack_start (GTK_BOX (range_buttons_hbox), remove_value_button, TRUE, TRUE, 0);
  
  gtk_signal_connect (GTK_OBJECT (add_value_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_value_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (remove_value_button), "clicked",
                      GTK_SIGNAL_FUNC (on_remove_value_button_clicked),
                      (gpointer)this);

  gtk_widget_hide(range_buttons_hbox);
    
  if ( m_expression )
  {
    op_label = gtk_label_new ("Logical operator:");
    gtk_widget_show (op_label);
    gtk_table_attach (GTK_TABLE (table2), op_label, 0, 1, 4, 5,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (0), 2, 2);
    gtk_label_set_justify (GTK_LABEL (op_label), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (op_label), 0, 0.5);
  
    op_hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (op_hbox);
    gtk_table_attach (GTK_TABLE (table2), op_hbox, 1, 2, 4, 5,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (GTK_FILL), 0, 0);
  
    op_combo = gtk_combo_new ();
    gtk_widget_show (op_combo);
    gtk_box_pack_start (GTK_BOX (op_hbox), op_combo, FALSE, TRUE, 0);
    gtk_combo_set_value_in_list (GTK_COMBO (op_combo), TRUE, FALSE);
    gtk_combo_set_use_arrows_always (GTK_COMBO (op_combo), TRUE);
    op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::NONE);
    op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::AND);
    op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::OR);
    gtk_combo_set_popdown_strings (GTK_COMBO (op_combo), op_combo_items);
    g_list_free (op_combo_items);
  
    op_combo_entry = GTK_COMBO (op_combo)->entry;
    gtk_widget_show (op_combo_entry);
    gtk_entry_set_editable (GTK_ENTRY (op_combo_entry), FALSE);
    gtk_entry_set_text (GTK_ENTRY (op_combo_entry), GTKGraphAttrTemplateCreationView::NONE);
    gtk_entry_set_width_chars (GTK_ENTRY (op_combo_entry), 15);
  
    not_label = gtk_label_new ("Negation:");
    gtk_widget_show (not_label);
    gtk_box_pack_start (GTK_BOX (op_hbox), not_label, FALSE, TRUE, 4);
    gtk_label_set_justify (GTK_LABEL (not_label), GTK_JUSTIFY_LEFT);
  
    not_checkbutton = gtk_check_button_new_with_mnemonic ("");
    gtk_widget_show (not_checkbutton);
    gtk_box_pack_start (GTK_BOX (op_hbox), not_checkbutton, FALSE, TRUE, 2);
    GTK_WIDGET_UNSET_FLAGS (not_checkbutton, GTK_CAN_FOCUS);
  }

  gtk_widget_grab_focus (value_entry);
};

void GTKGraphAttrValueDialog::set_attr_name( const StringContainer &attr_name, const string &type ) 
{ 
  if ( !attr_name.empty() )
  {
    m_attr_name = attr_name[ attr_name.size() - 1 ]; 
    
    if ( m_aliases )
      m_name_storage->get_attr_value_alases_by_name_alias( attr_name, type, m_all_value_aliases );
  }
}

int GTKGraphAttrValueDialog::run()
{
  create();
  gint result = gtk_dialog_run( GTK_DIALOG(attr_value) );
  char *text = 0;
  string tmp;
  long   ltmp = 0;
  stringstream str_stream("");
  
  m_attr_value = "";
    
  switch( result )
  {
  case GTK_RESPONSE_OK:
      
    if ( m_aliases )
    {
      if ( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON(range_checkbutton) ) )
        m_attr_value = get_aliased_value_range();
      else
        m_attr_value = get_aliased_value();
    }
    else
    {
      text = (char *)gtk_entry_get_text( GTK_ENTRY( value_entry ) );
      
      tmp = string(text);
    
      if ( m_is_string_value )
      {
        m_attr_value = "\"" + tmp + "\"";
      }
      else if ( tmp.find('.') != string::npos || tmp.find(',') != string::npos )
      {
        AttributeIntegerRange range;
        
        if ( range.set_string( tmp ) )
          m_attr_value = range.get_string();
        else
        {
          sscanf( text, "%ld", &ltmp );
          str_stream << ltmp;
          m_attr_value = str_stream.str();
        }
      }
      else
      {
        sscanf( text, "%ld", &ltmp );
        str_stream << ltmp;
        m_attr_value = str_stream.str();
      }
    }
    
    text = (char *)gtk_entry_get_text( GTK_ENTRY( value_op_combo_entry ) );
    tmp = string(text);
    
    if ( tmp == NOT_EQUAL )
      m_attr_value_op = "<>";
    else if (tmp == LESS )
      m_attr_value_op = "<";
    else if ( tmp == NOT_LESS )
      m_attr_value_op = ">=";
    else if ( tmp == GREATER )
      m_attr_value_op = ">";
    else if ( tmp == NOT_GREATER )
      m_attr_value_op = "<=";
    
    if ( m_expression )
    {
      text = (char *)gtk_entry_get_text( GTK_ENTRY( op_combo_entry ) );
      tmp = string(text);
      
      if ( tmp == GTKGraphAttrTemplateCreationView::AND )
        m_attr_op = "&";
      else if ( tmp == GTKGraphAttrTemplateCreationView::OR )
        m_attr_op = "|";
      
      m_negation = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( not_checkbutton) );
    }
    break;
      
  default:;  
  }
    
  gtk_widget_destroy( attr_value );
  attr_value = 0;

  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}

/******************************************************************************/
/*******************************************************************************/

void GTKGraphMetaAttrDialog::handle_check_meta_attr_id_toggled_event()
{
  if ( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( check_meta_attr_id) ) )
  {
    GTK_WIDGET_SET_FLAGS (meta_id_entry, GTK_CAN_FOCUS);
    gtk_entry_set_editable (GTK_ENTRY (meta_id_entry), TRUE );
    gtk_entry_set_visibility (GTK_ENTRY (meta_id_entry), TRUE );
    gtk_widget_grab_focus (meta_id_entry);
  }
  else
  {
    GTK_WIDGET_UNSET_FLAGS (meta_id_entry, GTK_CAN_FOCUS);
    gtk_entry_set_editable (GTK_ENTRY (meta_id_entry), FALSE );
    gtk_entry_set_visibility (GTK_ENTRY (meta_id_entry), FALSE );
  }
}

void GTKGraphMetaAttrDialog::handle_check_meta_attr_name_toggled_event()
{
  gtk_entry_set_visibility ( GTK_ENTRY(meta_name_entry), gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( check_meta_attr_name ) ) );
}

static void on_check_meta_attr_id_toggled( GtkToggleButton *togglebutton, gpointer user_data )
{
  GTKGraphMetaAttrDialog *meta_att_dialog = (GTKGraphMetaAttrDialog *)user_data;
  meta_att_dialog->handle_check_meta_attr_id_toggled_event( );
}

static void on_check_meta_attr_name_toggled ( GtkToggleButton *togglebutton, gpointer user_data )
{
  GTKGraphMetaAttrDialog *meta_att_dialog = (GTKGraphMetaAttrDialog *)user_data;
  meta_att_dialog->handle_check_meta_attr_name_toggled_event( );
}

void GTKGraphMetaAttrDialog::create( )
{
  GList *op_combo_items = NULL;
  
  meta_attr = gtk_dialog_new_with_buttons( "Set attribute value", NULL, GTK_DIALOG_MODAL, 
                                            GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL );
  gtk_window_set_title (GTK_WINDOW (meta_attr), "Set meta-attribute value" );

  gtk_window_set_position (GTK_WINDOW (meta_attr), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (meta_attr), FALSE);

  dialog_vbox3 = GTK_DIALOG (meta_attr)->vbox;
  gtk_widget_show (dialog_vbox3);

  table3 = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table3);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), table3, TRUE, TRUE, 0);

  
  check_meta_attr_id = gtk_check_button_new_with_mnemonic ("Meta-attribute index:");
  gtk_widget_show (check_meta_attr_id);
  gtk_table_attach (GTK_TABLE (table3), check_meta_attr_id, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
                    
  if ( m_aliased && !m_first_meta)
    gtk_widget_hide (check_meta_attr_id);
  
  check_meta_attr_name = gtk_check_button_new_with_mnemonic ("Meta-attribute name:");
  gtk_widget_show (check_meta_attr_name);
  gtk_table_attach (GTK_TABLE (table3), check_meta_attr_name, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_meta_attr_name), TRUE);
  
  if ( m_aliased )
    gtk_widget_set_sensitive (check_meta_attr_name, FALSE);
                    
  meta_name_entry = gtk_entry_new ();
  gtk_widget_show (meta_name_entry);
  gtk_table_attach (GTK_TABLE (table3), meta_name_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 1, 1);
  GTK_WIDGET_UNSET_FLAGS (meta_name_entry, GTK_CAN_FOCUS);     
  gtk_entry_set_editable (GTK_ENTRY (meta_name_entry), FALSE);  
  gtk_entry_set_invisible_char (GTK_ENTRY (meta_name_entry), 32);
  gtk_entry_set_text (GTK_ENTRY (meta_name_entry), m_attr_name.c_str());

  meta_id_entry = gtk_entry_new ();
  gtk_widget_show (meta_id_entry);
  gtk_table_attach (GTK_TABLE (table3), meta_id_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 1, 1);
  gtk_entry_set_invisible_char (GTK_ENTRY (meta_id_entry), 32);
  GTK_WIDGET_UNSET_FLAGS (meta_id_entry, GTK_CAN_FOCUS);
  
  if ( m_aliased && !m_first_meta)
    gtk_widget_hide (meta_id_entry);
  
  if ( m_expression )
  {
    op_label = gtk_label_new ("Logical operator:");
    gtk_widget_show (op_label);
    gtk_table_attach (GTK_TABLE (table3), op_label, 0, 1, 2, 3,
                      (GtkAttachOptions) (GTK_FILL),
                      (GtkAttachOptions) (0), 0, 0);
    gtk_label_set_justify (GTK_LABEL (op_label), GTK_JUSTIFY_LEFT);
    gtk_misc_set_alignment (GTK_MISC (op_label), 0, 0.5);
  
    op_hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (op_hbox);
    gtk_table_attach (GTK_TABLE (table3), op_hbox, 1, 2, 2, 3,
                      (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                      (GtkAttachOptions) (GTK_FILL), 0, 0);
  
    op_combo = gtk_combo_new ();
    gtk_widget_show (op_combo);
    gtk_box_pack_start (GTK_BOX (op_hbox), op_combo, FALSE, TRUE, 0);
    gtk_combo_set_value_in_list (GTK_COMBO (op_combo), TRUE, FALSE);
    gtk_combo_set_use_arrows_always (GTK_COMBO (op_combo), TRUE);
    op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::NONE);
    op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::AND);
    op_combo_items = g_list_append (op_combo_items, (gpointer)GTKGraphAttrTemplateCreationView::OR);
    gtk_combo_set_popdown_strings (GTK_COMBO (op_combo), op_combo_items);
    g_list_free (op_combo_items);
  
    op_combo_entry = GTK_COMBO (op_combo)->entry;
    gtk_widget_show (op_combo_entry);
    gtk_entry_set_editable (GTK_ENTRY (op_combo_entry), FALSE);
    gtk_entry_set_text (GTK_ENTRY (op_combo_entry), GTKGraphAttrTemplateCreationView::NONE);
    gtk_entry_set_width_chars (GTK_ENTRY (op_combo_entry), 15);
  
    not_label = gtk_label_new ("Negation:");
    gtk_widget_show (not_label);
    gtk_box_pack_start (GTK_BOX (op_hbox), not_label, FALSE, TRUE, 4);
    gtk_label_set_justify (GTK_LABEL (not_label), GTK_JUSTIFY_LEFT);
  
    not_checkbutton = gtk_check_button_new_with_mnemonic ("");
    gtk_widget_show (not_checkbutton);
    gtk_box_pack_start (GTK_BOX (op_hbox), not_checkbutton, FALSE, TRUE, 2);
    GTK_WIDGET_UNSET_FLAGS (not_checkbutton, GTK_CAN_FOCUS);
  }
  
  gtk_signal_connect (GTK_OBJECT (check_meta_attr_id), "toggled",
                      GTK_SIGNAL_FUNC (on_check_meta_attr_id_toggled),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (check_meta_attr_name), "toggled",
                      GTK_SIGNAL_FUNC (on_check_meta_attr_name_toggled),
                      (gpointer)this);
}

int GTKGraphMetaAttrDialog::run()
{
  create();
  
  gint result = gtk_dialog_run( GTK_DIALOG(meta_attr) );
  char *text = 0;
  long value = 0;
  char buff[255];
  string tmp = "";
  stringstream str_stream("");
  
  memset( buff, 0, sizeof(buff) );
    
  switch( result )
  {
  case GTK_RESPONSE_OK:

    if ( (!m_aliased || m_first_meta) && 
         gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( check_meta_attr_id ) ) )
    {
      text = (char *)gtk_entry_get_text( GTK_ENTRY( meta_id_entry ) );
      tmp = string(text);
  
      if ( tmp.find('.') != string::npos || tmp.find(',') != string::npos )
      {
        AttributeIntegerRange range;
        
        if ( range.set_string( tmp ) )
          tmp = range.get_string();
        else
        {
          sscanf( text, "%ld", &value );
          str_stream << value;
          tmp = str_stream.str();
        }
      }
      else
      {
        sscanf( text, "%ld", &value );
        str_stream << value;
        tmp = str_stream.str();
      }
    }
        
    if ( gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( check_meta_attr_name ) ) )
    {
      text = (char *)gtk_entry_get_text( GTK_ENTRY( meta_name_entry ) );
    }
    else
      text = (char*)UnixGraphAttrView::EMPTY_META_NAME.c_str();
        
    if ( !tmp.empty() )
      m_attr_name = tmp + ":" + string(text);
    else
      m_attr_name = string(text);
    
    if ( m_expression )
    {
      text = (char *)gtk_entry_get_text( GTK_ENTRY( op_combo_entry ) );
      tmp = string(text);
      
      if ( tmp == GTKGraphAttrTemplateCreationView::AND )
        m_attr_op = "&";
      else if ( tmp == GTKGraphAttrTemplateCreationView::OR )
        m_attr_op = "|";
      
      m_negation = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( not_checkbutton) );
    }    
    break;
      
  default:;  
  }
    
  gtk_widget_destroy( meta_attr );
  meta_attr = 0;

  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
  
}

/******************************************************************************/
/******************************************************************************/

void GTKGraphAttrTemplateCreationView::handle_text_entry_changed_event()
{
}

void GTKGraphAttrTemplateCreationView::update_buttons()
{
  if ( m_search_expression )
    gtk_widget_show( paren_button );
  else
    gtk_widget_hide( paren_button );
}

void GTKGraphAttrTemplateCreationView::handle_add_button_clicked_event()
{
  vector<string>      attr_path;
  string              str;
  bool                is_meta = false;
  string              value = "";
  string              op = "";
  string              relation = "=";
  bool                negation = false;
  int                 result = GraphGUIModalWindow::APPLIED;
  bool                aliased = false;
  bool                first_meta = false;
  
  bool is_string = m_attr_template_tree.get_selected_path( attr_path );
  
  if ( attr_path.size() == 0 )
    return;
  
  if ( m_search_template_tree.is_empty() )
    m_search_expression = false;
  
  is_meta = ( attr_path[attr_path.size() - 1] == "" );
  
  first_meta = is_meta && (attr_path.size() == 2);
  
  if ( m_name_storage != 0 )
    aliased = ( m_name_storage->get_curr_alias_set() >= 0);
  
  if ( m_names_only || ( aliased && is_meta && !first_meta && !m_search_expression) )
    m_search_template_tree.insert_path_value( attr_path, value );
  else
  {
    if ( is_meta )
    {
      GTKGraphMetaAttrDialog meta_dialog( NULL, m_search_expression, aliased, first_meta );
      
      meta_dialog.set_meta_attr_name( attr_path[attr_path.size() - 2] );
      result = meta_dialog.run();
      
      if ( result == GraphGUIModalWindow::APPLIED )
      {
        attr_path[attr_path.size() - 2] = meta_dialog.get_full_meta_attr_name();
        negation                        = meta_dialog.get_negation();
        op                              = meta_dialog.get_attr_logical_op();
      }
    }
    else
    {
      GTKGraphAttrValueDialog attr_dialog( m_name_storage, NULL, m_search_expression, is_string );

      attr_dialog.set_attr_name( attr_path, "bool" );
      result = attr_dialog.run();
      
      if ( result == GraphGUIModalWindow::APPLIED )
      {
        value    = attr_dialog.get_attr_value();
        relation = attr_dialog.get_attr_value_op();
        negation = attr_dialog.get_negation();
        op       = attr_dialog.get_attr_logical_op();
      }
    }
  }  
  
  if ( result == GraphGUIModalWindow::APPLIED  )
  {      
    m_search_template_tree.insert_path_value( attr_path, value, relation, negation, op, is_string );
    
    m_result_string = m_search_template_tree.get_string();
    
    if ( m_show_text )
      gtk_entry_set_text( GTK_ENTRY( text_entry ), m_result_string.c_str() );
  }
  else if ( m_search_template_tree.is_empty() && !m_disable_expression )
      m_search_expression = true;
  
  update_buttons();
}

void GTKGraphAttrTemplateCreationView::handle_parentheses_button_clicked_event( )
{
  bool   add_paren = true;
  string op        = "";
  bool   negation  = false;
  
  if ( !m_search_template_tree.is_empty() )
  {
    GTKGraphAttrPredDialog pred_dialog(NULL);
  
    int result = pred_dialog.run();
  
    if ( add_paren = (result == GraphGUIModalWindow::APPLIED) )
    {
      op = pred_dialog.get_attr_logical_op();
      negation = pred_dialog.get_negation();
    }
  }
  
  if ( add_paren )
  {
    vector<string> attr_path;
    attr_path.push_back( UnixGraphAttrView::EXPR_PARENTHESES );
    m_search_template_tree.insert_path_value( attr_path, "", "", negation, op );
    m_result_string = m_search_template_tree.get_string();
    
    if ( m_show_text )
      gtk_entry_set_text( GTK_ENTRY( text_entry ), m_result_string.c_str() );
  }
}

void GTKGraphAttrTemplateCreationView::handle_remove_button_clicked_event( )
{
  m_search_template_tree.remove_selected( );
  m_result_string = m_search_template_tree.get_string();
  
  if ( m_show_text )
    gtk_entry_set_text( GTK_ENTRY( text_entry ), m_result_string.c_str() );
  
  if ( m_search_template_tree.is_empty() && !m_disable_expression )
    m_search_expression = true;
  
  update_buttons( );
}

void GTKGraphAttrTemplateCreationView::handle_string_checkbutton_clicked_event( )
{

}  

/******************************************************************************/
/*
static void on_text_entry_changed (GtkEditable *editable, gpointer user_data)
{
  GTKGraphAttrTemplateCreationView *attr_creation_view = (GTKGraphAttrTemplateCreationView *)user_data;
  attr_creation_view->handle_text_entry_changed_event();
}
*/
static void on_paren_button_clicked (GtkButton *button, gpointer user_data)
{
  GTKGraphAttrTemplateCreationView *attr_creation_view = (GTKGraphAttrTemplateCreationView *)user_data;
  attr_creation_view->handle_parentheses_button_clicked_event();
}

static void on_add_button_clicked (GtkButton *button, gpointer user_data)
{
  GTKGraphAttrTemplateCreationView *attr_creation_view = (GTKGraphAttrTemplateCreationView *)user_data;
  attr_creation_view->handle_add_button_clicked_event();
}

static void on_remove_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKGraphAttrTemplateCreationView *attr_creation_view = (GTKGraphAttrTemplateCreationView *)user_data;
  attr_creation_view->handle_remove_button_clicked_event();
}
/*
static void on_string_checkbutton_clicked( GtkButton *button, gpointer user_data )
{
  GTKGraphAttrTemplateCreationView *attr_creation_view = (GTKGraphAttrTemplateCreationView *)user_data;
  attr_creation_view->handle_string_checkbutton_clicked_event();
}  

*/

GtkWidget* GTKGraphAttrTemplateCreationView::create()
{
  if ( table1 != NULL )
    destroy();
  
  table1 = gtk_table_new (5, 3, FALSE);
  gtk_widget_show (table1);
    
  if ( m_show_text )
  {
    text_entry = gtk_entry_new ();
    gtk_widget_show (text_entry);
    gtk_table_attach (GTK_TABLE (table1), text_entry, 0, 3, 3, 4,
                        (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                        (GtkAttachOptions) (0), 0, 0);
    gtk_entry_set_editable (GTK_ENTRY (text_entry), FALSE);
    
    string_checkbutton = gtk_check_button_new( );
    gtk_widget_show( string_checkbutton );
    gtk_table_attach (GTK_TABLE (table1), string_checkbutton, 0, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 1);
    gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (string_checkbutton), FALSE);
    gtk_widget_set_sensitive (string_checkbutton, FALSE);
//  gtk_tooltips_set_tip( tooltips, string_checkbutton, "Check it to input attribute search string", NULL );

    alignment1 = gtk_alignment_new( 0.5, 0.5, 0, 0 );
    gtk_widget_show( alignment1 );
    gtk_container_add( GTK_CONTAINER (string_checkbutton), alignment1 );

    hbox1 = gtk_hbox_new( FALSE, 2 );
    gtk_widget_show( hbox1 );
    gtk_container_add( GTK_CONTAINER (alignment1), hbox1 );

    image1 = gtk_image_new_from_stock( "gtk-bold", GTK_ICON_SIZE_BUTTON );
    gtk_widget_show( image1 );
    gtk_box_pack_start( GTK_BOX (hbox1), image1, FALSE, FALSE, 0 );

    label1 = gtk_label_new_with_mnemonic( "Resulting attribute string" );
    gtk_widget_show( label1 );
    gtk_box_pack_start( GTK_BOX (hbox1), label1, FALSE, FALSE, 0 );
    gtk_label_set_justify( GTK_LABEL (label1), GTK_JUSTIFY_LEFT );

  }
  
  template_scrolledwindow = gtk_scrolled_window_new( NULL, NULL );
  gtk_widget_show( template_scrolledwindow );
  gtk_table_attach( GTK_TABLE (table1), template_scrolledwindow, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0 );
  gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW (template_scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC );
  gtk_scrolled_window_set_placement( GTK_SCROLLED_WINDOW (template_scrolledwindow), GTK_CORNER_TOP_RIGHT );
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (template_scrolledwindow), GTK_SHADOW_OUT);
  
  tree = m_attr_template_tree.get_widget();
  gtk_widget_show( tree );
  gtk_container_add( GTK_CONTAINER (template_scrolledwindow), tree );

  scrolledwindow4 = gtk_scrolled_window_new( NULL, NULL );
  gtk_widget_show( scrolledwindow4 );
  gtk_table_attach( GTK_TABLE (table1), scrolledwindow4, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0 );
  gtk_scrolled_window_set_policy( GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC );
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow4), GTK_SHADOW_OUT);
  
  tree = m_search_template_tree.get_widget();
  gtk_widget_show( tree );
  gtk_container_add( GTK_CONTAINER (scrolledwindow4), tree );
  
  flow_vbox = gtk_vbox_new( FALSE, 1 );
  gtk_widget_show( flow_vbox );
  gtk_table_attach( GTK_TABLE (table1), flow_vbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_SHRINK),
                    (GtkAttachOptions) (GTK_EXPAND), 5, 0 );
                    
  paren_button = gtk_button_new_with_mnemonic( "()>" );
  gtk_widget_show( paren_button );
  gtk_box_pack_start( GTK_BOX (flow_vbox), paren_button, FALSE, FALSE, 0 );
  gtk_widget_set_size_request( paren_button, 46, 23 );
  
  if ( m_disable_expression )
    gtk_widget_hide( paren_button );

  add_button = gtk_button_new_with_mnemonic( ">>" );
  gtk_widget_show( add_button );
  gtk_box_pack_start( GTK_BOX (flow_vbox), add_button, FALSE, FALSE, 0 );
  gtk_widget_set_size_request( add_button, 46, 23 );
//  string tooltip = string("Add attribute to ") + m_result_title;
//  gtk_tooltips_set_tip( tooltips, add_button, tooltip.c_str(), NULL );

  remove_button = gtk_button_new_with_mnemonic( "<<" );
  gtk_widget_show( remove_button );
  gtk_box_pack_start( GTK_BOX (flow_vbox), remove_button, FALSE, FALSE, 0 );
  gtk_widget_set_size_request( remove_button, 46, 23 );
//  tooltip = string("Remove attribute from ") + m_result_title;
//  gtk_tooltips_set_tip( tooltips, remove_button, tooltip.c_str(), NULL );

  template_label = gtk_label_new( m_base_title.c_str() );
  gtk_widget_show( template_label );
  gtk_table_attach( GTK_TABLE (table1), template_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 2, 0 );
  gtk_label_set_justify( GTK_LABEL (template_label), GTK_JUSTIFY_LEFT );
  gtk_label_set_line_wrap( GTK_LABEL (template_label), TRUE );
  gtk_misc_set_alignment( GTK_MISC (template_label), 0, 0.01 );

  search_label = gtk_label_new( m_result_title.c_str() );
  gtk_widget_show ( search_label );
  gtk_table_attach( GTK_TABLE (table1), search_label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 3, 0 );
  gtk_label_set_justify( GTK_LABEL (search_label), GTK_JUSTIFY_LEFT );
  gtk_label_set_line_wrap( GTK_LABEL (search_label), TRUE );
  gtk_misc_set_alignment( GTK_MISC (search_label), 0, 0.01 );
  
  gtk_signal_connect (GTK_OBJECT (paren_button), "clicked",
                      GTK_SIGNAL_FUNC (on_paren_button_clicked),
                      (gpointer)this);
                      
  gtk_signal_connect (GTK_OBJECT (add_button), "clicked",
                      GTK_SIGNAL_FUNC (on_add_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (remove_button), "clicked",
                      GTK_SIGNAL_FUNC (on_remove_button_clicked),
                      (gpointer)this);
  
  return table1;
}

int GTKGraphAttrTemplateCreationView::run_dialog( const string &title )
{
  GtkWidget *dialog_vbox1;
  create();
  
  dialog = gtk_dialog_new_with_buttons( title.c_str(), NULL, GTK_DIALOG_MODAL, 
                                                        GTK_STOCK_OK, GTK_RESPONSE_OK, 
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL );
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

  dialog_vbox1 = GTK_DIALOG (dialog)->vbox;
  gtk_widget_show (dialog_vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  
  m_search_template_tree.expand_all();
    
  gint result = gtk_dialog_run( GTK_DIALOG(dialog) );
    
  gtk_widget_destroy( dialog );
  dialog = NULL;
  
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}
