#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "UnixGraphSaveGUI.h"

#define _ASCII_FORMAT_ "ASCII"
#define _BIN_FORMAT_ "Binary (16-bits identifiers)" 
#define _BIN32_FORMAT_ "Binary (32-bits identifiers)" 

using namespace GraphGraphics;

GraphFileInfo GTKGraphSaveGUI::m_last_file_info;
bool          GTKGraphSaveGUI::m_init = true;

void GTKGraphSaveGUI::handle_file_button_clicked_event( )
{
  string     file_name = gtk_entry_get_text( GTK_ENTRY(file_entry) );
  string     new_file_name = m_gui->run_fileselection_dialog ( "Select file", file_name, "" );
  
  if ( !new_file_name.empty() )
    gtk_entry_set_text( GTK_ENTRY(file_entry), new_file_name.c_str() );
}

void GTKGraphSaveGUI::handle_model_button_clicked_event()
{
  string     file_name = gtk_entry_get_text( GTK_ENTRY(model_entry) );
  string     new_file_name = m_gui->run_fileselection_dialog ( "Select model file", file_name, "" );
  
  if ( !new_file_name.empty() )
    gtk_entry_set_text( GTK_ENTRY(model_entry), new_file_name.c_str() );
  
}

void on_file_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKGraphSaveGUI *dialog = (GTKGraphSaveGUI*)user_data;
  dialog->handle_file_button_clicked_event();
}


void on_model_button_clicked( GtkButton *button, gpointer user_data )
{
  GTKGraphSaveGUI *dialog = (GTKGraphSaveGUI*)user_data;
  dialog->handle_model_button_clicked_event();
}

void GTKGraphSaveGUI::create()
{
  save_graph_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (save_graph_dialog), "Save options...");
  gtk_window_set_position (GTK_WINDOW (save_graph_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (save_graph_dialog), TRUE);

  dialog_vbox = GTK_DIALOG (save_graph_dialog)->vbox;
  gtk_widget_show (dialog_vbox);

  main_table = gtk_table_new (9, 3, FALSE);
  gtk_widget_show (main_table);
  gtk_box_pack_start (GTK_BOX (dialog_vbox), main_table, TRUE, TRUE, 0);

  file_entry = gtk_entry_new ();
  gtk_widget_show (file_entry);
  gtk_table_attach (GTK_TABLE (main_table), file_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  file_button = gtk_button_new_with_mnemonic (" Select file ");
  gtk_widget_show (file_button);
  gtk_table_attach (GTK_TABLE (main_table), file_button, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  file_label = gtk_label_new ("File name:");
  gtk_widget_show (file_label);
  gtk_table_attach (GTK_TABLE (main_table), file_label, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (file_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (file_label), 0, 0.5);

  name_entry = gtk_entry_new ();
  gtk_widget_show (name_entry);
  gtk_table_attach (GTK_TABLE (main_table), name_entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  name_label = gtk_label_new ("Graph/model name:");
  gtk_widget_show (name_label);
  gtk_table_attach (GTK_TABLE (main_table), name_label, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (name_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (name_label), 0, 0.5);

  format_label = gtk_label_new ("File format type:");
  gtk_widget_show (format_label);
  gtk_table_attach (GTK_TABLE (main_table), format_label, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (format_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (format_label), 0, 0.5);

  format_combo = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (GTK_COMBO (format_combo)->popwin),
                       "GladeParentKey", format_combo);
  gtk_widget_show (format_combo);
  gtk_table_attach (GTK_TABLE (main_table), format_combo, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (format_combo), TRUE, FALSE);
  gtk_combo_set_use_arrows_always (GTK_COMBO (format_combo), TRUE);
  format_combo_items = g_list_append (format_combo_items, (gpointer) _BIN_FORMAT_);
  format_combo_items = g_list_append (format_combo_items, (gpointer) _BIN32_FORMAT_);
  format_combo_items = g_list_append (format_combo_items, (gpointer) _ASCII_FORMAT_);
  gtk_combo_set_popdown_strings (GTK_COMBO (format_combo), format_combo_items);
  g_list_free (format_combo_items);

  format_combo_entry = GTK_COMBO (format_combo)->entry;
  gtk_widget_show (format_combo_entry);
  gtk_entry_set_text (GTK_ENTRY (format_combo_entry), _BIN_FORMAT_);

  version_entry = gtk_entry_new ();
  gtk_widget_show (version_entry);
  gtk_table_attach (GTK_TABLE (main_table), version_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (version_entry, FALSE);
  gtk_entry_set_editable (GTK_ENTRY (version_entry), FALSE);
  gtk_entry_set_text (GTK_ENTRY (version_entry), "001.000");

  version_label = gtk_label_new ("File version:");
  gtk_widget_show (version_label);
  gtk_table_attach (GTK_TABLE (main_table), version_label, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (version_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (version_label), 0, 0.5);

  comm_label = gtk_label_new ("Comment:");
  gtk_widget_show (comm_label);
  gtk_table_attach (GTK_TABLE (main_table), comm_label, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (comm_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (comm_label), 0, 0.5);

  comm_entry = gtk_entry_new ();
  gtk_widget_show (comm_entry);
  gtk_table_attach (GTK_TABLE (main_table), comm_entry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  model_label = gtk_label_new ("Model file:");
  gtk_widget_show (model_label);
  gtk_table_attach (GTK_TABLE (main_table), model_label, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (model_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (model_label), 0, 0.5);

  model_entry = gtk_entry_new ();
  gtk_widget_show (model_entry);
  gtk_table_attach (GTK_TABLE (main_table), model_entry, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  model_button = gtk_button_new_with_mnemonic ("Select file");
  gtk_widget_show (model_button);
  gtk_table_attach (GTK_TABLE (main_table), model_button, 2, 3, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_table_attach (GTK_TABLE (main_table), hseparator1, 0, 3, 8, 9,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  gr_alignment = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (gr_alignment);
  gtk_table_attach (GTK_TABLE (main_table), gr_alignment, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  graph_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (graph_checkbutton);
  gtk_container_add (GTK_CONTAINER (gr_alignment), graph_checkbutton);
  GTK_WIDGET_UNSET_FLAGS (graph_checkbutton, GTK_CAN_FOCUS);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (graph_checkbutton), TRUE);

  gr_label = gtk_label_new ("Save graph info:");
  gtk_widget_show (gr_label);
  gtk_table_attach (GTK_TABLE (main_table), gr_label, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (gr_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (gr_label), 0, 0.5);

  vis_label = gtk_label_new ("Save visual properties:");
  gtk_widget_show (vis_label);
  gtk_table_attach (GTK_TABLE (main_table), vis_label, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);
  gtk_label_set_justify (GTK_LABEL (vis_label), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (vis_label), 0, 0.5);

  vis_checkbutton = gtk_check_button_new_with_mnemonic ("");
  gtk_widget_show (vis_checkbutton);
  gtk_table_attach (GTK_TABLE (main_table), vis_checkbutton, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  GTK_WIDGET_UNSET_FLAGS (vis_checkbutton, GTK_CAN_FOCUS);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (vis_checkbutton), TRUE);

  dialog_action_area = GTK_DIALOG (save_graph_dialog)->action_area;
  gtk_widget_show (dialog_action_area);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area), GTK_BUTTONBOX_END);

  cancel_button = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancel_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (save_graph_dialog), cancel_button, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

  ok_button = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (ok_button);
  gtk_dialog_add_action_widget (GTK_DIALOG (save_graph_dialog), ok_button, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (file_button), "clicked",
                      GTK_SIGNAL_FUNC (on_file_button_clicked),
                      (gpointer)this);
  gtk_signal_connect (GTK_OBJECT (model_button), "clicked",
                      GTK_SIGNAL_FUNC (on_model_button_clicked),
                      (gpointer)this);
}

int GTKGraphSaveGUI::run()
{
  create();
  
  gtk_entry_set_text( GTK_ENTRY(file_entry), m_last_file_info.file_name.c_str() ); 
  gtk_entry_set_text( GTK_ENTRY(name_entry), m_last_file_info.graph_name.c_str() );
  switch ( m_last_file_info.file_format )
  {
  case GraphFileInfo::ASCII_FORMAT:
    gtk_entry_set_text( GTK_ENTRY(format_combo_entry), _ASCII_FORMAT_ );
    break;
  case GraphFileInfo::BIN16_FORMAT:
    gtk_entry_set_text( GTK_ENTRY(format_combo_entry), _BIN_FORMAT_ );
    break;
  default:
    gtk_entry_set_text( GTK_ENTRY(format_combo_entry), _BIN32_FORMAT_ );
  }
  gtk_entry_set_text( GTK_ENTRY(version_entry), m_last_file_info.version.c_str() );
  gtk_entry_set_text( GTK_ENTRY(comm_entry), m_last_file_info.comment.c_str() );
  gtk_entry_set_text( GTK_ENTRY(model_entry), m_last_file_info.model_file.c_str() );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( graph_checkbutton ), m_last_file_info.save_graph );
  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( vis_checkbutton ), m_last_file_info.save_view );
  
  gboolean result = gtk_dialog_run( GTK_DIALOG(save_graph_dialog) );
  
  if ( result == GTK_RESPONSE_OK )
  {
    string format = gtk_entry_get_text( GTK_ENTRY(format_combo_entry) );
    m_last_file_info.file_name = gtk_entry_get_text( GTK_ENTRY(file_entry) ); 
    m_last_file_info.graph_name = gtk_entry_get_text( GTK_ENTRY(name_entry) ); 
    m_last_file_info.file_format = ((format == _ASCII_FORMAT_)? GraphFileInfo::ASCII_FORMAT:
                                   (format == _BIN_FORMAT_)? GraphFileInfo::BIN16_FORMAT:
                                   GraphFileInfo::BIN32_FORMAT);
    m_last_file_info.version  = gtk_entry_get_text( GTK_ENTRY(version_entry) ); 
    m_last_file_info.model_file = gtk_entry_get_text( GTK_ENTRY(model_entry) ); 
    m_last_file_info.comment  = gtk_entry_get_text( GTK_ENTRY(comm_entry) ); 
    m_last_file_info.save_graph = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( graph_checkbutton ) );
    m_last_file_info.save_view  = (bool)gtk_toggle_button_get_active( GTK_TOGGLE_BUTTON( vis_checkbutton ) );
       
    m_app->get_event_handler()->handle_save( m_last_file_info );
  }
  
  gtk_widget_destroy( save_graph_dialog );
  
  return ((result == GTK_RESPONSE_OK)? GraphGUIModalWindow::APPLIED: GraphGUIModalWindow::CANCELED);
}

